/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.business.upgrade;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hies.common.util.MethodUtil;

@ExcludeFromJacocoGeneratedReport
public class UpdateTplDataService {
    private static final Log logger = LogFactory.getLog(UpdateTplDataService.class);
    private static DBRoute hmpDbRoute = new DBRoute("hmp");

    public static void updateAll() {
        long start = System.currentTimeMillis();
        String version = "1";
        String key = MethodUtil.getUpgradeFlagCachePath("UpdateTplDataService_updateAll");
        IHRAppCache cache = HRAppCache.get((String)"hies");
        String val = (String)cache.get(key, String.class);
        if (version.equalsIgnoreCase(val)) {
            return;
        }
        cache.put(key, (Object)version);
        UpdateTplDataService.updateTplF7FieldFormatConfig();
        UpdateTplDataService.updateTplEntitydescription();
        UpdateTplDataService.updateTplQueryentityid();
        logger.info("UpdateTplDataService->updateAll expense:{}", (Object)(System.currentTimeMillis() - start));
    }

    private static void updateTplF7FieldFormatConfig() {
        logger.info("UpdateTplFieldConfigServiceImpl_updateTplF7FieldFormatConfig excute.");
        long start = System.currentTimeMillis();
        StringBuilder log = new StringBuilder("updateTplF7FieldFormatConfig_UpgradeResultLog->start to update.");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hies_diaetplconf");
        try {
            helper.deleteByFilter(new QFilter[]{new QFilter("source", "=", (Object)"full")});
            Map<Long, String> allUpdateTpl = UpdateTplDataService.getAllUpdateTpl();
            logger.info("updateTplF7FieldFormatConfig_allUpdateTpl=" + JSONObject.toJSONString(allUpdateTpl));
            log.append("->allUpdateTpl count=");
            log.append(allUpdateTpl.size());
            int successCount = 0;
            HashSet<String> errors = new HashSet<String>(6);
            for (Map.Entry<Long, String> next : allUpdateTpl.entrySet()) {
                try {
                    DynamicObject tpl = helper.loadSingle((Object)next.getKey());
                    String tplnumber = tpl.getString("number");
                    String tmpltype = tpl.getString("tmpltype");
                    String editField = "IMPT".equalsIgnoreCase(tmpltype) ? "imptattr" : "exptattr";
                    Map<String, Map<String, Map<String, Object>>> propNameMap = MethodUtil.initEntityF7MainPropName(tpl);
                    if (propNameMap.size() == 0) {
                        errors.add(tplnumber);
                        continue;
                    }
                    boolean hasError = false;
                    DynamicObjectCollection tpltreeentryentity = tpl.getDynamicObjectCollection("tpltreeentryentity");
                    for (DynamicObject field : tpltreeentryentity) {
                        boolean isimport = field.getBoolean("isimport");
                        if (!isimport) continue;
                        String fieldnumber = field.getString("fieldnumber");
                        String childentity = field.getString("childentity");
                        if (StringUtils.isEmpty((CharSequence)fieldnumber) || StringUtils.isEmpty((CharSequence)childentity)) continue;
                        Map<String, Map<String, Object>> childentityprop = propNameMap.get(childentity);
                        if (childentityprop == null) {
                            hasError = true;
                            break;
                        }
                        Map<String, Object> fieldprop = childentityprop.get(fieldnumber);
                        if (fieldprop == null) continue;
                        String propNumber = (String)fieldprop.get("number");
                        String propName = (String)fieldprop.get("name");
                        switch (next.getValue()) {
                            case "number": {
                                if (StringUtils.isNotEmpty((CharSequence)propNumber)) {
                                    field.set(editField, (Object)"number");
                                    break;
                                }
                                if (StringUtils.isNotEmpty((CharSequence)propName)) {
                                    field.set(editField, (Object)"name");
                                    break;
                                }
                                field.set(editField, (Object)"id");
                                break;
                            }
                            case "name": {
                                if (StringUtils.isNotEmpty((CharSequence)propName)) {
                                    field.set(editField, (Object)"name");
                                    break;
                                }
                                if (StringUtils.isNotEmpty((CharSequence)propNumber)) {
                                    field.set(editField, (Object)"number");
                                    break;
                                }
                                field.set(editField, (Object)"id");
                                break;
                            }
                            case "number_name": {
                                if (StringUtils.isNotEmpty((CharSequence)propNumber) && StringUtils.isNotEmpty((CharSequence)propName)) {
                                    field.set(editField, (Object)"number_name");
                                    break;
                                }
                                if (StringUtils.isNotEmpty((CharSequence)propNumber)) {
                                    field.set(editField, (Object)"number");
                                    break;
                                }
                                if (StringUtils.isNotEmpty((CharSequence)propName)) {
                                    field.set(editField, (Object)"name");
                                    break;
                                }
                                field.set(editField, (Object)"id");
                            }
                        }
                    }
                    if (hasError) {
                        errors.add(tplnumber);
                        continue;
                    }
                    helper.saveOne(tpl);
                    logger.info("setBaseinfoformatBlank_pkid=" + next.getKey());
                    UpdateTplDataService.setBaseinfoformatBlank(next.getKey());
                    ++successCount;
                }
                catch (Throwable e) {
                    logger.error(e);
                    log.append("->occur exception:");
                    log.append(e.getMessage());
                }
            }
            log.append("->finished update successCount=");
            log.append(successCount);
            log.append("->error tpl:");
            log.append(String.join((CharSequence)",", errors));
        }
        catch (Throwable e) {
            logger.error(e);
            log.append("->occur exception:");
            log.append(e.getMessage());
        }
        log.append("->end update.");
        log.append("->expense:").append(System.currentTimeMillis() - start);
        logger.info(log.toString());
    }

    private static void updateTplEntitydescription() {
        logger.info("UpdateTplFieldConfigServiceImpl_updateTplEntitydescription excute.");
        long start = System.currentTimeMillis();
        String version = "2";
        String key = MethodUtil.getUpgradeFlagCachePath("updateTplEntitydescription");
        IHRAppCache cache = HRAppCache.get((String)"hies");
        String val = (String)cache.get(key, String.class);
        if (version.equalsIgnoreCase(val)) {
            return;
        }
        cache.put(key, (Object)version);
        StringBuilder log = new StringBuilder("updateTplEntitydescription_UpgradeResultLog->start to update.");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hies_diaetplconf");
        try {
            DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(null);
            int successCount = 0;
            HashSet errors = new HashSet(6);
            for (DynamicObject tpl : dynamicObjects) {
                try {
                    Map<String, Map<String, Map<String, Object>>> propNameMap = MethodUtil.initEntityF7MainPropName(tpl);
                    DynamicObjectCollection tpltreeentryentity = tpl.getDynamicObjectCollection("tpltreeentryentity");
                    for (DynamicObject field : tpltreeentryentity) {
                        String fieldnumber = field.getString("fieldnumber");
                        String entitydescription = field.getString("entitydescription");
                        if (!StringUtils.isNotEmpty((CharSequence)entitydescription)) continue;
                        try {
                            SerializationUtils.fromJsonString((String)entitydescription, Map.class);
                        }
                        catch (Throwable e) {
                            LocaleString lang;
                            String childentity = field.getString("childentity");
                            Map<String, Map<String, Object>> childentityprop = propNameMap.get(childentity);
                            String[] split = null;
                            if (entitydescription.contains(" ")) {
                                split = StringUtils.split((String)entitydescription, (String)" ");
                            } else if (entitydescription.contains(",")) {
                                split = StringUtils.split((String)entitydescription, (String)",");
                            }
                            HashMap map = Maps.newHashMapWithExpectedSize((int)3);
                            Map<String, Object> fieldprop = null;
                            if (childentityprop != null) {
                                fieldprop = childentityprop.get(fieldnumber);
                            }
                            if (split != null && fieldprop != null) {
                                lang = new LocaleString();
                                lang.setLocaleValue(split[0]);
                                map.put((String)fieldprop.get("number"), SerializationUtils.toJsonString((Object)lang));
                                if (split.length == 2) {
                                    LocaleString lang2 = new LocaleString();
                                    lang2.setLocaleValue(split[1]);
                                    map.put((String)fieldprop.get("name"), SerializationUtils.toJsonString((Object)lang2));
                                }
                                field.set("entitydescription", (Object)SerializationUtils.toJsonString((Object)map));
                            } else if (fieldprop == null) {
                                lang = new LocaleString();
                                lang.setLocaleValue(entitydescription);
                                map.put(fieldnumber, SerializationUtils.toJsonString((Object)lang));
                                field.set("entitydescription", (Object)SerializationUtils.toJsonString((Object)map));
                            }
                            helper.saveOne(tpl);
                            ++successCount;
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error(e);
                    log.append("->occur exception:");
                    log.append(e.getMessage());
                }
            }
            log.append("->finished update successCount=");
            log.append(successCount);
            log.append("->error tpl:");
            log.append(String.join((CharSequence)",", errors));
        }
        catch (Throwable e) {
            logger.error(e);
            log.append("->occur exception:");
            log.append(e.getMessage());
        }
        log.append("->end update.");
        log.append("->expense:").append(System.currentTimeMillis() - start);
        logger.info(log.toString());
    }

    private static void updateTplQueryentityid() {
        logger.info("UpdateTplFieldConfigServiceImpl_updateTplQueryentityid excute.");
        try {
            String sql = "UPDATE T_HIES_DIAETPLCONF SET FQUERYENTITYID = FENTITYID  WHERE FQUERYENTITYID  IS NULL OR FQUERYENTITYID = ' '";
            DB.execute((DBRoute)hmpDbRoute, (String)sql);
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    private static Map<Long, String> getAllUpdateTpl() {
        String querySql = "select fid,fbaseinfoformat from t_hies_diaetplconf where fbaseinfoformat !=' '";
        return (Map)DB.query((DBRoute)hmpDbRoute, (String)querySql, null, rs -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            while (rs.next()) {
                map.put(rs.getLong("fid"), rs.getString("fbaseinfoformat"));
            }
            return map;
        });
    }

    private static void setBaseinfoformatBlank(Long pkid) {
        String sql = "update t_hies_diaetplconf set fbaseinfoformat =' ' where fid =?";
        Object[] params = new Object[]{pkid};
        HRDBUtil.update((DBRoute)hmpDbRoute, (String)sql, (Object[])params);
    }
}

