/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.cache;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.ImportFileUtil;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;

public class EHcacheDiskCacheManager {
    private static final Log LOGGER = LogFactory.getLog(EHcacheDiskCacheManager.class);
    private CacheManager cacheManager;
    private Path tempDir = Files.createTempDirectory("hies_diskCache", new FileAttribute[0]);
    private String cacheName = "diskCache1";

    public EHcacheDiskCacheManager() throws IOException {
        this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((File)this.tempDir.toFile())).build(true);
        CacheConfiguration cacheConfig = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, String.class, (ResourcePools)ResourcePoolsBuilder.newResourcePoolsBuilder().disk(300L, MemoryUnit.MB, false).build()).build();
        this.cacheManager.createCache(this.cacheName, cacheConfig);
    }

    public void put(String key, String value) {
        Cache cache = this.cacheManager.getCache(this.cacheName, String.class, String.class);
        cache.put((Object)key, (Object)value);
    }

    public String get(String key) {
        Cache cache = this.cacheManager.getCache(this.cacheName, String.class, String.class);
        return (String)cache.get((Object)key);
    }

    public void close() {
        this.cacheManager.close();
        try {
            ImportFileUtil.deleteDirectory(this.tempDir);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
    }
}

