/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.cache;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.locks.ReentrantLock;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.Pair;
import kd.hr.hies.common.util.TextCompressUtil;

public class NettyOutJVMHeapManager {
    private ReentrantLock putLock = new ReentrantLock();
    private ReentrantLock getLock = new ReentrantLock();
    private int minSize = 0xA00000;
    private ByteBuf bufferDirect = Unpooled.directBuffer((int)this.minSize, (int)(MCConfigConstant.getOutJVMHeapSize() * 1024 * 1024));
    private volatile boolean hasOverflow = false;

    public int getPutPos() {
        return this.bufferDirect.readableBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, Integer> put(String str) {
        if (this.hasOverflow) {
            return null;
        }
        byte[] compress = TextCompressUtil.compress(str);
        try {
            this.putLock.lock();
            if (compress.length > this.bufferDirect.maxWritableBytes()) {
                this.hasOverflow = true;
                Pair<Integer, Integer> pair = null;
                return pair;
            }
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>(this.bufferDirect.writerIndex(), compress.length);
            this.bufferDirect.writeBytes(compress);
            Pair<Integer, Integer> pair2 = pair;
            return pair2;
        }
        finally {
            this.putLock.unlock();
        }
    }

    public String get(Pair<Integer, Integer> pair) {
        byte[] compress = new byte[pair.getSecond().intValue()];
        try {
            this.getLock.lock();
            this.bufferDirect.getBytes(pair.getFirst().intValue(), compress);
        }
        finally {
            this.getLock.unlock();
        }
        return TextCompressUtil.decompress(compress);
    }

    public void release() {
        this.bufferDirect.release();
    }
}

