/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.enu;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hies.common.constant.PageFieldKey;

public enum OprCategory implements PageFieldKey
{
    NEW("new"),
    UPDATE("update"),
    DELETE("delete"),
    UPDATE_AND_NEW("updateandnew"),
    EXPORT_FROM_LIST("export_from_list"),
    EXPORT_FROM_SELECTLIST("export_from_selectlist"),
    EXPORT_FROM_EXPTTPL("export_from_expttpl"),
    EXPORT_FROM_IMPTTPL("export_from_impttpl");

    private static final Map<String, OprCategory> cache;
    private final String value;

    private OprCategory(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static String pageFieldKey() {
        return "oprcategory";
    }

    public static OprCategory tranEnum(String type) {
        OprCategory oprCategory = cache.get(type);
        HRAssert.notNull((Object)oprCategory, (String)String.format("type[%s] is err, please check!for details, please see kd.hr.impt.common.enu.OprCategory", type), (Object[])new Object[0]);
        return oprCategory;
    }

    public static boolean isNew(String oprCategory) {
        return NEW.getValue().equalsIgnoreCase(oprCategory);
    }

    public static boolean isUpdate(String oprCategory) {
        return UPDATE.getValue().equalsIgnoreCase(oprCategory);
    }

    public static boolean isDelete(String oprCategory) {
        return DELETE.getValue().equalsIgnoreCase(oprCategory);
    }

    public static boolean isUpdateAndNew(String oprCategory) {
        return UPDATE_AND_NEW.getValue().equalsIgnoreCase(oprCategory);
    }

    public static boolean isExportByExptpl(String oprCategory) {
        return EXPORT_FROM_EXPTTPL.getValue().equalsIgnoreCase(oprCategory);
    }

    public static boolean isExportByImptpl(String oprCategory) {
        return EXPORT_FROM_IMPTTPL.getValue().equalsIgnoreCase(oprCategory);
    }

    public static boolean isExportByList(String oprCategory) {
        return EXPORT_FROM_LIST.getValue().equalsIgnoreCase(oprCategory);
    }

    static {
        cache = Arrays.stream(OprCategory.values()).collect(Collectors.toMap(OprCategory::getValue, Function.identity()));
    }
}

