/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.task;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.task.BlankPlatFormTask;
import kd.hr.hies.common.task.IEBackgroundTaskSubscriber;
import kd.hr.hies.common.util.MethodUtil;

@ExcludeFromJacocoGeneratedReport
public class IEGlobalTaskUtil {
    public static String createNewGlobalTask(String importType, IFormView view, String taskPkid, String des, String clickClassName, String closeCallBack) {
        JobFormInfo jobFormInfo = IEGlobalTaskUtil.createJobFormInfo(view, des, clickClassName, closeCallBack);
        String taskId = JobClient.dispatch((JobInfo)jobFormInfo.getJobInfo());
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setId(taskId);
        HashMap data = Maps.newHashMapWithExpectedSize((int)6);
        data.put("taskPkId", taskPkid);
        taskInfo.setData(SerializationUtils.toJsonString((Object)data));
        taskInfo.setProgress(0);
        taskInfo.setStatus("RUNNING");
        taskInfo.setDesc(des);
        String key = MethodUtil.getTaskCachePath(taskPkid, importType, "ball");
        IHRAppCache appCache = HRAppCache.get((String)"hies");
        appCache.put(key, (Object)taskInfo);
        TaskClientProxy.addTask((JobFormInfo)jobFormInfo, (TaskInfo)taskInfo, null);
        IEBackgroundTaskSubscriber subscriber = new IEBackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId, taskPkid, importType);
        ThreadPools.executeOnce((String)"task-hrbackground-monitor", (Runnable)subscriber);
        return taskId;
    }

    public static void feedbackProgress(String taskPKId, int progress, String importType) {
        String key = MethodUtil.getTaskCachePath(taskPKId, importType, "ball");
        IHRAppCache appCache = HRAppCache.get((String)"hies");
        TaskInfo taskInfo = (TaskInfo)appCache.get(key, TaskInfo.class);
        if (taskInfo == null) {
            return;
        }
        if (progress >= 100) {
            taskInfo.setStatus("COMPLETED");
        }
        taskInfo.setProgress(progress);
        taskInfo.setRunTime(System.currentTimeMillis());
        appCache.put(key, (Object)taskInfo);
    }

    private static JobFormInfo createJobFormInfo(IFormView view, String des, String clickClassName, String closeCallBack) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(des);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setAppId("hies");
        jobInfo.setTaskClassname(BlankPlatFormTask.class.getName());
        HashMap params = Maps.newHashMap();
        jobInfo.setParams((Map)params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(view.getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParams((Map)params);
        jobFormInfo.setClickClassName(clickClassName);
        jobFormInfo.getParams().putAll(view.getFormShowParameter().getCustomParams());
        jobFormInfo.setCanBackground(true);
        if (StringUtils.isNotEmpty((CharSequence)closeCallBack)) {
            CloseCallBack closeBack = new CloseCallBack(closeCallBack, "background_actionid");
            jobFormInfo.setCloseCallBack(closeBack);
        }
        return jobFormInfo;
    }
}

