/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dtx.util.DynamicObjectSerializeUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NameVersionEntryType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.hr.metadata.prop.QueryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.constant.TemplateConfConst;
import kd.hr.hies.common.enu.OprCategory;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.HRVirEntityUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.hies.common.util.TemplateEntityFieldUtil;
import kd.hr.hies.common.util.TemplateFormCommonUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;

@ExcludeFromJacocoGeneratedReport
public class EntityTreeServiceHelper
implements TemplateConfConst {
    private static final Log LOGGER = LogFactory.getLog(EntityTreeServiceHelper.class);
    private final Map<String, Map<String, IDataEntityProperty>> acrossPropMap = new HashMap<String, Map<String, IDataEntityProperty>>(16);
    private final TreeView treeView;
    private Map<String, String> dataRangeMap = new HashMap<String, String>(16);
    private String mainEntityNumber;
    private String queryEntityNumber;

    public EntityTreeServiceHelper(TreeView treeView, String mainEntityNumber, String queryEntityNumber) {
        this.treeView = treeView;
        this.mainEntityNumber = mainEntityNumber;
        this.queryEntityNumber = queryEntityNumber;
    }

    public static TreeNode buildRootNode() {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8", (String)HiesCommonRes.EntityTreeServiceHelper_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "1010", rootName, true, (Object)0);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    public static Set<TreeNode> getCheckedNode(IFormView view) {
        String json = view.getPageCache().get("checkedNode");
        LinkedHashSet treeNodes = StringUtils.isBlank((CharSequence)json) ? Sets.newLinkedHashSetWithExpectedSize((int)16) : Sets.newLinkedHashSet((Iterable)JSON.parseArray((String)json, TreeNode.class));
        return treeNodes;
    }

    public static void checkNodes(List<TreeNode> nodes, List<String> checkedField, Set<TreeNode> checkedTreeNode) {
        if (!CollectionUtils.isEmpty(nodes)) {
            nodes.forEach(x -> {
                if (checkedField.contains(x.getId())) {
                    checkedTreeNode.add((TreeNode)x);
                }
                List children = x.getChildren();
                EntityTreeServiceHelper.checkNodes(children, checkedField, checkedTreeNode);
            });
        }
    }

    private static void cacheDisableEntrys(IFormView view, List<DynamicObject> unCheckedDyns) {
        DynamicObjectType dynamicObjectType = view.getModel().getEntryEntity("treeentryentity").getDynamicObjectType();
        String jsonStr = view.getPageCache().get("disableEntry");
        HashMap<String, String> disableEntryMap = StringUtils.isNotBlank((CharSequence)jsonStr) ? (HashMap<String, String>)SerializationUtils.fromJsonString((String)jsonStr, Map.class) : new HashMap<String, String>(16);
        for (DynamicObject unCheckedDyn : unCheckedDyns) {
            String objectSerialization = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{unCheckedDyn}, (DynamicObjectType)dynamicObjectType);
            String fieldNumber = unCheckedDyn.getString("fieldnumber");
            disableEntryMap.put(fieldNumber, objectSerialization);
        }
        view.getPageCache().put("disableEntry", SerializationUtils.toJsonString(disableEntryMap));
    }

    public static Map<String, Map<String, LinkedHashMap<String, Object>>> getnEntityMap(DynamicObjectCollection dynColl) {
        String root = "";
        String entityMapKey = "";
        LinkedHashMap<String, Map<String, LinkedHashMap<String, Object>>> entityMap = new LinkedHashMap<String, Map<String, LinkedHashMap<String, Object>>>(16);
        HashMap<String, Map> propMaps = new HashMap<String, Map>(4);
        for (DynamicObject dyn : dynColl) {
            LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Object>>> dataMap;
            Long pid = dyn.getLong("pid");
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
            data.put("id", dyn.getPkValue());
            data.put("pid", pid);
            String entitydescription = HIESUtil.trimTplFieldEntitydescription(dyn.getString("entitydescription"));
            data.put("entitydescription", entitydescription);
            if (StringUtils.isNotEmpty((CharSequence)entitydescription)) {
                try {
                    Map map = (Map)SerializationUtils.fromJsonString((String)entitydescription, Map.class);
                    ArrayList list = new ArrayList(4);
                    map.values().forEach(x -> {
                        LocaleString lang = (LocaleString)SerializationUtils.fromJsonString((String)x, LocaleString.class);
                        if (StringUtils.isNotEmpty((CharSequence)lang.getLocaleValue())) {
                            list.add(lang.getLocaleValue());
                        }
                    });
                    data.put("displayname", String.join((CharSequence)",", list));
                }
                catch (Throwable e) {
                    LOGGER.warn(e);
                }
            }
            String fieldNumber = dyn.getString("fieldnumber");
            String entityNumber = dyn.getString("childentity");
            String bdFormat = dyn.getString("imptattr");
            Map allFields = (Map)propMaps.get(entityNumber);
            if (MapUtils.isEmpty((Map)allFields) && StringUtils.isNotBlank((CharSequence)entityNumber)) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                allFields = mainType.getAllFields();
                propMaps.put(entityNumber, allFields);
            }
            if (StringUtils.isNotBlank((Object)dyn.get("defvalprop"))) {
                try {
                    String comboItems;
                    IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldNumber);
                    if (property instanceof BasedataProp) {
                        DynamicObject dynamicObject;
                        HRBaseServiceHelper serviceHelper;
                        if (property instanceof QueryProp) {
                            serviceHelper = new HRBaseServiceHelper(((BasedataProp)property).getBaseEntityId());
                            dynamicObject = serviceHelper.loadSingle(dyn.get("defvalprop"));
                            data.put("defvalname", dynamicObject.getString("person.name"));
                        } else {
                            serviceHelper = new HRBaseServiceHelper(((BasedataProp)property).getBaseEntityId());
                            dynamicObject = serviceHelper.loadSingle(dyn.get("defvalprop"));
                            Map<String, Object> bdMainProp = MethodUtil.getBdMainProp(((BasedataProp)property).getBaseEntityId());
                            String bdName = (String)bdMainProp.get("name");
                            data.put("defvalname", dynamicObject.getString(bdName));
                        }
                    } else if (property instanceof ComboProp) {
                        comboItems = dyn.getString("defvalprop");
                        ComboProp comboProp = (ComboProp)allFields.get(fieldNumber);
                        List comboItem = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToStream((CharSequence)comboItems).map(str -> comboProp.getItemByName(str)).collect(Collectors.toList());
                        data.put("defvalname", Joiner.on((String)";").skipNulls().join(comboItem));
                    } else if (property instanceof BooleanProp) {
                        comboItems = dyn.getString("defvalprop");
                        List itemList = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)comboItems);
                        StringBuilder sb = new StringBuilder();
                        for (String s : itemList) {
                            if ("1".equals(s)) {
                                sb.append(ResManager.loadKDString((String)"\u662f", (String)HiesCommonRes.EntityTreeServiceHelper_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                                continue;
                            }
                            sb.append(ResManager.loadKDString((String)"\u5426", (String)HiesCommonRes.EntityTreeServiceHelper_3.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                        }
                        data.put("defvalname", sb.toString());
                    } else if (property instanceof DateProp) {
                        data.put("defvalname", HRDateTimeUtils.getDateStrWithoutMin((Date)new Date(dyn.getLong("defvalprop"))));
                    } else if (property instanceof CreateDateProp) {
                        data.put("defvalname", DateUtils.dateToString((Date)new Date(dyn.getLong("defvalprop")), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS));
                    } else if (property instanceof MuliLangTextProp) {
                        LocaleString localeString = (LocaleString)SerializationUtils.fromJsonString((String)dyn.getString("defvalprop"), LocaleString.class);
                        data.put("defvalname", localeString.getLocaleValue());
                    } else {
                        data.put("defvalname", dyn.get("defvalprop"));
                    }
                }
                catch (Exception exception) {
                    data.put("defvalname", dyn.get("defvalprop"));
                }
            }
            data.put("fieldimportdesc", dyn.getString("fieldimportdesc"));
            data.put("defvalprop", dyn.getString("defvalprop"));
            data.put("ismustinput", dyn.getBoolean("ismustinput"));
            data.put("isimport", dyn.getBoolean("isimport"));
            data.put("isdownloadcond", dyn.getBoolean("isdownloadcond"));
            data.put("iscondgetdata", dyn.getBoolean("iscondgetdata"));
            data.put("isfield", dyn.getBoolean("isfield"));
            data.put("ischecked", dyn.getBoolean("ischecked"));
            data.put("iscusfield", dyn.getBoolean("iscusfield"));
            data.put("seq", dyn.getInt("seq"));
            data.put("imptattr", bdFormat);
            data.put("exptattr", dyn.getString("exptattr"));
            data.put("issheet", dyn.getString("issheet"));
            data.put("sheetbdfields", dyn.getString("sheetbdfields"));
            data.put("fieldnumber", dyn.getString("fieldnumber"));
            data.put("fieldname", dyn.getString("fieldname"));
            boolean isField = dyn.getBoolean("isfield");
            if (pid == null || pid == 0L) continue;
            if (pid != null && pid != 0L && !isField) {
                root = dyn.getString("fieldnumber");
                root = StringUtils.isBlank((CharSequence)root) ? entityNumber + ".billhead" : entityNumber + "." + root;
                dataMap = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Object>>>(16);
                dataMap.put(root, data);
                entityMapKey = root + ":" + pid;
                entityMap.put(entityMapKey, dataMap);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)entityMapKey)) continue;
            dataMap = (LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Object>>>)entityMap.get(entityMapKey);
            fieldNumber = "billhead".equals(fieldNumber) ? "" : fieldNumber;
            dataMap.put(root + "." + fieldNumber, data);
        }
        return entityMap;
    }

    public TreeNode reBuildWholeTree(boolean isImport, String searchText, boolean isInit, boolean isShowVirEntity) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.mainEntityNumber);
        this.treeView.deleteAllNodes();
        TreeNode rootNode = this.buildEntityTreeNodes(mainType, isImport, searchText, isInit, isShowVirEntity);
        this.treeView.addNode(rootNode);
        this.treeView.focusNode(rootNode);
        this.treeView.treeNodeClick("", rootNode.getId());
        this.treeView.getView().getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)rootNode));
        return rootNode;
    }

    public void resetCheckedNode(IFormView fieldView) {
        Set<TreeNode> treeNodes = EntityTreeServiceHelper.getCheckedNode(fieldView);
        ArrayList treeNodeList = Lists.newArrayList(treeNodes);
        this.treeView.checkNodes((List)treeNodeList);
        Set<TreeNode> unTreeNodes = this.getUnCheckedNode(fieldView);
        int unTreeNodeSize = unTreeNodes.size();
        if (unTreeNodeSize == 0) {
            return;
        }
        ArrayList<DynamicObject> unCheckedDyns = new ArrayList<DynamicObject>(unTreeNodeSize);
        ArrayList<Integer> unCheckedRowIndexs = new ArrayList<Integer>(unTreeNodeSize);
        IDataModel model = fieldView.getModel();
        ArrayList<TreeNode> unCheckedNodes = new ArrayList<TreeNode>(unTreeNodes);
        Set unCheckedNodeIds = unCheckedNodes.stream().map(TreeNode::getId).collect(Collectors.toSet());
        DynamicObjectCollection entryEntityDyns = model.getEntryEntity("treeentryentity");
        for (DynamicObject dynamicObject : entryEntityDyns) {
            boolean isEntityId = this.mainEntityNumber.equals(dynamicObject.getString("childentity"));
            boolean isFieldNumber = unCheckedNodeIds.contains(dynamicObject.getString("fieldnumber"));
            boolean isChecked = (Boolean)dynamicObject.get("ischecked");
            if (!isEntityId || !isFieldNumber || isChecked) continue;
            unCheckedDyns.add(dynamicObject);
            unCheckedRowIndexs.add((Integer)dynamicObject.get("seq") - 1);
        }
        if (!CollectionUtils.isEmpty(unCheckedDyns)) {
            EntityTreeServiceHelper.cacheDisableEntrys(fieldView, unCheckedDyns);
            model.deleteEntryRows("treeentryentity", unCheckedRowIndexs.stream().mapToInt(Integer::valueOf).toArray());
        }
        TemplateFormCommonUtil.deleteParentNode(fieldView);
        fieldView.getModel().updateEntryCache(entryEntityDyns);
        fieldView.updateView("treeentryentity");
        TemplateFormCommonUtil.refreshChildEntryFieldDisplay(fieldView);
    }

    public boolean reBuildTreeBySearchKey(TreeView treeView, Boolean isImport, String searchText, boolean isShowVirEntity) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.mainEntityNumber);
        Map<String, List<String>> queryEntityTypeFieldMap = TemplateFormCommonUtil.getQueryEntityTypeFieldMap(this.queryEntityNumber);
        List<String> querySelectFieldList = queryEntityTypeFieldMap.get(this.mainEntityNumber);
        TreeNode rootNode = this.buildEntityTreeNodes(mainType, isImport, searchText, false, isShowVirEntity);
        List children = rootNode.getChildren();
        boolean isEmpty = true;
        for (TreeNode child : children) {
            if (CollectionUtils.isEmpty((Collection)child.getChildren())) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)HiesCommonRes.EntityTreeServiceHelper_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        } else {
            treeView.deleteAllNodes();
            treeView.addNode(rootNode);
            treeView.focusNode(rootNode);
            treeView.treeNodeClick("", rootNode.getId());
        }
        return isEmpty;
    }

    public TreeNode buildEntityTreeNodes(MainEntityType mainEntityType, boolean isImport, String searchText, boolean isInit, boolean isShowVirEntity) {
        String mainEntityNumber;
        TreeNode rootNode = EntityTreeServiceHelper.buildRootNode();
        int[] index = new int[]{1};
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        boolean isQueryEntity = false;
        if (mainEntityType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainEntityType;
            entityTypes.add(queryType.getMainEntityType());
            entityTypes.addAll(queryType.getAllJoinEntityType());
            isQueryEntity = true;
            mainEntityNumber = queryType.getMainEntityType().getName();
        } else {
            entityTypes.add(mainEntityType);
            mainEntityNumber = mainEntityType.getName();
        }
        ArrayList entityNodeList = Lists.newArrayListWithExpectedSize((int)16);
        List<EntityItem<?>> newItems = TemplateEntityFieldUtil.filterEntityItems(mainEntityType, isImport);
        for (MainEntityType mainEntity : entityTypes) {
            Object[] entityNodeId;
            EntityType entityType;
            if (isShowVirEntity) {
                for (Map.Entry entry : mainEntity.getAllEntities().entrySet()) {
                    entityType = (EntityType)entry.getValue();
                    entityNodeId = entityType.getName();
                    if (!mainEntityNumber.equals(entityNodeId)) continue;
                    this.addEntityNode(mainEntityType, searchText, isInit, rootNode, index, entityNodeList, newItems, entityType, (String)entityNodeId);
                }
                Object[] fields = HRVirEntityUtil.getFields(mainEntityNumber);
                if (ArrayUtils.isNotEmpty((Object[])fields)) {
                    TreeNode entityNode = new TreeNode(rootNode.getId(), "HR_VIRENTITY", ResManager.loadKDString((String)"HR\u4eba\u5458\u4fe1\u606f", (String)HiesCommonRes.EntityTreeServiceHelper_5.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), (Object)index[0]);
                    index[0] = index[0] + 1;
                    entityNode.setIsOpened(true);
                    ArrayList childrenNode = Lists.newArrayListWithExpectedSize((int)fields.length);
                    for (Object field : fields) {
                        String fieldNumber = field.getString("fieldnumber");
                        String fieldName = field.getString("fieldname");
                        if (!StringUtils.isBlank((CharSequence)searchText) && !StringUtils.containsIgnoreCase((CharSequence)fieldNumber, (CharSequence)searchText) && !StringUtils.containsIgnoreCase((CharSequence)fieldName, (CharSequence)searchText)) continue;
                        TreeNode treeNode = new TreeNode(entityNode.getId(), fieldNumber, fieldName + "(" + fieldNumber + ")", (Object)index[0]);
                        index[0] = index[0] + 1;
                        treeNode.setIsOpened(true);
                        childrenNode.add(treeNode);
                    }
                    entityNode.addChildren((List)childrenNode);
                    entityNodeList.add(entityNode);
                }
                for (Map.Entry entry : mainEntity.getAllEntities().entrySet()) {
                    EntityType entityType2 = (EntityType)entry.getValue();
                    String entityNodeId2 = entityType2.getName();
                    if (mainEntityNumber.equals(entityNodeId2)) continue;
                    this.addEntityNode(mainEntityType, searchText, isInit, rootNode, index, entityNodeList, newItems, entityType2, entityNodeId2);
                }
            } else {
                for (Map.Entry entry : mainEntity.getAllEntities().entrySet()) {
                    entityType = (EntityType)entry.getValue();
                    entityNodeId = entityType.getName();
                    this.addEntityNode(mainEntityType, searchText, isInit, rootNode, index, entityNodeList, newItems, entityType, (String)entityNodeId);
                }
            }
            rootNode.setChildren((List)entityNodeList);
        }
        return rootNode;
    }

    private void addEntityNode(MainEntityType mainEntityType, String searchText, boolean isInit, TreeNode rootNode, int[] index, List<TreeNode> entityNodeList, List<EntityItem<?>> newItems, EntityType entityType, String entityNodeId) {
        if (entityType instanceof SubEntryType) {
            return;
        }
        if (entityType instanceof LinkEntryType || entityType instanceof NameVersionEntryType) {
            return;
        }
        String entityNodeName = "";
        if (entityType.getDisplayName() != null) {
            entityNodeName = entityType instanceof MainEntityType ? entityType.getDisplayName().toString() : String.format(Locale.ROOT, ResManager.loadKDString((String)"%s(\u5206\u5f55)", (String)HiesCommonRes.EntityTreeServiceHelper_4.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), entityType.getDisplayName().toString());
        }
        List<IDataEntityProperty> properties = entityType.getFields().values().stream().filter(prop -> prop.getName() != null && (entityType instanceof QueryEntityType && !(prop instanceof JoinProperty) || TemplateEntityFieldUtil.newInstance().isPropertyImport(newItems, (IDataEntityProperty)prop))).collect(Collectors.toList());
        this.getSortProperties(this.mainEntityNumber, properties, null, entityType);
        if (!CollectionUtils.isEmpty(properties)) {
            TreeNode entityNode = new TreeNode(rootNode.getId(), entityNodeId, entityNodeName, (Object)index[0]);
            index[0] = index[0] + 1;
            entityNode.setIsOpened(true);
            this.buildEntryFieldTreeNode(mainEntityType.getName(), properties, entityNode, searchText, index, isInit);
            entityNodeList.add(entityNode);
        }
    }

    private void buildEntryFieldTreeNode(String mainEntityNumber, List<IDataEntityProperty> properties, TreeNode entityNode, String searchText, int[] index, boolean isInit) {
        ArrayList childrenNode = Lists.newArrayListWithExpectedSize((int)properties.size());
        for (IDataEntityProperty property : properties) {
            boolean isMustInputField = TemplateEntityFieldUtil.isMustInputField(property);
            DynamicProperty prop = (DynamicProperty)property;
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            String fldNodeId = property.getName();
            if (isMustInputField) {
                fldNodeName = fldNodeName + "*";
            }
            TreeNode treeNode = null;
            if (StringUtils.isBlank((CharSequence)searchText)) {
                treeNode = new TreeNode(entityNode.getId(), fldNodeId, fldNodeName + "(" + fldNodeId + ")", (Object)index[0]);
                index[0] = index[0] + 1;
                treeNode.setIsOpened(true);
                childrenNode.add(treeNode);
            } else if (StringUtils.containsIgnoreCase((CharSequence)fldNodeName, (CharSequence)searchText) || StringUtils.containsIgnoreCase((CharSequence)fldNodeId, (CharSequence)searchText)) {
                treeNode = new TreeNode(entityNode.getId(), fldNodeId, fldNodeName + "(" + fldNodeId + ")", (Object)index[0]);
                index[0] = index[0] + 1;
                treeNode.setIsOpened(true);
                childrenNode.add(treeNode);
            }
            if (!isMustInputField || !isInit) continue;
            this.addCheckedNodeToCache(this.treeView.getView(), Sets.newHashSet((Object[])new TreeNode[]{treeNode}));
        }
        entityNode.addChildren((List)childrenNode);
    }

    public static void putCheckedNodeToCache(IFormView view, Set<TreeNode> treeNodes) {
        view.getPageCache().put("checkedNode", SerializationUtils.toJsonString(treeNodes));
    }

    public void addCheckedNodeToCache(IFormView view, Set<TreeNode> treeNodes) {
        String json = view.getPageCache().get("checkedNode");
        Set treeNodeSet = StringUtils.isBlank((CharSequence)json) ? Sets.newLinkedHashSetWithExpectedSize((int)16) : (Set)SerializationUtils.fromJsonString((String)json, Set.class);
        treeNodeSet.addAll(treeNodes);
        view.getPageCache().put("checkedNode", SerializationUtils.toJsonString((Object)treeNodeSet));
    }

    public Set<TreeNode> getUnCheckedNode(IFormView view) {
        String json = view.getPageCache().get("uncheckedNode");
        LinkedHashSet treeNodes = StringUtils.isBlank((CharSequence)json) ? Sets.newLinkedHashSetWithExpectedSize((int)16) : Sets.newLinkedHashSet((Iterable)JSON.parseArray((String)json, TreeNode.class));
        return treeNodes;
    }

    private void getSortProperties(String rootEntityNumber, List<IDataEntityProperty> properties, Set<String> currSort, EntityType entityType) {
        List<ControlAp<?>> aps = this.getFormMetadata(rootEntityNumber);
        int j = 0;
        block0: for (ControlAp<?> ap : aps) {
            if (!(ap instanceof FieldAp)) continue;
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty prop = properties.get(i);
                if (ap.getKey().equals(prop.getName())) {
                    Collections.swap(properties, i, j++);
                    continue block0;
                }
                IDataEntityType rootEntityType = prop.getParent();
                while (rootEntityType.getParent() != null) {
                    rootEntityType = rootEntityType.getParent();
                }
                String propFullName = rootEntityType.getName() + "." + prop.getName();
                if (!this.dataRangeMap.containsKey(propFullName) || !this.dataRangeMap.get(propFullName).equals(ap.getKey())) continue;
                Collections.swap(properties, i, j++);
            }
        }
        ArrayList<Object> mustInputProps = new ArrayList<Object>();
        ArrayList<IDataEntityProperty> notMustInputProps = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty propertie : properties) {
            if (propertie instanceof FieldProp && ((FieldProp)propertie).isMustInput()) {
                mustInputProps.add(propertie);
                continue;
            }
            notMustInputProps.add(propertie);
        }
        mustInputProps.addAll(notMustInputProps);
        properties.clear();
        properties.addAll(mustInputProps);
        if (currSort != null) {
            this.sortPropertiesByDataMap(rootEntityNumber, properties, currSort, entityType);
        }
    }

    private List<ControlAp<?>> getFormMetadata(String formId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List aps = formMetadata.getItems();
        aps.sort((o1, o2) -> {
            int compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
            if (compareValue != 0) {
                return compareValue;
            }
            return Integer.compare(o1.getIndex(), o2.getIndex());
        });
        return aps;
    }

    private void sortPropertiesByDataMap(String rootEntityNumber, List<IDataEntityProperty> properties, Set<String> currSort, EntityType entityType) {
        int j = 0;
        ArrayList<String> currSortList = new ArrayList<String>(currSort);
        if (currSortList.size() > 0) {
            String pkFullName = entityType.getName() + "." + entityType.getPrimaryKey().getName();
            if (!(entityType instanceof MainEntityType)) {
                pkFullName = rootEntityNumber + "." + pkFullName;
            }
            if (!currSortList.contains(pkFullName)) {
                currSortList.add(1, pkFullName);
            }
            if (entityType instanceof MainEntityType) {
                this.handleAcrossedProperties(properties, rootEntityNumber);
            }
            block0: for (String key : currSortList) {
                for (int i = 0; i < properties.size(); ++i) {
                    IDataEntityProperty prop = properties.get(i);
                    String propFullName = prop.getName().equals(entityType.getPrimaryKey().getName()) ? pkFullName : rootEntityNumber + "." + prop.getName();
                    String newProp = prop.getParent().getName() + "." + prop.getName();
                    if (this.acrossPropMap.containsKey(rootEntityNumber) && this.acrossPropMap.get(rootEntityNumber).containsKey(newProp)) {
                        propFullName = newProp;
                    }
                    if (key.equals(propFullName)) {
                        Collections.swap(properties, i, j++);
                        continue block0;
                    }
                    if (!this.dataRangeMap.containsKey(propFullName) || !this.dataRangeMap.get(propFullName).equals(key)) continue;
                    Collections.swap(properties, i, j++);
                }
            }
        }
    }

    private void handleAcrossedProperties(List<IDataEntityProperty> properties, String rootEntityNumber) {
        for (Map.Entry<String, Map<String, IDataEntityProperty>> entry : this.acrossPropMap.entrySet()) {
            String entityNumber = entry.getKey();
            if (!StringUtils.equals((CharSequence)rootEntityNumber, (CharSequence)entityNumber)) {
                for (IDataEntityProperty property : entry.getValue().values()) {
                    properties.remove(property);
                }
                continue;
            }
            if (!this.acrossPropMap.containsKey(rootEntityNumber)) continue;
            for (IDataEntityProperty property : this.acrossPropMap.get(rootEntityNumber).values()) {
                if (property == null) continue;
                properties.add(property);
            }
        }
    }

    public void initCheckedNodeMap(IFormView fieldView, TreeNode rootNode) {
        IDataModel model = fieldView.getParentView().getModel();
        DynamicObjectCollection dynColl = model.getEntryEntity("tpltreeentryentity");
        ArrayList checkedField = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList unCheckedField = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dyn : dynColl) {
            String fieldNumber = dyn.getString("fieldnumber");
            String entityNumber = dyn.getString("childentity");
            boolean isEntity = entityNumber.equals(this.mainEntityNumber);
            boolean isChecked = dyn.getBoolean("ischecked") || dyn.getBoolean("isimport");
            boolean isField = dyn.getBoolean("isfield");
            boolean isVirField = dyn.getBoolean("isvirfield");
            if ((!isEntity || !isField) && !isVirField) continue;
            if (isChecked) {
                checkedField.add(fieldNumber);
                continue;
            }
            unCheckedField.add(fieldNumber);
        }
        LinkedHashSet checkedTreeNode = Sets.newLinkedHashSetWithExpectedSize((int)16);
        LinkedHashSet uncheckedTreeNode = Sets.newLinkedHashSetWithExpectedSize((int)16);
        List children = rootNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            EntityTreeServiceHelper.checkNodes(children, checkedField, checkedTreeNode);
        }
        if (!CollectionUtils.isEmpty((Collection)children)) {
            EntityTreeServiceHelper.checkNodes(children, unCheckedField, uncheckedTreeNode);
        }
        EntityTreeServiceHelper.putCheckedNodeToCache(fieldView, checkedTreeNode);
        EntityTreeServiceHelper.putUnCheckedNodeToCache(fieldView, uncheckedTreeNode);
    }

    public static void putUnCheckedNodeToCache(IFormView view, Set<TreeNode> treeNodes) {
        view.getPageCache().put("uncheckedNode", SerializationUtils.toJsonString(treeNodes));
    }

    public void resetEdit(IFormView fieldView) {
        String rootNodeStr = fieldView.getPageCache().get("rootNode");
        if (StringUtils.isBlank((CharSequence)rootNodeStr)) {
            return;
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        LinkedHashSet checkedTreeNode = Sets.newLinkedHashSetWithExpectedSize((int)16);
        List children = rootNode.getChildren();
        IFormView parentView = fieldView.getParentView();
        String mustInputField = TemplateFormCommonUtil.getEntityMustInputField(parentView.getModel(), this.mainEntityNumber);
        List<String> checkFields = Arrays.stream(mustInputField.split(",")).collect(Collectors.toList());
        Set<String> formulaRelFieldNumbers = MethodUtil.getFormulaRelFieldNumbers(this.mainEntityNumber, fieldView);
        if (!CollectionUtils.isEmpty(formulaRelFieldNumbers)) {
            checkFields.addAll(formulaRelFieldNumbers);
        }
        TreeView treeView = (TreeView)fieldView.getControl("treeviewap");
        if (!CollectionUtils.isEmpty((Collection)children)) {
            List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
            Map<String, String> itemClassPropMapTypes = MethodUtil.itemClassPropMapTypes(this.mainEntityNumber);
            if (MapUtils.isNotEmpty(itemClassPropMapTypes)) {
                HashSet<String> itemClassProps = new HashSet<String>(itemClassPropMapTypes.keySet());
                itemClassProps.retainAll(checkedNodeIds);
                if (!CollectionUtils.isEmpty(itemClassProps)) {
                    Set itemClassTypeProps = itemClassProps.stream().map(itemClassPropMapTypes::get).collect(Collectors.toSet());
                    itemClassTypeProps.retainAll(checkedNodeIds);
                    checkFields.addAll(itemClassTypeProps);
                }
            }
            EntityTreeServiceHelper.checkNodes(children, checkFields, checkedTreeNode);
        }
        for (TreeNode treeNode : checkedTreeNode) {
            treeView.checkNode(treeNode);
            treeView.treeNodeCheck(treeNode.getParentid(), treeNode.getId(), Boolean.valueOf(true));
            treeNode.setDisabled(true);
            treeView.updateNode(treeNode);
        }
        this.dealItemClassTypePropMustInput(fieldView);
        EntityTreeServiceHelper.lockMustInputField(fieldView, mustInputField);
    }

    public static void lockMustInputField(IFormView fieldView, String mustInputField) {
        String importType = (String)fieldView.getParentView().getModel().getValue("importtype");
        boolean isUpdateType = OprCategory.isUpdate(importType);
        if (!isUpdateType) {
            return;
        }
        DynamicObjectCollection dynColl = fieldView.getModel().getEntryEntity("treeentryentity");
        if (!ObjectUtils.isEmpty((Object)dynColl)) {
            List checkFields = Arrays.stream(mustInputField.split(",")).collect(Collectors.toList());
            for (int i = 0; i < dynColl.size(); ++i) {
                DynamicObject dyn = (DynamicObject)dynColl.get(i);
                String fieldNumber = (String)dyn.get("fieldnumber");
                if (!checkFields.contains(fieldNumber)) continue;
                fieldView.setEnable(Boolean.FALSE, i, new String[]{"ismustinput"});
            }
        }
    }

    public void dealItemClassTypePropMustInput(IFormView fieldView) {
        DynamicObjectCollection collection = fieldView.getModel().getEntryEntity("treeentryentity");
        Map<String, String> itemClassPropMapTypes = MethodUtil.itemClassPropMapTypes(this.mainEntityNumber);
        Set<String> itemClassPropIds = itemClassPropMapTypes.keySet();
        List itemClassTypePropMustInputIds = collection.stream().filter(item -> itemClassPropIds.contains(item.getString("fieldnumber")) && item.getBoolean("ismustinput")).map(item -> (String)itemClassPropMapTypes.get(item.getString("fieldnumber"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(itemClassTypePropMustInputIds)) {
            for (int rowNum = 0; rowNum < collection.size(); ++rowNum) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(rowNum);
                boolean isFieldNumber = itemClassTypePropMustInputIds.contains(dynamicObject.getString("fieldnumber"));
                if (!isFieldNumber || !dynamicObject.getBoolean("ismustinput")) continue;
                fieldView.setEnable(Boolean.FALSE, rowNum, new String[]{"ismustinput"});
            }
        }
    }
}

