/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.FieldStyleServiceHelper;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.common.dto.FieldStyle;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelStyleUtil {
    private static Log log = LogFactory.getLog(ExcelStyleUtil.class);

    public static ExportSheetStyle getExportSheetStyle(DynamicObject templateData, SXSSFWorkbook wb) {
        ExportSheetStyle styles;
        String templateNumber = templateData.getString("number");
        AtomicBoolean useGlobalSheetStyle = new AtomicBoolean(false);
        JSONObject fieldStyle = FieldStyleServiceHelper.getCustomFieldStyle(templateNumber, useGlobalSheetStyle);
        DynamicObject entityInfo = templateData.getDynamicObject("entity");
        String entityNumber = entityInfo.getString("id");
        boolean isGlobalSheetStyle = false;
        if (fieldStyle != null && fieldStyle.containsKey((Object)entityNumber)) {
            styles = ExcelStyleUtil.getCustomSheetStyle(ExcelStyleUtil.getEntityFromTemplateData(templateData), wb, fieldStyle);
        } else {
            styles = ExcelStyleUtil.getGlobalSheetStyle(ExcelStyleUtil.getEntityFromTemplateData(templateData), wb);
            isGlobalSheetStyle = true;
        }
        ExcelStyleUtil.putCustomFieldMerges(templateData, styles);
        if (!isGlobalSheetStyle) {
            Pair<CellStyle, CellStyle> cellStyleCellStyle = ExcelStyleUtil.buildGlobalSheetStyle(wb);
            styles.setGlobalHeadCellStyle((CellStyle)cellStyleCellStyle.getLeft());
            styles.setGlobalContentCellStyle((CellStyle)cellStyleCellStyle.getRight());
        }
        if (useGlobalSheetStyle.get()) {
            JSONObject globalFieldStyle = FieldStyleServiceHelper.getGlobalFieldStyle();
            styles.setTitleRowDefaultStyle(ExcelStyleUtil.isTitleRowDefaultStyle(globalFieldStyle));
        }
        return styles;
    }

    public static Map<String, ControlAp<?>> getFieldControlApMap(String mainEntityName) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityName, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        return formMeta.getItems().stream().filter(item -> item instanceof FieldAp || item instanceof EntryFieldAp).collect(Collectors.toMap(item2 -> item2.getKey(), Function.identity(), (x1, x2) -> x1));
    }

    public static String getMask(Map<String, ControlAp<?>> fieldApMap, IDataEntityProperty prop) {
        boolean flag = prop instanceof DateTimeProp ? StringUtils.isBlank((CharSequence)((DateTimeProp)prop).getRelateDateTimeRange()) : StringUtils.isBlank((CharSequence)((TimeProp)prop).getRelateTimeRange());
        String propName = prop.getName();
        if (propName == null || StringUtils.isBlank((CharSequence)propName)) {
            return "";
        }
        String mask = "";
        if (flag) {
            String string = mask = fieldApMap.get(propName) instanceof FieldAp ? ((FieldAp)fieldApMap.get(propName)).getMask() : ((EntryFieldAp)fieldApMap.get(propName)).getMask();
        }
        if (StringUtils.isBlank((CharSequence)mask)) {
            if (prop instanceof DateProp) {
                return ExcelStyleUtil.getDefaultMask("date");
            }
            if (prop instanceof TimeProp) {
                return ExcelStyleUtil.getDefaultMask("time");
            }
            return ExcelStyleUtil.getDefaultMask("datetime");
        }
        return ExcelStyleUtil.updateToLower(mask);
    }

    public static String getNumberMask(Map<String, ControlAp<?>> fieldApMap, IDataEntityProperty prop) {
        String propName = prop.getName();
        ControlAp<?> controlAp = fieldApMap.get(propName);
        if (ObjectUtils.isEmpty(controlAp)) {
            return "";
        }
        String mask = controlAp instanceof FieldAp ? ((FieldAp)controlAp).getMask() : ((EntryFieldAp)controlAp).getMask();
        return mask;
    }

    public static String getDisplayFormatString(Map<String, ControlAp<?>> fieldApMap, IDataEntityProperty prop) {
        String propName = prop.getName();
        try {
            ControlAp<?> controlAp = fieldApMap.get(propName);
            if (ObjectUtils.isEmpty(controlAp)) {
                return "";
            }
            String displayFormatString = controlAp instanceof FieldAp ? ((FieldAp)controlAp).getDisplayFormatString() : ((EntryFieldAp)controlAp).getDisplayFormatString();
            return displayFormatString;
        }
        catch (Exception ex) {
            log.warn("getDisplayFormatString fail propName={}", (Object)propName, (Object)ex);
            return "";
        }
    }

    public static boolean getNoDisplayScaleZero(Map<String, ControlAp<?>> fieldApMap, IDataEntityProperty prop) {
        String propName = prop.getName();
        try {
            ControlAp<?> controlAp = fieldApMap.get(propName);
            if (ObjectUtils.isEmpty(controlAp)) {
                return false;
            }
            boolean noDisplayScaleZero = controlAp instanceof FieldAp ? ((FieldAp)controlAp).isNoDisplayScaleZero() : ((EntryFieldAp)controlAp).isNoDisplayScaleZero();
            return noDisplayScaleZero;
        }
        catch (Exception ex) {
            log.warn("getNoDisplayScaleZero fail propName={}", (Object)propName, (Object)ex);
            return false;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static String updateToLower(String mask) {
        if (StringUtils.isNotBlank((CharSequence)mask)) {
            return mask.replace("YY", "yy").replace("DD", "dd");
        }
        return "";
    }

    public static String getDefaultMask(String type) {
        switch (type) {
            case "date": {
                return "yyyy-MM-dd";
            }
            case "time": {
                return "HH:mm:ss";
            }
        }
        return "yyyy-MM-dd HH:mm:ss";
    }

    public static ExportSheetStyle getByListExportSheetStyle(Set<String> entitySet, SXSSFWorkbook wb) {
        return ExcelStyleUtil.getGlobalSheetStyle(entitySet, wb);
    }

    public static CellStyle getByListExportCellStyle(SXSSFWorkbook wb) {
        ExportSheetStyle byListExportSheetStyle = ExcelStyleUtil.getByListExportSheetStyle(new HashSet<String>(), wb);
        return byListExportSheetStyle.getGlobalHeadCellStyle();
    }

    public static ExportSheetStyle getGlobalSheetStyle(Set<String> entitySet, SXSSFWorkbook wb) {
        ExportSheetStyle exportSheetStyle;
        JSONObject globalFieldStyle = FieldStyleServiceHelper.getGlobalFieldStyle();
        if (globalFieldStyle != null && !globalFieldStyle.isEmpty()) {
            globalFieldStyle = FieldStyleServiceHelper.getGlobalFieldStyle();
            Pair<CellStyle, CellStyle> cellStyleCellStyle = ExcelStyleUtil.buildGlobalSheetStyle(wb, globalFieldStyle);
            exportSheetStyle = new ExportSheetStyle(entitySet, wb, (CellStyle)cellStyleCellStyle.getLeft(), (CellStyle)cellStyleCellStyle.getRight());
        } else {
            exportSheetStyle = new ExportSheetStyle(wb);
        }
        exportSheetStyle.setTitleRowDefaultStyle(ExcelStyleUtil.isTitleRowDefaultStyle(globalFieldStyle));
        return exportSheetStyle;
    }

    public static boolean isTitleRowDefaultStyle(JSONObject globalFieldStyle) {
        JSONObject headJsonObject;
        if (globalFieldStyle != null && !globalFieldStyle.isEmpty() && (headJsonObject = globalFieldStyle.getJSONObject("header")) != null && !headJsonObject.isEmpty()) {
            JSONObject defaultStyle = FieldStyleServiceHelper.getDefaultStyle();
            FieldStyle headerFieldStyle = (FieldStyle)defaultStyle.get((Object)"header");
            String fontSize = headJsonObject.getString("fontSize");
            String fontFamily = headJsonObject.getString("fontFamily");
            String backgroundColor = headJsonObject.getString("backgroundColor");
            if (!(headerFieldStyle.getFontSize().equalsIgnoreCase(fontSize) && headerFieldStyle.getFontFamily().equalsIgnoreCase(fontFamily) && headerFieldStyle.getBackgroundColor().equalsIgnoreCase(backgroundColor))) {
                return false;
            }
        }
        return true;
    }

    private static Pair<CellStyle, CellStyle> buildGlobalSheetStyle(SXSSFWorkbook wb) {
        return ExcelStyleUtil.buildGlobalSheetStyle(wb, FieldStyleServiceHelper.getGlobalFieldStyle());
    }

    private static Pair<CellStyle, CellStyle> buildGlobalSheetStyle(SXSSFWorkbook wb, JSONObject fieldStyle) {
        JSONObject contentJsonObject;
        XSSFWorkbook xssfWorkbook = wb.getXSSFWorkbook();
        CellStyle globalHeadCellStyle = null;
        CellStyle globalContentCellStyle = null;
        JSONObject headJsonObject = fieldStyle.getJSONObject("header");
        if (headJsonObject != null && !headJsonObject.isEmpty()) {
            FieldStyle globalHeadFieldStyle = (FieldStyle)headJsonObject.toJavaObject(FieldStyle.class);
            globalHeadCellStyle = globalHeadFieldStyle.getCellStyle(xssfWorkbook);
        }
        if ((contentJsonObject = fieldStyle.getJSONObject("content")) != null && !contentJsonObject.isEmpty()) {
            FieldStyle globalContentFieldStyle = (FieldStyle)contentJsonObject.toJavaObject(FieldStyle.class);
            globalContentCellStyle = globalContentFieldStyle.getCellStyle(xssfWorkbook);
        }
        return Pair.of(globalHeadCellStyle, globalContentCellStyle);
    }

    private static ExportSheetStyle getCustomSheetStyle(Set<String> entitySet, SXSSFWorkbook wb, JSONObject fieldStyle) {
        XSSFWorkbook xssfWorkbook = wb.getXSSFWorkbook();
        HashBasedTable customHeadCellStyles = HashBasedTable.create();
        HashBasedTable customContentCellStyles = HashBasedTable.create();
        fieldStyle.forEach((arg_0, arg_1) -> ExcelStyleUtil.lambda$getCustomSheetStyle$5(xssfWorkbook, (Table)customHeadCellStyles, (Table)customContentCellStyles, arg_0, arg_1));
        ExportSheetStyle styles = new ExportSheetStyle(entitySet, wb, (Table<String, String, CellStyle>)customHeadCellStyles, (Table<String, String, CellStyle>)customContentCellStyles);
        return styles;
    }

    public static Set<String> getEntityFromTemplateData(DynamicObject templateData) {
        if (templateData != null) {
            HashSet set = Sets.newHashSet((Object[])new String[]{templateData.getString("entity.number")});
            if (templateData.containsProperty("entityrelation")) {
                DynamicObjectCollection entityrelation = templateData.getDynamicObjectCollection("entityrelation");
                for (DynamicObject child : entityrelation) {
                    set.add(child.getString("rentity.id"));
                }
            }
            return set;
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static ExportSheetStyle getPreViewExportSheetStyle(DynamicObject templateData, SXSSFWorkbook wb, String fieldstyle, String fieldmerge) {
        ExportSheetStyle styles;
        JSONObject fieldStyle = JSON.parseObject((String)fieldstyle);
        DynamicObject entityInfo = templateData.getDynamicObject("entity");
        String entityNumber = entityInfo.getString("id");
        boolean isGlobalSheetStyle = false;
        if (fieldStyle != null && fieldStyle.containsKey((Object)entityNumber)) {
            styles = ExcelStyleUtil.getCustomSheetStyle(ExcelStyleUtil.getEntityFromTemplateData(templateData), wb, fieldStyle);
        } else {
            styles = ExcelStyleUtil.getGlobalSheetStyle(ExcelStyleUtil.getEntityFromTemplateData(templateData), wb);
            isGlobalSheetStyle = true;
        }
        ExcelStyleUtil.putCustomFieldMerges(fieldmerge, styles);
        if (!isGlobalSheetStyle) {
            Pair<CellStyle, CellStyle> cellStyleCellStyle = ExcelStyleUtil.buildGlobalSheetStyle(wb);
            styles.setGlobalHeadCellStyle((CellStyle)cellStyleCellStyle.getLeft());
            styles.setGlobalContentCellStyle((CellStyle)cellStyleCellStyle.getRight());
        }
        return styles;
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean putCustomFieldMerges(String fieldmerge, ExportSheetStyle styles) {
        JSONObject customFieldMerge = JSON.parseObject((String)fieldmerge);
        if (customFieldMerge == null || customFieldMerge.isEmpty()) {
            return false;
        }
        return ExcelStyleUtil.putCustomFieldMerges(styles, customFieldMerge);
    }

    private static boolean putCustomFieldMerges(DynamicObject templateData, ExportSheetStyle styles) {
        String templateNumber = templateData.getString("number");
        JSONObject customFieldMerge = FieldStyleServiceHelper.getCustomFieldMerge(templateNumber);
        if (customFieldMerge == null || customFieldMerge.isEmpty()) {
            return false;
        }
        return ExcelStyleUtil.putCustomFieldMerges(styles, customFieldMerge);
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean putCustomFieldMerges(ExportSheetStyle styles, JSONObject customFieldMerge) {
        HashBasedTable customFieldMerges = HashBasedTable.create();
        customFieldMerge.forEach((arg_0, arg_1) -> ExcelStyleUtil.lambda$putCustomFieldMerges$7((Table)customFieldMerges, arg_0, arg_1));
        if (ObjectUtils.isNotEmpty((Object)customFieldMerges)) {
            styles.setCustomFieldMerges((Table<String, String, String>)customFieldMerges);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$putCustomFieldMerges$7(Table customFieldMerges, String key, Object value) {
        JSONObject fields = JSON.parseObject((String)((String)value));
        fields.forEach((key1, value1) -> {
            String cfr_ignored_0 = (String)customFieldMerges.put((Object)key, key1, (Object)((String)value1));
        });
    }

    private static /* synthetic */ void lambda$getCustomSheetStyle$5(XSSFWorkbook xssfWorkbook, Table customHeadCellStyles, Table customContentCellStyles, String key, Object value) {
        JSONObject fields = (JSONObject)value;
        fields.forEach((key1, value1) -> {
            JSONObject cellStyles = (JSONObject)value1;
            cellStyles.forEach((key2, value2) -> {
                FieldStyle customFieldStyle = (FieldStyle)((JSONObject)value2).toJavaObject(FieldStyle.class);
                CellStyle customCellStyle = customFieldStyle.getCellStyle(xssfWorkbook);
                if ("header".equals(key2)) {
                    customHeadCellStyles.put((Object)key, key1, (Object)customCellStyle);
                } else if ("content".equals(key2)) {
                    customContentCellStyles.put((Object)key, key1, (Object)customCellStyle);
                }
            });
        });
    }
}

