/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.ext.hr.entity.property.HisModelBasedataProp;
import kd.bos.ext.hr.entity.property.MulHisModelBasedataProp;
import kd.bos.form.AbstractFormView;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.constant.HIESConstant;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.enu.TemplateTypeEnum;
import kd.hr.hies.common.util.MethodUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HIESUtil {
    private static final Log LOGGER = LogFactory.getLog(HIESUtil.class);

    public static IFormView createEntityFormView(String formId) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("formId", formId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(mapParam);
        IFormView viewForWebApi = parameter.createViewForWebApi();
        viewForWebApi.initialize(parameter);
        return viewForWebApi;
    }

    public static String getSplitValue(Map<Integer, String> data) {
        return HIESUtil.getSplitValue(data.values().stream().findFirst().orElse(""));
    }

    public static String getSplitValue(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return "";
        }
        String[] split = data.split("#", 2);
        if (split.length > 1) {
            return split[1].trim();
        }
        return data;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void showMessage(IFormView formView, String msg, String detail, ConfirmCallBackListener callBack) {
        HashMap<String, String> jo = new HashMap<String, String>();
        if (callBack != null) {
            jo.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)formView.getService(IPageCache.class);
            cache.put("ConfirmCallBackListener." + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        jo.put("msg", msg);
        jo.put("detail", detail);
        jo.put("messageType", (String)MessageTypes.Default);
        ((AbstractFormView)formView).getClientProxy().addAction("showMessage", jo);
    }

    public static int excelNum2Digit(String excelNum) {
        char[] chars = excelNum.toCharArray();
        int digit = 0;
        for (char ch : chars) {
            digit = digit * 26 + (ch - 65 + 1);
        }
        return digit;
    }

    public static Boolean getBoolMap(String val) {
        HashSet<String> trueList = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u662f", (String)HiesCommonRes.HIESUtil_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)HiesCommonRes.HIESUtil_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)HiesCommonRes.HIESUtil_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)HiesCommonRes.HIESUtil_3.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), "true", "yes", "ok"));
        if (trueList.contains(val)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean getBooleanOfFalse(String val) {
        HashSet<String> trueList = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u5426", (String)HiesCommonRes.HIESUtil_4.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5047", (String)HiesCommonRes.HIESUtil_5.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0d\u52fe\u9009", (String)HiesCommonRes.HIESUtil_6.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9519", (String)HiesCommonRes.HIESUtil_7.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), "false", "no", "no good"));
        if (trueList.contains(val)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * Exception decompiling
     */
    public static String formatException(Throwable throwable) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getLegalSheetName(String name, String tmpltype) {
        name = HIESConstant.SpecCharPattern.matcher(name).replaceAll("");
        if (TemplateTypeEnum.IMPT.getCode().equalsIgnoreCase(tmpltype) && name.length() > 28) {
            return name.substring(name.length() - 28, name.length());
        }
        if (name.length() > 30) {
            return name.substring(name.length() - 30, name.length());
        }
        return name;
    }

    public static void getAllBDFieldKeys(DataEntityPropertyCollection properties, Set<String> allKeys, Set<String> allMulKeys, Set<String> allRefBillKeys) {
        for (IDataEntityProperty property : properties) {
            if (property instanceof BasedataProp) {
                allKeys.add(property.getName());
                continue;
            }
            if (property instanceof MulBasedataProp) {
                allMulKeys.add(property.getName());
                continue;
            }
            if (property instanceof RefBillProp) {
                allRefBillKeys.add(property.getName());
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryProperties = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
            HIESUtil.getAllBDFieldKeys(entryProperties, allKeys, allMulKeys, allRefBillKeys);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean needRelationInStoreForMEMS(DynamicObject tpl) {
        boolean needRelationInStore = false;
        String entitytype = tpl.getString("entitytype");
        if ("MEMS".equalsIgnoreCase(entitytype)) {
            DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
            for (DynamicObject child : entityrelation) {
                String relationleftprop = child.getString("relationleftprop");
                String relationrightprop = child.getString("relationrightprop");
                if (!StringUtils.isNotEmpty((CharSequence)relationleftprop) || !StringUtils.isNotEmpty((CharSequence)relationrightprop)) continue;
                needRelationInStore = true;
            }
        }
        return needRelationInStore;
    }

    public static String tranDecimalToBase26(int number) {
        StringBuilder stringBuilder = new StringBuilder();
        while (number > 0) {
            int m = number % 26;
            if (m != 0) {
                stringBuilder.insert(0, (char)(m - 1 + 65));
            } else {
                stringBuilder.insert(0, 'Z');
                number -= 26;
            }
            number = (number - m) / 26;
        }
        return stringBuilder.toString();
    }

    @ExcludeFromJacocoGeneratedReport
    public static String letterBackward(String letter) {
        byte key = letter.getBytes()[letter.length() - 1];
        letter = key == 90 ? (letter.length() > 1 ? (char)(letter.getBytes()[0] + 1) + "A" : "AA") : String.valueOf((char)(key + 1));
        return letter;
    }

    public static String getGlobalPlugins() {
        Optional first;
        Map map = BusinessDataServiceHelper.loadFromCache((String)"hies_diaesysparam", (String)"plugin", null);
        if (ObjectUtils.isNotEmpty((Object)map) && (first = map.values().stream().findFirst()).isPresent()) {
            return ((DynamicObject)first.get()).getString("plugin");
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void removeTaskKey(String taskId, String type) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            return;
        }
        LinkedList<String> keys = new LinkedList<String>();
        if (ImportCacheKeyType.EXPORT.equals(type)) {
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.EXPORT, "status"));
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.EXPORT, "processing"));
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.EXPORT, "result"));
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.EXPORT, "urls"));
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.EXPORT, "ball"));
        } else if (ImportCacheKeyType.IMPORT.equals(type)) {
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.IMPORT, "status"));
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.IMPORT, "processing"));
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.IMPORT, "result"));
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.IMPORT, "urls"));
            keys.add(MethodUtil.getTaskCachePath(taskId, ImportCacheKeyType.IMPORT, "ball"));
        }
        IHRAppCache cache = HRAppCache.get((String)"hies");
        keys.forEach(key -> cache.remove(key));
    }

    public static Map<Long, String> getAllAdminDivision() {
        DynamicObjectCollection collection = new HRBaseServiceHelper("bd_admindivision").queryOriginalCollection("id,fullname,country.name", new QFilter[0]);
        Map<Long, String> adminDivisionMap = collection.stream().collect(Collectors.toMap(dy2 -> dy2.getLong(0), dy -> dy.getString(2) + "/" + dy.getString(1).replace("_", "/"), (x1, x2) -> x1));
        return adminDivisionMap;
    }

    public static boolean needLoadHisModelPlugin(String entityNumber) {
        Map allFields = MetadataServiceHelper.getDataEntityType((String)entityNumber).getAllFields();
        boolean boid = allFields.containsKey("boid");
        boolean isCurrentVersion = allFields.containsKey("iscurrentversion");
        if (boid && isCurrentVersion) {
            return true;
        }
        for (Map.Entry entityPropertyEntry : allFields.entrySet()) {
            IDataEntityProperty value = (IDataEntityProperty)entityPropertyEntry.getValue();
            if (!(value instanceof HisModelBasedataProp) && !(value instanceof MulHisModelBasedataProp)) continue;
            return true;
        }
        return false;
    }

    public static boolean needLoadOdcFilterPlugin(String entityNumber, List<String> bdNames) {
        Map allFields = MetadataServiceHelper.getDataEntityType((String)entityNumber).getAllFields();
        for (Map.Entry entityPropertyEntry : allFields.entrySet()) {
            BasedataEntityType type;
            IDataEntityProperty fldProperty = (IDataEntityProperty)entityPropertyEntry.getValue();
            if (!(fldProperty instanceof IBasedataField) || !bdNames.contains((type = (BasedataEntityType)((IBasedataField)fldProperty).getComplexType()).getName())) continue;
            return true;
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Timestamp tranImptDateTimeProp(Object sourceDate, IDataEntityProperty prop, DynamicObject bill) throws ParseException {
        if (sourceDate == null) {
            return null;
        }
        DateTimeProp dateTimeProp = (DateTimeProp)prop;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatDate = format.format(sourceDate);
        Date date = dateTimeProp.parse((Object)bill, formatDate);
        Timestamp timestamp = new Timestamp(date.getTime());
        return timestamp;
    }

    public static Date tranExptDateTimeProp(Date sourceDate, DateTimeProp dateTimeProp, DynamicObject bill) throws ParseException {
        if (sourceDate != null) {
            String formatDate = dateTimeProp.format((Object)bill, sourceDate);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.parse(formatDate);
        }
        return sourceDate;
    }

    public static Map<String, Map<String, DynamicObject>> getTplFieldConfig(DynamicObject tpl) {
        DynamicObjectCollection templateEntry = tpl.getDynamicObjectCollection("tpltreeentryentity");
        HashMap entityFieldInfoMap = Maps.newHashMapWithExpectedSize((int)templateEntry.size());
        Map roleIdAndParentsList = templateEntry.stream().collect(Collectors.groupingBy(item -> item.getString("childentity"), Collectors.toList()));
        String entityNumber = "";
        Iterator iterator = roleIdAndParentsList.entrySet().iterator();
        while (iterator.hasNext()) {
            LinkedHashMap<String, DynamicObject> fieldSet = new LinkedHashMap<String, DynamicObject>();
            Map.Entry next = iterator.next();
            for (DynamicObject row : next.getValue()) {
                String attr = row.getString("fieldnumber");
                long pid = row.getLong("pid");
                if (pid != 0L && (row.getBoolean("isimport") || !row.getBoolean("isimport") && StringUtils.isNotBlank((CharSequence)row.getString("defvalprop")))) {
                    fieldSet.put(attr, row);
                    continue;
                }
                if (pid != 0L) continue;
                entityNumber = attr;
                entityFieldInfoMap.put(entityNumber, fieldSet);
            }
        }
        return entityFieldInfoMap;
    }

    public static String getTplInstruction() {
        StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"1.\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\uff1b", (String)HiesCommonRes.HIESUtil_8.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        builder.append(HIESUtil.getSysLineSeparator());
        builder.append(ResManager.loadKDString((String)"2.\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)HiesCommonRes.HIESUtil_9.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        return builder.toString();
    }

    public static String getTplInstruction2() {
        StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"1.\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\uff1b", (String)HiesCommonRes.HIESUtil_8.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        builder.append(HIESUtil.getSysLineSeparator());
        builder.append(ResManager.loadKDString((String)"2.\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff1b", (String)HiesCommonRes.HIESUtil_10.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        return builder.toString();
    }

    public static String getSysLineSeparator() {
        String lineSeparator = System.getProperty("line.separator");
        if (StringUtils.isEmpty((CharSequence)lineSeparator)) {
            lineSeparator = "\r\n";
        }
        return lineSeparator;
    }

    public static DataSet smartQueryF7(String baseDataEntityNum, Set<String> selectFields, QFilter[] qFilters, boolean isQueryProp, String logKey) {
        DataSet resultDataSet = null;
        try {
            if (isQueryProp) {
                DataSet tempDs;
                int size = qFilters[0].getNests(false).size();
                LOGGER.info(logKey + "_queryHrPersonF7_qFilters_size:{}", (Object)size);
                resultDataSet = HIESUtil.queryHrPersonF7(baseDataEntityNum, selectFields, qFilters);
                if (size > 500 && !(tempDs = resultDataSet.copy()).hasNext()) {
                    LOGGER.info("smartQueryF7_trigger_StackOverflowError");
                    throw new StackOverflowError();
                }
            } else {
                Set<String> collect = MethodUtil.filterNotExistField(selectFields, baseDataEntityNum);
                LOGGER.info(logKey + "_smartQueryF7_filterNotExistField_collect:{}", collect);
                resultDataSet = new HRBaseServiceHelper(baseDataEntityNum).queryDataSet("ExistsValidator_validate()", String.join((CharSequence)",", collect), qFilters);
            }
        }
        catch (Throwable e) {
            LOGGER.error("smartQueryF7_error.", e);
            QFilter baseDataQf = qFilters[0];
            List nests = baseDataQf.getNests(false);
            ArrayList<QFilter> tempList = new ArrayList<QFilter>(nests.size());
            QFilter firstQf = new QFilter(baseDataQf.getProperty(), baseDataQf.getCP(), baseDataQf.getValue());
            firstQf.and(((QFilter.QFilterNest)nests.get(0)).getFilter());
            tempList.add(firstQf);
            AtomicInteger index = new AtomicInteger(0);
            nests.forEach(qFilterNest -> {
                if (index.get() > 0) {
                    tempList.add(qFilterNest.getFilter());
                }
                index.getAndIncrement();
            });
            LOGGER.info(logKey + "smartQueryF7_tempList.size=" + tempList.size());
            if (nests.size() < 100) {
                throw e;
            }
            List averageAssignList = MethodUtil.averageAssign(tempList, 2);
            for (List list : averageAssignList) {
                QFilter newQFilter = null;
                for (QFilter qf : list) {
                    if (newQFilter == null) {
                        newQFilter = qf;
                        continue;
                    }
                    newQFilter.or(qf);
                }
                qFilters[0] = newQFilter;
                MethodUtil.printQfilters(qFilters, logKey + "_smartQueryF7_exception_qFilters");
                DataSet subDataSet = HIESUtil.smartQueryF7(baseDataEntityNum, selectFields, qFilters, isQueryProp, logKey);
                if (resultDataSet == null) {
                    resultDataSet = subDataSet;
                    continue;
                }
                resultDataSet = resultDataSet.union(subDataSet);
            }
        }
        return resultDataSet;
    }

    private static DataSet queryHrPersonF7(String baseDataEntityNum, Set<String> selectFields, QFilter[] qFilters) {
        if ("hrpi_depempf7query".equalsIgnoreCase(baseDataEntityNum)) {
            selectFields.add("adminorg.id");
            selectFields.add("adminorg");
        }
        return new HRBaseServiceHelper(baseDataEntityNum).queryMultiEntityDataSet(String.join((CharSequence)",", selectFields), qFilters, "", false, 0, 0);
    }

    public static String trimTplFieldEntitydescription(String entitydescription) {
        if (StringUtils.isEmpty((CharSequence)entitydescription) || !entitydescription.endsWith("^")) {
            return entitydescription;
        }
        return StringUtils.substringBetween((String)entitydescription, (String)"^en_US", (String)"^");
    }
}

