/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.util.FileNameUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.zip.ZipFile;
import kd.bos.zip.exception.ZipException;
import kd.bos.zip.model.ZipParameters;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import org.apache.commons.io.FileUtils;

public class ImportFileUtil {
    private static final Log logger = LogFactory.getLog(ImportFileUtil.class);

    public static String downloadTempFile(String tempUrl) throws IOException {
        logger.info("downloadTempFile_tempUrl=" + tempUrl);
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(tempUrl).getQuery().split("&");
        HashMap downloadFileParams = Maps.newHashMapWithExpectedSize((int)queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        try (InputStream in = content.getInputStream();){
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
        }
        logger.info("downloadTempFile_tempFile=" + tempFile.getPath());
        logger.info("downloadTempFile_tempFile.size=" + tempFile.length());
        return tempFile.getPath();
    }

    public static String downloadFile(String servePath) throws IOException {
        logger.info("downloadFile_tempUrl=" + servePath);
        FileService service = FileServiceFactory.getAttachmentFileService();
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
        try (InputStream in = service.getInputStream(servePath);){
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
        }
        logger.info("downloadFile_tempFile=" + tempFile.getPath());
        logger.info("downloadFile_tempFile.size=" + tempFile.length());
        return tempFile.getPath();
    }

    @ExcludeFromJacocoGeneratedReport
    public static String downloadRenameFile(String fullUrl, String fileName) throws IOException {
        String fileId = StringUtils.substringBetween((String)fullUrl, (String)"path=", (String)"&");
        String localPath = ImportFileUtil.downloadFile(fileId);
        File temp = new File(localPath);
        TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = null;
        try (FileInputStream fis = new FileInputStream(temp);){
            tempUrl = tfc.saveAsFullUrl(fileName, (InputStream)fis, 60);
            ImportFileUtil.deleteLocalTempFile(localPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tempUrl;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String downloadAttachPanelFileToDisk(String fullUrl) throws IOException {
        String fileId = StringUtils.substringBetween((String)fullUrl, (String)"path=", (String)"&");
        String localPath = ImportFileUtil.downloadFile(fileId);
        return localPath;
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> uploadFile(String fileName, String localPath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void deleteLocalTempFile(String localPath) throws IOException {
        Path path = Paths.get(localPath, new String[0]);
        Files.deleteIfExists(path);
    }

    public static void deleteDirectory(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
    }

    private static String getNewFilePath(String oldPath, String fileName) {
        String selfPath = oldPath;
        boolean encrptyPath = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"isEncrptyPath", (Object[])new Object[0])));
        if (oldPath == null || !oldPath.contains("/")) {
            selfPath = ImportFileUtil.generateAttPath(fileName);
        }
        return !encrptyPath ? selfPath : ImportFileUtil.generateAttPath(fileName);
    }

    private static String generateAttPath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)uuid, (String)fileName);
    }

    public static void deleteDirectory(String dirct) throws IOException {
        Path path = Paths.get(dirct, new String[0]);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @ExcludeFromJacocoGeneratedReport
    public static String createZip(String direc, List<String> files, String zipName) throws ZipException {
        File parent = new File(direc);
        ZipParameters zipParameters = new ZipParameters();
        LinkedList<File> filesToAdd = new LinkedList<File>();
        for (String file : files) {
            filesToAdd.add(new File(parent, file));
        }
        ZipFile zipFile = new ZipFile(zipName);
        zipFile.addFiles(filesToAdd, zipParameters);
        return zipName;
    }
}

