/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hies.common.bo.MetaMenuBO;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MetaMenuUtil {
    private static final Log LOGGER = LogFactory.getLog(MetaMenuUtil.class);
    private static final HRBaseServiceHelper cloudDbHelper = HRBaseServiceHelper.create((String)"hbss_cloud");

    @ExcludeFromJacocoGeneratedReport
    public static MetaMenuBO getMetaMenuBO(String appId, String formId) {
        String querySql = "SELECT c.fbizappid bizAppId, a.fid menuId from T_META_MENURUNTIME a LEFT JOIN t_meta_formdesign b on a.fformid = b.fnumber LEFT JOIN t_meta_entitydesign c ON b.fentityid = c.fid where 1=1 AND a.fappid = '%s' AND a.fformid = '%s' ";
        String sql = String.format(Locale.ROOT, querySql, appId, formId);
        return (MetaMenuBO)HRDBUtil.query((DBRoute)DBRoute.meta, (String)sql, null, resultSet -> {
            if (resultSet.next()) {
                MetaMenuBO metaMenuBO2 = new MetaMenuBO();
                metaMenuBO2.setBizAppId(resultSet.getString("bizAppId"));
                metaMenuBO2.setMenuItemId(resultSet.getString("menuId"));
                metaMenuBO2.setFormId(formId);
                metaMenuBO2.setAppId(appId);
                return metaMenuBO2;
            }
            MetaMenuBO metaMenuBO2 = new MetaMenuBO();
            metaMenuBO2.setFormId(formId);
            metaMenuBO2.setAppId(appId);
            return metaMenuBO2;
        });
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<MetaMenuBO> getMetaMenuBOs(String formId) {
        String querySql = "SELECT c.fbizappid bizAppId, a.fid menuId, a.fappid appId from T_META_MENURUNTIME a LEFT JOIN t_meta_formdesign b on a.fformid = b.fnumber LEFT JOIN t_meta_entitydesign c ON b.fentityid = c.fid where 1=1 AND a.fformid = '%s' ";
        String sql = String.format(Locale.ROOT, querySql, formId);
        ArrayList<MetaMenuBO> metaMenuBOs = new ArrayList<MetaMenuBO>(2);
        HRDBUtil.query((DBRoute)DBRoute.meta, (String)sql, null, resultSet -> {
            while (resultSet.next()) {
                MetaMenuBO metaMenuBO2 = new MetaMenuBO();
                metaMenuBO2.setBizAppId(resultSet.getString("bizAppId"));
                metaMenuBO2.setMenuItemId(resultSet.getString("menuId"));
                metaMenuBO2.setFormId(formId);
                metaMenuBO2.setAppId(resultSet.getString("appId"));
                metaMenuBOs.add(metaMenuBO2);
            }
            return null;
        });
        return metaMenuBOs;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String warpOprPageInfo(String appId, String formId, String serviceAppId) {
        MetaMenuBO metaMenuBO = MetaMenuUtil.getMetaMenuBO(appId, formId);
        metaMenuBO.setServiceAppId(serviceAppId);
        return metaMenuBO == null ? "" : SerializationUtils.toJsonString((Object)metaMenuBO);
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getBusinessField(String appNumber) {
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appNumber);
            if (ObjectUtils.isNotEmpty((Object)appInfo)) {
                return MetaMenuUtil.queryHbssBizCloudId(appInfo.getId());
            }
        }
        catch (Exception e) {
            LOGGER.warn("getBusinessField is err,errMsg:{}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getAppId(String appNumber) {
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appNumber);
            return ObjectUtils.isNotEmpty((Object)appInfo) ? appInfo.getId() : "";
        }
        catch (Exception e) {
            LOGGER.warn("getAppId is err,errMsg:{}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getAppName(String appNumber) {
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appNumber);
            return ObjectUtils.isNotEmpty((Object)appInfo) ? appInfo.getName().getLocaleValue() : "";
        }
        catch (Exception e) {
            LOGGER.warn("getAppName is err,errMsg:{}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getBizCloudName(String appNumber) {
        try {
            DynamicObject bizCloudDyn;
            String appId = MetaMenuUtil.getAppId(appNumber);
            if (StringUtils.isNotBlank((CharSequence)appId) && ObjectUtils.isNotEmpty((Object)(bizCloudDyn = BizCloudServiceHelp.getBizCloudByAppID((String)appId)))) {
                OrmLocaleValue bizCloudName = (OrmLocaleValue)bizCloudDyn.get("name");
                return bizCloudName.getLocaleValue();
            }
        }
        catch (Exception e) {
            LOGGER.warn("getBizCloudName is err,errMsg:{}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    @ExcludeFromJacocoGeneratedReport
    public static String queryHbssBizCloudId(String appId) {
        try {
            DynamicObject bizCloudDyn = BizCloudServiceHelp.getBizCloudByAppID((String)appId);
            String bizCloudId = bizCloudDyn.getString("id");
            if (StringUtils.isBlank((CharSequence)bizCloudId)) {
                LOGGER.warn("table[t_meta_bizapp] fid={} is not data", (Object)appId);
                return "";
            }
            DynamicObject dynamicObject = cloudDbHelper.queryOriginalOne("id", new QFilter("cloud", "=", (Object)bizCloudId));
            if (Objects.nonNull(dynamicObject)) {
                String businessFieldId = dynamicObject.getString("id");
                if (StringUtils.isBlank((CharSequence)businessFieldId)) {
                    LOGGER.warn("table[t_hbss_cloud] fcloudid={} is not data", (Object)bizCloudId);
                    return "";
                }
                return businessFieldId;
            }
        }
        catch (Exception e) {
            LOGGER.warn("queryHbssBizCloudId is err,errMsg:{}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    public static String getModelType(String entityNumber) {
        String queryFormId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((CharSequence)queryFormId)) {
            return null;
        }
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)queryFormId, (MetaCategory)MetaCategory.Entity);
        return entityMeta.getModelType();
    }

    @ExcludeFromJacocoGeneratedReport
    public static Set<String> getQueryEntityNumbers(String billFormId) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)billFormId);
        if (ObjectUtils.isEmpty((Object)queryEntityType)) {
            return new HashSet<String>(0);
        }
        List joinEntitys = queryEntityType.getJoinEntitys();
        Set<String> entityNumbers = joinEntitys.stream().map(JoinEntity::getEntityName).collect(Collectors.toSet());
        entityNumbers.add(queryEntityType.getMainEntityType().getName());
        return entityNumbers;
    }

    public static Set<String> getAllEntityNumber(Set<String> entityNumbers) {
        HashSet<String> result = new HashSet<String>(4);
        result.addAll(entityNumbers);
        for (String entityNumber : entityNumbers) {
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
            if (StringUtils.isEmpty((CharSequence)entityId)) continue;
            MetaMenuUtil.getParentEntityNumber(result, entityId);
        }
        return result;
    }

    public static Set<String> getAllEntityNumber(String entityNumber) {
        HashSet<String> result = new HashSet<String>(4);
        result.add(entityNumber);
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            return result;
        }
        MetaMenuUtil.getParentEntityNumber(result, entityId);
        return result;
    }

    private static void getParentEntityNumber(Set<String> result, String entityId) {
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entityMeta != null) {
            result.add(entityMeta.getKey());
            MetaMenuUtil.getParentEntityNumber(result, entityMeta.getParentId());
        }
    }
}

