/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.ext.hr.metadata.prop.MulQueryProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.threads.impl.ThreadPoolImpl;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.bo.MultiLevelHeaderBO;
import kd.hr.hies.common.ext.bos.FilterBuilder;
import kd.hr.hies.common.ext.bos.FilterBuilderParameter;
import kd.hr.hies.common.util.ExcelStyleUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class MethodUtil {
    private static final Log logger = LogFactory.getLog(MethodUtil.class);
    private static final Pattern IMG_PATTERN = Pattern.compile("<img\\b[^>]*\\bsrc\\b\\s*=\\s*('|\")?([^'\"\n\r\f>]+(\\.jpg|\\.bmp|\\.eps|\\.gif|\\.mif|\\.miff|\\.png|\\.tif|\\.tiff|\\.svg|\\.wmf|\\.jpe|\\.jpeg|\\.dib|\\.ico|\\.tga|\\.cut|\\.pic)\\b)[^>]*>", 2);
    private static final Pattern pattern = Pattern.compile("\\$(.*?)\\$");

    @ExcludeFromJacocoGeneratedReport
    public static List<String> getImageSrcs(String htmlCode) {
        ArrayList<String> imageSrcList = new ArrayList<String>();
        Matcher matcher = IMG_PATTERN.matcher(htmlCode);
        while (matcher.find()) {
            String quote = matcher.group(1);
            String src = quote == null || quote.trim().length() == 0 ? matcher.group(2).split("\\s+")[0] : matcher.group(2);
            imageSrcList.add(src);
        }
        return imageSrcList;
    }

    public static String getTaskCachePath(String taskId, String importType, String type) {
        return "hr_" + importType + "_task_".concat(taskId).concat("_").concat(type);
    }

    public static String getUpgradeFlagCachePath(String type) {
        return "hr_hies_tplUpgrade_" + type;
    }

    public static Map<String, Map<String, Object>> getEntityBdMainProp(String entityId) {
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityId);
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            ((EntityType)entry.getValue()).getFields().values().forEach(fldProperty -> {
                Map<String, Object> bdMainProp = null;
                if (fldProperty instanceof IBasedataField) {
                    BasedataEntityType type = (BasedataEntityType)((IBasedataField)fldProperty).getComplexType();
                    bdMainProp = MethodUtil.getBdMainProp(type.getName());
                }
                if (bdMainProp != null) {
                    fieldMap.put(fldProperty.getName(), bdMainProp);
                }
            });
        }
        return fieldMap;
    }

    public static Map<String, Object> getBdMainProp(String bdId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        if (StringUtils.isEmpty((String)bdId)) {
            return map;
        }
        MainEntityType bd = MetadataServiceHelper.getDataEntityType((String)bdId);
        if (bd instanceof BasedataEntityType) {
            IDataEntityProperty enablePro;
            BasedataEntityType type = (BasedataEntityType)bd;
            map.put("name", type.getNameProperty());
            map.put("number", type.getNumberProperty());
            map.put("id", type.getPrimaryKey());
            map.put("status", type.getBillStatus());
            map.put("enable", type.getForbidStatus());
            map.put("masterid", type.getMasteridPropName());
            if (StringUtils.isEmpty((String)type.getForbidStatus()) && (enablePro = (IDataEntityProperty)type.getProperties().get((Object)"enable")) instanceof BillStatusProp && StringUtils.isNotEmpty((String)enablePro.getAlias())) {
                map.put("enable", "enable");
            }
        } else if (bd instanceof BillEntityType) {
            BillEntityType type = (BillEntityType)bd;
            map.put("number", type.getBillNo());
        }
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, String> getBdNumberNameText(IDataEntityProperty property) {
        String bdId = ((IBasedataField)property).getComplexType().getName();
        Map<String, Object> bdMainProp = MethodUtil.getBdMainProp(bdId);
        String number = (String)bdMainProp.get("number");
        String name = (String)bdMainProp.get("name");
        String nameDisplayName = StringUtils.getEmpty();
        String numberDisplayName = StringUtils.getEmpty();
        DataEntityPropertyCollection baseProperties = ((IBasedataField)property).getComplexType().getProperties();
        IDataEntityProperty numberProperty = (IDataEntityProperty)baseProperties.get((Object)number);
        if (property instanceof IQueryProp) {
            numberDisplayName = ResManager.loadKDString((String)"\u5de5\u53f7", (String)HiesCommonRes.MethodUtil_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
        } else if (Objects.nonNull(numberProperty)) {
            numberDisplayName = numberProperty.getDisplayName().getLocaleValue();
        }
        IDataEntityProperty nameProperty = (IDataEntityProperty)baseProperties.get((Object)name);
        if (property instanceof IQueryProp) {
            nameDisplayName = ResManager.loadKDString((String)"\u59d3\u540d", (String)HiesCommonRes.MethodUtil_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
        } else if (Objects.nonNull(nameProperty)) {
            nameDisplayName = nameProperty.getDisplayName().getLocaleValue();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("number", numberDisplayName);
        map.put("name", nameDisplayName);
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, String> getBdNumberNameText(MainEntityType baseEntityType) {
        BasedataEntityType type = (BasedataEntityType)baseEntityType;
        Map allFields = baseEntityType.getAllFields();
        String nameDisplayName = ((IDataEntityProperty)allFields.get(type.getNameProperty())).getDisplayName().getLocaleValue();
        String numberDisplayName = ((IDataEntityProperty)allFields.get(type.getNumberProperty())).getDisplayName().getLocaleValue();
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("number", numberDisplayName);
        map.put("name", nameDisplayName);
        return map;
    }

    public static Map<String, Object> getHRPersonMainProp(String baseEntityId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        if ("hrpi_depempf7query".equals(baseEntityId) || "hrpi_employeef7query".equals(baseEntityId)) {
            map.put("name", "person.name");
            map.put("number", "person.number");
        } else {
            map.put("name", "name");
            map.put("number", "number");
        }
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, Object> getHRPersonQueryField(String baseEntityId, String fieldName) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        if ("hrpi_depempf7query".equals(baseEntityId) || "hrpi_employeef7query".equals(baseEntityId)) {
            map.put("name", fieldName + ".person.name");
            map.put("number", fieldName + ".person.number");
        } else {
            map.put("name", fieldName + '.' + "name");
            map.put("number", fieldName + '.' + "number");
        }
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean isHRPersonField(String fieldName, Map<String, IDataEntityProperty> allFields) {
        IDataEntityProperty property = allFields.get(fieldName);
        return property instanceof IQueryProp;
    }

    public static Map<String, Set<String>> getAllRefBdSelectedAtrr(String mainEntityId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)mainEntityId);
        entityType.getProperties().forEach(prop -> {
            if (prop instanceof IBasedataField) {
                String bdSelectedAtrrStr = MethodUtil.getBdSelectedAtrrStr(prop);
                if (StringUtils.isNotEmpty((String)bdSelectedAtrrStr)) {
                    map.put(prop.getName(), Arrays.stream(bdSelectedAtrrStr.split(",")).collect(Collectors.toSet()));
                }
            } else if (prop instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)prop;
                entryProp.getDynamicCollectionItemPropertyType().getProperties().forEach(prop2 -> {
                    String bdSelectedAtrrStr;
                    if (prop2 instanceof IBasedataField && StringUtils.isNotEmpty((String)(bdSelectedAtrrStr = MethodUtil.getBdSelectedAtrrStr(prop2)))) {
                        map.put(prop2.getName(), Arrays.stream(bdSelectedAtrrStr.split(",")).collect(Collectors.toSet()));
                    }
                });
            }
        });
        return map;
    }

    private static String getBdSelectedAtrrStr(IDataEntityProperty prop) {
        if (prop instanceof BasedataProp) {
            BasedataProp bdpro = (BasedataProp)prop;
            DynamicObjectType dynamicComplexPropertyType = bdpro.getDynamicComplexPropertyType();
            RefEntityType ref = (RefEntityType)dynamicComplexPropertyType;
            String extendName = ref.getExtendName();
            String replace = extendName.replace(bdpro.getBaseEntityId(), "").replace("[", "").replace("]", "");
            return replace;
        }
        if (prop instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)prop;
        }
        return "";
    }

    public static IFormView initFormView(String pageId) {
        SessionManager.getCurrent().setRequestThread(true);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        IFormController srv = (IFormController)view.getService(IFormController.class);
        srv.registerListener();
        return view;
    }

    public static IFormView getViewNoPlugin(String pageId) {
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
        return view;
    }

    public static void syncRequestTraceId(Object sourceRc) {
        RequestContext.get().setTraceId(((RequestContext)sourceRc).getTraceId());
        RequestContextThreadBinder.bind((RequestContext)RequestContext.get());
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, Object> getRecoveryViewParams(String pageId) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(pageId);
        map.put("cacheMap", JSONObject.toJSONString((Object)pageCache.getAll()));
        map.put("pageJson", JSONObject.toJSONString((Object)pageCache));
        return map;
    }

    @ExcludeFromJacocoGeneratedReport
    public static IFormView recoveryView(String pageJson, Map<String, String> cacheMap) {
        PageCache newcache = (PageCache)JSONObject.parseObject((String)pageJson, PageCache.class);
        newcache.put(cacheMap);
        Map all = newcache.getAll();
        String parameter = (String)all.get(FormShowParameter.class.getSimpleName());
        FormShowParameter formShowParameter = FormShowParameter.fromJsonString((String)parameter);
        formShowParameter.endInit();
        IFormView view = formShowParameter.createView();
        view.addService(IPageCache.class, (Object)newcache);
        view.initialize(formShowParameter);
        return view;
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean releaseView(IFormView view) {
        try {
            FormController controller = new FormController(view);
            controller.release(null);
            return true;
        }
        catch (Throwable e) {
            logger.error(e);
            return false;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void shutdownNowThreadPool(ThreadPool pool) throws NoSuchFieldException, IllegalAccessException {
        if (pool == null) {
            return;
        }
        ThreadPoolImpl impl = (ThreadPoolImpl)pool;
        Field field = impl.getClass().getDeclaredField("es");
        ReflectionUtils.makeAccessible((Field)field);
        ExecutorService ex = (ExecutorService)field.get(impl);
        ex.shutdownNow();
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        LinkedList<List<T>> result = new LinkedList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }

    private static ThreadPoolExecutor getThreadPoolExecutor(String name) {
        try {
            Field poolMap = ThreadPools.class.getDeclaredField("poolMap");
            ReflectionUtils.makeAccessible((Field)poolMap);
            Map pools = (Map)poolMap.get(ThreadPools.class.newInstance());
            ThreadPoolImpl pool = (ThreadPoolImpl)pools.get(name);
            if (pool == null) {
                return null;
            }
            Field esf = pool.getClass().getDeclaredField("es");
            ReflectionUtils.makeAccessible((Field)esf);
            ExecutorService espol = (ExecutorService)esf.get(pool);
            Field del = espol.getClass().getDeclaredField("delegateService");
            ReflectionUtils.makeAccessible((Field)del);
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)del.get(espol);
            return tpe;
        }
        catch (Throwable e) {
            logger.error(e);
            return null;
        }
    }

    public static Map<String, Integer> getThreadPoolKeyInfo(String name) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        ThreadPoolExecutor pool = MethodUtil.getThreadPoolExecutor(name);
        if (pool == null) {
            return map;
        }
        map.put("queue", pool.getQueue().size());
        map.put("activeCount", pool.getActiveCount());
        return map;
    }

    public static String getRouteAppId(String serviceAppId) {
        String routeAppId = ServiceLookup.hasDeployedAppId((String)"imp-exp") ? "imp-exp" : serviceAppId;
        return routeAppId;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void addUrlPermitData(String url, String entityNum, String appId) {
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("entityNum", entityNum);
        refEntitiyMap.put("appId", appId);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }

    public static Map<String, String> reversalMap(Map<String, String> sourceMap) {
        HashMap entitySheetMap = Maps.newHashMapWithExpectedSize((int)sourceMap.size());
        for (Map.Entry<String, String> next : sourceMap.entrySet()) {
            entitySheetMap.put(next.getValue(), next.getKey());
        }
        return entitySheetMap;
    }

    public static List<String> getTplAllEntitys(DynamicObject tpl) {
        LinkedList<String> list = new LinkedList<String>();
        if (tpl == null) {
            return list;
        }
        String mainid = tpl.getString("entity.id");
        list.add(mainid);
        DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
        for (DynamicObject child : entityrelation) {
            String childId = child.getString("rentity.id");
            list.add(childId);
        }
        return list;
    }

    public static Map<String, String> samplingCpuMem() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long usedPhysicalMemorySize = operatingSystemMXBean.getTotalPhysicalMemorySize() - operatingSystemMXBean.getFreePhysicalMemorySize();
        StringBuilder builder = new StringBuilder();
        builder.append("us:").append(usedPhysicalMemorySize / 1024L / 1024L);
        builder.append("M,uh:").append(heapMemoryUsage.getUsed() / 1024L / 1024L);
        builder.append("M");
        map.put("memory", builder.toString());
        double systemCpuLoad = operatingSystemMXBean.getSystemCpuLoad();
        double processCpuLoad = operatingSystemMXBean.getProcessCpuLoad();
        StringBuilder builder2 = new StringBuilder();
        builder2.append("s:").append(String.format("%.0f", systemCpuLoad * 100.0));
        builder2.append("%,p:").append(String.format("%.0f", processCpuLoad * 100.0));
        builder2.append("%");
        map.put("cpu", builder2.toString());
        return map;
    }

    public static String getMemoryConfig() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalPhysicalMemorySize = operatingSystemMXBean.getTotalPhysicalMemorySize();
        StringBuilder builder = new StringBuilder();
        builder.append("totalPhysicalMemorySize:").append(totalPhysicalMemorySize / 1024L / 1024L);
        builder.append("M,heapMemoryMaxSize:").append(heapMemoryUsage.getMax() / 1024L / 1024L);
        builder.append("M");
        return builder.toString();
    }

    public static QFilter getDataInitQFilter(String billFormId) {
        Map allFields = MetadataServiceHelper.getDataEntityType((String)billFormId).getAllFields();
        for (IDataEntityProperty toPro : allFields.values()) {
            if (!HRStringUtils.equals((String)toPro.getName(), (String)"initdatasource") && !HRStringUtils.equals((String)toPro.getName(), (String)"initstatus") && !HRStringUtils.equals((String)toPro.getName(), (String)"initbatch")) continue;
            if (HRStringUtils.isEmpty((String)toPro.getAlias())) {
                return null;
            }
            if (!HRStringUtils.equals((String)toPro.getName(), (String)"initstatus")) continue;
            QFilter statusFilter = new QFilter("initstatus", "=", (Object)"2");
            return statusFilter;
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, Integer> getVirtualProcess(int trueProgress, int trueTimeRemaining, float finishedBillCount, int totalBillCount) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)4);
        result.put("progress", trueProgress >= 90 ? trueProgress : 90);
        result.put("timeRemaining", trueTimeRemaining < 3000 ? trueProgress : 3000);
        if (finishedBillCount > 0.0f && totalBillCount > 0) {
            float virtualFinishedBillCount = (float)totalBillCount * 0.9f;
            result.put("finishedBillCount", finishedBillCount >= virtualFinishedBillCount ? (int)finishedBillCount : (int)virtualFinishedBillCount);
        }
        return result;
    }

    public static Map<String, Map<String, Map<String, Object>>> initEntityF7MainPropName(DynamicObject tpl) {
        String mainid = tpl.getString("entity.id");
        if (StringUtils.isEmpty((String)mainid)) {
            return Maps.newHashMapWithExpectedSize((int)1);
        }
        DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
        HashMap map = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
        map.put(mainid, MethodUtil.getEntityBdMainProp(mainid));
        for (DynamicObject child : entityrelation) {
            String childId = child.getString("rentity.id");
            map.put(childId, MethodUtil.getEntityBdMainProp(childId));
        }
        return map;
    }

    public static String getLevelOneKey(String key) {
        String[] split = StringUtils.split((String)key, (boolean)true, (char[])new char[]{'.'});
        if (split == null || split.length == 0) {
            logger.info("MethodUtil.getLevelOneKey_null:{}", (Object)key);
            return key;
        }
        return split[0];
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getLastKey(String key) {
        String[] split = StringUtils.split((String)key, (boolean)true, (char[])new char[]{'.'});
        return split[split.length - 1];
    }

    @ExcludeFromJacocoGeneratedReport
    public static Set<String> filterNotExistField(Set<String> selectFields, String baseDataEntityNum) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)baseDataEntityNum);
        HashSet<String> newSelectFields = new HashSet<String>(selectFields.size());
        selectFields.forEach(field -> {
            String[] split = HRStringUtils.split((String)field, (String)".");
            if (MethodUtil.canAddField(split, mainType, new AtomicInteger(0))) {
                newSelectFields.add((String)field);
            }
        });
        return newSelectFields;
    }

    private static boolean canAddField(String[] split, MainEntityType mainType, AtomicInteger count) {
        if (count.get() >= split.length) {
            return true;
        }
        IDataEntityProperty property = (IDataEntityProperty)mainType.getProperties().get((Object)split[count.get()]);
        if (property != null && StringUtils.isNotEmpty((String)property.getAlias())) {
            if (property instanceof IBasedataField) {
                BasedataEntityType bdtype = (BasedataEntityType)((IBasedataField)property).getComplexType();
                count.getAndIncrement();
                return MethodUtil.canAddField(split, (MainEntityType)bdtype, count);
            }
            return true;
        }
        return false;
    }

    public static String checkSheetRepeatName(String sourceName, String newName, int index, SXSSFWorkbook wb) {
        ++index;
        SXSSFSheet sheet = wb.getSheet(newName);
        if (sheet != null) {
            newName = sourceName + "(" + index + ")";
            return MethodUtil.checkSheetRepeatName(sourceName, newName, index, wb);
        }
        return newName;
    }

    public static void printQfilters(QFilter[] qFilters, String key) {
        if (qFilters == null) {
            return;
        }
        StringBuilder logqf = new StringBuilder();
        for (QFilter qf : qFilters) {
            if (ObjectUtils.isEmpty((Object)qf)) continue;
            logqf.append(qf).append(";");
        }
        if (logqf.length() > 500) {
            String start = logqf.substring(0, 400);
            String end = logqf.substring(logqf.length() - 100, logqf.length());
            logger.info(key + " count:{},filter:{}", (Object)qFilters.length, (Object)(start + "..." + end));
            return;
        }
        logger.info(key + " count:{},filter:{}", (Object)qFilters.length, (Object)logqf.toString());
    }

    public static <E> List<E> arrayToList(E[] array) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            return null;
        }
        ArrayList transferedList = new ArrayList(array.length);
        Arrays.stream(array).forEach(arr -> transferedList.add(arr));
        return transferedList;
    }

    public static long get64BitHash(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = md.digest(input.getBytes());
            byte[] firstEightBytes = new byte[8];
            System.arraycopy(hashBytes, 0, firstEightBytes, 0, 8);
            return MethodUtil.toUnsignedLong(firstEightBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static long toUnsignedLong(byte[] bytes) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value <<= 8;
            value |= (long)(bytes[i] & 0xFF);
        }
        return value;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, String> getSortF7fields(String baseDataId) {
        LinkedHashMap metaF7fields = new LinkedHashMap(16);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)baseDataId);
        Map allFields = type.getAllFields();
        if (type instanceof QueryEntityType) {
            LinkedHashMap<String, String> sortF7fields = new LinkedHashMap<String, String>(2);
            if ("hrpi_depempf7query".equals(baseDataId) || "hrpi_employeef7query".equals(baseDataId)) {
                sortF7fields.put("person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)HiesCommonRes.MethodUtil_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                sortF7fields.put("person.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)HiesCommonRes.MethodUtil_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            } else {
                sortF7fields.put("number", ((IDataEntityProperty)allFields.get(((QueryEntityType)type).getNumberProperty())).getDisplayName().getLocaleValue());
                sortF7fields.put("name", ((IDataEntityProperty)allFields.get(((QueryEntityType)type).getNameProperty())).getDisplayName().getLocaleValue());
            }
            return sortF7fields;
        }
        String entityNumber = baseDataId;
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        metadata.getItems().forEach(item -> {
            if (item instanceof BasedataFormAp) {
                BasedataFormAp basedataFormAp = (BasedataFormAp)item;
                FormMetadata listMeta = basedataFormAp.getListMeta();
                if (listMeta == null) {
                    return;
                }
                listMeta.getItems().forEach(listItem -> {
                    if (listItem instanceof ListColumnAp) {
                        ListColumnAp listColumnAp = (ListColumnAp)listItem;
                        String listFieldId = listColumnAp.getListFieldId();
                        if ("fseq".equals(listFieldId)) {
                            return;
                        }
                        String visibles = listColumnAp.getVisible();
                        if (!StringUtils.isBlank((String)visibles) && Arrays.asList(visibles.split(",")).contains("lookup")) {
                            IDataEntityProperty property = (IDataEntityProperty)allFields.get(listFieldId);
                            if (ObjectUtils.isEmpty((Object)property)) {
                                property = (IDataEntityProperty)allFields.get(listFieldId.substring(0, listFieldId.indexOf(46)));
                                if (property.getParent() instanceof EntryType) {
                                    return;
                                }
                                if (!ObjectUtils.isEmpty((Object)property) && StringUtils.isNotEmpty((String)property.getAlias())) {
                                    metaF7fields.put(listFieldId, listColumnAp.getName().getLocaleValue());
                                }
                            } else {
                                if (property.getParent() instanceof EntryType) {
                                    return;
                                }
                                if (StringUtils.isNotEmpty((String)property.getAlias())) {
                                    metaF7fields.put(listFieldId, listColumnAp.getName().getLocaleValue());
                                }
                            }
                        }
                    }
                });
            }
        });
        LinkedHashMap<String, String> sortF7fields = new LinkedHashMap<String, String>(metaF7fields.size());
        Set keySet = metaF7fields.keySet();
        if (keySet.contains("number")) {
            sortF7fields.put("number", (String)metaF7fields.get("number"));
        }
        if (keySet.contains("name")) {
            sortF7fields.put("name", (String)metaF7fields.get("name"));
        }
        metaF7fields.entrySet().removeIf(item -> "number".equals(item.getKey()) || "name".equals(item.getKey()));
        sortF7fields.putAll(metaF7fields);
        return sortF7fields;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String tranSortF7fieldNames(String entityNum, String baseDataId, String selectFieldValues) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        IDataEntityProperty property = (IDataEntityProperty)entityType.getAllFields().get(baseDataId);
        if (property instanceof ItemClassProp) {
            try {
                Map selectFieldMap = (Map)JSON.parseObject((String)selectFieldValues, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){}, (Feature[])new Feature[0]);
                ArrayList<String> selectFieldNames = new ArrayList<String>(selectFieldMap.size());
                for (Map.Entry entry : selectFieldMap.entrySet()) {
                    String baseEntityId = (String)entry.getKey();
                    MainEntityType baseEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                    Map<String, String> sortF7fields = MethodUtil.getSortF7fields(baseEntityId);
                    List entrySelectFieldNames = Arrays.stream(((String)entry.getValue()).split(",")).map(sortF7fields::get).collect(Collectors.toList());
                    selectFieldNames.add(baseEntityType.getDisplayName().getLocaleValue().concat("\uff1a").concat(Joiner.on((String)"\uff1b").join(entrySelectFieldNames)));
                }
                String sign = "\u3002";
                return String.join((CharSequence)sign, selectFieldNames).concat(sign);
            }
            catch (Exception ex) {
                return MethodUtil.tranSortF7fieldNames(selectFieldValues, property);
            }
        }
        return MethodUtil.tranSortF7fieldNames(selectFieldValues, property);
    }

    private static String tranSortF7fieldNames(String selectFieldValues, IDataEntityProperty property) {
        String baseEntityId = property instanceof MulBasedataProp ? ((MulBasedataProp)property).getBaseEntityId() : ((BasedataProp)property).getBaseEntityId();
        Map<String, String> sortF7fields = MethodUtil.getSortF7fields(baseEntityId);
        List selectFieldNames = Arrays.stream(selectFieldValues.split(",")).map(sortF7fields::get).collect(Collectors.toList());
        return Joiner.on((String)"\uff1b").join(selectFieldNames);
    }

    public static List<String> getSortF7OrderBys(String baseDataId) {
        ArrayList<String> sortF7OrderBys = new ArrayList<String>(8);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)baseDataId);
        Map allFields = type.getAllFields();
        String entityNumber = type instanceof QueryEntityType ? ((QueryEntityType)type).getMainEntityType().getName() : baseDataId;
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        metadata.getItems().forEach(item -> {
            if (item instanceof BasedataFormAp) {
                BasedataFormAp basedataFormAp = (BasedataFormAp)item;
                FormMetadata listMeta = basedataFormAp.getListMeta();
                if (listMeta == null) {
                    return;
                }
                listMeta.getItems().forEach(listItem -> {
                    if (listItem instanceof ListColumnAp) {
                        ListColumnAp listColumnAp = (ListColumnAp)listItem;
                        String listFieldId = listColumnAp.getListFieldId();
                        if ("fseq".equals(listFieldId)) {
                            return;
                        }
                        String visibles = listColumnAp.getVisible();
                        if (!StringUtils.isBlank((String)visibles) && Arrays.asList(visibles.split(",")).contains("lookup")) {
                            IDataEntityProperty property = (IDataEntityProperty)allFields.get(listFieldId);
                            if (ObjectUtils.isEmpty((Object)property)) {
                                String order = listColumnAp.getOrder();
                                if (!SortType.NotOrder.name().equals(order)) {
                                    sortF7OrderBys.add(listFieldId.concat(" ").concat(order));
                                }
                            } else if (StringUtils.isNotEmpty((String)property.getAlias())) {
                                String order = listColumnAp.getOrder();
                                if (!SortType.NotOrder.name().equals(order)) {
                                    sortF7OrderBys.add(listFieldId.concat(" ").concat(order));
                                }
                            }
                        }
                    }
                });
            }
        });
        return sortF7OrderBys;
    }

    public static QFilter getF7BdCondQFilter(String entityName, IDataEntityProperty prop) {
        FilterCondition filterCondition = EntityMetadataCache.getBaseDataFieldFilterMeta((String)entityName, (String)prop.getName());
        if (!ObjectUtils.isEmpty((Object)filterCondition) && !ObjectUtils.isEmpty((Object)filterCondition.getFilter())) {
            String baseEntityId = prop instanceof RefBillProp ? ((RefBillProp)prop).getBillEntityId() : ((IBasedataField)prop).getBaseEntityId();
            FilterBuilderParameter filterBuilderParameter = new FilterBuilderParameter(EntityMetadataCache.getDataEntityType((String)baseEntityId), filterCondition).setNeedParseBaseDataIds(true);
            FilterBuilder filterBuilder = new FilterBuilder(filterBuilderParameter);
            filterBuilder.buildFilter();
            QFilter filterConditionQFilter = filterBuilder.getQFilter();
            MethodUtil.printQfilters(new QFilter[]{filterConditionQFilter}, "getF7BdCondQFilter_" + baseEntityId + "_filter");
            return filterConditionQFilter;
        }
        return null;
    }

    public static Map<String, String> itemClassPropMapTypes(String baseDataId) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)baseDataId);
        Map allFields = entityType.getAllFields();
        for (Map.Entry entry : allFields.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            if (!(property instanceof ItemClassProp)) continue;
            String typePropFieldNumber = ((ItemClassProp)property).getTypePropName();
            map.put((String)entry.getKey(), typePropFieldNumber);
        }
        return map;
    }

    public static Map<String, Set<String>> itemClassTypePropMapProps(String baseDataId) {
        Map<String, String> itemClassPropMapTypes = MethodUtil.itemClassPropMapTypes(baseDataId);
        return itemClassPropMapTypes.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
    }

    public static Map<String, MultiLevelHeaderBO> getEntryFields(String baseDataId, String entryKey) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)baseDataId);
        Map allFields = type.getAllFields();
        String entityNumber = type instanceof QueryEntityType ? ((QueryEntityType)type).getMainEntityType().getName() : baseDataId;
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        List items = metadata.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            return new LinkedHashMap<String, MultiLevelHeaderBO>(0);
        }
        Optional<ControlAp> entryApOptional = items.stream().filter(item -> item instanceof EntryAp && entryKey.equals(item.getKey())).findFirst();
        if (!entryApOptional.isPresent()) {
            return new LinkedHashMap<String, MultiLevelHeaderBO>(0);
        }
        LinkedHashMap<String, MultiLevelHeaderBO> entryFields = new LinkedHashMap<String, MultiLevelHeaderBO>(8);
        MethodUtil.getEntryFields(entryFields, entryKey, entryApOptional.get().getId(), allFields, items, 1, "", false);
        return entryFields;
    }

    private static void getEntryFields(Map<String, MultiLevelHeaderBO> entryFields, String entryKey, String entryId, Map<String, IDataEntityProperty> allFields, List<ControlAp<?>> items, int level, String parentTableName, boolean isGroupField) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        items.forEach(item -> {
            if (item instanceof EntryFieldAp) {
                EntryFieldAp entryFieldAp = (EntryFieldAp)item;
                String fieldId = entryFieldAp.getKey();
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldId);
                if (!ObjectUtils.isEmpty((Object)property) && StringUtils.isNotEmpty((String)property.getAlias())) {
                    String curEntryKey = property.getParent().getName();
                    if (!entryKey.equals(curEntryKey)) {
                        return;
                    }
                    String parentId = entryFieldAp.getParentId();
                    if (!isGroupField && !entryId.equals(parentId)) {
                        return;
                    }
                    MultiLevelHeaderBO multiLevelHeaderBO = new MultiLevelHeaderBO(level, fieldId, property.getDisplayName().getLocaleValue(), parentTableName, parentId);
                    entryFields.put(fieldId, multiLevelHeaderBO);
                }
            } else if (item instanceof EntryFieldGroupAp) {
                EntryFieldGroupAp entryFieldGroupAp = (EntryFieldGroupAp)item;
                String parentId = entryFieldGroupAp.getParentId();
                if (!isGroupField && !entryId.equals(parentId)) {
                    return;
                }
                List innerItems = entryFieldGroupAp.getItems();
                MultiLevelHeaderBO multiLevelHeaderBO = new MultiLevelHeaderBO(level, entryFieldGroupAp.getId(), entryFieldGroupAp.getName().getLocaleValue(), parentTableName, parentId);
                multiLevelHeaderBO.setTableFlag(true);
                entryFields.put(entryFieldGroupAp.getId(), multiLevelHeaderBO);
                MethodUtil.getEntryFields(entryFields, entryKey, entryId, allFields, innerItems, level + 1, entryFieldGroupAp.getName().getLocaleValue(), true);
            }
        });
    }

    public static Pair<Map<String, MultiLevelHeaderBO>, Integer> buildEntryFields(String baseDataId, String entryKey, List<String> targetFields) {
        Map<String, MultiLevelHeaderBO> entryFields = MethodUtil.getEntryFields(baseDataId, entryKey);
        if (MapUtils.isEmpty(entryFields)) {
            return Pair.of(new HashMap(0), (Object)1);
        }
        boolean existTargetField = !CollectionUtils.isEmpty(targetFields);
        HashMap<String, ArrayList<String>> level2groupFields = new HashMap<String, ArrayList<String>>(8);
        HashMap<String, ArrayList<String>> level3groupFields = new HashMap<String, ArrayList<String>>(8);
        int maxLevel = 1;
        for (MultiLevelHeaderBO multiLevelHeaderBO : entryFields.values()) {
            List<String> groupFields;
            String parentId;
            String id = multiLevelHeaderBO.getId();
            if (existTargetField && !targetFields.contains(id)) continue;
            int level = multiLevelHeaderBO.getLevel();
            if (level == 2) {
                parentId = multiLevelHeaderBO.getParentId();
                groupFields = (ArrayList<String>)level2groupFields.get(parentId);
                if (CollectionUtils.isEmpty((Collection)groupFields)) {
                    groupFields = new ArrayList<String>(8);
                    level2groupFields.put(parentId, (ArrayList<String>)groupFields);
                }
                groupFields.add(id);
                maxLevel = Math.max(level, maxLevel);
                continue;
            }
            if (level == 3) {
                parentId = multiLevelHeaderBO.getParentId();
                groupFields = (List)level3groupFields.get(parentId);
                if (CollectionUtils.isEmpty((Collection)groupFields)) {
                    groupFields = new ArrayList(8);
                    level3groupFields.put(parentId, (ArrayList<String>)groupFields);
                }
                groupFields.add(id);
                maxLevel = Math.max(level, maxLevel);
                continue;
            }
            if (level <= 3) continue;
            throw new KDBizException("not suppot level3 headers");
        }
        for (Map.Entry entry : entryFields.entrySet()) {
            MultiLevelHeaderBO value;
            String parentId = (value = (MultiLevelHeaderBO)entry.getValue()).getParentId();
            List level2groupFieldList = (List)level2groupFields.get(parentId);
            value.setCurGroupItems(CollectionUtils.isEmpty((Collection)level2groupFieldList) ? (List)level3groupFields.get(parentId) : level2groupFieldList);
        }
        return Pair.of(entryFields, (Object)maxLevel);
    }

    public static Pair<Map<String, MultiLevelHeaderBO>, Integer> parseTableLayout(String baseDataId, String entryKey, List<String> targetFields) {
        boolean isTableFlag;
        int level;
        MultiLevelHeaderBO multiLevelHeaderBO;
        Pair<Map<String, MultiLevelHeaderBO>, Integer> multiLevelHeaderBOPair = MethodUtil.buildEntryFields(baseDataId, entryKey, targetFields);
        Map multiLevelHeaderBOMap = (Map)multiLevelHeaderBOPair.getLeft();
        int maxLevel = (Integer)multiLevelHeaderBOPair.getRight();
        int curCol = 0;
        HashMap<String, ArrayList<MultiLevelHeaderBO>> tableLayoutMapping = new HashMap<String, ArrayList<MultiLevelHeaderBO>>(8);
        for (Map.Entry entry : multiLevelHeaderBOMap.entrySet()) {
            multiLevelHeaderBO = (MultiLevelHeaderBO)entry.getValue();
            level = multiLevelHeaderBO.getLevel();
            isTableFlag = multiLevelHeaderBO.isTableFlag();
            if (isTableFlag) continue;
            if (level == 1) {
                multiLevelHeaderBO.setFirstRow(0);
            } else if (level == 2) {
                multiLevelHeaderBO.setFirstRow(1);
            } else if (level == 3) {
                multiLevelHeaderBO.setFirstRow(2);
            } else {
                throw new KDBizException("not support 3level tableheader");
            }
            String parentId = multiLevelHeaderBO.getParentId();
            ArrayList<MultiLevelHeaderBO> childs = (ArrayList<MultiLevelHeaderBO>)tableLayoutMapping.get(parentId);
            if (CollectionUtils.isEmpty((Collection)childs)) {
                childs = new ArrayList<MultiLevelHeaderBO>(8);
            }
            childs.add(multiLevelHeaderBO);
            tableLayoutMapping.put(parentId, childs);
            multiLevelHeaderBO.setLastRow(maxLevel - 1);
            multiLevelHeaderBO.setFirstCol(curCol);
            multiLevelHeaderBO.setLastCol(curCol);
            ++curCol;
        }
        for (Map.Entry entry : multiLevelHeaderBOMap.entrySet()) {
            multiLevelHeaderBO = (MultiLevelHeaderBO)entry.getValue();
            level = multiLevelHeaderBO.getLevel();
            isTableFlag = multiLevelHeaderBO.isTableFlag();
            if (!isTableFlag) continue;
            if (level == 2) {
                MultiLevelHeaderBO level2LastChildTableMBO = (MultiLevelHeaderBO)((List)tableLayoutMapping.get(multiLevelHeaderBO.getId())).get(0);
                List<String> level3CurGroupItems = level2LastChildTableMBO.getCurGroupItems();
                String level3FirstChildId = level3CurGroupItems.get(0);
                MultiLevelHeaderBO level3FirstChildMBO = (MultiLevelHeaderBO)multiLevelHeaderBOMap.get(level3FirstChildId);
                String level3LastChildId = level3CurGroupItems.get(level3CurGroupItems.size() - 1);
                MultiLevelHeaderBO level3LastChildMBO = (MultiLevelHeaderBO)multiLevelHeaderBOMap.get(level3LastChildId);
                multiLevelHeaderBO.setFirstRow(1);
                multiLevelHeaderBO.setLastRow(1);
                multiLevelHeaderBO.setFirstCol(level3FirstChildMBO.getFirstCol());
                multiLevelHeaderBO.setLastCol(level3LastChildMBO.getLastCol());
                String parentId = multiLevelHeaderBO.getParentId();
                ArrayList<MultiLevelHeaderBO> childs = (ArrayList<MultiLevelHeaderBO>)tableLayoutMapping.get(parentId);
                if (CollectionUtils.isEmpty((Collection)childs)) {
                    childs = new ArrayList<MultiLevelHeaderBO>(8);
                }
                childs.add(multiLevelHeaderBO);
                tableLayoutMapping.put(parentId, childs);
            } else if (level == 3) {
                throw new KDBizException("not support 3level tableheader");
            }
            ++curCol;
        }
        for (Map.Entry entry : multiLevelHeaderBOMap.entrySet()) {
            String fieldId = (String)entry.getKey();
            MultiLevelHeaderBO multiLevelHeaderBO2 = (MultiLevelHeaderBO)entry.getValue();
            int level2 = multiLevelHeaderBO2.getLevel();
            boolean isTableFlag2 = multiLevelHeaderBO2.isTableFlag();
            if (!isTableFlag2) continue;
            if (level2 == 1) {
                multiLevelHeaderBO2.setFirstRow(0);
                multiLevelHeaderBO2.setLastRow(0);
                MultiLevelHeaderBO level2FirstChildMBO = (MultiLevelHeaderBO)((List)tableLayoutMapping.get(fieldId)).get(0);
                boolean isFirstChildTableFlag = level2FirstChildMBO.isTableFlag();
                if (isFirstChildTableFlag) {
                    List<String> level3CurGroupItems = level2FirstChildMBO.getCurGroupItems();
                    String level3FirstChildId = level3CurGroupItems.get(0);
                    MultiLevelHeaderBO level3FirstChildMBO = (MultiLevelHeaderBO)multiLevelHeaderBOMap.get(level3FirstChildId);
                    multiLevelHeaderBO2.setFirstCol(level3FirstChildMBO.getFirstCol());
                } else {
                    multiLevelHeaderBO2.setFirstCol(level2FirstChildMBO.getFirstCol());
                }
                List<String> level2CurGroupItems = level2FirstChildMBO.getCurGroupItems();
                String level2LastChildId = level2CurGroupItems.get(level2CurGroupItems.size() - 1);
                MultiLevelHeaderBO level2LastChildMBO = (MultiLevelHeaderBO)multiLevelHeaderBOMap.get(level2LastChildId);
                boolean isLastChildTableFlag = level2LastChildMBO.isTableFlag();
                if (isLastChildTableFlag) {
                    MultiLevelHeaderBO level2LastChildTableMBO = (MultiLevelHeaderBO)((List)tableLayoutMapping.get(level2LastChildMBO.getId())).get(0);
                    List<String> level3CurGroupItems = level2LastChildTableMBO.getCurGroupItems();
                    String level3LastChildId = level3CurGroupItems.get(level3CurGroupItems.size() - 1);
                    MultiLevelHeaderBO level3LastChildMBO = (MultiLevelHeaderBO)multiLevelHeaderBOMap.get(level3LastChildId);
                    multiLevelHeaderBO2.setLastCol(level3LastChildMBO.getLastCol());
                } else {
                    multiLevelHeaderBO2.setLastCol(level2LastChildMBO.getLastCol());
                }
            }
            ++curCol;
        }
        return multiLevelHeaderBOPair;
    }

    public static Set<String> getFormulaRelFieldNumbers(String entityNumber, IFormView view) {
        return MethodUtil.getFormulaRelFieldNumbers(entityNumber, MethodUtil.getAllDeffieldvalprops(view));
    }

    @ExcludeFromJacocoGeneratedReport
    public static Set<String> getFormulaRelFieldNumbers(String entityNumber, String defvalprop) {
        if (StringUtils.isEmpty((String)defvalprop)) {
            return new HashSet<String>(0);
        }
        defvalprop = defvalprop.replaceAll("\\".concat("$dynamicFlag_"), "");
        Set<String> formulaRelFieldNumbers = MethodUtil.getFormulaRelFieldNumbers(defvalprop);
        HashSet<String> relFieldNumbers = new HashSet<String>(formulaRelFieldNumbers.size());
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = mainType.getAllFields();
        for (Map.Entry entry : allFields.entrySet()) {
            String targetKey;
            String key = (String)entry.getKey();
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            IDataEntityType parentProperty = property.getParent();
            if (parentProperty instanceof EntryType) {
                String parentPropertyName = parentProperty.getName();
                targetKey = parentPropertyName.concat(".").concat(key);
            } else {
                targetKey = key;
            }
            if (!MethodUtil.contains(formulaRelFieldNumbers, targetKey)) continue;
            relFieldNumbers.add(key);
        }
        return relFieldNumbers;
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean contains(Set<String> formulaRelFieldNumbers, String matchText) {
        String formulaRelFieldNumber;
        String matchTextChildPrefix = matchText.concat(".");
        boolean isMatch = false;
        Iterator<String> iterator = formulaRelFieldNumbers.iterator();
        while (iterator.hasNext() && !(isMatch = (formulaRelFieldNumber = iterator.next()).equals(matchText) || formulaRelFieldNumber.startsWith(matchTextChildPrefix))) {
        }
        return isMatch;
    }

    public static String getAllDeffieldvalprops(IFormView view) {
        StringBuilder defvalprop = new StringBuilder(32);
        DynamicObjectCollection cusFieldEntryEntityColl = view.getModel().getEntryEntity("cusfieldentryentity");
        if (!ObjectUtils.isEmpty((Object)cusFieldEntryEntityColl)) {
            for (DynamicObject dyn : cusFieldEntryEntityColl) {
                String deffieldvalprop = (String)dyn.get("deffieldvalprop");
                if (!StringUtils.isNotEmpty((String)deffieldvalprop)) continue;
                defvalprop.append(deffieldvalprop);
            }
        }
        return defvalprop.toString();
    }

    public static Set<String> getFormulaRelFieldNumbers(String defvalprop) {
        HashSet<String> relFieldNumbers = new HashSet<String>();
        Matcher m = pattern.matcher(defvalprop);
        int i = 1;
        while (m.find()) {
            String str = m.group(i);
            relFieldNumbers.add(str);
        }
        return relFieldNumbers;
    }

    public static String formatTimeStr(int time) {
        if (time < 0) {
            return null;
        }
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    public static boolean ignoreUniqueValField(IDataEntityProperty prop) {
        if (prop instanceof BigIntProp || prop instanceof IntegerProp || prop instanceof DateProp) {
            return false;
        }
        return prop instanceof MulBasedataProp || prop instanceof MulQueryProp || prop instanceof MulComboProp || prop instanceof BigDecimal || prop instanceof DecimalProp || prop instanceof TimeProp || prop instanceof DateTimeProp || prop instanceof ItemClassProp || prop instanceof ItemClassTypeProp || prop instanceof AdminDivisionProp || prop instanceof RefBillProp;
    }

    public static <T> void printPlugins(List<T> plugins) {
        if (!ObjectUtils.isEmpty(plugins)) {
            StringBuilder builder = new StringBuilder();
            plugins.forEach(pl -> builder.append(pl.getClass().getName()));
            logger.info("printPlugins:{}", (Object)builder.toString());
        }
    }

    public static Map<String, String> getComboValueKey(String entityId, String field) {
        HashMap<String, String> itmes = new HashMap<String, String>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(field);
        if (property instanceof ComboProp) {
            ComboProp temp = (ComboProp)property;
            for (ValueMapItem item : temp.getComboItems()) {
                itmes.put(item.getName().getLocaleValue(), item.getValue());
            }
        }
        return itmes;
    }

    public static Map<String, String> getComboKeyValue(String entityId, String field) {
        HashMap<String, String> itmes = new HashMap<String, String>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(field);
        if (property instanceof ComboProp) {
            ComboProp temp = (ComboProp)property;
            for (ValueMapItem item : temp.getComboItems()) {
                itmes.put(item.getValue(), item.getName().getLocaleValue());
            }
        }
        return itmes;
    }

    @ExcludeFromJacocoGeneratedReport
    public static <T extends Control> T getControl(String formId, String key) {
        HRAssert.notBlank((String)formId, (String)"param{formId} can not be null", (Object[])new Object[0]);
        FormRoot rootControl = FormMetadataCache.getRootControl((String)formId);
        HRAssert.notNull((Object)rootControl, (String)"FormMetadataCache.getRootControl(formId={%s}) result is null", (Object[])new Object[]{formId});
        return MethodUtil.getControl((Control)rootControl, key);
    }

    public static <T extends Control> T getControl(Control control, String key) {
        HRAssert.notNull((Object)control, (String)"param{control} can not be null", (Object[])new Object[0]);
        HRAssert.notBlank((String)key, (String)"param{key} can not be null", (Object[])new Object[0]);
        if (control.getKey().equals(key)) {
            return (T)control;
        }
        if (control instanceof Container) {
            for (Control item : ((Container)control).getItems()) {
                T targetControl = MethodUtil.getControl(item, key);
                if (ObjectUtils.isEmpty(targetControl)) continue;
                return targetControl;
            }
        }
        return null;
    }

    public static Map<String, String> getFieldTips(String baseDataId, boolean isContainTitle) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)baseDataId);
        Map allFields = type.getAllFields();
        String entityNumber = type instanceof QueryEntityType ? ((QueryEntityType)type).getMainEntityType().getName() : baseDataId;
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        List items = metadata.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> fieldTips = new HashMap<String, String>(16);
        items.forEach(item -> {
            FieldAp fieldAp;
            String fieldId;
            IDataEntityProperty property;
            if (item instanceof FieldAp && !ObjectUtils.isEmpty((Object)(property = (IDataEntityProperty)allFields.get(fieldId = (fieldAp = (FieldAp)item).getKey()))) && StringUtils.isNotEmpty((String)property.getAlias())) {
                String contentText;
                String titleText;
                Tips ctlTips = fieldAp.getCtlTips();
                if (ObjectUtils.isEmpty((Object)ctlTips) || "bill".equals(ctlTips.getType())) {
                    return;
                }
                String targetContent = "";
                LocaleString title = ctlTips.getTitle();
                LocaleString content = ctlTips.getContent();
                if (isContainTitle && !ObjectUtils.isEmpty((Object)title) && StringUtils.isNotEmpty((String)(titleText = title.toString()))) {
                    targetContent = titleText;
                }
                if (!ObjectUtils.isEmpty((Object)content) && StringUtils.isNotEmpty((String)(contentText = content.toString()))) {
                    targetContent = StringUtils.isNotEmpty((String)targetContent) ? targetContent + ":" + contentText : contentText;
                }
                if (StringUtils.isEmpty((String)targetContent)) {
                    return;
                }
                fieldTips.put(fieldId, targetContent);
            }
        });
        return fieldTips;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getDefaultComment(IDataEntityProperty prop, Map<String, ControlAp<?>> fieldApMap, boolean isEntry) {
        String defaultComment = "";
        String fieldNumber = prop.getName();
        boolean isID = "id".equalsIgnoreCase(fieldNumber);
        if (isEntry) {
            isID = fieldNumber.endsWith(".id");
        }
        if (isID) {
            StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"1.\u5185\u7801\u662f\u5339\u914d\u5355\u636e\u4f53\u6216\u5b50\u5355\u636e\u4f53\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u552f\u4e00\u6027\uff1b", (String)HiesCommonRes.MethodUtil_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            builder.append('\n');
            builder.append(ResManager.loadKDString((String)"2.\u5982\u9700\u66f4\u65b0\u5206\u5f55\u4fe1\u606f\uff0c\u8bf7\u586b\u5199\u5185\u7801\uff1b\u65b0\u589e\u5206\u5f55\uff0c\u65e0\u9700\u586b\u5199\uff1b", (String)HiesCommonRes.MethodUtil_3.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            builder.append('\n');
            builder.append(ResManager.loadKDString((String)"3.\u83b7\u53d6\u5185\u7801\u65b9\u5f0f\uff1a\u4f7f\u7528\u201c\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u201d\uff0c\u5219\u53ef\u5bfc\u51fa\u5206\u5f55\u7684\u5185\u7801\u3002", (String)HiesCommonRes.MethodUtil_4.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
            defaultComment = builder.toString();
        } else if (prop instanceof TimeProp) {
            String mask = ExcelStyleUtil.getMask(fieldApMap, prop);
            defaultComment = String.format(ResManager.loadKDString((String)"\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a%s", (String)HiesCommonRes.MethodUtil_5.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), mask);
        } else if (prop instanceof DateProp) {
            String mask = ExcelStyleUtil.getMask(fieldApMap, prop);
            defaultComment = String.format(ResManager.loadKDString((String)"\u65e5\u671f\uff0c\u793a\u4f8b\uff1a%s", (String)HiesCommonRes.MethodUtil_6.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), mask);
        } else if (prop instanceof DateTimeProp) {
            String mask = ExcelStyleUtil.getMask(fieldApMap, prop);
            defaultComment = String.format(ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\uff0c\u793a\u4f8b\uff1a%s", (String)HiesCommonRes.MethodUtil_7.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), mask);
        } else if (prop instanceof ComboProp) {
            try {
                ArrayList<ValueMapItem> itemList = new ArrayList<ValueMapItem>(((ComboProp)prop).getComboItems());
                itemList.removeIf(next -> !next.isItemVisible());
                CharSequence[] itemDesc = new String[itemList.size()];
                for (int index = 0; index < itemList.size(); ++index) {
                    String name;
                    itemDesc[index] = name = ((ValueMapItem)itemList.get(index)).getName().toString();
                }
                if (prop instanceof MulComboProp) {
                    defaultComment = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53ef\u9009\u9879\uff1a%s\uff0c\u586b\u5199\u591a\u4e2a\u503c\u65f6\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694\u3002", (String)HiesCommonRes.MethodUtil_8.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), String.join((CharSequence)"\u3001", itemDesc));
                }
            }
            catch (Throwable e) {
                logger.error(e);
                throw new KDBizException("get combo item list ".concat(prop.getDisplayName().getLocaleValue()).concat("'s failed'\uff1akey=").concat(fieldNumber));
            }
        }
        return defaultComment;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, String> getFieldPathDisplayNames(Map<String, IDataEntityProperty> allFields, boolean isEntityTpl, String entityNumber, DynamicObjectCollection treeentryentity) {
        HashMap fieldsMap = Maps.newHashMapWithExpectedSize((int)32);
        for (DynamicObject dyn : treeentryentity) {
            boolean isVirField;
            boolean isField = dyn.getBoolean("isfield");
            if (!isField || isEntityTpl && (isVirField = dyn.getBoolean("isvirfield"))) continue;
            String fieldNumber = dyn.getString("fieldnumber");
            String fieldName = dyn.getString("fieldname");
            boolean isCusField = dyn.getBoolean("iscusfield");
            if (isCusField) {
                fieldsMap.put("$" + fieldNumber + "$", "[" + fieldName + "]");
                continue;
            }
            IDataEntityProperty property = allFields.get(fieldNumber);
            if (property instanceof MulBasedataProp) continue;
            if (ObjectUtils.isEmpty((Object)property)) {
                fieldsMap.put("$" + fieldNumber + "$", "[" + fieldName + "]");
                continue;
            }
            String parentId = property.getParent().getName();
            boolean isEntryField = !entityNumber.equals(parentId);
            String fieldPath = fieldNumber;
            String treeNodeText = property.getDisplayName().toString();
            if (isEntryField) {
                fieldPath = parentId + "." + fieldNumber;
            }
            if (property instanceof BasedataProp) {
                String relFieldPrefix = fieldPath + ".";
                fieldPath = relFieldPrefix + "id";
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                String extendName = ((BasedataProp)property).getComplexType().getExtendName();
                String bdRelAtrrStr = extendName.replace(baseEntityId, "").replace("[", "").replace("]", "");
                DataEntityPropertyCollection relProps = ((BasedataProp)property).getComplexType().getProperties();
                for (IDataEntityProperty relProp : relProps) {
                    String propNum = relProp.getName();
                    if (HRStringUtils.isEmpty((String)propNum) || HRStringUtils.equals((String)"id", (String)propNum) || HRStringUtils.equals((String)"masterid", (String)propNum) || HRStringUtils.equals((String)"multilanguagetext", (String)propNum) || propNum.endsWith("_id") || relProp instanceof EntryProp || relProp instanceof MulBasedataProp || HRStringUtils.isEmpty((String)relProp.getAlias())) continue;
                    if (relProp instanceof BasedataProp) {
                        String fieldKey = treeNodeText + relProp.getDisplayName().toString();
                        String number = relFieldPrefix + propNum + ".id";
                        fieldsMap.put("$" + number + "$", "[" + fieldKey + "]");
                        if (!StringUtils.isNotEmpty((String)bdRelAtrrStr)) continue;
                        Set collect = Arrays.stream(bdRelAtrrStr.split(",")).map(item -> {
                            String[] split = item.split("\\.");
                            if (split.length > 2) {
                                return split[0] + "." + split[1];
                            }
                            return item;
                        }).collect(Collectors.toSet());
                        DataEntityPropertyCollection relProps2s = ((BasedataProp)relProp).getComplexType().getProperties();
                        for (IDataEntityProperty relProp2 : relProps2s) {
                            LocaleString displayName;
                            String number3;
                            if (!collect.contains(propNum + "." + relProp2.getName())) continue;
                            if (relProp2 instanceof BasedataProp) {
                                number3 = relFieldPrefix + propNum + "." + relProp2.getName() + ".id";
                                displayName = relProp2.getDisplayName();
                                if (ObjectUtils.isEmpty((Object)displayName)) {
                                    displayName = new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)HiesCommonRes.TemplateFieldConfPlugin_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                                }
                                fieldsMap.put("$" + number3 + "$", "[" + fieldKey + displayName + "]");
                                continue;
                            }
                            number3 = relFieldPrefix + propNum + "." + relProp2.getName();
                            displayName = relProp2.getDisplayName();
                            if (ObjectUtils.isEmpty((Object)displayName)) {
                                displayName = new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)HiesCommonRes.TemplateFieldConfPlugin_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                            }
                            fieldsMap.put("$" + number3 + "$", "[" + fieldKey + displayName + "]");
                        }
                        continue;
                    }
                    String number = relFieldPrefix + propNum;
                    fieldsMap.put("$" + number + "$", "[" + treeNodeText + relProp.getDisplayName().toString() + "]");
                }
            }
            fieldsMap.put("$" + fieldPath + "$", "[" + treeNodeText + "]");
        }
        return fieldsMap;
    }
}

