/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.plugin.args.SensitiveArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IconProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class SensitiveFiledUtil {
    public static FieldControlRules getFieldControlRulesByForm(String appId, String formId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        FieldControlRules fieldControlRules = permissionService.getFieldControlRules(userId, appId, formId);
        if (fieldControlRules == null || fieldControlRules.getFieldControlRuleDtos() == null || fieldControlRules.getFieldControlRuleDtos().isEmpty()) {
            return null;
        }
        return fieldControlRules;
    }

    public static FieldControlRule getFieldControlRule(long orgId, FieldControlRules rules) {
        FieldControlRules fieldControlRules = rules;
        if (fieldControlRules == null) {
            return null;
        }
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (orgId != 0L) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                if (!Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        } else {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
        }
        return fieldControlRule;
    }

    public static Object tryDeSensitiveValue(DynamicObject row, KeyValue kv, ListField listField, Object value, boolean canExport, SensitiveArgs sensitiveArgs, String formId) {
        if (!canExport) {
            return SensitiveFiledUtil.setDefalutDeSensitiveValue(value);
        }
        return SensitiveFiledUtil.tryDeSensitive(row, kv, listField, value, sensitiveArgs, formId);
    }

    private static Object deSensitive(String field, ListField listField, DynamicObject row, Object value, SensitiveArgs sensitiveArgs, String formId) {
        if (value == null) {
            return value;
        }
        if (!SensitiveFiledUtil.isSensitive(field, sensitiveArgs)) {
            return SensitiveFiledUtil.checkAndToGetDesensitizeValue(listField, value, row, SensitiveFiledUtil.getMainType(formId).getMainOrg());
        }
        SensitiveArgs.SensitiveRule rule = sensitiveArgs.getRule(field);
        String exportVal = value.toString();
        exportVal = rule != null && Pattern.matches(rule.regex, exportVal) ? exportVal.replaceAll(rule.regex, rule.replacement) : sensitiveArgs.getDesensitiveFun().handle(field, exportVal);
        return exportVal;
    }

    private static MainEntityType getMainType(String formId) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)formId);
        if (mainType instanceof QueryEntityType) {
            mainType = ((QueryEntityType)mainType).getMainEntityType();
        }
        return mainType;
    }

    private static boolean isSensitive(String field, SensitiveArgs sensitiveArgs) {
        if (sensitiveArgs == null) {
            return false;
        }
        return sensitiveArgs.contain(field);
    }

    public static Object tryDeSensitive(DynamicObject row, KeyValue kv, ListField listField, Object value, SensitiveArgs sensitiveArgs, String formId) {
        if (!SensitiveFiledUtil.isInstanceofList(value)) {
            value = SensitiveFiledUtil.deSensitive(kv.key, listField, row, value, sensitiveArgs, formId);
            return value;
        }
        List listValue = (List)value;
        ArrayList<Object> res = new ArrayList<Object>(10);
        for (Object obj : listValue) {
            res.add(SensitiveFiledUtil.deSensitive(kv.key, listField, row, obj, sensitiveArgs, formId));
        }
        return res;
    }

    public static Object setDefalutDeSensitiveValue(Object value) {
        if (!SensitiveFiledUtil.isInstanceofList(value)) {
            value = "******";
            return value;
        }
        List listValue = (List)value;
        ArrayList<String> res = new ArrayList<String>(10);
        for (Object ignored : listValue) {
            res.add("******");
        }
        return res;
    }

    public static Object checkAndToGetDesensitizeValue(ListField listField, Object value, DynamicObject row, String mainOrg) {
        if (listField == null) {
            return value;
        }
        IDataEntityProperty fieldProp = listField.getSrcFieldProp();
        if (!PrivacyCenterServiceHelper.isDesensitizeField((IDataEntityProperty)fieldProp, (String)ResManager.getLanguage(), (String)"EXPORT", (DynamicObject)row)) {
            if (!(fieldProp instanceof BasedataProp)) {
                return value;
            }
            value = SensitiveFiledUtil.getRealValue(value);
            if (!SensitiveFiledUtil.isHRQueryField(listField)) {
                AbstractColumnDesc columnDesc = listField.getColumnDesc(row.getDynamicObjectType(), mainOrg, SensitiveFiledUtil.isSpecialFormat(listField));
                return columnDesc.getDesensitizeValue(ResManager.getLanguage(), row, value);
            }
        }
        value = SensitiveFiledUtil.getRealValue(value);
        return PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)fieldProp, (String)ResManager.getLanguage(), (String)"EXPORT", (DynamicObject)row, (Object)value);
    }

    private static Object getRealValue(Object value) {
        if (!(value instanceof Map)) {
            return value;
        }
        Map valueMap = (Map)value;
        if (valueMap.containsKey("result")) {
            Object result = valueMap.get("result");
            return result;
        }
        return value;
    }

    public static boolean isSpecialFormat(ListField listField) {
        IDataEntityProperty srcProp = listField.getSrcFieldProp();
        boolean isSpecial = srcProp instanceof DecimalProp || srcProp instanceof IconProp || srcProp instanceof PictureProp || srcProp instanceof FlexProp || srcProp instanceof IQueryProp;
        return isSpecial;
    }

    public static boolean isHRQueryField(ListField listField) {
        IDataEntityProperty srcProp = listField.getSrcFieldProp();
        boolean isSpecial = srcProp instanceof IQueryProp;
        return isSpecial;
    }

    public static boolean isInstanceofList(Object value) {
        return value instanceof List;
    }

    public static boolean isCanExport(FieldControlRule fieldControlRule, String fieldKey) {
        if (fieldControlRule == null) {
            return true;
        }
        return !fieldControlRule.getCanNotReadFields().contains(fieldKey);
    }
}

