/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.designer.query.QueryEntityTreeNode;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NameVersionEntryType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.AttachmentCountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.hr.metadata.prop.MulQueryProp;
import kd.bos.ext.hr.metadata.prop.QueryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.constant.TemplateConfConst;
import kd.hr.hies.common.dto.CustomTabPage;
import kd.hr.hies.common.dto.EntityFieldContext;
import kd.hr.hies.common.enu.OprCategory;
import kd.hr.hies.common.enu.TemplateTypeEnum;
import kd.hr.hies.common.ext.property.VirEntityTextProp;
import kd.hr.hies.common.util.EntityTreeServiceHelper;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.HRVirEntityUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.hies.common.util.TemplateExportAttrUtil;
import kd.hr.hies.common.util.TemplateFormCommonUtil;
import kd.hr.hies.common.util.TemplateUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class TemplateEntityFieldUtil
implements TemplateConfConst {
    private static final Log logger = LogFactory.getLog(TemplateEntityFieldUtil.class);
    private static final String FIELD_HIS_BSED = "bsed";
    private static final String FIELD_ENTITYNAME = "tplentityname";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_ENTITYNUMBER = "fieldnumber";
    private static final String FIELD_ENTITYFID = "childentity";
    private static final String FIELD_ISFIELD = "isfield";
    private static final String FIELD_ISIMPORT = "isimport";
    private static final String FIELD_ISMUSTINPUT = "ismustinput";
    private static final String FIELD_ISDOWNLOADCOND = "isdownloadcond";
    private static final String FIELD_ISCONDGETDATA = "iscondgetdata";
    private static final String FIELD_ID = "id";
    private static final String FIELD_PID = "pid";
    private static final String FIELD_SEQ = "seq";
    public final String RES_BILLHEAD_NAME = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)HiesCommonRes.TemplateEntityFieldUtil_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
    public final String RES_ID_NAME = ResManager.loadKDString((String)"\u5185\u7801", (String)HiesCommonRes.TemplateEntityFieldUtil_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
    public final String RES_SUPERIOR_ID_NAME = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)HiesCommonRes.TemplateEntityFieldUtil_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
    private Map<String, String> dataRangeMap = new HashMap<String, String>(16);
    private final Map<String, Map<String, IDataEntityProperty>> acrossPropMap = new HashMap<String, Map<String, IDataEntityProperty>>(16);
    private Map<String, IDataEntityProperty> newPropMap = new HashMap<String, IDataEntityProperty>();
    private Set<String> entryCollection = new HashSet<String>();
    private Map<String, Integer[]> entityIndexMapping = new HashMap<String, Integer[]>();

    public static TemplateEntityFieldUtil newInstance() {
        return new TemplateEntityFieldUtil();
    }

    public static void buildAndRestoreFieldTree(IFormView view, IDataModel model, LinkedHashMap<String, String> allEntity, OperationStatus operationStatus) {
        String templateType = (String)model.getValue("tmpltype");
        String downloadCond = (String)model.getValue("enabledowncond");
        boolean isImport = "IMPT".equals(templateType);
        boolean isDownloadCond = "1".equals(downloadCond);
        boolean isOpen = TemplateEntityFieldUtil.mustInputIsOpen(model);
        boolean canEdit = TemplateEntityFieldUtil.mustInputCanEdit(model);
        boolean baseCanEdit = TemplateEntityFieldUtil.baseCanEdit(model);
        DynamicObject bizobject = (DynamicObject)model.getValue("entity");
        if (Objects.nonNull(bizobject)) {
            Map<String, Map<String, Object>> importTypeUniqueMap = TemplateFormCommonUtil.getAllEntityUnique(model);
            Map<String, Map<String, Object>> importTypeRelationFieldMap = TemplateFormCommonUtil.getAllEntityRelationField(model);
            for (Map.Entry<String, Map<String, Object>> entityEntry : importTypeUniqueMap.entrySet()) {
                String entityNumber = entityEntry.getKey();
                Map<String, Object> uniqueDataMap = entityEntry.getValue();
                Map<String, Object> relationFieldDataMap = importTypeRelationFieldMap.get(entityNumber);
                String uniqueVal = (String)uniqueDataMap.get("uniqueVal");
                if (!ObjectUtils.isEmpty(relationFieldDataMap)) {
                    uniqueVal = uniqueVal + relationFieldDataMap.get("uniqueVal");
                }
                uniqueDataMap.put("uniqueVal", uniqueVal);
            }
            TemplateEntityFieldUtil.rebuildEntryEntityAndInit(view, model, isImport, isDownloadCond, isOpen, Boolean.FALSE, canEdit, baseCanEdit, allEntity, operationStatus, null, importTypeUniqueMap, TemplateEntityFieldUtil.isShowVirEntity(view));
        }
    }

    public static boolean baseCanEdit(IDataModel model) {
        String value = (String)model.getValue("importtype");
        return "delete".equals(value);
    }

    public static boolean mustInputCanEdit(IDataModel model) {
        String value = (String)model.getValue("importtype");
        return !"new".equals(value) && !"updateandnew".equals(value);
    }

    public static boolean mustInputIsOpen(IDataModel model) {
        String value = (String)model.getValue("importtype");
        return "new".equals(value) || "updateandnew".equals(value) || "update".equals(value);
    }

    public static void rebuildEntryEntityAndInit(IFormView view, IDataModel model, boolean isImport, boolean isDownloadCond, boolean isOpen, Boolean isClear, Boolean canEdit, Boolean baseCanEdit, LinkedHashMap<String, String> allEntity, OperationStatus operationStatus, JSONObject orderObj, Map<String, Map<String, Object>> uniqueVal, boolean isShowVirEntity) {
        Map<String, Map<String, LinkedHashMap<String, Object>>> entityMap = TemplateEntityFieldUtil.getEntityMap(model);
        DynamicObject bizobject = (DynamicObject)model.getValue("entity");
        String entityNumber = bizobject.getString("number");
        DynamicObject queryBizobject = (DynamicObject)model.getValue("queryentity");
        String queryEntityNumber = "";
        if (Objects.nonNull(queryBizobject)) {
            queryEntityNumber = queryBizobject.getString("number");
        }
        TemplateEntityFieldUtil.cacheCusField(view);
        model.beginInit();
        model.deleteEntryData("tpltreeentryentity");
        model.endInit();
        Map<String, Map<String, LinkedHashMap<String, Object>>> orderEntityMap = TemplateEntityFieldUtil.sortField(allEntity, orderObj, entityMap, false);
        ArrayList emptyList = new ArrayList();
        boolean isNew = !model.getDataEntity().getDataEntityState().getFromDatabase();
        for (Map.Entry<String, Map<String, LinkedHashMap<String, Object>>> entryMap : orderEntityMap.entrySet()) {
            ArrayList cancelUnique;
            String[] split = entryMap.getKey().split(":");
            String entityId = split[0];
            String number = split[1];
            Map<String, LinkedHashMap<String, Object>> dataMap = entryMap.getValue();
            Map<String, Object> data = uniqueVal.get(number);
            String uniqueval = ObjectUtils.isEmpty(data) ? "" : (String)data.get("uniqueVal");
            List list = cancelUnique = ObjectUtils.isEmpty(data) ? emptyList : (List)data.get("cancelUnique");
            if (isNew && number.equals(entityNumber) && StringUtils.isNotBlank((CharSequence)uniqueval)) {
                for (String fieldNumber : uniqueval.split(",")) {
                    String dataKey;
                    LinkedHashMap<String, Object> dataValue;
                    if (!StringUtils.isNotBlank((CharSequence)fieldNumber) || ObjectUtils.isEmpty(dataValue = dataMap.get(dataKey = number + "." + fieldNumber))) continue;
                    dataValue.put(FIELD_ISIMPORT, Boolean.TRUE);
                    dataValue.put(FIELD_ISMUSTINPUT, Boolean.TRUE);
                }
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
            String name = mainType.getDisplayName().getLocaleValue();
            EntityFieldContext entityFieldContext = new EntityFieldContext(view, number, "tpltreeentryentity", isImport, isOpen, canEdit, baseCanEdit, uniqueval, dataMap);
            TemplateEntityFieldUtil.newInstance().addTreeEntryRow(entityFieldContext);
            if (!isClear.booleanValue()) {
                TemplateEntityFieldUtil.newInstance().resetCustomStyles(view, model, "tpltreeentryentity", number, dataMap, isImport);
            }
            TemplateFormCommonUtil.addTabPage(view, new CustomTabPage(entityId, name), number, queryEntityNumber, isImport, isDownloadCond, isOpen, isClear, canEdit, baseCanEdit, uniqueval, dataMap, operationStatus, isShowVirEntity);
        }
    }

    public static void rebuildEntryEntityAndInitPage(IFormView view, IDataModel model, boolean isImport, boolean isDownloadCond, boolean isOpen, Boolean isClear, Boolean canEdit, Boolean baseCanEdit, LinkedHashMap<String, String> allEntity, OperationStatus operationStatus, JSONObject orderObj, Map<String, Map<String, Object>> uniqueVal) {
        Map<String, Map<String, LinkedHashMap<String, Object>>> entityMap = TemplateEntityFieldUtil.getEntityMap(model);
        model.beginInit();
        model.deleteEntryData("tpltreeentryentity");
        model.endInit();
        Map<String, Map<String, LinkedHashMap<String, Object>>> orderEntityMap = TemplateEntityFieldUtil.sortField(allEntity, orderObj, entityMap, false);
        for (Map.Entry<String, Map<String, LinkedHashMap<String, Object>>> entryMap : orderEntityMap.entrySet()) {
            String[] split = entryMap.getKey().split(":");
            String number = split[1];
            Map<String, LinkedHashMap<String, Object>> dataMap = entryMap.getValue();
            Map<String, Object> data = uniqueVal.get(number);
            String uniqueval = ObjectUtils.isEmpty(data) ? "" : (String)data.get("uniqueVal");
            EntityFieldContext entityFieldContext = new EntityFieldContext(view, number, "tpltreeentryentity", isImport, isOpen, canEdit, baseCanEdit, uniqueval, dataMap);
            TemplateEntityFieldUtil.newInstance().addTreeEntryRow(entityFieldContext);
            if (isClear.booleanValue()) continue;
            TemplateEntityFieldUtil.newInstance().resetCustomStyles(view, model, "tpltreeentryentity", number, dataMap, isImport);
        }
    }

    public static Map<String, Map<String, LinkedHashMap<String, Object>>> sortField(LinkedHashMap<String, String> allEntity, JSONObject orderObj, Map<String, Map<String, LinkedHashMap<String, Object>>> entityMap, boolean isEntryTpl) {
        LinkedHashMap<String, Map<String, LinkedHashMap<String, Object>>> orderEntityMap = new LinkedHashMap<String, Map<String, LinkedHashMap<String, Object>>>(allEntity.size());
        for (Map.Entry<String, String> allEntityEntry : allEntity.entrySet()) {
            for (Map.Entry<String, Map<String, LinkedHashMap<String, Object>>> entryMap : entityMap.entrySet()) {
                if (!entryMap.getKey().equals(allEntityEntry.getKey())) continue;
                if (!ObjectUtils.isEmpty((Object)orderObj)) {
                    String[] split = entryMap.getKey().split(":");
                    String entityId = split[0];
                    String number = split[1];
                    List fieldOrder = (List)JSON.parseObject((String)orderObj.getString(number), List.class);
                    if (CollectionUtils.isNotEmpty((Collection)fieldOrder)) {
                        orderEntityMap.put(entryMap.getKey(), TemplateEntityFieldUtil.getOrderedFieldMap(fieldOrder, entryMap, number, isEntryTpl));
                        continue;
                    }
                    orderEntityMap.put(entryMap.getKey(), entryMap.getValue());
                    continue;
                }
                orderEntityMap.put(entryMap.getKey(), entryMap.getValue());
            }
        }
        return orderEntityMap;
    }

    private static Map<String, LinkedHashMap<String, Object>> getOrderedFieldMap(List<String> fieldOrder, Map.Entry<String, Map<String, LinkedHashMap<String, Object>>> entryMap, String number, boolean isEntryTpl) {
        LinkedHashMap<String, Object> fieldInfo;
        int index = 0;
        Map<String, LinkedHashMap<String, Object>> fieldMap = entryMap.getValue();
        ArrayListMultimap fieldOrderMultimap = ArrayListMultimap.create();
        if (isEntryTpl) {
            for (String field : fieldOrder) {
                fieldInfo = fieldMap.get(number + "." + field);
                if (MapUtils.isEmpty(fieldInfo) && field.endsWith("_id")) {
                    fieldInfo = fieldMap.get(number + "." + field.replaceAll("_id", "\\.id"));
                }
                fieldOrderMultimap.put((Object)((Long)fieldInfo.get(FIELD_PID)), (Object)field);
            }
        } else {
            for (String field : fieldOrder) {
                fieldInfo = fieldMap.get(number + "." + field);
                fieldOrderMultimap.put((Object)((Long)fieldInfo.get(FIELD_PID)), (Object)field);
            }
        }
        LinkedHashMap<String, LinkedHashMap<String, Object>> seqFieldMap = new LinkedHashMap<String, LinkedHashMap<String, Object>>(fieldMap.size());
        for (Map.Entry<String, LinkedHashMap<String, Object>> fieldMapEntry : fieldMap.entrySet()) {
            String key = fieldMapEntry.getKey();
            if (seqFieldMap.containsKey(key)) continue;
            LinkedHashMap<String, Object> value = fieldMapEntry.getValue();
            Long id = (Long)value.get(FIELD_PID);
            List fields = fieldOrderMultimap.get((Object)id);
            String entityField = "";
            String[] split = key.split("\\.");
            if (split.length == 2) {
                entityField = split[1];
            }
            if (TemplateEntityFieldUtil.needGenerateSeq(key, fields, entityField)) {
                for (String field : fields) {
                    LinkedHashMap<String, Object> fieldDetail = fieldMap.get(number + "." + field);
                    if (ObjectUtils.isEmpty(fieldDetail)) continue;
                    fieldDetail.put(FIELD_SEQ, ++index);
                    seqFieldMap.put(number + "." + field, fieldDetail);
                }
                value.put(FIELD_SEQ, ++index);
                seqFieldMap.put(key, value);
                continue;
            }
            value.put(FIELD_SEQ, ++index);
            seqFieldMap.put(key, value);
        }
        return seqFieldMap;
    }

    public static boolean needGenerateSeq(String key, List<String> fields, String entityField) {
        return FIELD_ID.equals(entityField) || key.endsWith(".id") || StringUtils.isNotBlank((CharSequence)entityField) && CollectionUtils.isNotEmpty(fields) && fields.contains(entityField);
    }

    public static Map<CustomTabPage, Map<String, LinkedHashMap<String, Object>>> getEntityCssMap(IDataModel model, LinkedHashMap<String, String> allEntity) {
        DynamicObjectCollection dynColl = model.getEntryEntity("tpltreeentryentity");
        String root = "";
        CustomTabPage entityMapKey = null;
        int index = 0;
        LinkedHashMap entityMap = new LinkedHashMap(16);
        for (DynamicObject dyn : dynColl) {
            Long pid = dyn.getLong(FIELD_PID);
            boolean isField = dyn.getBoolean(FIELD_ISFIELD);
            boolean isImport = dyn.getBoolean(FIELD_ISIMPORT);
            if (TemplateEntityFieldUtil.isSubField(pid, isField)) {
                ++index;
            }
            if (!isImport && isField) continue;
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
            data.put(FIELD_NAME, dyn.getString(FIELD_NAME));
            data.put(FIELD_PID, index);
            if (pid == null || pid == 0L) {
                root = dyn.getString(FIELD_ENTITYNUMBER);
                String entityName = dyn.getString(FIELD_ENTITYNAME);
                entityMapKey = new CustomTabPage(root, entityName);
                LinkedHashMap dataMap = new LinkedHashMap(16);
                entityMap.put(entityMapKey, dataMap);
                continue;
            }
            Map dataMap = (Map)entityMap.get(entityMapKey);
            String fieldNumber = dyn.getString(FIELD_ENTITYNUMBER);
            String string = fieldNumber = "billhead".equals(fieldNumber) ? "" : fieldNumber;
            if (!isField || !StringUtils.isNotBlank((CharSequence)fieldNumber) || FIELD_ID.equals(fieldNumber) || fieldNumber.endsWith(".id")) continue;
            dataMap.put(fieldNumber, data);
        }
        for (Map.Entry customTabPageMapEntry : entityMap.entrySet()) {
            Map value = (Map)customTabPageMapEntry.getValue();
            int i = 1;
            for (Map.Entry field : value.entrySet()) {
                LinkedHashMap data = (LinkedHashMap)field.getValue();
                data.put(FIELD_SEQ, i++);
            }
        }
        LinkedHashMap<CustomTabPage, Map<String, LinkedHashMap<String, Object>>> linkedEntityMap = new LinkedHashMap<CustomTabPage, Map<String, LinkedHashMap<String, Object>>>(16);
        for (Map.Entry<String, String> entity : allEntity.entrySet()) {
            String key = entity.getKey().split(":")[0];
            for (Map.Entry customTabPageMapEntry : entityMap.entrySet()) {
                String tabPageKey = ((CustomTabPage)customTabPageMapEntry.getKey()).getTabPageKey();
                if (!key.equals(tabPageKey)) continue;
                linkedEntityMap.put((CustomTabPage)customTabPageMapEntry.getKey(), (Map<String, LinkedHashMap<String, Object>>)customTabPageMapEntry.getValue());
            }
        }
        return linkedEntityMap;
    }

    public static boolean isSubField(Long pid, boolean isField) {
        return !isField && pid != null && pid != 0L;
    }

    public static Map<String, Map<String, LinkedHashMap<String, Object>>> getEntityMap(IDataModel model) {
        DynamicObjectCollection dynColl = model.getEntryEntity("tpltreeentryentity");
        String root = "";
        String entityMapKey = "";
        HashMap<String, Map<String, LinkedHashMap<String, Object>>> entityMap = new HashMap<String, Map<String, LinkedHashMap<String, Object>>>(16);
        for (DynamicObject dyn : dynColl) {
            LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Object>>> dataMap;
            Long pid = dyn.getLong(FIELD_PID);
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
            data.put(FIELD_ID, dyn.getPkValue());
            data.put(FIELD_PID, pid);
            String entitydescription = HIESUtil.trimTplFieldEntitydescription(dyn.getString("entitydescription"));
            data.put("entitydescription", entitydescription);
            if (StringUtils.isNotEmpty((CharSequence)entitydescription)) {
                try {
                    Map map = (Map)SerializationUtils.fromJsonString((String)entitydescription, Map.class);
                    ArrayList list = new ArrayList(4);
                    map.values().forEach(x -> {
                        LocaleString lang = (LocaleString)SerializationUtils.fromJsonString((String)x, LocaleString.class);
                        if (StringUtils.isNotEmpty((CharSequence)lang.getLocaleValue())) {
                            list.add(lang.getLocaleValue());
                        }
                    });
                    data.put("displayname", String.join((CharSequence)",", list));
                }
                catch (Throwable e) {
                    logger.warn(e);
                }
            }
            String fieldNumber = dyn.getString(FIELD_ENTITYNUMBER);
            String entityNumber = dyn.getString(FIELD_ENTITYFID);
            if (StringUtils.isNotBlank((Object)dyn.get("defvalprop"))) {
                String defVal = dyn.getString("defvalprop");
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                Map allFields = mainType.getAllFields();
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldNumber);
                if (defVal.contains("$dynamicFlag_")) {
                    String finalDefVal = defVal.replace("$dynamicFlag_", "");
                    boolean isEntityTpl = "hies_tplfieldconf_new".equals(model.getDataEntityType().getName());
                    Map<String, String> fieldPathDisplayNames = MethodUtil.getFieldPathDisplayNames(allFields, isEntityTpl, entityNumber, dynColl);
                    for (Map.Entry<String, String> entry : fieldPathDisplayNames.entrySet()) {
                        String key = entry.getKey();
                        if (!finalDefVal.contains(key)) continue;
                        finalDefVal = finalDefVal.replace(key, entry.getValue());
                    }
                    data.put("defvalname", finalDefVal);
                } else if (property instanceof MulBasedataProp) {
                    if (StringUtils.isNotBlank((CharSequence)defVal)) {
                        String[] ids = defVal.split(",");
                        DynamicObjectCollection collection = new DynamicObjectCollection();
                        String baseEntityId = ((MulBasedataProp)property).getBaseEntityId();
                        MainEntityType type = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                        Map<String, Object> bdMainProp = property instanceof MulQueryProp ? MethodUtil.getHRPersonMainProp(baseEntityId) : MethodUtil.getBdMainProp(baseEntityId);
                        String bdName = (String)bdMainProp.get("name");
                        ArrayList mulBaseVal = Lists.newArrayListWithExpectedSize((int)ids.length);
                        for (String tempId : ids) {
                            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)tempId, (DynamicObjectType)type);
                            collection.add((Object)dynamicObject);
                            mulBaseVal.add(dynamicObject.getString(bdName));
                        }
                        String collect = mulBaseVal.stream().collect(Collectors.joining(";"));
                        data.put("defvalname", collect);
                    }
                } else if (property instanceof BasedataProp) {
                    DynamicObject dynamicObject;
                    HRBaseServiceHelper serviceHelper;
                    String bdName;
                    Map<String, Object> bdMainProp;
                    String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                    if (property instanceof QueryProp) {
                        bdMainProp = MethodUtil.getHRPersonMainProp(baseEntityId);
                        bdName = (String)bdMainProp.get("name");
                        serviceHelper = new HRBaseServiceHelper(baseEntityId);
                        dynamicObject = serviceHelper.loadSingle((Object)defVal);
                        data.put("defvalname", dynamicObject.getString(bdName));
                    } else {
                        bdMainProp = MethodUtil.getBdMainProp(baseEntityId);
                        bdName = (String)bdMainProp.get("name");
                        serviceHelper = new HRBaseServiceHelper(baseEntityId);
                        dynamicObject = serviceHelper.loadSingle((Object)defVal);
                        data.put("defvalname", dynamicObject.getString(bdName));
                    }
                } else if (property instanceof ComboProp) {
                    ComboProp comboProp = (ComboProp)mainType.getAllFields().get(fieldNumber);
                    List comboItem = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToStream((CharSequence)defVal).map(str -> comboProp.getItemByName(str)).collect(Collectors.toList());
                    data.put("defvalname", Joiner.on((String)";").skipNulls().join(comboItem));
                } else if (property instanceof BooleanProp) {
                    List itemList = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)defVal);
                    StringBuilder sb = new StringBuilder();
                    for (String s : itemList) {
                        if ("1".equals(s)) {
                            sb.append(ResManager.loadKDString((String)"\u662f", (String)HiesCommonRes.TemplateEntityFieldUtil_5.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                            continue;
                        }
                        sb.append(ResManager.loadKDString((String)"\u5426", (String)HiesCommonRes.TemplateEntityFieldUtil_6.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                    }
                    data.put("defvalname", sb.toString());
                } else if (property instanceof DateProp) {
                    data.put("defvalname", HRDateTimeUtils.getDateStrWithoutMin((Date)new Date(dyn.getLong("defvalprop"))));
                } else if (property instanceof DateTimeProp) {
                    data.put("defvalname", DateUtils.dateToString((Date)new Date(dyn.getLong("defvalprop")), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS));
                } else if (property instanceof TimeProp) {
                    data.put("defvalname", MethodUtil.formatTimeStr(dyn.getInt("defvalprop")));
                } else if (property instanceof CreateDateProp || property instanceof ModifyDateProp) {
                    data.put("defvalname", DateUtils.dateToString((Date)new Date(dyn.getLong("defvalprop")), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS));
                } else if (property instanceof MuliLangTextProp) {
                    LocaleString localeString = (LocaleString)SerializationUtils.fromJsonString((String)defVal, LocaleString.class);
                    data.put("defvalname", localeString.getLocaleValue());
                } else {
                    data.put("defvalname", defVal);
                }
            }
            data.put("defvalprop", dyn.getString("defvalprop"));
            data.put(FIELD_ISMUSTINPUT, dyn.getBoolean(FIELD_ISMUSTINPUT));
            data.put(FIELD_ISIMPORT, dyn.getBoolean(FIELD_ISIMPORT));
            data.put(FIELD_ISDOWNLOADCOND, dyn.getBoolean(FIELD_ISDOWNLOADCOND));
            data.put(FIELD_ISCONDGETDATA, dyn.getBoolean(FIELD_ISCONDGETDATA));
            data.put("fieldimportdesc", dyn.get("fieldimportdesc"));
            data.put(FIELD_ISFIELD, dyn.getBoolean(FIELD_ISFIELD));
            data.put("ischecked", dyn.getBoolean("ischecked"));
            data.put("iscusfield", dyn.getBoolean("iscusfield"));
            data.put(FIELD_SEQ, dyn.getInt(FIELD_SEQ));
            data.put("imptattr", dyn.getString("imptattr"));
            data.put("exptattr", dyn.getString("exptattr"));
            data.put("issheet", dyn.getString("issheet"));
            data.put("sheetbdfields", dyn.getString("sheetbdfields"));
            data.put(FIELD_NAME, dyn.getString(FIELD_NAME));
            data.put("cusfieldid", dyn.getLong("cusfieldid"));
            data.put("isvirfield", dyn.getBoolean("isvirfield"));
            if (pid == null || pid == 0L) {
                root = dyn.getString(FIELD_ENTITYNUMBER);
                entityMapKey = dyn.getString(FIELD_ENTITYFID) + ":" + root;
                dataMap = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Object>>>(16);
                dataMap.put(root, data);
                entityMap.put(entityMapKey, dataMap);
                continue;
            }
            dataMap = (LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Object>>>)entityMap.get(entityMapKey);
            fieldNumber = "billhead".equals(fieldNumber) ? "" : fieldNumber;
            dataMap.put(root + "." + fieldNumber, data);
        }
        return entityMap;
    }

    public static Map<String, LinkedHashMap<String, Object>> getSubEntityMap(IDataModel model) {
        HashMap subEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection dynColl = model.getEntryEntity("entityrelation");
        for (DynamicObject dy : dynColl) {
            DynamicObject subEntity = (DynamicObject)dy.get("rentity");
            String entityNumber = subEntity.getString("number");
            LinkedHashMap<String, Object> data = subEntityMap.getOrDefault(entityNumber, new LinkedHashMap(16));
            data.put("entityuniqueval", dy.get("entityuniqueval"));
            data.put("relationleftprop", dy.get("relationleftprop"));
            data.put("relationrightprop", dy.get("relationrightprop"));
            subEntityMap.put(entityNumber, data);
        }
        return subEntityMap;
    }

    public void resetCustomStyles(IFormView view, IDataModel model, String treeentryentity, String root, Map<String, LinkedHashMap<String, Object>> dataMap, boolean isImport) {
        DynamicObjectCollection dynColl = model.getEntryEntity(treeentryentity);
        Map<String, Map<String, Object>> importF7BdFormatConfig = TemplateEntityFieldUtil.getImportF7BdFormatConfig(root);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("deffieldnumber", new Object[0]);
        vs.addField("deffieldname", new Object[0]);
        vs.addField("deffieldvalname", new Object[0]);
        vs.addField("deffieldvalprop", new Object[0]);
        int i = 0;
        model.beginInit();
        String cusfieldName = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5", (String)HiesCommonRes.TemplateEntityFieldUtil_7.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
        String virFieldName = ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f", (String)HiesCommonRes.TemplateEntityFieldUtil_9.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
        for (DynamicObject dyn : dynColl) {
            if (dataMap != null) {
                String propName = dyn.getString(FIELD_ENTITYNUMBER);
                String entityNumber = dyn.getString(FIELD_ENTITYFID);
                Long pid = dyn.getLong(FIELD_PID);
                String fullPropName = propName;
                if (pid == null || pid == 0L) {
                    root = propName;
                } else {
                    fullPropName = root + "." + propName;
                }
                Map data = dataMap.get(fullPropName);
                if (data != null) {
                    String defValProp = (String)data.get("defvalprop");
                    String defValName = (String)data.get("defvalname");
                    if (StringUtils.isNotBlank((CharSequence)defValProp)) {
                        String fieldName = TemplateFormCommonUtil.getDisplayName(entityNumber, propName);
                        String displayName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s(%2$s)", (String)HiesCommonRes.TemplateEntityFieldUtil_8.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), fieldName, propName);
                        vs.addRow(new Object[]{propName, displayName, defValName, defValProp});
                    }
                    boolean isCusField = (Boolean)data.get("iscusfield");
                    boolean isVirField = (Boolean)data.get("isvirfield");
                    model.setValue("entitydescription", data.get("entitydescription"), i);
                    model.setValue("displayname", data.get("displayname"), i);
                    if (isCusField) {
                        model.setValue(FIELD_NAME, data.get(FIELD_NAME), i);
                        model.setValue(FIELD_ENTITYNAME, (Object)cusfieldName, i);
                    } else if (isVirField) {
                        model.setValue(FIELD_ENTITYNAME, (Object)virFieldName, i);
                    }
                    if ("tpltreeentryentity".equals(treeentryentity)) {
                        model.setValue("defvalprop", (Object)defValProp, i);
                        model.setValue("defvalname", (Object)defValName, i);
                    }
                    TemplateUtil.setIsMustInput(model, (Boolean)data.get(FIELD_ISMUSTINPUT), i);
                    TemplateUtil.setIsImport(model, (Boolean)data.get(FIELD_ISIMPORT), i);
                    model.setValue("ischecked", data.get("ischecked"), i);
                    model.setValue(FIELD_ISFIELD, data.get(FIELD_ISFIELD), i);
                    model.setValue("iscusfield", (Object)isCusField, i);
                    model.setValue("cusfieldid", data.get("cusfieldid"), i);
                    model.setValue("isvirfield", (Object)isVirField, i);
                    model.setValue(FIELD_ISDOWNLOADCOND, data.get(FIELD_ISDOWNLOADCOND), i);
                    model.setValue(FIELD_ISCONDGETDATA, data.get(FIELD_ISCONDGETDATA), i);
                    boolean fieldIsImport = (Boolean)data.get(FIELD_ISIMPORT);
                    if (fieldIsImport) {
                        model.setValue("ischecked", (Object)true, i);
                    }
                    if (Boolean.TRUE.equals(data.get(FIELD_ISIMPORT))) {
                        Map<String, Object> imptFormatConfig;
                        model.setValue("imptattr", data.get("imptattr"), i);
                        model.setValue("issheet", data.get("issheet"), i);
                        String selectFieldValues = (String)data.get("sheetbdfields");
                        if (StringUtils.isNotBlank((CharSequence)selectFieldValues)) {
                            String tranSortF7fieldNames = MethodUtil.tranSortF7fieldNames(root, propName, selectFieldValues);
                            model.setValue("sheetbdfieldnames", (Object)tranSortF7fieldNames, i);
                        }
                        model.setValue("sheetbdfields", (Object)selectFieldValues, i);
                        String exptattr = (String)data.get("exptattr");
                        model.setValue("exptattr", (Object)exptattr, i);
                        if (view.getEntityId().equalsIgnoreCase("hies_tplfieldconf_new") && (imptFormatConfig = importF7BdFormatConfig.get(propName)) != null && imptFormatConfig.get("canEdit") == Boolean.TRUE) {
                            view.setEnable(Boolean.TRUE, i, new String[]{"imptattr"});
                            view.setEnable(Boolean.TRUE, i, new String[]{"issheet"});
                        }
                        if (view.getEntityId().equalsIgnoreCase("hies_tplfieldconf_new") && StringUtils.isNotEmpty((CharSequence)exptattr)) {
                            List<String> lists = Arrays.asList(StringUtils.split((String)exptattr, (String)","));
                            String displayName = TemplateExportAttrUtil.getExportPropsDisplayName(root, view, lists, i);
                            model.setValue("exptattr", (Object)displayName, i);
                            model.setValue("exptattrtemp", (Object)exptattr, i);
                            view.setEnable(Boolean.TRUE, i, new String[]{"exptattr"});
                        }
                        if (isCusField) {
                            model.setValue("issheet", (Object)"", i);
                            model.setValue("sheetbdfields", (Object)"", i);
                            model.setValue("sheetbdfieldnames", (Object)"", i);
                        }
                    }
                    String fieldImportDesc = dyn.getString("fieldimportdesc");
                    Object val = data.get("fieldimportdesc");
                    Object importDescRealVal = TemplateUtil.getImportDescRealVal(val);
                    if (ObjectUtils.isEmpty((Object)importDescRealVal)) {
                        if (StringUtils.isBlank((CharSequence)fieldImportDesc)) {
                            TemplateUtil.setImportDesc(model, val, i);
                        } else {
                            TemplateUtil.setImportDesc(model, dyn.get("fieldimportdesc"), i);
                        }
                    } else {
                        TemplateUtil.setImportDesc(model, val, i);
                    }
                }
            }
            ++i;
        }
        model.endInit();
        if ("treeentryentity".equals(treeentryentity)) {
            model.beginInit();
            ((AbstractFormDataModel)model).batchCreateNewEntryRow("cusfieldentryentity", vs);
            model.endInit();
            view.updateView("cusfieldentryentity");
        }
    }

    public void resetCustomFieldStyles(IFormView view, IDataModel model, String treeentryentity, String root, Map<String, LinkedHashMap<String, Object>> dataMap, boolean isImport) {
    }

    public void addTreeEntryRow(EntityFieldContext entityFieldContext) {
        String treeEntryEntity = entityFieldContext.getTreeEntryEntity();
        IFormView view = entityFieldContext.getView();
        entityFieldContext.setNeedPrimaryKey(true);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)view.getControl(entityFieldContext.getTreeEntryEntity());
        treeEntryGrid.queryTreeNodeChildren();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityFieldContext.getEntityNumber());
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        boolean inhRelation = EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(HisModelController.getInstance().entityInhRelation(entityFieldContext.getEntityNumber()));
        entityFieldContext.setInhRelation(inhRelation);
        boolean isQueryEntity = false;
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypes.add(queryType.getMainEntityType());
            entityTypes.addAll(queryType.getAllJoinEntityType());
            isQueryEntity = true;
        } else {
            entityTypes.add(mainType);
        }
        for (MainEntityType mainEntityType : entityTypes) {
            view.getPageCache().put("rootEntityNumber", mainEntityType.getName());
            this.buildFldTreeRowExt(entityFieldContext, mainEntityType);
        }
        view.updateView(treeEntryEntity);
        TreeEntryGrid grid = (TreeEntryGrid)view.getControl(treeEntryEntity);
        grid.setCollapse(false);
    }

    public void buildBillTreeFieldsExt(EntityFieldContext entityFieldContext) {
        String treeEntryEntity = entityFieldContext.getTreeEntryEntity();
        IFormView view = entityFieldContext.getView();
        IDataModel model = entityFieldContext.getModel();
        String entityNumber = entityFieldContext.getEntityNumber();
        entityFieldContext.setNeedPrimaryKey(false);
        model.beginInit();
        model.deleteEntryData(treeEntryEntity);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        boolean inhRelation = EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(HisModelController.getInstance().entityInhRelation(entityNumber));
        entityFieldContext.setInhRelation(inhRelation);
        boolean isQueryEntity = false;
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypes.add(queryType.getMainEntityType());
            entityTypes.addAll(queryType.getAllJoinEntityType());
            isQueryEntity = true;
        } else {
            entityTypes.add(mainType);
        }
        for (MainEntityType mainEntityType : entityTypes) {
            view.getPageCache().put("rootEntityNumber", mainEntityType.getName());
            this.buildFldTreeRowExt(entityFieldContext, mainEntityType);
        }
        view.updateView(treeEntryEntity);
        model.updateCache();
        TreeEntryGrid grid = (TreeEntryGrid)view.getControl(treeEntryEntity);
        grid.setCollapse(false);
        model.endInit();
    }

    private void buildFldTreeRowExt(EntityFieldContext entityFieldContext, MainEntityType mainType) {
        IDataModel model = entityFieldContext.getModel();
        IFormView view = entityFieldContext.getView();
        String entityNumber = entityFieldContext.getEntityNumber();
        String treeEntryEntity = entityFieldContext.getTreeEntryEntity();
        Map<String, LinkedHashMap<String, Object>> dataMap = entityFieldContext.getDataMap();
        model.beginInit();
        Integer[] pRow = new Integer[]{model.createNewEntryRow(treeEntryEntity), null};
        model.endInit();
        this.fillExistingRowIdAndPid(model, view, treeEntryEntity, mainType.getName(), dataMap, pRow[0]);
        this.entityIndexMapping.put(mainType.getName(), pRow);
        this.fillPartialFieldsInfo(view, entityNumber, model, mainType.getDisplayName().toString(), mainType.getName(), pRow[0]);
        this.buildEntryTreeRow(entityFieldContext, mainType, pRow);
    }

    private void buildEntryTreeRow(EntityFieldContext entityFieldContext, MainEntityType mainType, Integer[] pRow) {
        IFormView view = entityFieldContext.getView();
        IDataModel model = entityFieldContext.getModel();
        String treeEntryEntity = entityFieldContext.getTreeEntryEntity();
        boolean[] isAllCheck = new boolean[]{false};
        int[] row = new int[]{-1};
        Set entryMap = mainType.getAllEntities().entrySet();
        boolean isImport = entityFieldContext.isImportFlag();
        List<EntityItem<?>> imptSupportFields = TemplateEntityFieldUtil.filterEntityItems(mainType, isImport);
        List<ControlAp<?>> aps = this.getFormMetadata(mainType.getName());
        if (entityFieldContext.isShowVirEntity()) {
            String entityKey;
            EntityType entityType;
            String mainEntityNumber = entityFieldContext.getMainEntityNumber();
            for (Map.Entry<String, EntityType> entry : entryMap) {
                entityType = (EntityType)entry.getValue();
                entityKey = (String)entry.getKey();
                if (entityType instanceof SubEntryType || !mainEntityNumber.equals(entityKey)) continue;
                if (entry.getValue() instanceof EntryType) {
                    this.entryCollection.add(entityKey);
                }
                this.entitySortAndBuild(entityFieldContext, mainType, imptSupportFields, aps, pRow, row, isAllCheck, entry);
            }
            for (Map.Entry<String, EntityType> entry : entryMap) {
                entityType = (EntityType)entry.getValue();
                entityKey = (String)entry.getKey();
                if (entityType instanceof SubEntryType || mainEntityNumber.equals(entityKey)) continue;
                if (entry.getValue() instanceof EntryType) {
                    this.entryCollection.add(entityKey);
                }
                this.entitySortAndBuild(entityFieldContext, mainType, imptSupportFields, aps, pRow, row, isAllCheck, entry);
            }
        } else {
            for (Map.Entry<String, EntityType> entry : entryMap) {
                EntityType entityType = (EntityType)entry.getValue();
                if (entityType instanceof SubEntryType) continue;
                if (entry.getValue() instanceof EntryType) {
                    this.entryCollection.add((String)entry.getKey());
                }
                this.entitySortAndBuild(entityFieldContext, mainType, imptSupportFields, aps, pRow, row, isAllCheck, entry);
            }
        }
        view.getPageCache().put("entryCollection", this.entryCollection.toString());
        if (row[0] > 0) {
            model.beginInit();
            model.deleteEntryRow(treeEntryEntity, row[0]);
            model.endInit();
        }
        if (isAllCheck[0]) {
            TemplateUtil.setIsMustInputTrue(model, pRow[0]);
            model.setValue(FIELD_ISDOWNLOADCOND, (Object)Boolean.TRUE, pRow[0].intValue());
            model.setValue(FIELD_ISCONDGETDATA, (Object)Boolean.TRUE, pRow[0].intValue());
        }
    }

    private void entitySortAndBuild(EntityFieldContext entityFieldContext, MainEntityType mainType, List<EntityItem<?>> imptSupportFields, List<ControlAp<?>> aps, Integer[] pRow, int[] row, boolean[] isAllCheck, Map.Entry<String, EntityType> entry) {
        IDataEntityType parentType;
        IDataModel model = entityFieldContext.getModel();
        IFormView view = entityFieldContext.getView();
        Map<String, LinkedHashMap<String, Object>> dataMap = entityFieldContext.getDataMap();
        String treeEntryEntity = entityFieldContext.getTreeEntryEntity();
        boolean isNeedPrimaryKey = entityFieldContext.isNeedPrimaryKey();
        EntityType entityType = entry.getValue();
        if (entityType instanceof LinkEntryType || entityType instanceof NameVersionEntryType) {
            return;
        }
        String entityNodeId = entityType.getName();
        String entityNodeName = "";
        if (entityType.getDisplayName() != null) {
            entityNodeName = entityType.getDisplayName().toString();
        }
        if (entityType instanceof MainEntityType) {
            entityNodeName = this.RES_BILLHEAD_NAME;
            entityNodeId = "";
        }
        pRow = this.entityIndexMapping.get((parentType = entityType.getParent()) != null ? parentType.getName() : entityType.getName());
        if (row[0] < 0) {
            model.beginInit();
            row[0] = model.insertEntryRow(treeEntryEntity, pRow[0].intValue());
            model.endInit();
        }
        this.fillExistingRowIdAndPid(model, view, treeEntryEntity, mainType.getName() + "." + entityNodeId, dataMap, row[0]);
        List<IDataEntityProperty> properties = entityType.getFields().values().stream().filter(prop -> prop.getName() != null && (entityType instanceof QueryEntityType && !(prop instanceof JoinProperty) || this.isPropertyImport(imptSupportFields, (IDataEntityProperty)prop))).collect(Collectors.toList());
        List<IDataEntityProperty> cusProperties = TemplateEntityFieldUtil.registerCusField(properties, model, view, mainType, entityType, treeEntryEntity);
        properties.addAll(cusProperties);
        if (entityFieldContext.isShowVirEntity() && entityType.getName().equals(entityFieldContext.getMainEntityNumber())) {
            List<IDataEntityProperty> hrVirEntityProperties = TemplateEntityFieldUtil.registerHRVirEntityField(entityFieldContext.getMainEntityNumber());
            properties.addAll(hrVirEntityProperties);
        }
        Set<String> currSort = dataMap != null ? dataMap.keySet() : null;
        this.getSortProperties(view, properties, aps, currSort, entityType, isNeedPrimaryKey);
        boolean isAllChildrenCheck = true;
        if (!properties.isEmpty()) {
            isAllChildrenCheck = this.buildEntryFieldTreeRow(entityFieldContext, mainType, row[0], entry.getKey(), entityNodeId, entityNodeName, properties, entityType);
            if (!isAllChildrenCheck) {
                isAllCheck[0] = Boolean.FALSE;
            }
            row[0] = -1;
        }
    }

    public static List<IDataEntityProperty> registerCusField(List<IDataEntityProperty> pros, IDataModel model, IFormView view, MainEntityType mainEntityType, EntityType entityType, String treeEntryEntity) {
        Pair<Map<String, LinkedHashMap>, Map<String, LinkedHashMap>> pair = TemplateEntityFieldUtil.getCusField(model, view, mainEntityType, entityType, "tpltreeentryentity");
        Map cusField = (Map)pair.getRight();
        Map sysField = (Map)pair.getLeft();
        ArrayList properties = Lists.newArrayListWithExpectedSize((int)16);
        HashSet cusFieldSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry fieldEntry : cusField.entrySet()) {
            String key = (String)fieldEntry.getKey();
            String[] split = key.split("\\.");
            if (split.length < 3) continue;
            String fieldName = key.split("\\.")[2];
            cusFieldSet.add(fieldName);
            properties.add(TemplateEntityFieldUtil.registerCusFieldProps(fieldName, fieldName));
        }
        return properties;
    }

    public static List<IDataEntityProperty> registerHRVirEntityField(String mainEntityNumber) {
        DynamicObject[] fields;
        ArrayList properties = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject field : fields = HRVirEntityUtil.getFields(mainEntityNumber)) {
            String fieldNumber = field.getString(FIELD_ENTITYNUMBER);
            String fieldName = field.getString(FIELD_NAME);
            properties.add(TemplateEntityFieldUtil.registerVirEntityFieldProps(fieldNumber, fieldName));
        }
        return properties;
    }

    public static void cacheCusField(IFormView view) {
        Map<String, Map<String, LinkedHashMap<String, Object>>> entityMap = EntityTreeServiceHelper.getnEntityMap(view.getModel().getEntryEntity("tpltreeentryentity"));
        LinkedHashMap cusField = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, Map<String, LinkedHashMap<String, Object>>> entry : entityMap.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split(":");
            ArrayList field = Lists.newArrayListWithCapacity((int)16);
            Map<String, LinkedHashMap<String, Object>> value = entry.getValue();
            for (Map.Entry<String, LinkedHashMap<String, Object>> fieldEntry : value.entrySet()) {
                LinkedHashMap<String, Object> fieldData = fieldEntry.getValue();
                boolean isCusField = (Boolean)fieldData.get("iscusfield");
                String fieldNumber = (String)fieldData.get(FIELD_ENTITYNUMBER);
                if (!isCusField) continue;
                field.add(fieldNumber);
            }
            cusField.put(split[0], field);
        }
        view.getPageCache().put("cusFieldList", SerializationUtils.toJsonString((Object)cusField));
    }

    public static Map<String, List<String>> getCusField(IFormView view) {
        String cusFieldList = view.getPageCache().get("cusFieldList");
        if (StringUtils.isNotBlank((CharSequence)cusFieldList)) {
            return (Map)SerializationUtils.fromJsonString((String)cusFieldList, Map.class);
        }
        return Maps.newHashMap();
    }

    private static Pair<Map<String, LinkedHashMap>, Map<String, LinkedHashMap>> getCusField(IDataModel model, IFormView view, MainEntityType mainEntityType, EntityType entityType, String treeEntryEntity) {
        String mapKey;
        List<String> pageFieldList;
        Map<String, Map<String, LinkedHashMap<String, Object>>> entityMap = TemplateEntityFieldUtil.getnEntityMap(model, view);
        LinkedHashMap cusField = Maps.newLinkedHashMapWithExpectedSize((int)16);
        LinkedHashMap sysField = Maps.newLinkedHashMapWithExpectedSize((int)16);
        Map<String, List<String>> cacheCusField = TemplateEntityFieldUtil.getCusField(view);
        if (HRStringUtils.equals((String)mainEntityType.getName(), (String)entityType.getName())) {
            for (Map.Entry<String, Map<String, LinkedHashMap<String, Object>>> entry : entityMap.entrySet()) {
                String key = entry.getKey();
                Map<String, LinkedHashMap<String, Object>> value = entry.getValue();
                if (!key.contains("billhead") || !key.contains(mainEntityType.getName())) continue;
                String mapKey2 = mainEntityType.getName() + "billhead";
                for (Map.Entry<String, LinkedHashMap<String, Object>> fieldEntry : value.entrySet()) {
                    String fieldKey = fieldEntry.getKey();
                    LinkedHashMap<String, Object> fieldData = fieldEntry.getValue();
                    boolean isCusField = (Boolean)fieldData.get("iscusfield");
                    boolean isChecked = (Boolean)fieldData.get("ischecked");
                    if (isCusField) {
                        cusField.put(fieldEntry.getKey(), fieldEntry.getValue());
                        continue;
                    }
                    if (!isChecked) continue;
                    sysField.put(fieldEntry.getKey(), fieldEntry.getValue());
                }
            }
        } else {
            String mainEntityTypeNumber = mainEntityType.getName();
            String entryKeyPrefix = mainEntityTypeNumber + "." + entityType.getName() + ":";
            for (Map.Entry<String, Map<String, LinkedHashMap<String, Object>>> entry : entityMap.entrySet()) {
                String key = entry.getKey();
                Map<String, LinkedHashMap<String, Object>> value = entry.getValue();
                if (!key.startsWith(entryKeyPrefix)) continue;
                for (Map.Entry<String, LinkedHashMap<String, Object>> fieldEntry : value.entrySet()) {
                    String fieldKey = fieldEntry.getKey();
                    LinkedHashMap<String, Object> fieldData = fieldEntry.getValue();
                    boolean isCusField = (Boolean)fieldData.get("iscusfield");
                    boolean isChecked = (Boolean)fieldData.get("ischecked");
                    if (isCusField) {
                        cusField.put(fieldEntry.getKey(), fieldEntry.getValue());
                        continue;
                    }
                    if (!isChecked) continue;
                    sysField.put(fieldEntry.getKey(), fieldEntry.getValue());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(pageFieldList = cacheCusField.get(mapKey = HRStringUtils.equals((String)mainEntityType.getName(), (String)entityType.getName()) ? mainEntityType.getName() + ".billhead" : mainEntityType.getName() + "." + entityType.getName())) && CollectionUtils.isNotEmpty(pageFieldList)) {
            for (String fieldNum : pageFieldList) {
                cusField.put(mapKey + "." + fieldNum, null);
            }
        }
        return Pair.of((Object)sysField, (Object)cusField);
    }

    public static Map<String, Map<String, LinkedHashMap<String, Object>>> getnEntityMap(IDataModel model, IFormView view) {
        boolean isParentModel = view.getEntityId().equalsIgnoreCase("hies_diaetplconf");
        DynamicObjectCollection entryEntity = isParentModel ? view.getModel().getEntryEntity("tpltreeentryentity") : view.getParentView().getModel().getEntryEntity("tpltreeentryentity");
        return EntityTreeServiceHelper.getnEntityMap(entryEntity);
    }

    private static IDataEntityProperty registerCusFieldProps(String fieldName, String displayName) {
        TextProp textProp = new TextProp();
        textProp.setMaxLenth(255);
        textProp.setMinLenth(0);
        textProp.setName(fieldName);
        textProp.setDisplayName(new LocaleString(displayName));
        textProp.setDbIgnore(true);
        textProp.setMustInput(true);
        return textProp;
    }

    private static IDataEntityProperty registerVirEntityFieldProps(String fieldName, String displayName) {
        VirEntityTextProp textProp = new VirEntityTextProp();
        textProp.setMaxLenth(255);
        textProp.setMinLenth(0);
        textProp.setName(fieldName);
        textProp.setDisplayName(new LocaleString(displayName));
        textProp.setDbIgnore(true);
        textProp.setMustInput(false);
        textProp.setVirField(true);
        return textProp;
    }

    private boolean buildEntryFieldTreeRow(EntityFieldContext entityFieldContext, MainEntityType mainType, int row, String entryKey, String entityNodeId, String entityNodeName, List<IDataEntityProperty> properties, EntityType entityType) {
        IDataModel model = entityFieldContext.getModel();
        IFormView view = entityFieldContext.getView();
        String entityNumber = entityFieldContext.getEntityNumber();
        String treeEntryEntity = entityFieldContext.getTreeEntryEntity();
        boolean isAllChildrenCheck = true;
        model.beginInit();
        int[] rows = model.batchInsertEntryRow(treeEntryEntity, row, properties.size());
        model.endInit();
        HashMap<String, String> fieldTips = entityFieldContext.isImportFlag() ? MethodUtil.getFieldTips(entityNumber, false) : new HashMap(0);
        Map<String, ControlAp<?>> fieldApMap = ExcelStyleUtil.getFieldControlApMap(entityNumber);
        model.beginInit();
        int i = 0;
        for (IDataEntityProperty property : properties) {
            if (!this.buildFldTreeNode(entityFieldContext, property, rows[i], mainType, entityType, fieldTips, fieldApMap)) {
                isAllChildrenCheck = false;
            }
            ++i;
        }
        this.fillPartialFieldsInfo(view, entityNumber, model, entityNodeName, entityNodeId, row);
        TemplateUtil.setIsMustInput(model, isAllChildrenCheck, row);
        TemplateUtil.setIsImport(model, isAllChildrenCheck, row);
        model.setValue(FIELD_ISDOWNLOADCOND, (Object)isAllChildrenCheck, row);
        model.setValue(FIELD_ISCONDGETDATA, (Object)isAllChildrenCheck, row);
        if (!this.entityIndexMapping.containsKey(entryKey)) {
            this.entityIndexMapping.put(entryKey, new Integer[]{row, rows[rows.length - 1]});
        }
        model.endInit();
        return isAllChildrenCheck;
    }

    private boolean buildFldTreeNode(EntityFieldContext entityFieldContext, IDataEntityProperty fldProperty, int row, MainEntityType mainType, EntityType entityType, Map<String, String> fieldTips, Map<String, ControlAp<?>> fieldApMap) {
        Boolean isImportValue;
        String importType;
        boolean ismustinput;
        String entityNumber = entityFieldContext.getEntityNumber();
        IDataModel model = entityFieldContext.getModel();
        IFormView view = entityFieldContext.getView();
        String treeEntryEntity = entityFieldContext.getTreeEntryEntity();
        boolean isImportTpl = entityFieldContext.isImportFlag();
        boolean isOpen = entityFieldContext.isOpenFlag();
        Map<String, LinkedHashMap<String, Object>> dataMap = entityFieldContext.getDataMap();
        DynamicProperty prop = (DynamicProperty)fldProperty;
        String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
        String fieldNumber = prop.getName();
        model.setValue(FIELD_ENTITYFID, (Object)entityNumber, row);
        if (prop.getParent() != null && prop == prop.getParent().getPrimaryKey()) {
            fldNodeName = this.RES_ID_NAME;
            if (prop.getParent() instanceof EntryType) {
                fieldNumber = prop.getParent().getName() + "." + prop.getName();
            }
        } else if (prop.getName().equals(FIELD_PID) && prop.getParent() instanceof TreeEntryType) {
            fldNodeName = this.RES_SUPERIOR_ID_NAME;
            fieldNumber = prop.getParent().getName() + "." + prop.getName();
        }
        if (TemplateEntityFieldUtil.isMustInputField(fldProperty)) {
            fldNodeName = fldNodeName + "*";
        }
        if (dataMap != null) {
            DynamicObject rowObj = model.getEntryRowEntity(treeEntryEntity, row);
            this.restoreExistedRowInfo(mainType, dataMap, prop, entityNumber, rowObj, entityType);
            Object ismustinputVal = model.getValue(FIELD_ISIMPORT);
            ismustinput = ismustinputVal == null ? fldNodeName.endsWith("*") : Boolean.TRUE.equals(ismustinputVal);
        } else {
            ismustinput = fldNodeName.endsWith("*");
        }
        model.setValue(FIELD_NAME, (Object)fldNodeName, row);
        String propFullName = this.setPropFullName(view, (EntityType)mainType, (IDataEntityProperty)prop);
        boolean isNewProp = this.newPropMap.containsKey(propFullName);
        try {
            importType = (String)view.getModel().getValue("importtype");
        }
        catch (Exception ex) {
            importType = (String)view.getParentView().getModel().getValue("importtype");
        }
        boolean isUpdateType = OprCategory.isUpdate(importType);
        if (ismustinput && !isNewProp && isImportTpl && isOpen) {
            TemplateUtil.setIsMustInputTrue(model, row);
            model.setValue("ischecked", (Object)Boolean.TRUE, row);
            if (isUpdateType) {
                view.setEnable(Boolean.FALSE, row, new String[]{FIELD_ISMUSTINPUT});
            }
        }
        if (ismustinput && entityFieldContext.isInhRelation() && FIELD_HIS_BSED.equals(entityNumber)) {
            TemplateUtil.setIsMustInputTrue(model, row);
            model.setValue("ischecked", (Object)Boolean.TRUE, row);
            if (isUpdateType) {
                view.setEnable(Boolean.FALSE, row, new String[]{FIELD_ISMUSTINPUT});
            }
        }
        if (ismustinput && TemplateEntityFieldUtil.isUniqueval(entityFieldContext.getUniqueVal(), fieldNumber)) {
            TemplateUtil.setIsMustInputTrue(model, row);
            model.setValue("ischecked", (Object)Boolean.TRUE, row);
            if (isUpdateType) {
                view.setEnable(Boolean.FALSE, row, new String[]{FIELD_ISMUSTINPUT});
            }
        }
        if (Boolean.FALSE.equals(isImportValue = (Boolean)model.getValue(FIELD_ISIMPORT, row)) || !(prop instanceof BasedataProp) && !(prop instanceof MulBasedataProp)) {
            model.setValue("issheet", (Object)"", row);
            model.setValue("sheetbdfields", (Object)"", row);
            view.setEnable(Boolean.FALSE, row, new String[]{"issheet", "sheetbdfieldnames"});
        }
        if (Boolean.FALSE.equals(isImportValue)) {
            view.setEnable(Boolean.FALSE, row, new String[]{"displayname", "defvalname", "fieldimportdesc"});
        }
        model.setValue(FIELD_ENTITYNUMBER, (Object)fieldNumber, row);
        model.setValue(FIELD_ISFIELD, (Object)Boolean.TRUE, row);
        if (fldProperty instanceof VirEntityTextProp) {
            model.setValue("isvirfield", (Object)Boolean.TRUE, row);
        }
        TemplateEntityFieldUtil.initBdFormatConfig(entityFieldContext, fldProperty, row);
        if (!isImportTpl) {
            return ismustinput;
        }
        if (MapUtils.isEmpty(fieldTips)) {
            return ismustinput;
        }
        OrmLocaleValue fieldImportDesc = (OrmLocaleValue)model.getValue("fieldimportdesc", row);
        if (ObjectUtils.isEmpty((Object)fieldImportDesc) || StringUtils.isBlank((CharSequence)fieldImportDesc.toString())) {
            String defaultComment = MethodUtil.getDefaultComment(fldProperty, fieldApMap, false);
            String tips = fieldTips.get(fieldNumber);
            if (StringUtils.isNotBlank((CharSequence)defaultComment)) {
                if (StringUtils.isNotBlank((CharSequence)tips)) {
                    TemplateUtil.setImportDesc(model, defaultComment.concat("\n").concat(tips), row);
                } else {
                    TemplateUtil.setImportDesc(model, defaultComment, row);
                }
            } else if (StringUtils.isNotBlank((CharSequence)tips)) {
                String[] split = tips.split("\\\\n");
                if (split.length > 1) {
                    ArrayList arrayList = new ArrayList(split.length);
                    Collections.addAll(arrayList, split);
                    tips = String.join((CharSequence)"\n", arrayList);
                }
                TemplateUtil.setImportDesc(model, tips, row);
            }
        }
        return ismustinput;
    }

    private void buildVirFldTreeNode(EntityFieldContext entityFieldContext, DynamicObject field, int row) {
        String entityNumber = entityFieldContext.getEntityNumber();
        IDataModel model = entityFieldContext.getModel();
        IFormView view = entityFieldContext.getView();
        String treeEntryEntity = entityFieldContext.getTreeEntryEntity();
        model.setValue(FIELD_ENTITYFID, (Object)entityNumber, row);
        model.setValue(FIELD_ENTITYNUMBER, (Object)field.getString(FIELD_ENTITYNUMBER), row);
        model.setValue(FIELD_NAME, (Object)field.getString(FIELD_NAME), row);
        TemplateUtil.setIsMustInputFalse(model, row);
        TemplateUtil.setIsImportFalse(model, row);
        model.setValue("ischecked", (Object)Boolean.FALSE, row);
        model.setValue("issheet", (Object)"", row);
        model.setValue("sheetbdfields", (Object)"", row);
        model.setValue(FIELD_ISFIELD, (Object)Boolean.TRUE, row);
        model.setValue("isvirfield", (Object)Boolean.TRUE, row);
        view.setEnable(Boolean.FALSE, row, new String[]{FIELD_ISMUSTINPUT});
        view.setEnable(Boolean.FALSE, row, new String[]{"issheet", "sheetbdfieldnames"});
        view.setEnable(Boolean.FALSE, row, new String[]{"displayname", "defvalname", "fieldimportdesc"});
        view.setEnable(Boolean.FALSE, row, new String[]{"imptattr", "exptattr"});
    }

    public static boolean isMustInputField(IDataEntityProperty fldProperty) {
        return fldProperty instanceof FieldProp && ((FieldProp)fldProperty).isMustInput() || fldProperty instanceof BasedataProp && ((BasedataProp)fldProperty).isMustInput() || fldProperty instanceof MulBasedataProp && ((MulBasedataProp)fldProperty).isMustInput();
    }

    public static List<EntityItem<?>> filterEntityItems(MainEntityType mainType, boolean isImport) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        boolean isExpt = !isImport;
        return entityItems.stream().filter(item -> item instanceof Field && (isExpt ? ((Field)item).getFeatures().isExportable() : ((Field)item).getFeatures().isImportable())).collect(Collectors.toList());
    }

    private List<ControlAp<?>> getFormMetadata(String formId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List aps = formMetadata.getItems();
        Collections.sort(aps, new Comparator<ControlAp<?>>(){

            @Override
            public int compare(ControlAp<?> o1, ControlAp<?> o2) {
                int compareValue = 0;
                compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        return aps;
    }

    private void fillExistingRowIdAndPid(IDataModel model, IFormView formView, String treeEntryEntity, String nodeName, Map<String, LinkedHashMap<String, Object>> dataMap, int row) {
        if (dataMap != null && !dataMap.isEmpty()) {
            DynamicObject rowObj = model.getEntryRowEntity(treeEntryEntity, row);
            Map rootData = dataMap.get(nodeName);
            if (rootData != null) {
                rowObj.set(FIELD_ID, rootData.get(FIELD_ID));
                rowObj.set(FIELD_PID, rootData.get(FIELD_PID));
            }
        }
    }

    private void fillPartialFieldsInfo(IFormView view, String number, IDataModel model, String entityName, String entityNumber, int row) {
        model.beginInit();
        model.setValue(FIELD_ENTITYFID, (Object)number, row);
        model.setValue(FIELD_ENTITYNAME, (Object)entityName, row);
        model.setValue(FIELD_ISFIELD, (Object)Boolean.FALSE, row);
        model.setValue(FIELD_ENTITYNUMBER, (Object)entityNumber, row);
        model.setValue("issheet", (Object)"", row);
        view.setEnable(Boolean.FALSE, row, new String[]{"entitydescription", "displayname", "defvalname", "defvalprop", "fieldimportdesc", "imptattr", "exptattr", "issheet", "sheetbdfieldnames"});
        view.setEnable(Boolean.FALSE, row, new String[]{"operationcolumnap"});
        model.beginInit();
    }

    private static boolean isUniqueval(String mainentityuniqueval, String entityNumber) {
        String[] split;
        List<String> uniquevalList;
        boolean isEnableEdit = false;
        if (StringUtils.isNotBlank((CharSequence)mainentityuniqueval) && (uniquevalList = Arrays.asList(split = mainentityuniqueval.split(","))).contains(entityNumber)) {
            isEnableEdit = true;
        }
        return isEnableEdit;
    }

    private void restoreExistedRowInfo(MainEntityType mainType, Map<String, LinkedHashMap<String, Object>> dataMap, DynamicProperty prop, String entityNumber, DynamicObject rowObj, EntityType entityType) {
        Map fieldRow;
        String mainEntityName = mainType.getName();
        String fullPropNumber = mainEntityName + "." + entityNumber;
        String curPropNumber = "";
        curPropNumber = prop.getParent() == null ? entityType.getName() + "." + entityNumber : prop.getParent().getName() + "." + entityNumber;
        boolean isAcross = false;
        if (this.acrossPropMap.containsKey(mainEntityName) && this.acrossPropMap.get(mainEntityName).containsKey(curPropNumber)) {
            fullPropNumber = curPropNumber;
            isAcross = true;
        }
        if ((fieldRow = (Map)dataMap.get(fullPropNumber)) != null && !isAcross) {
            rowObj.set(FIELD_ID, fieldRow.get(FIELD_ID));
            rowObj.set(FIELD_PID, fieldRow.get(FIELD_PID));
        }
    }

    public boolean isPropertyImport(List<EntityItem<?>> imptSupportFields, IDataEntityProperty prop) {
        if (prop instanceof AttachmentProp || prop instanceof AttachmentCountProp || FIELD_ID.equalsIgnoreCase(prop.getName()) || FIELD_SEQ.equalsIgnoreCase(prop.getName())) {
            return false;
        }
        String controlKey = null;
        if (prop instanceof FlexProp) {
            controlKey = ((FlexProp)prop).getBasePropertyKey();
        } else if (prop instanceof ItemClassProp) {
            controlKey = ((ItemClassProp)prop).getTypePropName();
        }
        boolean existControlField = false;
        boolean existProp = false;
        for (EntityItem<?> item : imptSupportFields) {
            DateRangeField field;
            if (item instanceof DateRangeField) {
                field = (DateRangeField)item;
                if (field.getStartDateFieldKey().equals(prop.getName()) || field.getEndDateFieldKey().equals(prop.getName())) {
                    this.dataRangeMap.put(prop.getParent().getName() + "." + prop.getName(), field.getKey());
                    existProp = true;
                    break;
                }
            } else if (item instanceof TimeRangeField && ((field = (TimeRangeField)item).getStartDateFieldKey().equals(prop.getName()) || field.getEndDateFieldKey().equals(prop.getName()))) {
                this.dataRangeMap.put(prop.getParent().getName() + "." + prop.getName(), field.getKey());
                existProp = true;
                break;
            }
            if (controlKey != null && controlKey.equals(item.getKey())) {
                existControlField = true;
            }
            if (!prop.getName().equals(item.getKey())) continue;
            existProp = true;
            if (controlKey != null && !existControlField) continue;
            break;
        }
        return existProp && (controlKey == null || existControlField);
    }

    private void getSortProperties(IFormView formView, List<IDataEntityProperty> properties, List<ControlAp<?>> aps, Set<String> currSort, EntityType entityType, boolean isNeedPrimaryKey) {
        int j = 0;
        block0: for (ControlAp<?> ap : aps) {
            if (!(ap instanceof FieldAp)) continue;
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty prop = properties.get(i);
                if (ap.getKey().equals(prop.getName())) {
                    Collections.swap(properties, i, j++);
                    continue block0;
                }
                IDataEntityType rootEntityType = prop.getParent();
                if (rootEntityType == null) continue;
                while (rootEntityType.getParent() != null) {
                    rootEntityType = rootEntityType.getParent();
                }
                String propFullName = rootEntityType.getName() + "." + prop.getName();
                if (!this.dataRangeMap.containsKey(propFullName) || !this.dataRangeMap.get(propFullName).equals(ap.getKey())) continue;
                Collections.swap(properties, i, j++);
            }
        }
        ArrayList<Object> mustInputProps = new ArrayList<Object>();
        ArrayList<IDataEntityProperty> notMustInputProps = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty propertie : properties) {
            if (propertie instanceof FieldProp && ((FieldProp)propertie).isMustInput()) {
                mustInputProps.add(propertie);
                continue;
            }
            notMustInputProps.add(propertie);
        }
        mustInputProps.addAll(notMustInputProps);
        properties.clear();
        properties.addAll(mustInputProps);
        if (currSort != null) {
            this.sortPropertiesByDataMap(formView, properties, currSort, entityType);
            this.getNewPropMap(formView, properties, currSort, entityType);
        }
        if (isNeedPrimaryKey) {
            String templateType = formView.getPageCache().get("tmpltype");
            if (entityType != null && !"EXPT".equalsIgnoreCase(templateType)) {
                if (entityType instanceof TreeEntryType) {
                    properties.add(0, (IDataEntityProperty)entityType.getProperty(FIELD_PID));
                }
                properties.add(0, (IDataEntityProperty)entityType.getPrimaryKey());
            }
        }
    }

    private void sortPropertiesByDataMap(IFormView formView, List<IDataEntityProperty> properties, Set<String> currSort, EntityType entityType) {
        String rootEntityNumber = formView.getPageCache().get("rootEntityNumber");
        int j = 0;
        ArrayList<String> currSortList = new ArrayList<String>(currSort);
        if (currSortList.size() > 0) {
            String pkFullName = entityType.getName() + "." + entityType.getPrimaryKey().getName();
            if (!(entityType instanceof MainEntityType)) {
                pkFullName = rootEntityNumber + "." + pkFullName;
            }
            if (!currSortList.contains(pkFullName)) {
                currSortList.add(1, pkFullName);
            }
            if (entityType instanceof MainEntityType) {
                this.handleAcrossedProperties(properties, rootEntityNumber);
            }
            block0: for (String key : currSortList) {
                for (int i = 0; i < properties.size(); ++i) {
                    IDataEntityProperty prop = properties.get(i);
                    String propFullName = prop.getName().equals(entityType.getPrimaryKey().getName()) ? pkFullName : rootEntityNumber + "." + prop.getName();
                    String newProp = "";
                    newProp = prop.getParent() == null ? entityType.getName() + "." + prop.getName() : prop.getParent().getName() + "." + prop.getName();
                    if (this.acrossPropMap.containsKey(rootEntityNumber) && this.acrossPropMap.get(rootEntityNumber).containsKey(newProp)) {
                        propFullName = newProp;
                    }
                    if (key.equals(propFullName)) {
                        Collections.swap(properties, i, j++);
                        continue block0;
                    }
                    if (!this.dataRangeMap.containsKey(propFullName) || !this.dataRangeMap.get(propFullName).equals(key)) continue;
                    Collections.swap(properties, i, j++);
                }
            }
        }
    }

    private void handleAcrossedProperties(List<IDataEntityProperty> properties, String rootEntityNumber) {
        for (Map.Entry<String, Map<String, IDataEntityProperty>> entry : this.acrossPropMap.entrySet()) {
            String entityNumber = entry.getKey();
            if (!StringUtils.equals((CharSequence)rootEntityNumber, (CharSequence)entityNumber)) {
                for (IDataEntityProperty property : entry.getValue().values()) {
                    properties.remove(property);
                }
                continue;
            }
            if (!this.acrossPropMap.containsKey(rootEntityNumber)) continue;
            for (IDataEntityProperty property : this.acrossPropMap.get(rootEntityNumber).values()) {
                if (property == null) continue;
                properties.add(property);
            }
        }
    }

    private void getNewPropMap(IFormView formView, List<IDataEntityProperty> properties, Set<String> currSort, EntityType entityType) {
        ArrayList<String> currSortList = new ArrayList<String>(currSort);
        if (currSortList.size() > 0) {
            boolean isNewPropMap = false;
            for (String key : currSortList) {
                for (int i = 0; i < properties.size(); ++i) {
                    IDataEntityProperty prop = properties.get(i);
                    String propFullName = this.setPropFullName(formView, entityType, prop);
                    if (isNewPropMap || this.newPropMap.containsKey(propFullName)) continue;
                    this.newPropMap.put(propFullName, prop);
                }
                isNewPropMap = true;
                if (!this.newPropMap.containsKey(key)) continue;
                this.newPropMap.remove(key);
            }
        }
    }

    private String setPropFullName(IFormView formView, EntityType entityType, IDataEntityProperty prop) {
        String rootEntityNumber = formView.getPageCache().get("rootEntityNumber");
        String pkFullName = entityType.getName() + "." + entityType.getPrimaryKey().getName();
        if (!(entityType instanceof MainEntityType)) {
            pkFullName = rootEntityNumber + "." + pkFullName;
        }
        String propFullName = prop.getName().equals(entityType.getPrimaryKey().getName()) ? pkFullName : rootEntityNumber + "." + prop.getName();
        return propFullName;
    }

    public static TreeNode buildBillTreeNodes(IFormView view, QueryEntityTreeBuildParameter parameter, boolean isShowId, String val, boolean isImport, List<String> filter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName() + val, mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = TemplateEntityFieldUtil.buildFldTreeNodes(view, parameter, isShowId, isImport, filter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        TreeNode entityNode = new TreeNode(mainType.getName(), mainType.getName() + "billhead", ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)HiesCommonRes.TemplateEntityFieldUtil_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        entityNode.setIsOpened(false);
        if (isShowId) {
            TreeNode idNode = new TreeNode(mainType.getName(), mainType.getName() + ".id", FIELD_ID);
            entityNode.addChild(idNode);
        }
        List<TreeNode> entryNodes = TemplateEntityFieldUtil.buildEntryFldRefPropNodes(view, mainType, null, null, billNode, mainType.getName(), parameter.isDynamicText(), isShowId, filter);
        List<TreeNode> refNodes = TemplateEntityFieldUtil.buildBDFldRefPropNodes(view, mainType, null, null, billNode, mainType.getName(), parameter.isDynamicText(), isShowId, isImport, filter);
        entityNode.addChildren(refNodes);
        billNode.addChild(entityNode);
        billNode.addChildren(entryNodes);
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldTreeNodes(IFormView view, QueryEntityTreeBuildParameter parameter, boolean isShowId, boolean isImport, List<String> filter) {
        List queryChildEntityList;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
        if (parameter.getQueryEntityList() != null && (queryChildEntityList = ((QueryEntityTreeNode)parameter.getQueryEntityList().get(0)).getChildList()) != null) {
            for (QueryEntityTreeNode queryEntityTreeNode : queryChildEntityList) {
                MainEntityType queryentityType = EntityMetadataCache.getDataEntityType((String)queryEntityTreeNode.getEntityNumber());
                TreeNode queryentityNode = new TreeNode(((QueryEntityTreeNode)parameter.getQueryEntityList().get(0)).getEntityAlias(), queryEntityTreeNode.getEntityAlias(), queryentityType.getDisplayName().toString());
                entityFldNodes.add(queryentityNode);
                TreeNode entityNode = new TreeNode(queryEntityTreeNode.getEntityAlias(), queryEntityTreeNode.getEntityAlias() + "billhead", ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)HiesCommonRes.TemplateEntityFieldUtil_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                entityNode.setIsOpened(false);
                List<TreeNode> entryNodes = TemplateEntityFieldUtil.buildEntryFldRefPropNodes(view, queryentityType, null, null, queryentityNode, queryEntityTreeNode.getEntityAlias(), parameter.isDynamicText(), isShowId, filter);
                List<TreeNode> refNodes = TemplateEntityFieldUtil.buildBDFldRefPropNodes(view, queryentityType, null, null, queryentityNode, queryEntityTreeNode.getEntityAlias(), parameter.isDynamicText(), isShowId, isImport, filter);
                if (isShowId) {
                    TreeNode idNode = new TreeNode(queryentityType.getName(), queryentityType.getName() + ".id", FIELD_ID);
                    entityFldNodes.add(idNode);
                }
                if (refNodes.size() > 0) {
                    entityFldNodes.addAll(refNodes);
                }
                if (entryNodes.size() <= 0) continue;
                entityFldNodes.addAll(entryNodes);
            }
        }
        nodes.addAll(entityFldNodes);
        if (parameter.getQueryEntityList() != null && parameter.getQueryEntityList().size() > 1) {
            parameter.getQueryEntityList().remove(0);
            List<TreeNode> nextNodes = TemplateEntityFieldUtil.buildFldTreeNodes(view, parameter, isShowId, isImport, filter);
            nodes.addAll(nextNodes);
        }
        return nodes;
    }

    private static List<TreeNode> buildEntryFldRefPropNodes(IFormView view, MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText, boolean isShowId, List<String> filter) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bdType.getName());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        TemplateEntityFieldUtil templateEntityFieldUtil = TemplateEntityFieldUtil.newInstance();
        for (IDataEntityProperty property : properties) {
            EntryProp entryProp;
            if (!CollectionUtils.isNotEmpty(filter) || !(property instanceof EntryProp) || !Objects.equals((entryProp = (EntryProp)property).getParent().getName(), dataEntityType.getName())) continue;
            IDataEntityType entryEntitytype = entryProp.getItemType();
            List<EntityItem<?>> newItems = TemplateEntityFieldUtil.filterEntityItems(bdType, Boolean.TRUE);
            DataEntityPropertyCollection entryProperties = entryEntitytype.getProperties();
            List<IDataEntityProperty> validProperties = TemplateEntityFieldUtil.getValidProperties(newItems, (List<IDataEntityProperty>)entryProperties, filter);
            List<ControlAp<?>> aps = TemplateEntityFieldUtil.newInstance().getFormMetadata(bdType.getName());
            TemplateEntityFieldUtil.newInstance().getSortProperties(view, validProperties, aps, null, (EntityType)bdType, false);
            if (CollectionUtils.isEmpty(validProperties)) {
                return refNodes;
            }
            TreeNode entityNode = new TreeNode(bdFldNode.getId(), prefix + "." + property.getName(), property.getDisplayName().toString());
            entityNode.setIsOpened(false);
            String prefixEntrty = prefix + "." + property.getName();
            for (IDataEntityProperty entryProperty : validProperties) {
                String entryPropertyName = entryProperty.getName();
                if (FIELD_ID.equals(entryPropertyName) || FIELD_SEQ.equals(entryPropertyName) || entryPropertyName.endsWith("_id") && entryProperty instanceof LongProp || !(entryProperty instanceof IFieldHandle) || ((IFieldHandle)entryProperty).isSysField() || property instanceof CreateDateProp || property instanceof ModifyDateProp || property instanceof CreaterProp || property instanceof ModifierProp || !templateEntityFieldUtil.isPropertyImport(newItems, entryProperty)) continue;
                String name = entryProperty.getName();
                if (CollectionUtils.isNotEmpty(filter) && filter.contains(name) || entryProperty instanceof EntryProp) continue;
                TreeNode fldNode = TemplateEntityFieldUtil.buildFldTreeNode(entryProperty, matchedProperty, matchedClassType, entityNode, prefixEntrty, isDynamicText);
                if (entryProperty instanceof BasedataProp) {
                    if (fldNode == null) {
                        fldNode = TemplateEntityFieldUtil.buildFldTreeNode(entryProperty, null, null, entityNode, prefixEntrty, isDynamicText);
                    }
                    BasedataProp bdProp2 = (BasedataProp)entryProperty;
                    MainEntityType bdType2 = (MainEntityType)bdProp2.getComplexType();
                    String prefix2 = prefixEntrty + "." + entryProperty.getName();
                    entityNode.addChild(fldNode);
                    continue;
                }
                if (fldNode == null) continue;
                entityNode.addChild(fldNode);
            }
            refNodes.add(entityNode);
        }
        return refNodes;
    }

    private static List<IDataEntityProperty> getValidProperties(List<EntityItem<?>> newItems, List<IDataEntityProperty> entryProperties, List<String> filter) {
        TemplateEntityFieldUtil templateEntityFieldUtil = TemplateEntityFieldUtil.newInstance();
        ArrayList properties = Lists.newArrayListWithExpectedSize((int)entryProperties.size());
        for (IDataEntityProperty entryProperty : entryProperties) {
            String entryPropertyName = entryProperty.getName();
            if (FIELD_ID.equals(entryPropertyName) || FIELD_SEQ.equals(entryPropertyName) || entryPropertyName.endsWith("_id") && entryProperty instanceof LongProp || !(entryProperty instanceof IFieldHandle) || ((IFieldHandle)entryProperty).isSysField() || !templateEntityFieldUtil.isPropertyImport(newItems, entryProperty) || entryProperty instanceof CreateDateProp || entryProperty instanceof ModifyDateProp || entryProperty instanceof CreaterProp || entryProperty instanceof ModifierProp) continue;
            String name = entryProperty.getName();
            if (CollectionUtils.isNotEmpty(filter) && filter.contains(name)) continue;
            properties.add(entryProperty);
        }
        return properties;
    }

    private static Boolean isIncludeField(IDataEntityProperty entryProperty) {
        return entryProperty instanceof TextProp || entryProperty instanceof BasedataProp || entryProperty instanceof MuliLangTextProp;
    }

    private static List<TreeNode> buildBDFldRefPropNodes(IFormView view, MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText, boolean isShowId, boolean isImport, List<String> filter) {
        List<EntityItem<?>> entityItems = TemplateEntityFieldUtil.filterEntityItems(bdType, isImport);
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        ArrayList properties = Lists.newArrayList(bdType.getFields().values());
        List<ControlAp<?>> aps = TemplateEntityFieldUtil.newInstance().getFormMetadata(bdType.getName());
        TemplateEntityFieldUtil templateEntityFieldUtil = TemplateEntityFieldUtil.newInstance();
        templateEntityFieldUtil.getSortProperties(view, properties, aps, null, (EntityType)bdType, false);
        List<EntityItem<?>> newItems = TemplateEntityFieldUtil.filterEntityItems(bdType, isImport);
        for (IDataEntityProperty property : properties) {
            String propertyName;
            if (!CollectionUtils.isEmpty(filter) ? FIELD_ID.equals(propertyName = property.getName()) || FIELD_SEQ.equals(propertyName) || propertyName.endsWith("_id") && property instanceof LongProp || !(property instanceof IFieldHandle) || ((IFieldHandle)property).isSysField() || property instanceof CreateDateProp || property instanceof ModifyDateProp || property instanceof CreaterProp || property instanceof ModifierProp : !(property instanceof IFieldHandle) || ((IFieldHandle)property).isSysField() || StringUtils.isBlank((CharSequence)property.getAlias()) || TemplateEntityFieldUtil.isIncludeField(property) == false) continue;
            if (!templateEntityFieldUtil.isPropertyImport(newItems, property)) continue;
            String name = property.getName();
            if (CollectionUtils.isNotEmpty(filter) && filter.contains(name)) continue;
            boolean existProp = false;
            if (CollectionUtils.isEmpty(filter)) {
                for (EntityItem<?> entityItem : entityItems) {
                    if (!property.getName().equals(entityItem.getKey())) continue;
                    existProp = true;
                }
                if (!existProp) continue;
            }
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = TemplateEntityFieldUtil.buildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            if (property instanceof BasedataProp) {
                List<TreeNode> refNodes2;
                if (fldNode == null) {
                    fldNode = TemplateEntityFieldUtil.buildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
                }
                BasedataProp bdProp2 = (BasedataProp)property;
                MainEntityType bdType2 = (MainEntityType)bdProp2.getComplexType();
                String prefix2 = prefix + "." + property.getName();
                if (bdType2 == null) continue;
                if (CollectionUtils.isEmpty(filter) && (refNodes2 = TemplateEntityFieldUtil.buildBDFldRefPropNodes(view, bdType2, matchedProperty, matchedClassType, fldNode, prefix2, isDynamicText, isShowId, isImport, filter)).size() > 0) {
                    fldNode.addChildren(refNodes2);
                }
                refNodes.add(fldNode);
                continue;
            }
            if (fldNode == null) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = TemplateEntityFieldUtil.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp) {
                if (!((BasedataProp)matchedProperty).isFromSampleMaster(fldProperty)) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        return isMatch;
    }

    public static Map<String, Map<String, Object>> getImportF7BdFormatConfig(String entityName) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            ((EntityType)entry.getValue()).getFields().values().forEach(fldProperty -> {
                Map<String, Object> imptFormatConfig = TemplateEntityFieldUtil.getImptInitF7BdFormatConfig(fldProperty);
                if (imptFormatConfig != null) {
                    ret.put(fldProperty.getName(), imptFormatConfig);
                }
            });
        }
        return ret;
    }

    public static Map<String, Map<String, Object>> getExportF7BdFormatConfig(String entityName) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            ((EntityType)entry.getValue()).getFields().values().forEach(fldProperty -> {
                Map<String, Object> imptFormatConfig = TemplateEntityFieldUtil.getExptInitF7BdFormatConfig(fldProperty);
                if (imptFormatConfig != null) {
                    ret.put(fldProperty.getName(), imptFormatConfig);
                }
            });
        }
        return ret;
    }

    public static Map<String, Object> getImptInitF7BdFormatConfig(IDataEntityProperty field) {
        return TemplateEntityFieldUtil.getInitF7BdFormatConfig(field, TemplateTypeEnum.IMPT.getCode());
    }

    public static Map<String, Object> getExptInitF7BdFormatConfig(IDataEntityProperty field) {
        return TemplateEntityFieldUtil.getInitF7BdFormatConfig(field, TemplateTypeEnum.EXPT.getCode());
    }

    public static Map<String, Object> getInitF7BdFormatConfig(IDataEntityProperty field, String type) {
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)3);
        Map<String, Object> bdMainProp = null;
        if (!(field instanceof IBasedataField)) {
            return null;
        }
        BasedataEntityType bdtype = (BasedataEntityType)((IBasedataField)field).getComplexType();
        bdMainProp = MethodUtil.getBdMainProp(bdtype.getName());
        String retNumber = (String)bdMainProp.get("number");
        String retName = (String)bdMainProp.get("name");
        if (TemplateTypeEnum.IMPT.getCode().equalsIgnoreCase(type)) {
            retMap.put("canEdit", Boolean.FALSE);
            if (StringUtils.isNotEmpty((CharSequence)retNumber)) {
                retMap.put("val", "number");
            } else if (StringUtils.isNotEmpty((CharSequence)retName)) {
                retMap.put("val", "name");
            } else {
                retMap.put("val", FIELD_ID);
            }
            if (StringUtils.isNotEmpty((CharSequence)retNumber) && StringUtils.isNotEmpty((CharSequence)retName) && !retNumber.equalsIgnoreCase(retName)) {
                retMap.put("canEdit", Boolean.TRUE);
            }
        } else if (TemplateTypeEnum.EXPT.getCode().equalsIgnoreCase(type)) {
            String val = "";
            if (StringUtils.isNotEmpty((CharSequence)retNumber)) {
                val = retNumber;
            }
            if (StringUtils.isNotEmpty((CharSequence)retName)) {
                val = val + "," + retName;
            }
            if (StringUtils.isEmpty((CharSequence)retNumber) && StringUtils.isEmpty((CharSequence)retName)) {
                val = FIELD_ID;
            }
            if (retNumber.equalsIgnoreCase(retName) && StringUtils.isNotEmpty((CharSequence)retNumber)) {
                val = retNumber;
            }
            retMap.put("val", val);
        }
        return retMap;
    }

    private static void initBdFormatConfig(EntityFieldContext entityFieldContext, IDataEntityProperty fldProperty, int row) {
        if (!(fldProperty instanceof IBasedataField)) {
            return;
        }
        IDataModel model = entityFieldContext.getModel();
        IFormView view = entityFieldContext.getView();
        boolean isParentModel = entityFieldContext.getView().getEntityId().equalsIgnoreCase("hies_diaetplconf");
        if (isParentModel) {
            TemplateExportAttrUtil.cacheRefProps(entityFieldContext.getModel(), entityFieldContext.getEntityNumber(), fldProperty, entityFieldContext.getView());
        }
        view.setEnable(Boolean.FALSE, row, new String[]{"imptattr", "exptattr"});
        if (entityFieldContext.isImportFlag()) {
            if (StringUtils.isNotBlank((Object)model.getValue("imptattr", row))) {
                return;
            }
            Map<String, Object> imptFormatConfig = TemplateEntityFieldUtil.getImptInitF7BdFormatConfig(fldProperty);
            if (imptFormatConfig != null) {
                model.setValue("imptattr", imptFormatConfig.get("val"), row);
            }
        } else {
            if (StringUtils.isNotBlank((Object)model.getValue("exptattr", row))) {
                return;
            }
            Map<String, Object> exptFormatConfig = TemplateEntityFieldUtil.getExptInitF7BdFormatConfig(fldProperty);
            if (exptFormatConfig != null) {
                String val = (String)exptFormatConfig.get("val");
                if (isParentModel) {
                    model.setValue("exptattr", (Object)val, row);
                } else {
                    List<String> lists = Arrays.asList(StringUtils.split((String)val, (String)","));
                    String displayName = TemplateExportAttrUtil.getExportPropsDisplayName(entityFieldContext.getEntityNumber(), view, lists, row);
                    model.setValue("exptattrtemp", (Object)val, row);
                    model.setValue("exptattr", (Object)displayName, row);
                }
            }
        }
    }

    private static void buildEntryFieldTreeNode(List<IDataEntityProperty> properties, TreeNode entityNode, String searchText) {
        ArrayList childrenNode = Lists.newArrayListWithExpectedSize((int)properties.size());
        for (IDataEntityProperty property : properties) {
            TreeNode treeNode;
            DynamicProperty prop = (DynamicProperty)property;
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            String fldNodeId = entityNode.getId() + "." + property.getName();
            boolean mustInputField = TemplateEntityFieldUtil.isMustInputField(property);
            if (StringUtils.isBlank((CharSequence)searchText)) {
                treeNode = new TreeNode(entityNode.getId(), fldNodeId, fldNodeName + "(" + fldNodeId + ")");
                treeNode.setIsOpened(true);
                childrenNode.add(treeNode);
                continue;
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)fldNodeName, (CharSequence)searchText)) continue;
            treeNode = new TreeNode(entityNode.getId(), fldNodeId, fldNodeName + "(" + fldNodeId + ")");
            treeNode.setIsOpened(true);
            childrenNode.add(treeNode);
        }
        entityNode.addChildren((List)childrenNode);
    }

    public static TreeNode buildRootNode() {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8", (String)HiesCommonRes.TemplateEntityFieldUtil_10.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "1010", rootName, true);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    public static boolean isShowVirEntity(IFormView view) {
        IDataModel model = view.getModel();
        boolean isEntityTypeSE = "SE".equals(model.getValue("entitytype"));
        DynamicObject mainDyObj = (DynamicObject)model.getValue("entity");
        String mainEntityNumber = mainDyObj.getString("number");
        DynamicObject mainQueryDyObj = (DynamicObject)model.getValue("queryentity");
        if (ObjectUtils.isEmpty((Object)mainQueryDyObj)) {
            return isEntityTypeSE;
        }
        boolean isNormalEntity = mainEntityNumber.equals(mainQueryDyObj.getString("number"));
        return isEntityTypeSE && isNormalEntity;
    }
}

