/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.hr.hies.common.util.HIESUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TemplateUtil {
    public static void setIsImportTrue(IDataModel model, int row) {
        model.setValue("isimport", (Object)Boolean.TRUE, row);
    }

    public static void setIsImportFalse(IDataModel model, int row) {
        model.setValue("isimport", (Object)Boolean.FALSE, row);
    }

    public static void setIsImport(IDataModel model, Boolean isImport, int row) {
        if (isImport.booleanValue()) {
            TemplateUtil.setIsImportTrue(model, row);
        } else {
            TemplateUtil.setIsImportFalse(model, row);
        }
    }

    public static void setIsMustInputTrue(IDataModel model, int row) {
        model.setValue("ismustinput", (Object)Boolean.TRUE, row);
        TemplateUtil.setIsImportTrue(model, row);
    }

    public static void setIsMustInputFalse(IDataModel model, int row) {
        model.setValue("ismustinput", (Object)Boolean.FALSE, row);
    }

    public static void setIsMustInput(IDataModel model, Boolean isImport, int row) {
        if (isImport.booleanValue()) {
            TemplateUtil.setIsMustInputTrue(model, row);
        } else {
            TemplateUtil.setIsMustInputFalse(model, row);
        }
    }

    public static void setImportDesc(IDataModel model, Object val, int row) {
        Object importDescRealVal = TemplateUtil.getImportDescRealVal(val);
        if (importDescRealVal instanceof ILocaleString) {
            ILocaleString value = (ILocaleString)importDescRealVal;
            String sysLineSeparator = HIESUtil.getSysLineSeparator();
            value.forEach((key, val2) -> {
                val2 = val2.replace("\\r\\n", sysLineSeparator);
                value.setItem(key, val2);
            });
        }
        model.setValue("fieldimportdesc", importDescRealVal, row);
    }

    public static Object getImportDescRealVal(Object val) {
        if (ObjectUtils.isEmpty((Object)val)) {
            return val;
        }
        if (val instanceof JSONObject) {
            LocaleString localeString = (LocaleString)JSONObject.parseObject((String)val.toString(), LocaleString.class);
            return localeString;
        }
        return val;
    }

    public static Integer computeRealRowNum(IDataModel model, DynamicObject curDyn) {
        LinkedHashMap<String, Integer> entryMaxRows = TemplateUtil.getEntryMaxRows(model);
        return entryMaxRows.get(curDyn.getString("pid"));
    }

    public static LinkedHashMap<String, Integer> getEntryMaxRows(IDataModel model) {
        DynamicObjectCollection entryEntityDyns = model.getEntryEntity("treeentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntityDyns)) {
            return new LinkedHashMap<String, Integer>(0);
        }
        DynamicObject firstRowEntity = model.getEntryRowEntity("treeentryentity", 0);
        String firstRowField = firstRowEntity.getString("id");
        LinkedHashMap entityMapDyns = entryEntityDyns.stream().collect(Collectors.groupingBy(item -> item.getString("pid"), LinkedHashMap::new, Collectors.toList()));
        int entryMaxNum = 1;
        LinkedHashMap<String, Integer> entityMapMaxRows = new LinkedHashMap<String, Integer>(entityMapDyns.size());
        for (Map.Entry entry : entityMapDyns.entrySet()) {
            String key = (String)entry.getKey();
            if ("0".equals(key) || firstRowField.equals(key)) continue;
            int size = ((List)entry.getValue()).size() + 1;
            entityMapMaxRows.put(key, entryMaxNum += size);
        }
        return entityMapMaxRows;
    }
}

