/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TextCompressUtil {
    private static final Log LOGGER = LogFactory.getLog(TextCompressUtil.class);
    private static final String ENCODE = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes(ENCODE));
        }
        catch (Exception e) {
            LOGGER.error("GZipUtils.compress error", (Throwable)e);
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (Exception e) {
                    LOGGER.error("GZipUtils.compress gzip close error", (Throwable)e);
                }
            }
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(byte[] source) {
        if (source == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gZipIns = null;
        String decompressedStr = null;
        try {
            int offset;
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(source);
            gZipIns = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            while ((offset = gZipIns.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressedStr = new String(out.toByteArray(), ENCODE);
        }
        catch (Exception e) {
            LOGGER.error("GZipUtils.decompress error", (Throwable)e);
        }
        finally {
            if (gZipIns != null) {
                try {
                    gZipIns.close();
                }
                catch (Exception e) {
                    LOGGER.error("GZipUtils.decompress gZipIns close error", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    LOGGER.error("GZipUtils.decompress in close error", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    LOGGER.error("GZipUtils.decompress out close error", (Throwable)e);
                }
            }
        }
        return decompressedStr;
    }
}

