/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.HiesCommonRes;
import kd.hr.hies.common.util.MethodUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

@ExcludeFromJacocoGeneratedReport
public class BaseDataFieldListPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    public static final String KEY_TREEVIEW = "tv_fields";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String baseDataKey = (String)formShowParameter.getCustomParam("baseDataKey");
        if (StringUtils.isNotBlank((CharSequence)baseDataKey)) {
            String selectFieldValues = (String)formShowParameter.getCustomParam("sheetbdfields");
            this.fillTreeNodes(baseDataKey, selectFieldValues);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        this.cacheSelectFields(treeView);
    }

    private void cacheSelectFields(TreeView treeView) {
        HashMap<String, String> selectFields = new HashMap<String, String>(2);
        selectFields.put("selectfieldvalue", this.getCheckedNodeIds(treeView));
        selectFields.put("selectfieldname", this.getCheckedNodeTexts(treeView));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String baseDataKey = (String)formShowParameter.getCustomParam("baseDataKey");
        this.getView().getParentView().getPageCache().put(baseDataKey, JSON.toJSONString(selectFields));
    }

    private String getCheckedNodeTexts(TreeView treeView) {
        return Joiner.on((String)"\uff1b").join((Iterable)treeView.getTreeState().getCheckedNodes().stream().map(temp -> temp.get("text")).collect(Collectors.toList()));
    }

    private String getCheckedNodeIds(TreeView treeView) {
        return String.join((CharSequence)",", treeView.getTreeState().getCheckedNodeIds());
    }

    private void fillTreeNodes(String baseDataKey, String selectFieldValues) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        Map<String, String> sortF7fields = MethodUtil.getSortF7fields(baseDataKey);
        if (MapUtils.isNotEmpty(sortF7fields)) {
            List<Object> selectFields = new ArrayList(0);
            if (StringUtils.isNotBlank((CharSequence)selectFieldValues)) {
                selectFields = Arrays.stream(selectFieldValues.split(",")).collect(Collectors.toList());
            }
            if (sortF7fields.size() == 2 && ObjectUtils.isNotEmpty((Object)sortF7fields.get("person.number")) && ObjectUtils.isNotEmpty((Object)sortF7fields.get("person.name"))) {
                for (Map.Entry<String, String> entry : sortF7fields.entrySet()) {
                    String fieldId = entry.getKey();
                    TreeNode rootNode = new TreeNode("", fieldId, entry.getValue());
                    rootNode.setDisabled(true);
                    treeView.addNode(rootNode);
                    treeView.checkNode(rootNode);
                    treeView.treeNodeCheck(rootNode.getParentid(), rootNode.getId(), Boolean.valueOf(true));
                    treeView.updateNode(rootNode);
                }
            } else {
                for (Map.Entry<String, String> entry : sortF7fields.entrySet()) {
                    String fieldId = entry.getKey();
                    TreeNode rootNode = new TreeNode("", fieldId, entry.getValue());
                    if ("number".equals(fieldId) || "name".equals(fieldId)) {
                        rootNode.setDisabled(true);
                        treeView.addNode(rootNode);
                        treeView.checkNode(rootNode);
                        treeView.treeNodeCheck(rootNode.getParentid(), rootNode.getId(), Boolean.valueOf(true));
                        treeView.updateNode(rootNode);
                        continue;
                    }
                    if (selectFields.contains(fieldId)) {
                        treeView.addNode(rootNode);
                        treeView.checkNode(rootNode);
                        treeView.treeNodeCheck(rootNode.getParentid(), rootNode.getId(), Boolean.valueOf(true));
                        treeView.updateNode(rootNode);
                        continue;
                    }
                    treeView.addNode(rootNode);
                }
            }
            this.cacheSelectFields(treeView);
        }
    }

    private void addDefTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868", (String)HiesCommonRes.BaseDataFieldListPlugin_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addNode(root);
    }
}

