/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.HiesCommonRes;

@ExcludeFromJacocoGeneratedReport
public class GenerateButtonAnalysisReporterPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(GenerateButtonAnalysisReporterPlugin.class);
    private MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
    private Map<String, String> paltOperate = null;
    private Map<String, String> customOp = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, String> apps = null;
    private Map<String, String> clouds = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void click(EventObject evt) {
        Button bt = (Button)evt.getSource();
        String op = bt.getKey();
        String type = (String)this.getModel().getValue("type");
        String txtlikeop = (String)this.getModel().getValue("txtlikeop");
        this.paltOperate = this.initPaltOperate();
        if (StringUtils.isNotEmpty((CharSequence)txtlikeop)) {
            String[] split = StringUtils.split((String)txtlikeop, (String)",");
            Arrays.asList(split).forEach(item -> this.customOp.put((String)item, (String)item));
        }
        this.apps = this.initApp();
        this.clouds = this.initCloud();
        HashMap errorPageMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap allPageMap = Maps.newHashMapWithExpectedSize((int)16);
        if ("buttonap".equals(op)) {
            this.clearEntry("entryentity");
            this.clearEntry("entryentity2");
            DynamicObjectCollection all = this.loadAllPages(type);
            if (all.size() == 0) {
                this.getView().showTipNotification("No data.");
                return;
            }
            LOGGER.info("loadAllPages_count={}", (Object)all.size());
            for (DynamicObject page : all) {
                String pageId = page.getString("id");
                String pageNumber = page.getString("number");
                String bizappid = page.getString("bizappid");
                try {
                    Map<String, String> opTypeMap = this.getPageOpType(pageId);
                    Map<String, String> btnMap = this.getButtonInfo(pageNumber, pageId, opTypeMap, bizappid);
                    allPageMap.put(pageNumber, btnMap);
                }
                catch (Exception e) {
                    LOGGER.info("GenerateButtonAnalysisReporterPlugin_pageNumber={}", (Object)pageNumber);
                    errorPageMap.put(pageNumber, e.getMessage());
                }
            }
            this.writeTable(allPageMap);
            this.writeErrorTable(errorPageMap);
        }
    }

    private DynamicObjectCollection loadAllPages(String type) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_formmeta");
        QFilter qFilter = new QFilter("isv", "=", (Object)"kingdee");
        switch (type) {
            case "meta": {
                String pageIds = (String)this.getModel().getValue("val");
                String[] splitPageIds = StringUtils.split((String)pageIds, (String)",");
                if (splitPageIds.length > 0) {
                    qFilter.and(new QFilter("number", "in", (Object)splitPageIds));
                    break;
                }
                qFilter.and(new QFilter("1", "<>", (Object)1));
                this.showErrorNotification();
                break;
            }
            case "app": {
                String apps = (String)this.getModel().getValue("val");
                String[] splitApps = StringUtils.split((String)apps, (String)",");
                if (splitApps.length > 0) {
                    HRBaseServiceHelper helper1 = new HRBaseServiceHelper("bos_devportal_bizapp");
                    DynamicObjectCollection collection = helper1.queryOriginalCollection("id", new QFilter[]{new QFilter("number", "in", (Object)splitApps)});
                    ArrayList ids = new ArrayList(collection.size());
                    collection.forEach(dy -> ids.add(dy.getString("id")));
                    qFilter.and(new QFilter("bizappid", "in", ids));
                    break;
                }
                qFilter.and(new QFilter("1", "<>", (Object)1));
                this.showErrorNotification();
                break;
            }
            case "all": {
                break;
            }
        }
        return helper.queryOriginalCollection("id,number,modeltype,bizappid", new QFilter[]{qFilter});
    }

    private Map<String, String> getPageOpType(String pageId) {
        FormMetadata metadata;
        HashMap opType = Maps.newHashMapWithExpectedSize((int)16);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)pageId, (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null && (entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)(metadata = (FormMetadata)MetadataDao.readMeta((String)pageId, (MetaCategory)MetaCategory.Form)).getEntityId(), (MetaCategory)MetaCategory.Entity)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)HiesCommonRes.GenerateButtonAnalysisReporterPlugin_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        }
        entityMetadata.getItems().forEach(xx -> {
            if (xx instanceof BaseEntity) {
                BaseEntity bf = (BaseEntity)xx;
                bf.getOperations().forEach(op -> opType.put(op.getKey(), op.getOperationType()));
            } else if (xx instanceof QueryEntity) {
                QueryEntity bf = (QueryEntity)xx;
                bf.getOperations().forEach(op -> opType.put(op.getKey(), op.getOperationType()));
            }
        });
        return opType;
    }

    private Map<String, String> getButtonInfo(String pageNumber, String pageId, Map<String, String> opTypeMap, String bizappid) {
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)pageId, (MetaCategory)MetaCategory.Form);
        HashMap btnMap = Maps.newHashMapWithExpectedSize((int)16);
        metadata.getItems().forEach(xx -> {
            if (xx instanceof BasedataFormAp) {
                BasedataFormAp bf = (BasedataFormAp)xx;
                if (bf.getListMeta() == null) {
                    return;
                }
                bf.getListMeta().getItems().forEach(item -> {
                    if (item instanceof BarItemAp) {
                        this.addkey(pageNumber, (ControlAp)item, opTypeMap, btnMap, bizappid);
                    }
                });
            } else if (xx instanceof BarItemAp) {
                this.addkey(pageNumber, (ControlAp)xx, opTypeMap, btnMap, bizappid);
            } else if (xx instanceof ButtonAp) {
                this.addkey(pageNumber, (ControlAp)xx, opTypeMap, btnMap, bizappid);
            }
        });
        return btnMap;
    }

    private void addkey(String pageNumber, ControlAp item, Map<String, String> opType, Map<String, String> btnMap, String bizappid) {
        ButtonAp biap = (ButtonAp)item;
        String visible0 = item.getVisible();
        Object[] split0 = StringUtils.split((String)visible0, (String)",");
        if (item.isInvisible() || ObjectUtils.isEmpty((Object[])split0)) {
            return;
        }
        String realOpKey = opType.get(biap.getOperationKey());
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)biap.getOperationKey()) && (this.paltOperate.containsKey(realOpKey) || this.isLikeCustomOp(biap.getKey()))) {
            String opkey;
            String plugin = "";
            if ("importdata".equalsIgnoreCase(realOpKey)) {
                plugin = this.getPlugin(pageNumber, biap.getOperationKey());
            }
            if (StringUtils.isEmpty((CharSequence)(opkey = this.paltOperate.get(realOpKey)))) {
                opkey = biap.getKey();
            }
            builder.append(bizappid).append("&").append(opkey).append('(').append(realOpKey).append(')').append("&").append(plugin);
            btnMap.put(biap.getName().getLocaleValue() + '(' + biap.getKey() + ')', builder.toString());
        }
        biap.getDropdownItems().forEach(ddl -> {
            String visible = ddl.getVisible();
            Object[] split = StringUtils.split((String)visible, (String)",");
            if (ObjectUtils.isEmpty((Object[])split)) {
                return;
            }
            String realOpKey2 = (String)opType.get(ddl.getOperationKey());
            StringBuilder builder2 = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)ddl.getOperationKey()) && (this.paltOperate.containsKey(realOpKey2) || this.isLikeCustomOp(ddl.getKey()))) {
                String opkey;
                String plugin = "";
                if ("importdata".equalsIgnoreCase(realOpKey2)) {
                    plugin = this.getPlugin(pageNumber, ddl.getOperationKey());
                }
                if (StringUtils.isEmpty((CharSequence)(opkey = this.paltOperate.get(realOpKey2)))) {
                    opkey = ddl.getKey();
                }
                builder2.append(bizappid).append("&").append(opkey).append('(').append(realOpKey2).append(')').append("&").append(plugin);
                btnMap.put(ddl.getTitle().getLocaleValue() + '(' + ddl.getKey() + ')', builder2.toString());
            }
        });
    }

    private void writeTable(Map<String, Map<String, String>> allPageMap) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        allPageMap.forEach((key, val) -> {
            Map btnMap = val;
            if (btnMap == null) {
                return;
            }
            btnMap.forEach((key2, val2) -> {
                String[] split = StringUtils.split((String)val2, (String)"&");
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("txtcloud", new Object[0]);
                vs.addField("txtapp", new Object[0]);
                vs.addField("txtpage", new Object[0]);
                vs.addField("txtbtn", new Object[0]);
                vs.addField("txtop", new Object[0]);
                vs.addField("ckhasplugin", new Object[0]);
                vs.addField("txtplugin", new Object[0]);
                String appInfo = this.apps.get(split[0]);
                String[] splitApp = StringUtils.split((String)appInfo, (String)",");
                boolean hasPlugin = split.length > 2;
                vs.addRow(new Object[]{this.clouds.get(splitApp[1]), splitApp[0], key, key2, split[1], hasPlugin, hasPlugin ? split[2] : ""});
                model.batchCreateNewEntryRow("entryentity", vs);
            });
        });
    }

    private void writeTableForPage(Map<String, Map<String, String>> allPageMap) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        allPageMap.forEach((key, val) -> {
            Map btnMap = val;
            if (!ObjectUtils.isEmpty((Object)btnMap)) {
                Object val2 = btnMap.values().toArray()[0];
                String[] split = StringUtils.split((String)String.valueOf(val2), (String)"&");
                String appInfo = this.apps.get(split[0]);
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("txtcloud", new Object[0]);
                vs.addField("txtapp", new Object[0]);
                vs.addField("txtpage", new Object[0]);
                String[] splitApp = StringUtils.split((String)appInfo, (String)",");
                vs.addRow(new Object[]{this.clouds.get(splitApp[1]), splitApp[0], key});
                model.batchCreateNewEntryRow("entryentity", vs);
            }
        });
    }

    private void writeErrorTable(Map<String, String> errorPageMap) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        errorPageMap.forEach((key, val) -> {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("txtpage2", new Object[0]);
            vs.addField("txterror", new Object[0]);
            vs.addRow(new Object[]{key, val});
            model.batchCreateNewEntryRow("entryentity2", vs);
        });
    }

    private Map<String, String> initApp() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper helper1 = new HRBaseServiceHelper("bos_devportal_bizapp");
        DynamicObjectCollection apps = helper1.queryOriginalCollection("id,number,bizcloud", null);
        apps.forEach(dy -> map.put(dy.getString("id"), dy.getString("number") + ',' + dy.getString("bizcloud")));
        return map;
    }

    private Map<String, String> initCloud() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper clouds = new HRBaseServiceHelper("bos_devportal_bizcloud");
        DynamicObjectCollection collection = clouds.queryOriginalCollection("id,number", null);
        collection.forEach(dy -> map.put(dy.getString("id"), dy.getString("number")));
        return map;
    }

    private String getPlugin(String entityId, String operationKey) {
        StringBuilder opPlugins = new StringBuilder();
        String operateStr = this.metadataService.loadEntityOperationMeta(entityId, operationKey);
        JSONObject jsonObject = JSONObject.parseObject((String)operateStr);
        if (jsonObject == null) {
            return "";
        }
        JSONObject parameter = jsonObject.getJSONObject("parameter");
        if (parameter == null) {
            return "";
        }
        String pluginstr = parameter.getString("plugins");
        List plugins = (List)JSONObject.parseObject((String)pluginstr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        if (plugins != null && plugins.size() > 0) {
            for (Map p : plugins) {
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                opPlugins.append((String)p.get("ClassName")).append(",");
            }
        }
        return opPlugins.toString();
    }

    private void showErrorNotification() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5bf9\u8c61\u503c\u3002", (String)HiesCommonRes.GenerateButtonAnalysisReporterPlugin_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
    }

    private Map<String, String> initPaltOperate() {
        HashMap paltOperate = Maps.newHashMapWithExpectedSize((int)16);
        paltOperate.put("importdata", ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)HiesCommonRes.GenerateButtonAnalysisReporterPlugin_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        paltOperate.put("exportlist", ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\uff08\u6309\u5bfc\u5165\u6a21\u677f\uff09", (String)HiesCommonRes.GenerateButtonAnalysisReporterPlugin_3.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        paltOperate.put("exportlistbyselectfields", ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\uff08\u6309\u5217\u8868\uff09", (String)HiesCommonRes.GenerateButtonAnalysisReporterPlugin_4.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        paltOperate.put("exportlist_expt", ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\uff08\u6309\u5bfc\u51fa\u6a21\u677f\uff09", (String)HiesCommonRes.GenerateButtonAnalysisReporterPlugin_5.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        paltOperate.put("importentry", ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5bfc\u5165", (String)HiesCommonRes.GenerateButtonAnalysisReporterPlugin_6.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        paltOperate.put("exportentry", ResManager.loadKDString((String)"\u5bfc\u51fa\u5355\u636e\u4f53\u6570\u636e", (String)HiesCommonRes.GenerateButtonAnalysisReporterPlugin_7.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        return paltOperate;
    }

    private void clearEntry(String entryentity) {
        DynamicObjectCollection all = this.getModel().getEntryEntity(entryentity);
        int[] row = new int[all.size()];
        for (int i = 0; i < all.size(); ++i) {
            row[i] = i;
        }
        this.getModel().deleteEntryRows(entryentity, row);
    }

    private boolean isLikeCustomOp(String btnKey) {
        for (String key : this.customOp.keySet()) {
            if (!btnKey.contains(key)) continue;
            return true;
        }
        return false;
    }
}

