/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.SelectEntityFieldUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.SelectFieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hies.business.HRBizAppHelper;
import kd.hr.hies.common.HiesCommonRes;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

@ExcludeFromJacocoGeneratedReport
public class SetEntityRelPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String ENTRY = "entryentity";
    private static final String PAGE_SELECT_ENTITY_FIELDS = "hies_selectentityfields";
    private static final String LEFT_VAL_TYPE = "leftvaluetype";
    private static final String LEFT_ALIAS = "leftalias";
    private static final String RIGHT_TYPE = "righttype";
    private static final String RIGHT_VAL_TYPE = "rightvaluetype";
    private static final String RIGHT_ALIAS = "rightalias";
    private static final String RIGHT_BASE_DATA_ID = "rightbasedataid";
    private static final String RIGHT_ENUM_ID = "rightenumid";
    private static final String LEFT = "entityfield";
    private static final String FIELD_ENTITY = "entity";
    private static final String RIGHT = "relentityfield";
    private static final String RIGHT_PARENT_ALIAS = "rightparentalias";
    private static final String LEFT_PARENT_ALIAS = "leftparentalias";
    private static final String CONDITION = "condition";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("columnResizeMode", "preset");
        this.getView().updateControlMetadata(ENTRY, (Map)map);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.lockEntryFirstRowRight();
        if (OperationStatus.VIEW == status) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnclose"});
        } else if (OperationStatus.EDIT == status) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_ENTITY});
        }
        this.getModel().setDataChanged(false);
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        dataEntityState.setBizChanged(false);
    }

    private void setRightField(JoinConditionBo conditionBo, EntityRelationCommonBo entityRelationBo, SelectFieldTreeNode entityNode, SelectFieldTreeNode joinEntityNode, int rowIndex) {
        StringBuilder parentType = new StringBuilder();
        SelectFieldTreeNode rightNode = this.getFieldNode(conditionBo.getRightProp(), entityNode, joinEntityNode, parentType);
        if (rightNode == null) {
            return;
        }
        String rightDisplayName = rightNode.getLongName() + " | " + rightNode.getFieldAlias();
        this.getModel().setValue(RIGHT, (Object)rightDisplayName, rowIndex);
        this.getModel().setValue(RIGHT_VAL_TYPE, (Object)rightNode.getValueType(), rowIndex);
        this.getModel().setValue(RIGHT_ALIAS, (Object)conditionBo.getRightProp(), rowIndex);
        if (HRStringUtils.equals((String)parentType.toString(), (String)"main")) {
            this.getModel().setValue(RIGHT_PARENT_ALIAS, (Object)entityRelationBo.getEntityAlias(), rowIndex);
        } else {
            this.getModel().setValue(RIGHT_PARENT_ALIAS, (Object)entityRelationBo.getJoinEntityAlias(), rowIndex);
        }
    }

    private void setRightValue(JoinConditionBo conditionBo, String parentType, EntityRelationCommonBo entityRelationBo, MainEntityTypeUtil mainEntityTypeUtil, int rowIndex) {
        String entityNum = HRStringUtils.equals((String)parentType, (String)"main") ? entityRelationBo.getEntityNumber() : entityRelationBo.getJoinEntityNumber();
        if (conditionBo.getLeftProp().endsWith(".id")) {
            Map baseDataMap = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)entityNum, (String)conditionBo.getLeftProp(), (MainEntityTypeUtil)mainEntityTypeUtil);
            this.getModel().setValue(RIGHT, (Object)this.queryBaseDataName(conditionBo.getRightPropVal(), (String)baseDataMap.get("baseDataNum"), (String)baseDataMap.get("pkType")), rowIndex);
            this.getModel().setValue(RIGHT_BASE_DATA_ID, (Object)conditionBo.getRightPropVal(), rowIndex);
        } else {
            IDataEntityProperty property = AnalyseObjectUtil.parseFieldAliasGetProperty((String)entityNum, (String)conditionBo.getLeftProp(), (MainEntityTypeUtil)mainEntityTypeUtil);
            if (property instanceof ComboProp) {
                String rightPropVal = conditionBo.getRightPropVal();
                ArrayList rightValues = Lists.newArrayListWithCapacity((int)10);
                rightValues.addAll(Arrays.stream(rightPropVal.split(",")).filter(HRStringUtils::isNotEmpty).map(val -> val.substring(1, val.length() - 1)).collect(Collectors.toList()));
                List comboItems = ((ComboProp)property).getComboItems();
                StringBuilder nameSb = new StringBuilder();
                for (String rightValue : rightValues) {
                    Optional<ValueMapItem> itemOp = comboItems.stream().filter(item -> HRStringUtils.equals((String)item.getValue(), (String)rightValue)).findAny();
                    itemOp.ifPresent(valueMapItem -> nameSb.append(valueMapItem.getName().getLocaleValue()).append(","));
                }
                if (nameSb.length() > 0) {
                    this.getModel().setValue(RIGHT, (Object)nameSb.substring(0, nameSb.length() - 1), rowIndex);
                    this.getModel().setValue(RIGHT_ENUM_ID, (Object)rightPropVal, rowIndex);
                }
            } else {
                this.getModel().setValue(RIGHT, (Object)conditionBo.getRightPropVal(), rowIndex);
            }
        }
    }

    private String queryBaseDataName(String baseDataId, String baseDataNum, String baseDataPkType) {
        if (HRStringUtils.isEmpty((String)baseDataId)) {
            return "";
        }
        StringBuilder baseDataName = new StringBuilder();
        List ids = Arrays.stream(baseDataId.split(",")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        if (HRStringUtils.equals((String)baseDataPkType, (String)"long")) {
            List longIds = ids.stream().map(Long::parseLong).collect(Collectors.toList());
            qFilter = new QFilter("id", "in", longIds);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseDataNum);
        DynamicObjectCollection dys = helper.queryOriginalCollection("id, name", new QFilter[]{qFilter});
        Map<String, String> idToName = dys.stream().collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy.getString("name")));
        for (String id : ids) {
            String name = idToName.get(id);
            baseDataName.append(name).append(",");
        }
        if (baseDataName.length() > 0) {
            return baseDataName.substring(0, baseDataName.length() - 1);
        }
        return baseDataName.toString();
    }

    @ExcludeFromJacocoGeneratedReport
    private SelectFieldTreeNode getFieldNode(String fieldAlias, SelectFieldTreeNode entityNode, SelectFieldTreeNode joinEntityNode, StringBuilder parentType) {
        ArrayList result = Lists.newArrayListWithCapacity((int)10);
        SelectEntityFieldUtil.findNode((String)fieldAlias, (SelectFieldTreeNode)entityNode, (List)result);
        if (result.isEmpty()) {
            parentType.append("sub");
            SelectEntityFieldUtil.findNode((String)fieldAlias, (SelectFieldTreeNode)joinEntityNode, (List)result);
        } else {
            parentType.append("main");
        }
        if (result.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u6570\u636e\u4e2d\u5305\u542b\u57fa\u7840\u8d44\u6599\u5c5e\u6027\uff08%s\uff09\u65e7\u6570\u636e\uff0c\u8bf7\u79fb\u9664\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)HiesCommonRes.SetEntityRelPlugin_10.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), fieldAlias));
            return null;
        }
        return (SelectFieldTreeNode)result.get(0);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit entityEdit = (TextEdit)this.getControl(LEFT);
        entityEdit.addClickListener((ClickListener)this);
        TextEdit joinEntityEdit = (TextEdit)this.getControl(RIGHT);
        joinEntityEdit.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"btnsave"});
        BasedataEdit mainEntityBaseData = (BasedataEdit)this.getView().getControl(FIELD_ENTITY);
        mainEntityBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @ExcludeFromJacocoGeneratedReport
    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeSet;
        String newValue;
        String propName = args.getProperty().getName();
        if (HRStringUtils.equals((String)propName, (String)FIELD_ENTITY)) {
            this.clearEntityRelEntry();
        } else if (HRStringUtils.equals((String)propName, (String)LEFT)) {
            String rightType;
            ChangeData[] changeSet2 = args.getChangeSet();
            String newValue2 = (String)changeSet2[0].getNewValue();
            int rowIndex = changeSet2[0].getRowIndex();
            if (HRStringUtils.isEmpty((String)newValue2)) {
                this.getModel().setValue(LEFT_ALIAS, null, rowIndex);
                this.getModel().setValue(LEFT_VAL_TYPE, null, rowIndex);
                this.getModel().setValue(LEFT_PARENT_ALIAS, null, rowIndex);
            }
            if (HRStringUtils.equals((String)"value", (String)(rightType = (String)this.getModel().getValue(RIGHT_TYPE, rowIndex)))) {
                this.getModel().setValue(RIGHT, null, rowIndex);
            }
        } else if (HRStringUtils.equals((String)propName, (String)CONDITION)) {
            int rowIndex = args.getChangeSet()[0].getRowIndex();
            String rightType = (String)this.getModel().getValue(RIGHT_TYPE, rowIndex);
            if (HRStringUtils.equals((String)"value", (String)rightType)) {
                this.getModel().setValue(RIGHT, null, rowIndex);
            }
        } else if (HRStringUtils.equals((String)propName, (String)RIGHT) && HRStringUtils.isEmpty((String)(newValue = (String)(changeSet = args.getChangeSet())[0].getNewValue()))) {
            int rowIndex = changeSet[0].getRowIndex();
            this.getModel().setValue(RIGHT_ALIAS, null, rowIndex);
            this.getModel().setValue(RIGHT_VAL_TYPE, null, rowIndex);
            this.getModel().setValue(RIGHT_TYPE, null, rowIndex);
            this.getModel().setValue(RIGHT_PARENT_ALIAS, null, rowIndex);
            this.getModel().setValue(RIGHT_BASE_DATA_ID, null, rowIndex);
            this.getModel().setValue(RIGHT_ENUM_ID, null, rowIndex);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if ("btnsave".equals(control.getKey().toLowerCase(Locale.ROOT)) && !this.check()) {
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            DynamicObject entity = (DynamicObject)this.getModel().getValue(FIELD_ENTITY);
            if (ObjectUtils.isEmpty((Object)entity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b9e\u4f53\u201d\u3002", (String)HiesCommonRes.SetEntityRelPlugin_9.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                return;
            }
            String key = ((TextEdit)evt.getSource()).getKey();
            this.getPageCache().put("entryFieldKey", key);
            String entityNum = "hies_person_virentity";
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(PAGE_SELECT_ENTITY_FIELDS);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectFields"));
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY);
            DynamicObject currentRow = (DynamicObject)this.getModel().getEntryEntity(ENTRY).get(index);
            if (HRStringUtils.equals((String)key, (String)LEFT)) {
                entityNum = entity.getString("id");
                parameter.setCustomParam("hideEntryField", (Object)true);
                parameter.setCustomParam("onlyShowHRBDField", (Object)true);
                parameter.setCustomParam("leftOrRight", (Object)"left");
                parameter.setCustomParam("otherParentAlias", (Object)"hies_person_virentity");
                parameter.setCustomParam("otherFieldType", (Object)currentRow.getString(RIGHT_VAL_TYPE));
                parameter.setCustomParam("joinEntityNum", (Object)"hies_person_virentity");
                parameter.setCustomParam("joinEntityAlias", (Object)"hies_person_virentity");
            } else {
                parameter.setCustomParam("hideEntryField", (Object)true);
                parameter.setCustomParam("leftOrRight", (Object)"right");
                parameter.setCustomParam("otherParentAlias", (Object)currentRow.getString(LEFT_PARENT_ALIAS));
                parameter.setCustomParam("otherFieldType", (Object)currentRow.getString(LEFT_VAL_TYPE));
                parameter.setCustomParam("rightType", (Object)currentRow.getString(RIGHT_TYPE));
                parameter.setCustomParam(CONDITION, (Object)currentRow.getString(CONDITION));
                parameter.setCustomParam("rightVal", (Object)currentRow.getString(RIGHT));
                String leftAlias = currentRow.getString(LEFT_ALIAS);
                if (leftAlias.endsWith(".id")) {
                    parameter.setCustomParam("rightBaseDataId", (Object)currentRow.getString(RIGHT_BASE_DATA_ID));
                    String baseDataNum = AnalyseObjectUtil.parseFieldAliasGetBaseDataNum((String)entityNum, (String)leftAlias, (MainEntityTypeUtil)new MainEntityTypeUtil());
                    parameter.setCustomParam("baseDataNum", (Object)baseDataNum);
                } else {
                    IDataEntityProperty property = AnalyseObjectUtil.parseFieldAliasGetProperty((String)entityNum, (String)leftAlias, (MainEntityTypeUtil)new MainEntityTypeUtil());
                    if (property instanceof ComboProp) {
                        List comboItems = ((ComboProp)property).getComboItems();
                        parameter.setCustomParam("comboItems", (Object)SerializationUtils.toJsonString((Object)comboItems));
                        parameter.setCustomParam("enums", (Object)currentRow.getString(RIGHT_ENUM_ID));
                    }
                }
            }
            parameter.setCustomParam("entityNum", (Object)entityNum);
            parameter.setCustomParam("entityAlias", (Object)entityNum);
            parameter.setCustomParam("entityType", (Object)"main");
            parameter.setCustomParam("joinEntityType", (Object)"sub");
            this.getView().showForm(parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            // empty if block
        }
    }

    public boolean check() {
        DynamicObjectCollection personEntrys;
        ArrayList<String> errMsgs = new ArrayList<String>(2);
        int firstErrRow = -1;
        String firstErrKey = "";
        DynamicObject entity = (DynamicObject)this.getModel().getValue(FIELD_ENTITY);
        if (ObjectUtils.isEmpty((Object)entity)) {
            errMsgs.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b9e\u4f53\u201d", (String)HiesCommonRes.SetEntityRelPlugin_0.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)(personEntrys = this.getModel().getEntryEntity(ENTRY)))) {
            errMsgs.add(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u5173\u8054\u5173\u7cfb\u201c", (String)HiesCommonRes.SetEntityRelPlugin_1.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        } else {
            int relEntrySize = personEntrys.size();
            HashSet<String> leftNames = new HashSet<String>(relEntrySize);
            HashSet<String> repeatLeftNames = new HashSet<String>(relEntrySize);
            HashSet<String> rightNames = new HashSet<String>(relEntrySize);
            HashSet<String> repeatRightNames = new HashSet<String>(relEntrySize);
            HashSet<String> nullValErrProp = new HashSet<String>(relEntrySize);
            for (int entryRow = 0; entryRow < relEntrySize; ++entryRow) {
                String rightName;
                DynamicObject entryEntity = ((BillModel)this.getModel()).getEntryEntity(ENTRY, entryRow);
                String leftName = entryEntity.getString(LEFT);
                if (ObjectUtils.isEmpty((Object)leftName)) {
                    nullValErrProp.add(LEFT);
                    if (firstErrRow < 0) {
                        firstErrRow = entryRow;
                        firstErrKey = LEFT;
                    }
                } else if (!leftNames.add(leftName)) {
                    repeatLeftNames.add(leftName);
                    if (firstErrRow < 0) {
                        firstErrRow = entryRow;
                        firstErrKey = LEFT;
                    }
                }
                if (ObjectUtils.isEmpty((Object)(rightName = entryEntity.getString(RIGHT)))) {
                    nullValErrProp.add(RIGHT);
                    if (firstErrRow >= 0) continue;
                    firstErrRow = entryRow;
                    firstErrKey = RIGHT;
                    continue;
                }
                if (rightNames.add(rightName)) continue;
                repeatRightNames.add(rightName);
                if (firstErrRow >= 0) continue;
                firstErrRow = entryRow;
                firstErrKey = RIGHT;
            }
            ArrayList<String> nullValErrPropMsg = new ArrayList<String>(2);
            if (CollectionUtils.isNotEmpty(nullValErrProp)) {
                if (nullValErrProp.contains(LEFT)) {
                    nullValErrPropMsg.add(ResManager.loadKDString((String)"\u672c\u5b9e\u4f53\u5b57\u6bb5", (String)HiesCommonRes.SetEntityRelPlugin_2.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                }
                if (nullValErrProp.contains(RIGHT)) {
                    nullValErrPropMsg.add(ResManager.loadKDString((String)"HR\u4eba\u5458\u4fe1\u606f\u865a\u5b9e\u4f53\u5b57\u6bb5", (String)HiesCommonRes.SetEntityRelPlugin_3.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
                }
            }
            if (CollectionUtils.isNotEmpty(nullValErrPropMsg)) {
                errMsgs.add(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d", (String)HiesCommonRes.SetEntityRelPlugin_4.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), String.join((CharSequence)"\u3001", nullValErrPropMsg)));
            }
            if (CollectionUtils.isNotEmpty(repeatLeftNames)) {
                errMsgs.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u672c\u5b9e\u4f53\u5b57\u6bb5\u5b58\u5728\u76f8\u540c\u7684\u503c\uff1a\u201c%s\u201d", (String)HiesCommonRes.SetEntityRelPlugin_5.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), String.join((CharSequence)"\u3001", repeatLeftNames)));
            }
            if (CollectionUtils.isNotEmpty(repeatRightNames)) {
                errMsgs.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0bHR\u4eba\u5458\u4fe1\u606f\u865a\u5b9e\u4f53\u5b57\u6bb5\u5b58\u5728\u76f8\u540c\u7684\u503c\uff1a\u201c%s\u201d", (String)HiesCommonRes.SetEntityRelPlugin_6.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), String.join((CharSequence)"\u3001", repeatRightNames)));
            }
        }
        if (errMsgs.size() > 0) {
            if (firstErrRow > -1) {
                AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY);
                grid.focusCell(firstErrRow, firstErrKey);
            }
            if (errMsgs.size() == 1) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u3002", (String)HiesCommonRes.SetEntityRelPlugin_7.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), String.join((CharSequence)"\uff1b", (CharSequence)errMsgs.get(0))));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)HiesCommonRes.SetEntityRelPlugin_8.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]), Joiner.on((String)"\r\n").join(errMsgs), MessageTypes.Default);
            }
            return false;
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)evt.getActionId(), (String)"selectFields") && (returnData = evt.getReturnData()) != null) {
            Map returnDataMap = (Map)returnData;
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            String entryFieldKey = this.getPageCache().get("entryFieldKey");
            if (HRStringUtils.equals((String)entryFieldKey, (String)LEFT)) {
                this.getModel().setValue(LEFT, returnDataMap.get("displayName"), currentRow);
                this.getModel().setValue(LEFT_VAL_TYPE, returnDataMap.get("valueType"), currentRow);
                this.getModel().setValue(LEFT_ALIAS, returnDataMap.get("fieldAlias"), currentRow);
                this.getModel().setValue(LEFT_PARENT_ALIAS, returnDataMap.get("entityAlias"), currentRow);
            } else {
                this.getModel().setValue(RIGHT, returnDataMap.get("displayName"), currentRow);
                this.getModel().setValue(RIGHT_BASE_DATA_ID, returnDataMap.get("baseDataIds"), currentRow);
                this.getModel().setValue(RIGHT_ENUM_ID, returnDataMap.get("enums"), currentRow);
                String rightType = (String)returnDataMap.get("rightType");
                if (HRStringUtils.equals((String)rightType, (String)"field")) {
                    this.getModel().setValue(RIGHT_VAL_TYPE, returnDataMap.get("valueType"), currentRow);
                    this.getModel().setValue(RIGHT_ALIAS, returnDataMap.get("fieldAlias"), currentRow);
                    this.getModel().setValue(RIGHT_PARENT_ALIAS, returnDataMap.get("entityAlias"), currentRow);
                } else {
                    this.getModel().setValue(RIGHT_PARENT_ALIAS, null, currentRow);
                }
                this.getModel().setValue(RIGHT_TYPE, (Object)rightType, currentRow);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_ENTITY)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("number", "in", this.getBillNumbers()));
        }
    }

    private List<String> getBillNumbers() {
        QFilter[] filters;
        Object[] entityEncryptObjects;
        String fields = "number";
        String orderBy = "bizappid asc";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImportFilter = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter hrAppIdsFilter = null;
        List<DynamicObject> dynRuntimeApps = HRBizAppHelper.wildcardSearchRuntimeApps("", new QFilter[0]);
        if (CollectionUtils.isNotEmpty(dynRuntimeApps)) {
            HashSet<String> apps = new HashSet<String>(dynRuntimeApps.size());
            for (DynamicObject object : dynRuntimeApps) {
                apps.add(object.getString("id"));
            }
            hrAppIdsFilter = new QFilter("bizappid_id", "in", apps);
        }
        if (ArrayUtils.isNotEmpty((Object[])(entityEncryptObjects = BusinessDataServiceHelper.load((String)"hies_hrvirentityreg", (String)FIELD_ENTITY, (QFilter[])new QFilter[0])))) {
            Set entityIdSet = Arrays.stream(entityEncryptObjects).map(o -> o.getDynamicObject(FIELD_ENTITY).getPkValue()).collect(Collectors.toSet());
            QFilter entityIdFilter = new QFilter("id", "not in", entityIdSet);
            filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImportFilter, entityIdFilter, hrAppIdsFilter};
        } else {
            filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImportFilter, hrAppIdsFilter};
        }
        ArrayList<String> billNumbers = new ArrayList<String>();
        try (DataSet ds = ORM.create().queryDataSet("bos_entityobject", "bos_entityobject", fields, filters, orderBy);){
            for (Row row : ds) {
                billNumbers.add(row.getString("number"));
            }
        }
        return billNumbers;
    }

    private void deleteEntityRelEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY);
        int size = entryEntity.size();
        if (size > 0) {
            int[] delRows = new int[size];
            for (int index = 0; index < delRows.length; ++index) {
                delRows[index] = index;
            }
            this.getModel().deleteEntryRows(ENTRY, delRows);
        }
    }

    private void clearEntityRelEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY);
        int size = entryEntity.size();
        if (size > 0) {
            int rowIndex = 0;
            this.getModel().setValue(LEFT, null, rowIndex);
            this.getModel().setValue(LEFT_PARENT_ALIAS, null, rowIndex);
            this.getModel().setValue(LEFT_ALIAS, null, rowIndex);
            this.getModel().setValue(LEFT_VAL_TYPE, null, rowIndex);
        }
    }

    private void lockEntryFirstRowRight() {
        int currentRow = 0;
        this.getView().setEnable(Boolean.FALSE, currentRow, new String[]{RIGHT});
        this.getModel().setValue(RIGHT, (Object)ResManager.loadKDString((String)"\u5de5\u53f7 | number", (String)HiesCommonRes.SetEntityRelPlugin_8.resId(), (String)"hrmp-hies-common", (Object[])new Object[0]));
        this.getModel().setValue(RIGHT_PARENT_ALIAS, (Object)"hrpi_person", currentRow);
        this.getModel().setValue(RIGHT_ALIAS, (Object)"number", currentRow);
        this.getModel().setValue(RIGHT_VAL_TYPE, (Object)"string", currentRow);
        this.getModel().setValue(RIGHT_TYPE, (Object)"field", currentRow);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        TreeView treeView;
        String targetNodeId;
        IListView iListView;
        ITreeListView treeListView;
        ITreeModel treeModel;
        TreeNode treeNode;
        IFormView parentView;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate instanceof Save && StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess() && (parentView = this.getView().getParentView()) instanceof IListView && (treeNode = (treeModel = (treeListView = (iListView = (IListView)parentView).getTreeListView()).getTreeModel()).refreshNode((Object)(targetNodeId = (treeView = treeListView.getTreeView()).getTreeState().getFocusNodeId()))) != null) {
            treeView.updateNode(treeNode);
            treeView.focusNode(treeNode);
            treeView.treeNodeClick(treeNode.getParentid(), targetNodeId);
        }
    }
}

