/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin.processor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.model.complexobj.labelandreport.DataSourceCloudBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.common.bo.ObjEntityRelation;
import kd.hr.hies.common.bo.ObjJoinEntity;
import kd.hr.hies.common.bo.ObjQueryField;
import kd.hr.hies.common.constant.VirEntityCfgConstants;
import kd.hr.hies.common.util.FieldDefineService;
import kd.hr.hies.common.util.VirEntityCfgService;
import kd.hr.hies.formplugin.VirEntityCfgEdit;
import kd.hr.hies.formplugin.processor.VirEntityCfgCommonProcessor;

@ExcludeFromJacocoGeneratedReport
public class VirEntityCfgInitProcessor
extends VirEntityCfgCommonProcessor
implements VirEntityCfgConstants {
    private static final Log LOGGER = LogFactory.getLog(VirEntityCfgInitProcessor.class);

    public VirEntityCfgInitProcessor(VirEntityCfgEdit plugin) {
        super(plugin);
    }

    public void initData() {
        VirEntityCfgService service = VirEntityCfgService.getInstance();
        Long id = (Long)this.getModel().getValue("id");
        List<ObjJoinEntity> joinEntities = service.queryAndAssembleJoinEntities(id);
        List<ObjQueryField> queryFields = service.queryAndAssembleQueryFields(id);
        block0: for (ObjJoinEntity joinEntity : joinEntities) {
            for (ObjQueryField queryField : queryFields) {
                if (!joinEntity.getEntityNumber().equals(queryField.getEntityNumber()) || !Boolean.TRUE.equals(queryField.getSysPresetFlag())) continue;
                joinEntity.setSysPresetFlag(true);
                LOGGER.info("entity:{} \u5b58\u5728\u9884\u5236\u5b57\u6bb5\uff0c\u8bbe\u7f6e\u5b9e\u4f53\u4e3a\u9884\u5236\u5b9e\u4f53\uff0c\u65e0\u6cd5\u88ab\u5220\u9664\uff08\u524d\u7aef\u53bb\u9664x\u6309\u94ae\uff09", (Object)joinEntity);
                continue block0;
            }
        }
        List<ObjEntityRelation> entityRelations = service.queryAndAssembleEntityRelations(id);
        for (ObjEntityRelation entityRelation : entityRelations) {
            joinEntities.stream().filter(entityBo -> HRStringUtils.equals((String)entityBo.getEntityAlias(), (String)entityRelation.getJoinEntityAlias())).findAny().ifPresent(entityBo -> entityBo.setEntityRelation(entityRelation));
        }
        this.getView().getPageCache().put("joinEntities", SerializationUtils.toJsonString(joinEntities));
        this.getView().getPageCache().put("originJoinEntities", SerializationUtils.toJsonString(joinEntities));
        VirEntityCfgService.putPageCache(this.getView(), queryFields);
        this.getView().getPageCache().put("originQueryFields", SerializationUtils.toJsonString(queryFields));
        this.getView().getPageCache().put("entityRelations", SerializationUtils.toJsonString(entityRelations));
        this.getView().getPageCache().put("originEntityRelations", SerializationUtils.toJsonString(entityRelations));
    }

    public Map<String, Object> initCustomControl(boolean isInit) {
        List joinEntities = Collections.emptyList();
        List queryFields = Collections.emptyList();
        List entityRelations = Collections.emptyList();
        List<Object> entityAllFields = Lists.newArrayListWithCapacity((int)10);
        String joinEntitiesStr = this.getView().getPageCache().get("joinEntities");
        String queryFieldsStr = VirEntityCfgService.getPageCache(this.getView());
        String entityRelationsStr = this.getView().getPageCache().get("entityRelations");
        ArrayList selectedFieldKeys = Lists.newArrayListWithCapacity((int)10);
        if (this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            if (HRStringUtils.isNotEmpty((String)joinEntitiesStr)) {
                joinEntities = JSON.parseArray((String)joinEntitiesStr, ObjJoinEntity.class);
            }
            if (HRStringUtils.isNotEmpty((String)queryFieldsStr)) {
                queryFields = JSON.parseArray((String)queryFieldsStr, ObjQueryField.class);
                queryFields.stream().filter(queryField -> queryField.isVirtualEntityField() || !queryField.getFieldAlias().endsWith(".id")).forEach(queryField -> selectedFieldKeys.add(queryField.getFieldAlias()));
            }
            if (HRStringUtils.isNotEmpty((String)entityRelationsStr)) {
                entityRelations = JSON.parseArray((String)entityRelationsStr, ObjEntityRelation.class);
            }
            FieldDefineService service = new FieldDefineService();
            service.setSetComplexType(false);
            HashSet<String> refFieldAliasList = new HashSet<String>(0);
            entityAllFields = service.getEntityAllFields(joinEntities, queryFields, refFieldAliasList);
            if (isInit) {
                this.setAllFieldsToCache(entityAllFields);
            }
        }
        FieldDefineService fieldDefineService = new FieldDefineService();
        List<DataSourceCloudBo> dataSourceCloudBos = fieldDefineService.getDataSourceTree();
        Map<String, Object> dataMap = this.assembleData(dataSourceCloudBos, joinEntities, entityRelations, entityAllFields, selectedFieldKeys, isInit);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData(dataMap);
        if (isInit) {
            this.getView().getPageCache().put("initCompleted", "1");
        }
        return dataMap;
    }

    private Map<String, Object> assembleData(List<DataSourceCloudBo> clouds, List<ObjJoinEntity> joinEntities, List<ObjEntityRelation> entityRelations, List<FieldTreeNode> entityAllFields, List<String> selectedFieldKeys, boolean isInit) {
        for (ObjJoinEntity joinEntity : joinEntities) {
            if (!HRStringUtils.equals((String)joinEntity.getType(), (String)"sub")) continue;
            entityRelations.stream().filter(relation -> HRStringUtils.equals((String)relation.getJoinEntityAlias(), (String)joinEntity.getEntityAlias())).findAny().ifPresent(arg_0 -> ((ObjJoinEntity)joinEntity).setEntityRelation(arg_0));
        }
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        String statusParam = this.getPageStatus();
        dataMap.put("status", statusParam);
        dataMap.put("entityNodes", joinEntities);
        dataMap.put("clouds", clouds);
        if (isInit && HRStringUtils.equals((String)statusParam, (String)OperationStatus.VIEW.toString())) {
            entityAllFields.forEach(this::disableFieldTreeNode);
        }
        dataMap.put("fieldTreeNode", entityAllFields);
        dataMap.put("selectedFieldKeys", selectedFieldKeys);
        dataMap.put("method", "init");
        FieldDefineService fieldDefineService = new FieldDefineService();
        dataMap.put("entities", fieldDefineService.getAllEntities(clouds));
        dataMap.put("dataSource", "business");
        return dataMap;
    }

    private void disableFieldTreeNode(FieldTreeNode node) {
        node.setDisabled(Boolean.TRUE);
        if (node.getChildren() != null) {
            for (FieldTreeNode child : node.getChildren()) {
                this.disableFieldTreeNode(child);
            }
        }
    }

    private String getPageStatus() {
        String dataStatus;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String statusParam = status.toString();
        boolean audit = HRBaseDataConfigUtil.getAudit((String)this.getView().getEntityId());
        if (audit && !HRStringUtils.equals((String)(dataStatus = (String)this.getModel().getValue("status")), (String)"A")) {
            statusParam = OperationStatus.VIEW.toString();
        }
        this.getView().getPageCache().put("pageStatus", statusParam);
        return statusParam;
    }

    public void initStatus(OperationStatus status) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        Map<String, Object> dataMap = this.initCustomControl(false);
        dataMap.put("method", "initStatus");
        dataMap.put("status", OperationStatus.VIEW == status ? OperationStatus.VIEW.toString() : OperationStatus.EDIT.toString());
        dataMap.put("currtime", new Date().getTime());
        customcontrol.setData(dataMap);
    }
}

