/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.formplugin.tool;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hies.common.constant.HIESConstant;
import kd.hr.hies.common.util.HIESUtil;

@ExcludeFromJacocoGeneratedReport
public class PlatformTemplateTranslatePlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PlatformTemplateTranslatePlugin.class);
    static final String BOS_IMPORTTEMPLATE = "bos_importtemplate";
    static final String BOS_IMPORTENTRY_TEMPLATE = "bos_importentry_template";
    static final String HIES_DIAETPLCONF = "hies_diaetplconf";
    static final String HIES_ENTRY_TPL = "hies_entry_tpl";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void click(EventObject evt) {
        Button bt = (Button)evt.getSource();
        String op = bt.getKey();
        String type = (String)this.getModel().getValue("type");
        String val = (String)this.getModel().getValue("val");
        String[] vals = StringUtils.split((String)val, (String)",");
        Map<Object, Object> result = Maps.newHashMapWithExpectedSize((int)16);
        if ("buttonap".equals(op)) {
            this.clearEntry("entryentity");
            switch (type) {
                case "entity": {
                    result = this.translateEntityTpl(vals);
                    break;
                }
                case "entry": {
                    result = this.translateEntryTpl(vals);
                    break;
                }
            }
        }
        this.writeResultTable(result);
        this.getView().showTipNotification("finished");
    }

    private Map<String, Map<String, Object>> translateEntityTpl(String[] vals) {
        Map map;
        String number;
        DynamicObject[] dys;
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper helper0 = new HRBaseServiceHelper(HIES_DIAETPLCONF);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(BOS_IMPORTTEMPLATE);
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "in", (Object)vals)};
        Object[] objects = helper.loadDynamicObjectArray(qFilters);
        if (ObjectUtils.isEmpty((Object[])objects)) {
            this.getView().showTipNotification("no data");
            return result;
        }
        LinkedList<String> ignors = new LinkedList<String>();
        for (Object dy : objects) {
            Map map2 = result.computeIfAbsent(dy.getString("number"), val -> Maps.newHashMapWithExpectedSize((int)3));
            this.validateTpl((DynamicObject)dy, map2, ignors);
        }
        for (DynamicObject dynamicObject : dys = helper0.queryOriginalArray("number,name,id,issyspreset", qFilters)) {
            number = dynamicObject.getString("number");
            map = result.computeIfAbsent(number, val -> Maps.newHashMapWithExpectedSize((int)3));
            map.put("ckissyspreset", dynamicObject.getBoolean("issyspreset"));
            map.put("ckexist", true);
            if (!dynamicObject.getBoolean("issyspreset")) continue;
            map.put("ckresult", false);
            map.put("txtremark", "the issyspreset data can not translate.");
            ignors.add(number);
        }
        for (Object object : objects) {
            number = object.getString("number");
            if (ignors.contains(number)) continue;
            map = result.computeIfAbsent(number, val -> Maps.newHashMapWithExpectedSize((int)3));
            try {
                String name = object.getString("name");
                if (this.hasRepeatNameTpl((DynamicObject)object)) {
                    map.put("ckresult", false);
                    map.put("txtremark", "has repeat name template.");
                    continue;
                }
                DynamicObject hrtpl = helper0.generateEmptyDynamicObject();
                this.initEntityTplDefaultValue(hrtpl);
                hrtpl.set("id", object.getPkValue());
                hrtpl.set("masterid", object.getPkValue());
                hrtpl.set("tmpltype", (Object)object.getString("templatetype"));
                hrtpl.set("number", (Object)number);
                hrtpl.set("name", (Object)name);
                DynamicObject bizobject = object.getDynamicObject("bizobject");
                hrtpl.set("queryentity", (Object)bizobject);
                hrtpl.set("entity", (Object)bizobject);
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)HIES_DIAETPLCONF);
                EntityType tpltreeentryentity = (EntityType)dataEntityType.getAllEntities().get("tpltreeentryentity");
                DynamicObjectCollection collection = new DynamicObjectCollection();
                DynamicObjectCollection treeentryentity = object.getDynamicObjectCollection("treeentryentity");
                List collection2 = treeentryentity.stream().collect(Collectors.toList());
                collection2.sort(Comparator.comparing(a -> a.getLong("seq")));
                int seq = 1;
                for (DynamicObject field : treeentryentity) {
                    boolean isfield;
                    DynamicObject entryitem = new DynamicObject((DynamicObjectType)tpltreeentryentity);
                    entryitem.set("id", (Object)field.getLong("id"));
                    long pid = field.getLong("pid");
                    entryitem.set("pid", (Object)pid);
                    String entitynumber = field.getString("entitynumber");
                    if (!entitynumber.equals("billhead")) {
                        entryitem.set("fieldnumber", (Object)entitynumber);
                    }
                    if ((isfield = field.getBoolean("isfield")) && !entitynumber.endsWith(".id") && !entitynumber.equals("id")) {
                        entryitem.set("isimport", field.get("isimport"));
                    }
                    entryitem.set("ischecked", (Object)true);
                    entryitem.set("ismustinput", field.get("ismustinput"));
                    entryitem.set("imptattr", (Object)field.getString("importprop"));
                    entryitem.set("exptattr", (Object)field.getString("exportpropname"));
                    entryitem.set("fieldimportdesc", (Object)field.getString("entitydescription"));
                    entryitem.set("isfield", (Object)isfield);
                    entryitem.set("seq", (Object)seq);
                    entryitem.set("childentity", (Object)bizobject.getString("number"));
                    collection.add((Object)entryitem);
                    ++seq;
                }
                hrtpl.set("tpltreeentryentity", (Object)collection);
                helper0.deleteByFilter(new QFilter[]{qFilters[0], new QFilter("number", "=", (Object)number)});
                helper0.saveOne(hrtpl);
                map.put("ckresult", true);
            }
            catch (Throwable e) {
                LOGGER.error(e);
                map.put("ckresult", false);
                map.put("txtremark", e.getMessage());
            }
        }
        return result;
    }

    private void initEntityTplDefaultValue(DynamicObject hrtpl) {
        hrtpl.set("tplgenmode", (Object)"sysgen");
        hrtpl.set("orgfield", (Object)OrgUnitServiceHelper.getRootOrgId());
        hrtpl.set("entitytype", (Object)"SE");
        hrtpl.set("instruction", (Object)HIESUtil.getTplInstruction());
        hrtpl.set("allocationpolicy", (Object)"0");
        hrtpl.set("enable", (Object)"1");
        hrtpl.set("importtype", (Object)"new");
        hrtpl.set("source", (Object)"normal");
        hrtpl.set("creator", (Object)RequestContext.get().getCurrUserId());
        hrtpl.set("status", (Object)"C");
    }

    private Map<String, Map<String, Object>> translateEntryTpl(String[] vals) {
        Map map;
        String number;
        DynamicObject[] dys;
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper helper0 = new HRBaseServiceHelper(HIES_ENTRY_TPL);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(BOS_IMPORTENTRY_TEMPLATE);
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "in", (Object)vals)};
        Object[] objects = helper.loadDynamicObjectArray(qFilters);
        if (ObjectUtils.isEmpty((Object[])objects)) {
            this.getView().showTipNotification("no data");
            return result;
        }
        LinkedList<String> ignors = new LinkedList<String>();
        for (Object dy : objects) {
            Map map2 = result.computeIfAbsent(dy.getString("number"), val -> Maps.newHashMapWithExpectedSize((int)3));
            this.validateTpl((DynamicObject)dy, map2, ignors);
        }
        for (DynamicObject dynamicObject : dys = helper0.queryOriginalArray("number,name,id,issyspreset", qFilters)) {
            number = dynamicObject.getString("number");
            map = result.computeIfAbsent(number, val -> Maps.newHashMapWithExpectedSize((int)3));
            map.put("ckissyspreset", dynamicObject.getBoolean("issyspreset"));
            map.put("ckexist", true);
            if (!dynamicObject.getBoolean("issyspreset")) continue;
            map.put("ckresult", false);
            map.put("txtremark", "the issyspreset data can not translate.");
            ignors.add(number);
        }
        for (Object object : objects) {
            number = object.getString("number");
            if (ignors.contains(number)) continue;
            map = result.computeIfAbsent(number, val -> Maps.newHashMapWithExpectedSize((int)3));
            try {
                String name = object.getString("name");
                if (this.hasRepeatNameTpl((DynamicObject)object)) {
                    map.put("ckresult", false);
                    map.put("txtremark", "has repeat name template.");
                    continue;
                }
                DynamicObject hrtpl = helper0.generateEmptyDynamicObject();
                this.initEntryTplDefaultValue(hrtpl);
                hrtpl.set("id", object.getPkValue());
                hrtpl.set("masterid", object.getPkValue());
                hrtpl.set("number", (Object)object.getString("number"));
                hrtpl.set("name", (Object)name);
                DynamicObject bizobject = object.getDynamicObject("bizobject");
                hrtpl.set("entity", (Object)bizobject);
                String mulcombo = object.getString("mulcombo").replaceAll(",", "");
                hrtpl.set("entrytype", (Object)mulcombo);
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)HIES_ENTRY_TPL);
                EntityType tpltreeentryentity = (EntityType)dataEntityType.getAllEntities().get("tpltreeentryentity");
                DynamicObjectCollection collection = new DynamicObjectCollection();
                DynamicObjectCollection treeentryentity = object.getDynamicObjectCollection("treeentryentity");
                List collection2 = treeentryentity.stream().collect(Collectors.toList());
                collection2.sort(Comparator.comparing(a -> a.getLong("seq")));
                int seq = 1;
                long fieldPid = 0L;
                for (DynamicObject field : treeentryentity) {
                    DynamicObject entryitem = new DynamicObject((DynamicObjectType)tpltreeentryentity);
                    entryitem.set("id", (Object)field.getLong("id"));
                    long pid = field.getLong("pid");
                    entryitem.set("pid", (Object)pid);
                    String entitynumber = field.getString("entitynumber");
                    entryitem.set("fieldnumber", (Object)entitynumber);
                    if (!entitynumber.equals(bizobject.getString("number")) && !entitynumber.equals(mulcombo)) {
                        entryitem.set("isimport", field.get("isimport"));
                        entryitem.set("isfield", (Object)true);
                        fieldPid = pid;
                    }
                    entryitem.set("ischecked", (Object)true);
                    entryitem.set("ismustinput", field.get("ismustinput"));
                    entryitem.set("imptattr", (Object)field.getString("importprop"));
                    entryitem.set("fieldimportdesc", (Object)field.getString("entitydescription"));
                    entryitem.set("seq", (Object)seq);
                    entryitem.set("childentity", (Object)bizobject.getString("number"));
                    collection.add((Object)entryitem);
                    if (seq == 2) {
                        seq += 2;
                        continue;
                    }
                    ++seq;
                }
                DynamicObject entryIdItem = new DynamicObject((DynamicObjectType)tpltreeentryentity);
                entryIdItem.set("pid", (Object)fieldPid);
                entryIdItem.set("fieldnumber", (Object)(mulcombo + ".id"));
                entryIdItem.set("isimport", (Object)true);
                entryIdItem.set("isfield", (Object)true);
                entryIdItem.set("ischecked", (Object)true);
                entryIdItem.set("seq", (Object)3);
                entryIdItem.set("childentity", (Object)bizobject.getString("number"));
                collection.add((Object)entryIdItem);
                hrtpl.set("tpltreeentryentity", (Object)collection);
                helper0.deleteByFilter(new QFilter[]{qFilters[0], new QFilter("number", "=", (Object)number)});
                helper0.saveOne(hrtpl);
                map.put("ckresult", true);
            }
            catch (Throwable e) {
                LOGGER.error(e);
                map.put("ckresult", false);
                map.put("txtremark", e.getMessage());
            }
        }
        return result;
    }

    private void initEntryTplDefaultValue(DynamicObject hrtpl) {
        hrtpl.set("orgfield", (Object)OrgServiceUtil.getHRRootOrgId());
        hrtpl.set("instruction", (Object)HIESUtil.getTplInstruction());
        hrtpl.set("allocationpolicy", (Object)"0");
        hrtpl.set("enable", (Object)"1");
        hrtpl.set("importtype", (Object)"updateandnew");
        hrtpl.set("source", (Object)"normal");
        hrtpl.set("creator", (Object)RequestContext.get().getCurrUserId());
        hrtpl.set("status", (Object)"C");
        hrtpl.set("mainentityuniqueval", (Object)"id");
        hrtpl.set("tmpltype", (Object)"IMPT");
    }

    private void writeResultTable(Map<String, Map<String, Object>> result) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        result.forEach((key, val) -> {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("txttpl", new Object[0]);
            vs.addField("ckexist", new Object[0]);
            vs.addField("ckissyspreset", new Object[0]);
            vs.addField("ckresult", new Object[0]);
            vs.addField("txtremark", new Object[0]);
            vs.addRow(new Object[]{key, val.get("ckexist"), val.get("ckissyspreset"), val.get("ckresult"), val.get("txtremark")});
            model.batchCreateNewEntryRow("entryentity", vs);
        });
    }

    private void clearEntry(String entryentity) {
        DynamicObjectCollection all = this.getModel().getEntryEntity(entryentity);
        int[] row = new int[all.size()];
        for (int i = 0; i < all.size(); ++i) {
            row[i] = i;
        }
        this.getModel().deleteEntryRows(entryentity, row);
    }

    private void validateTpl(DynamicObject tpl, Map<String, Object> map, List<String> ignors) {
        String name;
        String number = tpl.getString("number");
        if (HIESConstant.SpecCharPattern.matcher(number).find() || HIESConstant.CHINESE_PATTERN.matcher(number).find()) {
            map.put("ckresult", false);
            map.put("txtremark", "the number is illegle");
            ignors.add(number);
        }
        if (HIESConstant.SpecCharPattern.matcher(name = tpl.getString("name")).find()) {
            map.put("ckresult", false);
            map.put("txtremark", "the name is illegle");
            ignors.add(number);
        }
    }

    private boolean hasRepeatNameTpl(DynamicObject dy) {
        DynamicObject[] temDys;
        boolean hasRepeatNameTpl = false;
        HRBaseServiceHelper helper0 = new HRBaseServiceHelper(HIES_DIAETPLCONF);
        String number = dy.getString("number");
        String name = dy.getString("name");
        for (DynamicObject dy1 : temDys = helper0.queryOriginalArray("number,name", new QFilter[]{new QFilter("name", "=", (Object)name)})) {
            String number1 = dy1.getString("number");
            String name1 = dy1.getString("name");
            if (!name.equals(name1) || number.equals(number1)) continue;
            hasRepeatNameTpl = true;
        }
        return hasRepeatNameTpl;
    }
}

