/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.EContemplateService;
import kd.hr.hrcs.bussiness.service.esign.ESignConfigService;
import kd.hr.hrcs.bussiness.service.esign.ESignConstants;
import kd.hr.hrcs.bussiness.service.esign.SignFlowService;
import kd.hr.hrcs.bussiness.service.esign.api.BatchInitiateSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.CancelSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.CorpSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.DisuseSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.DownLoadSignFile;
import kd.hr.hrcs.bussiness.service.esign.api.InitiateSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.ObtainSignLink;
import kd.hr.hrcs.bussiness.service.esign.api.QuerySignTask;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.factory.ESignSrvFactory;
import kd.hr.hrcs.bussiness.service.esign.factory.ServiceRouter;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOSealMgrUtil;
import kd.hr.hrcs.mservice.api.IHRCSEContractService;

public class HRCSESignService
implements IHRCSEContractService {
    private static final Log LOGGER = LogFactory.getLog(HRCSESignService.class);
    private SignFlowService signFlowService = new SignFlowService();

    public SignRespParam toSign(SignReqParam signReqParam) {
        InitiateSignTask signTaskService = this.getInitiateSignTask(signReqParam, null);
        SignRespParam signRespParam = signTaskService.toSign(signReqParam);
        return signRespParam;
    }

    public SignRespParam getHandSignUrl(String contractNo, SignReqParam signReqParam) {
        LOGGER.info("getHandSignUrl contractNo={}", (Object)contractNo);
        ObtainSignLink obtainSignLink = this.getESignSrvFactory(signReqParam, contractNo).getObtainSignLink();
        return obtainSignLink.getHandSignUrl(contractNo, signReqParam);
    }

    public SignRespParam sign(Long fiorg, Long templateTypeId, String contractNo) {
        LOGGER.info("sign fiorg={};tempId={};contractNo={}", new Object[]{fiorg, templateTypeId, contractNo});
        ESignConfigService configService = new ESignConfigService();
        Long lawEntityId = configService.getLawEntityId(fiorg);
        if (lawEntityId != null) {
            SignReqParam signReqParam = new SignReqParam(fiorg, null, null, true);
            signReqParam.setLawEntityId(lawEntityId);
            return this.signNew(signReqParam, contractNo);
        }
        LOGGER.error("sign cann't find the lawEntityId.");
        return null;
    }

    public SignRespParam signNew(SignReqParam signReqParam, String contractNo) {
        CorpSignTask corpSignTask = this.getESignSrvFactory(signReqParam, contractNo).getCorpSignTask();
        return corpSignTask.sign(signReqParam, contractNo);
    }

    public SignRespParam getPrevAndDown(Long fiorg, String contractNo) {
        LOGGER.info("getPrevAndDown fiorg={};contractNo={}", (Object)fiorg, (Object)contractNo);
        ESignConfigService configService = new ESignConfigService();
        Long lawEntityId = configService.getLawEntityId(fiorg);
        if (lawEntityId != null) {
            SignReqParam signReqParam = new SignReqParam(fiorg, null, null, true);
            signReqParam.setLawEntityId(lawEntityId);
            return this.getPrevAndDownNew(signReqParam, contractNo);
        }
        LOGGER.error("isUploadSignature cann't find the lawEntityId.");
        return null;
    }

    public SignRespParam getPrevAndDownNew(SignReqParam signReqParam, String contractNo) {
        DownLoadSignFile downLoadSignFile = this.getESignSrvFactory(signReqParam, contractNo).getDownLoadSignFile();
        return downLoadSignFile.getPrevAndDown(signReqParam, contractNo);
    }

    public boolean cancel(Long fiorg, String contractNo) {
        LOGGER.info("cancel fiorg={};contractNo={}", (Object)fiorg, (Object)contractNo);
        ESignConfigService configService = new ESignConfigService();
        Long lawEntityId = configService.getLawEntityId(fiorg);
        if (lawEntityId != null) {
            SignReqParam signReqParam = new SignReqParam(fiorg, null, null, true);
            signReqParam.setLawEntityId(lawEntityId);
            return this.cancelNew(signReqParam, contractNo);
        }
        LOGGER.error("isUploadSignature cann't find the lawEntityId.");
        return false;
    }

    public boolean cancelNew(SignReqParam signReqParam, String contractNo) {
        CancelSignTask cancelSignTask = this.getESignSrvFactory(signReqParam, contractNo).getCancelSignTask();
        return cancelSignTask.cancel(signReqParam, contractNo);
    }

    @Deprecated
    public boolean authStatus(SignReqParam signReqParam) {
        this.printLog("authStatus", signReqParam);
        return true;
    }

    public String getAuthStatus(SignReqParam signReqParam) {
        this.printLog("getAuthStatus", signReqParam);
        return null;
    }

    public boolean signStatus(SignReqParam signReqParam, String contractNo) {
        LOGGER.info("signStatus contractNo={}", (Object)contractNo);
        this.printLog("signStatus", signReqParam);
        QuerySignTask querySignTask = this.getESignSrvFactory(signReqParam, contractNo).getQuerySignTask();
        boolean isSign = querySignTask.signStatus(signReqParam, contractNo);
        if (isSign) {
            SignFlowService signFlowService = new SignFlowService();
            signFlowService.updatePerosnSignStatus(contractNo, true);
        }
        return isSign;
    }

    private void updateContractSignStatus(DynamicObjectCollection personDynColl, DynamicObjectCollection entryDynColl, DynamicObject flowSignDyn) {
        boolean personFlag = false;
        boolean entryFlag = false;
        for (DynamicObject person : personDynColl) {
            if ("signed".equals(person.getString("personsignstatus")) || "sign_rejected".equals(person.getString("personsignstatus"))) {
                personFlag = true;
                continue;
            }
            personFlag = false;
        }
        for (DynamicObject entry : entryDynColl) {
            if ("signed".equals(entry.getString("orgsignstatus")) || "sign_rejected".equals(entry.getString("orgsignstatus"))) {
                entryFlag = true;
                continue;
            }
            entryFlag = false;
        }
        if (personFlag && entryFlag) {
            flowSignDyn.set("signstatus", (Object)"signed");
        }
        HRBaseServiceHelper signFlowServiceHelper = new HRBaseServiceHelper("hrcs_signflow");
        signFlowServiceHelper.updateOne(flowSignDyn);
    }

    public boolean contractSignStatus(Long fiorg, String contractNo) {
        LOGGER.info("signStatus fiorg={};contractNo={}", (Object)fiorg, (Object)contractNo);
        ESignConfigService configService = new ESignConfigService();
        Long lawEntityId = configService.getLawEntityId(fiorg);
        if (lawEntityId != null) {
            SignReqParam signReqParam = new SignReqParam(fiorg, null, null, true);
            signReqParam.setLawEntityId(lawEntityId);
            return this.contractSignStatusNew(signReqParam, contractNo);
        }
        LOGGER.error("contractSignStatus cann't find the lawEntityId.");
        return false;
    }

    public boolean contractSignStatusNew(SignReqParam signReqParam, String contractNo) {
        LOGGER.info("contractSignStatus contractNo={}", (Object)contractNo);
        QuerySignTask querySignTask = this.getESignSrvFactory(signReqParam, contractNo).getQuerySignTask();
        boolean isSign = querySignTask.contractSignStatus(signReqParam, contractNo);
        if (isSign) {
            SignFlowService signFlowService = new SignFlowService();
            signFlowService.updateContractSignStatus(contractNo, true);
        }
        return isSign;
    }

    private ESignSrvFactory getESignSrvFactory(SignReqParam signReqParam, String contractNo) {
        return this.getESignSrvFactory(signReqParam.getLawEntityId(), contractNo);
    }

    private ESignSrvFactory getESignSrvFactory(Long lawEntityId, String contractNo) {
        SignFlowService signFlowService;
        DynamicObject flowSignDyn;
        if (HRStringUtils.isNotEmpty((String)contractNo) && (flowSignDyn = (signFlowService = new SignFlowService()).queryOneByNo(contractNo)) != null && flowSignDyn.getLong("signconfig.id") != 0L) {
            ESignAppInfo eSignAppInfo = ESignAppCfgUtil.getESignAppInfo((Object)flowSignDyn.getLong("signconfig.id"));
            return ServiceRouter.getSrvFactory((String)eSignAppInfo.getSpId(), (String)String.valueOf(lawEntityId));
        }
        return ServiceRouter.getOnlineSrvFactory((Long)lawEntityId);
    }

    private InitiateSignTask getInitiateSignTask(SignReqParam signReqParam, String contractNo) {
        return this.getESignSrvFactory(signReqParam, contractNo).getInitiateSignTask();
    }

    public boolean contSubjectExists(Long fiorg) {
        LOGGER.info("contSubjectExists fiorg={}", (Object)fiorg);
        ESignConfigService configService = new ESignConfigService();
        Long lawEntityId = configService.getLawEntityId(fiorg);
        if (lawEntityId != null) {
            SignReqParam signReqParam = new SignReqParam(fiorg, null, null, true);
            signReqParam.setLawEntityId(lawEntityId);
            return this.contSubjectExistsNew(signReqParam);
        }
        LOGGER.error("contSubjectExists cann't find the lawEntityId.");
        return false;
    }

    public boolean contSubjectExistsNew(SignReqParam signReqParam) {
        try {
            ESignAppInfo appInfo = ESignAppCfgUtil.getOnlineAppInfoByCorpId((Long)signReqParam.getLawEntityId());
            return appInfo != null;
        }
        catch (Exception exp) {
            LOGGER.error("contSubjectExistsNew exp:" + exp.getMessage());
            LOGGER.error((Throwable)exp);
            return false;
        }
    }

    public boolean isUploadSignature(Long fiorg) {
        LOGGER.info("isUploadSignature fiorg={}", (Object)fiorg);
        ESignConfigService configService = new ESignConfigService();
        Long lawEntityId = configService.getLawEntityId(fiorg);
        if (lawEntityId != null) {
            SignReqParam signReqParam = new SignReqParam(fiorg, null, null, true);
            signReqParam.setLawEntityId(lawEntityId);
            return this.isUploadSignatureNew(signReqParam);
        }
        LOGGER.error("isUploadSignature cann't find the lawEntityId.");
        return false;
    }

    public boolean isUploadSignatureNew(SignReqParam signReqParam) {
        try {
            ESignAppInfo appInfo = ESignAppCfgUtil.getOnlineAppInfoByCorpId((Long)signReqParam.getLawEntityId());
            if (appInfo != null) {
                DynamicObject contTplDyo = EContemplateService.queryEContplInfo((Long)signReqParam.getTemplateId());
                DynamicObject sealDyn = ESignCOSealMgrUtil.querySealBySealType((Object)Long.parseLong(appInfo.getSpId()), (Object)signReqParam.getLawEntityId(), (Long)contTplDyo.getLong("sealtypeid.id"));
                if (sealDyn != null && sealDyn.getLong("sealid") != 0L && contTplDyo.getBoolean("corporateseal")) {
                    sealDyn = ESignCOSealMgrUtil.querySealBySealType((Object)Long.parseLong(appInfo.getSpId()), (Object)signReqParam.getLawEntityId(), (Long)ESignConstants.SEAL_TYPE_ID_LEGAL);
                    return sealDyn != null;
                }
            }
        }
        catch (Exception exp) {
            LOGGER.error("isUploadSignatureNew exp:" + exp.getMessage());
            LOGGER.error((Throwable)exp);
        }
        return false;
    }

    private void printLog(String msg, SignReqParam signReqParam) {
        String reqMsg = JSON.toJSONString((Object)signReqParam);
        reqMsg = reqMsg.replace(signReqParam.getName(), "").replace(signReqParam.getIdentity(), "").replace(signReqParam.getMobile(), "");
        LOGGER.info("{} signReqParam={}", (Object)msg, (Object)reqMsg);
    }

    public SignRespParam multFiletoSign(SignReqParam signReqParam) {
        InitiateSignTask signTaskService = this.getInitiateSignTask(signReqParam, null);
        SignRespParam signRespParam = signTaskService.multFileToSign(signReqParam);
        return signRespParam;
    }

    public SignRespParam abolish(String preContractNo, SignReqParam signReqParam) {
        DisuseSignTask disuseSignTask = this.getESignSrvFactory(signReqParam, preContractNo).getDisuseSignTask();
        return disuseSignTask.abolish(preContractNo, signReqParam);
    }

    public SignRespParam getBatchSignUrl(Map<String, Object> params) {
        List contractNos = (List)params.get("contractNos");
        Long lawEntityId = (Long)params.get("lawEntityId");
        HRAssert.isFalse((boolean)CollectionUtils.isEmpty((Collection)contractNos), (String)"contractNos is empty", (Object[])new Object[0]);
        HRAssert.isFalse((lawEntityId == null || lawEntityId == 0L ? 1 : 0) != 0, (String)"contractNos is empty", (Object[])new Object[0]);
        String contractNo = (String)contractNos.get(0);
        ESignSrvFactory eSignSrvFactory = this.getESignSrvFactory(lawEntityId, contractNo);
        BatchInitiateSignTask batchInitiateSignTask = eSignSrvFactory.getBatchInitiateSignTask();
        return batchInitiateSignTask.getBatchSignUrl(params);
    }
}

