/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.econtract.CheckVariableResp;
import kd.hr.hbp.common.model.econtract.KeyWordMappingEntryParam;
import kd.hr.hbp.common.model.econtract.KeyWordMappingParam;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.EContractServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.econtract.KeywordMappingServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.utils.HRCSListUtils;
import kd.hr.hrcs.mservice.api.IHRCSKeywordMappingService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HRCSKeywordMappingService
implements IHRCSKeywordMappingService {
    private static final Log LOGGER = LogFactory.getLog(HRCSKeywordMappingService.class);
    private static HashMap<String, String> fieldCach = Maps.newHashMapWithExpectedSize((int)16);

    public int deleteKeywordMapping(String formNumber, Long contempDyId) {
        int delRowsCount = KeywordMappingServiceHelper.deleteKeywordMapping((String)formNumber, (Object)contempDyId);
        return delRowsCount;
    }

    public DynamicObject selectKeywordMapping(String formNumber, Long contempDyId) {
        DynamicObject dynamicObject = null;
        dynamicObject = KeywordMappingServiceHelper.selectKeywordMapping((String)formNumber, (Object)contempDyId);
        return dynamicObject;
    }

    public DynamicObject selectKeywordMappingWithCondition(String formNumber, Long contempDyId) {
        DynamicObject dynamicObject = null;
        dynamicObject = KeywordMappingServiceHelper.selectKeywordMappingWithCondition((String)formNumber, (Object)contempDyId);
        return dynamicObject;
    }

    public void updateKeywordMapping(Set<String> newFieldSet, String formNumber, Long contempDyId) {
        DynamicObject dynamicObject = KeywordMappingServiceHelper.loadKeywordMapping((String)formNumber, (Object)contempDyId);
        DynamicObjectCollection entityColl = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection dynamicObjects = KeywordMappingServiceHelper.compareKeyword(newFieldSet, (DynamicObjectCollection)entityColl, (boolean)false);
        dynamicObject.set("entryentity", (Object)dynamicObjects);
        KeywordMappingServiceHelper.update((DynamicObject)dynamicObject);
    }

    public void copyKeywordMappingFromOldToNew(Set<String> newFieldSet, String formNumber, Long contempDyId, Long contempNewId) {
        DynamicObject dynamicObject = KeywordMappingServiceHelper.loadKeywordMapping((String)formNumber, (Object)contempDyId);
        DynamicObjectCollection entityColl = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection dynamicObjects = KeywordMappingServiceHelper.compareKeyword(newFieldSet, (DynamicObjectCollection)entityColl, (boolean)true);
        DynamicObject newDy = new DynamicObject(dynamicObject.getDynamicObjectType());
        HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)newDy);
        newDy.set("entryentity", (Object)dynamicObjects);
        newDy.set("contempid", (Object)contempNewId);
        Long newId = DBServiceHelper.genGlobalLongId();
        newDy.set("id", (Object)newId);
        KeywordMappingServiceHelper.saveOne((DynamicObject)newDy);
    }

    public Map<String, String> getEntitySelectFieldMap(DynamicObject dynamicObject) {
        Map map = null;
        if (!Objects.isNull(dynamicObject)) {
            DynamicObjectCollection dyColl = dynamicObject.getDynamicObjectCollection("entryentity");
            map = KeywordMappingServiceHelper.getMapFromKeywordMapping((DynamicObjectCollection)dyColl);
        }
        return map;
    }

    public List<String> checkKeywordMapping(String formNumber, Long contempDyId) {
        ArrayList list = null;
        DynamicObject dynamicObject = KeywordMappingServiceHelper.selectKeywordMapping((String)formNumber, (Object)contempDyId);
        if (!Objects.isNull(dynamicObject)) {
            list = Lists.newArrayListWithExpectedSize((int)10);
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject dy : collection) {
                String wordField = dy.getString("wordfield");
                String entityField = dy.getString("entityfield");
                String isCustomize = dy.getString("iscustomize");
                if (!HRStringUtils.isEmpty((String)entityField) || HRStringUtils.equals((String)"1", (String)isCustomize)) continue;
                list.add(wordField);
            }
        }
        return list;
    }

    @Deprecated
    public Map<String, String> getMapFromKeywordMappingConfig() {
        return null;
    }

    public Map<String, String> getRealReplacedMap(List<DynamicObject> dyList, DynamicObjectCollection keywordMappingDyColl) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)keywordMappingDyColl.size());
        block0: for (DynamicObject keywordDy : keywordMappingDyColl) {
            String wordField = keywordDy.getString("wordfield");
            String entityNumber = keywordDy.getString("entitynumber");
            String entityField = keywordDy.getString("entityfield");
            for (DynamicObject dy : dyList) {
                String entityNumberByDy = dy.getDataEntityType().getName();
                if (!HRStringUtils.equals((String)entityNumber, (String)entityNumberByDy)) continue;
                String valueStr = this.transFieldTypeToStr(dy, entityField);
                map.put(wordField, valueStr);
                continue block0;
            }
        }
        LOGGER.info("\u5173\u952e\u5b57map" + JSON.toJSONString((Object)map));
        return map;
    }

    private DynamicObject generateNewEntity(DynamicObject formDy, Object conTemplateId) {
        LOGGER.info("generateNewEntity contempDyId={},contempNewId={}", conTemplateId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_relateentity");
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)formDy, (DynamicObject)dynamicObject);
        dynamicObject.set("contempid", conTemplateId);
        Object object = serviceHelper.saveOne(dynamicObject);
        return (DynamicObject)object;
    }

    private String transFieldTypeToStr(DynamicObject dy, String entityField) {
        String fieldValueStr;
        block10: {
            Object fieldValue = dy.get(entityField);
            fieldValueStr = "";
            if (fieldValue instanceof DynamicObject) {
                fieldValueStr = ((DynamicObject)fieldValue).getString("name");
            } else if (fieldValue instanceof DynamicObjectCollection) {
                fieldValueStr = ((DynamicObjectCollection)fieldValue).toString();
            } else if (fieldValue instanceof Date) {
                String pattern = "yyyy-MM-dd";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                fieldValueStr = simpleDateFormat.format((Date)fieldValue);
            } else {
                fieldValueStr = fieldValue instanceof OrmLocaleValue ? ((OrmLocaleValue)fieldValue).getLocaleValue() : (fieldValue instanceof Boolean ? Boolean.toString((Boolean)fieldValue) : (fieldValue instanceof Integer ? ((Integer)fieldValue).toString() : (fieldValue instanceof Long ? ((Long)fieldValue).toString() : (fieldValue instanceof BigDecimal ? ((BigDecimal)fieldValue).setScale(2, RoundingMode.HALF_DOWN).stripTrailingZeros().toPlainString() : (String)fieldValue))));
            }
            if (null == fieldValueStr || "null".equals(fieldValueStr)) {
                fieldValueStr = "";
            }
            DynamicProperty property = null;
            try {
                property = dy.getDynamicObjectType().getProperty(entityField);
                if (property instanceof ComboProp) {
                    ComboProp comboProp = (ComboProp)property;
                    String tmpValue = fieldValueStr;
                    ValueMapItem mapItem = comboProp.getComboItems().stream().filter(item -> tmpValue.equals(item.getValue())).findFirst().get();
                    fieldValueStr = mapItem == null ? fieldValueStr : mapItem.getName().getLocaleValue();
                }
            }
            catch (Exception exception) {
                LOGGER.error("transFieldTypeToStr exception:", (Throwable)exception);
                if (property == null) break block10;
                LOGGER.info("transFieldTypeToStr exception:{}", (Object)property.getClass().getName());
            }
        }
        return fieldValueStr;
    }

    private void processEntityFieldMapping(List<DynamicObject> dyList, DynamicObjectCollection keywordMappingDyColl, Map<String, String> map, Map<String, Object> paramsMap, String mainentity) {
        HashMap cachEntityFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap cachEntityDynamicObjects = Maps.newHashMapWithExpectedSize((int)16);
        Map groupTplConfigByParentId = KeywordMappingServiceHelper.groupTplvariableByParentId();
        Map entityIdFilterConditionMap = KeywordMappingServiceHelper.getEntityIdFilterConditionMap((DynamicObjectCollection)keywordMappingDyColl);
        for (DynamicObject keywordDy : keywordMappingDyColl) {
            String wordField = keywordDy.getString("wordfield");
            String entityNumber = keywordDy.getString("entitynumber");
            if (HRStringUtils.isEmpty((String)entityNumber)) continue;
            Long relateEntityId = keywordDy.getLong("relateentityid");
            String entityField = keywordDy.getString("entityfield");
            String filterCondition = keywordDy.getString("filtercondition");
            String multilang = keywordDy.getString("multlang");
            ArrayList resultValues = Lists.newArrayListWithCapacity((int)16);
            String rootId = KeywordMappingServiceHelper.getRootId((String)mainentity);
            if (relateEntityId.equals(Long.valueOf(rootId)) || "hlcm_contractapplybase".equals(entityNumber)) {
                this.getFieldMap(dyList, map, paramsMap, wordField, entityNumber, entityField, filterCondition, resultValues, "1", rootId, multilang);
                continue;
            }
            ArrayList resultList = Lists.newArrayListWithCapacity((int)16);
            long start = System.currentTimeMillis();
            this.getRelateEntity(dyList, Long.valueOf(rootId), relateEntityId, resultList, filterCondition, keywordMappingDyColl, cachEntityFieldMap, cachEntityDynamicObjects, groupTplConfigByParentId, entityIdFilterConditionMap);
            long end = System.currentTimeMillis();
            LOGGER.info("getRelateEntity task cost: {}.", (Object)(end - start));
            long start2 = System.currentTimeMillis();
            this.getFieldMap(resultList, map, paramsMap, wordField, entityNumber, entityField, filterCondition, resultValues, "2", rootId, multilang);
            long end2 = System.currentTimeMillis();
            LOGGER.info("getFieldMap task cost: {}.", (Object)(end2 - start2));
        }
        String muchflag = map.get("muchflag");
        if (HRStringUtils.isNotEmpty((String)muchflag) && muchflag.contains("\u3001")) {
            String substring = muchflag.substring(0, muchflag.lastIndexOf("\u3001"));
            map.put("muchflag", substring);
        }
    }

    public Map<String, String> getKeyWordReplacedMap(List<DynamicObject> dyList, DynamicObject keywordMappingDy, String mainentity) {
        try {
            long start = System.currentTimeMillis();
            DynamicObjectCollection keywordMappingDyColl = keywordMappingDy.getDynamicObjectCollection("entryentity");
            if (keywordMappingDyColl == null) {
                return new HashMap<String, String>();
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)keywordMappingDyColl.size());
            Map paramsMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("15NPDX/GJFOO", Long.valueOf(RequestContext.get().getOrgId())));
            Object contempid = keywordMappingDy.get("contempid");
            if (Objects.isNull(contempid)) {
                return map;
            }
            this.processEntityFieldMapping(dyList, keywordMappingDyColl, map, paramsMap, mainentity);
            long end = System.currentTimeMillis();
            LOGGER.info("getKeyWordReplacedMap task coast: {}.", (Object)(end - start));
            return map;
        }
        catch (Exception exception) {
            LOGGER.error("getKeyWordReplacedMap error", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }

    public Map<String, String> getKeyWordRepMapWithCust(List<DynamicObject> dyList, DynamicObject keywordMappingDy, String formNumber, Map<String, String> customizeKVs) {
        try {
            long start = System.currentTimeMillis();
            keywordMappingDy = this.updateWordMappingCommonVariable(keywordMappingDy);
            if (keywordMappingDy == null) {
                return new HashMap<String, String>();
            }
            DynamicObjectCollection keywordMappingDyColl = keywordMappingDy.getDynamicObjectCollection("entryentity");
            if (keywordMappingDyColl == null) {
                return new HashMap<String, String>();
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)keywordMappingDyColl.size());
            Map paramsMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("15NPDX/GJFOO", Long.valueOf(RequestContext.get().getOrgId())));
            Object contempid = keywordMappingDy.get("contempid");
            if (Objects.isNull(contempid)) {
                return map;
            }
            DynamicObjectCollection entityFieldCollect = new DynamicObjectCollection();
            DynamicObjectCollection customizeKeyCollect = new DynamicObjectCollection();
            keywordMappingDyColl.forEach(keywordEntry -> {
                String isCustomize = keywordEntry.getString("iscustomize");
                if (HRStringUtils.equals((String)"1", (String)isCustomize)) {
                    customizeKeyCollect.add(keywordEntry);
                } else if (HRStringUtils.isNotEmpty((String)keywordEntry.getString("entitynumber"))) {
                    entityFieldCollect.add(keywordEntry);
                }
            });
            customizeKeyCollect.forEach(customizeDy -> {
                String wordField = customizeDy.getString("wordfield");
                String customizeKey = customizeDy.getString("customizekey");
                String customizeValue = customizeKVs.getOrDefault(customizeKey, "");
                map.put(wordField, customizeValue);
            });
            this.processEntityFieldMapping(dyList, entityFieldCollect, map, paramsMap, formNumber);
            long end = System.currentTimeMillis();
            LOGGER.info("getKeyWordRepMapWithCust task cost: {}.", (Object)(end - start));
            return map;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject updateWordMappingCommonVariable(DynamicObject keywordMappingDy) {
        TXHandle txHandle = TX.requiresNew();
        HRBaseServiceHelper mappingService = new HRBaseServiceHelper("hrcs_keywordmapping");
        DynamicObject keywordMappingDyNew = mappingService.loadSingle(keywordMappingDy.getPkValue());
        try {
            try {
                KeywordMappingServiceHelper.updateMainEntityFilterConditionNew();
            }
            catch (Exception exception) {
                LOGGER.error("updateMainEntityFilterConditionNew error", (Throwable)exception);
            }
            String mainEntity = keywordMappingDyNew.getString("formnumber");
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
            DynamicObjectCollection keywordMappingDyColl = keywordMappingDyNew.getDynamicObjectCollection("entryentity");
            ArrayList tipList = Lists.newArrayListWithCapacity((int)16);
            if (keywordMappingDyColl == null || keywordMappingDyColl.size() == 0) {
                DynamicObject dynamicObject = null;
                return dynamicObject;
            }
            for (DynamicObject entryDynamicObject : keywordMappingDyColl) {
                DynamicObject dynamicObject = entryDynamicObject.getDynamicObject("variableid");
                String wordField = entryDynamicObject.getString("wordfield");
                if (!"hlcm_contracttemplate".equals(mainEntity) && dynamicObject == null) {
                    tipList.add(wordField);
                    continue;
                }
                if (dynamicObject == null) continue;
                DynamicObject commonVarById = KeywordMappingServiceHelper.getCommonVarById((Object)dynamicObject.getPkValue());
                String getValueWay = commonVarById.getString("getvalueway");
                if (HRStringUtils.equals((String)"1", (String)getValueWay)) {
                    entryDynamicObject.set("entitynumber", commonVarById.get("entitynumber"));
                    entryDynamicObject.set("entityfield", commonVarById.get("entityfield"));
                    entryDynamicObject.set("relateentityid", commonVarById.get("relateentityid"));
                    entryDynamicObject.set("iscustomize", (Object)"0");
                    entryDynamicObject.set("filtercondition", commonVarById.get("filtercondition"));
                    continue;
                }
                entryDynamicObject.set("customizekey", commonVarById.get("custkey"));
                entryDynamicObject.set("iscustomize", (Object)"1");
            }
            if (!CollectionUtils.isEmpty((Collection)tipList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e%s\u6a21\u677f\u53d8\u91cf\u7684\u5173\u8054\u5e38\u7528\u53d8\u91cf\u3002", (String)"HRCSKeywordMappingService_3", (String)"hrmp-hrcs-mservice", (Object[])new Object[]{String.join((CharSequence)"\u3001", tipList)}));
            }
            baseServiceHelper.updateOne(keywordMappingDyNew);
        }
        catch (Exception exception) {
            LOGGER.error("updateWordMappingCommonVariable error", (Throwable)exception);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
        }
        return keywordMappingDyNew;
    }

    public CheckVariableResp keyWordCheck(String url, boolean isTempFile) {
        CheckVariableResp checkVariableResp = KeywordMappingServiceHelper.keyWordCheck((String)url, (boolean)isTempFile);
        return checkVariableResp;
    }

    public KeyWordMappingParam matchingVariable(List<String> keywords, String mainEntityNumber) {
        LOGGER.info("matchingVariable keywords={},mainEntityNumber={}", keywords, (Object)mainEntityNumber);
        KeyWordMappingParam mappingParam = KeywordMappingServiceHelper.matchingVariable(keywords, (String)mainEntityNumber);
        return mappingParam;
    }

    public KeyWordMappingParam getKeyWordMapping(String mainEntityNumber, Long mainContempId, Long contempId) {
        LOGGER.info("getKeyWordMapping mainEntityNumber={},mainContempId={},contempId={}", new Object[]{mainEntityNumber, mainContempId, contempId});
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        DynamicObject[] query = baseServiceHelper.query("formnumber,contempmainid,contempid,entryentity.wordfield,entryentity.multlang,entryentity.variableid", new QFilter[]{new QFilter("formnumber", "=", (Object)mainEntityNumber), new QFilter("contempmainid", "=", (Object)mainContempId), new QFilter("contempid", "=", (Object)contempId)});
        if (query.length == 0 && (query = baseServiceHelper.query("formnumber,contempmainid,contempid,entryentity.wordfield,entryentity.multlang,entryentity.variableid", new QFilter[]{new QFilter("contempid", "=", (Object)contempId)})).length == 0 && (contempId == null || contempId == 0L)) {
            query = baseServiceHelper.query("formnumber,contempmainid,contempid,entryentity,entryentity.wordfield,entryentity.multlang,entryentity.variableid", new QFilter[]{new QFilter("formnumber", "=", (Object)mainEntityNumber), new QFilter("contempmainid", "=", (Object)mainContempId)}, "createtime desc");
        }
        KeyWordMappingParam keyWordMappingParam = new KeyWordMappingParam();
        if (query == null || query.length == 0) {
            keyWordMappingParam.setEntryParam(new ArrayList());
            return keyWordMappingParam;
        }
        DynamicObject dataEntity = query[0];
        String formnumber = dataEntity.getString("formnumber");
        Long contempMainId = dataEntity.getLong("contempmainid");
        Long contempVid = dataEntity.getLong("contempid");
        keyWordMappingParam.setMainEntityNumber(formnumber);
        keyWordMappingParam.setContempVid(contempVid);
        keyWordMappingParam.setMainContempId(contempMainId);
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : entryentity) {
            KeyWordMappingEntryParam wordMappingEntryParam = new KeyWordMappingEntryParam();
            String keyWord = dynamicObject.getString("wordfield");
            DynamicObject variable = dynamicObject.getDynamicObject("variableid");
            Long variableId = 0L;
            if (variable != null) {
                variableId = variable.getLong("id");
            }
            String lang = dynamicObject.getString("multlang");
            wordMappingEntryParam.setWordField(keyWord);
            wordMappingEntryParam.setCommonVarId(variableId);
            wordMappingEntryParam.setLang(lang);
            arrayList.add(wordMappingEntryParam);
        }
        keyWordMappingParam.setEntryParam((List)arrayList);
        return keyWordMappingParam;
    }

    public Object saveContempMapping(KeyWordMappingParam keyWordMappingParam) {
        KeywordMappingServiceHelper.saveMainEntity((String)keyWordMappingParam.getMainEntityNumber());
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        DynamicObject dynamicObject = baseServiceHelper.generateEmptyDynamicObject();
        dynamicObject.set("formnumber", (Object)keyWordMappingParam.getMainEntityNumber());
        dynamicObject.set("contempmainid", (Object)keyWordMappingParam.getMainContempId());
        dynamicObject.set("contempid", (Object)keyWordMappingParam.getContempVid());
        List entryParam = keyWordMappingParam.getEntryParam();
        DynamicObjectCollection dynamicObjectCollection = baseServiceHelper.generateEmptyEntryCollection(dynamicObject, "entryentity");
        for (KeyWordMappingEntryParam mappingEntryParam : entryParam) {
            DynamicObject entryDynamicObject = baseServiceHelper.generateEmptyEntryDynamicObject("entryentity");
            entryDynamicObject.set("wordfield", (Object)mappingEntryParam.getWordField());
            entryDynamicObject.set("multlang", (Object)mappingEntryParam.getLang());
            entryDynamicObject.set("variableid", (Object)mappingEntryParam.getCommonVarId());
            DynamicObject commonVarById = KeywordMappingServiceHelper.getCommonVarById((Object)mappingEntryParam.getCommonVarId());
            String getValueWay = commonVarById.getString("getvalueway");
            if (HRStringUtils.equals((String)"1", (String)getValueWay)) {
                entryDynamicObject.set("entitynumber", commonVarById.get("entitynumber"));
                entryDynamicObject.set("entityfield", commonVarById.get("entityfield"));
                entryDynamicObject.set("relateentityid", commonVarById.get("relateentityid"));
                entryDynamicObject.set("iscustomize", (Object)"0");
                entryDynamicObject.set("filtercondition", commonVarById.get("filtercondition"));
            } else {
                entryDynamicObject.set("customizekey", commonVarById.get("custkey"));
                entryDynamicObject.set("iscustomize", (Object)"1");
            }
            dynamicObjectCollection.add((Object)entryDynamicObject);
        }
        return baseServiceHelper.saveOne(dynamicObject);
    }

    public int deleteContempMapping(String mainEntityNumber, Long mainContempId, Long contempId) {
        LOGGER.info("deleteContempMapping mainEntityNumber={},mainContempId={},contempId={}", new Object[]{mainEntityNumber, mainContempId, contempId});
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_keywordmapping");
        if (contempId == null || contempId == 0L) {
            return baseServiceHelper.deleteByFilter(new QFilter[]{new QFilter("formnumber", "=", (Object)mainEntityNumber), new QFilter("contempmainid", "=", (Object)mainContempId)});
        }
        return baseServiceHelper.deleteByFilter(new QFilter[]{new QFilter("formnumber", "=", (Object)mainEntityNumber), new QFilter("contempid", "=", (Object)contempId)});
    }

    private void getFieldMap(List<DynamicObject> dyList, Map<String, String> map, Map<String, Object> paramsMap, String wordField, String entityNumber, String entityField, String filterCondition, ArrayList<String> resultValues, String maingEntityFlag, String rootId, String multLang) {
        for (int i = 0; i < dyList.size(); ++i) {
            this.getFieldValue(entityNumber, dyList.get(i), entityField, filterCondition, entityField.split("\\."), i, resultValues, maingEntityFlag, rootId, multLang);
        }
        if (resultValues.size() == 0) {
            map.put(wordField, "");
            return;
        }
        this.setWordFieldMapValue(map, paramsMap, wordField, resultValues);
    }

    private void setWordFieldMapValue(Map<String, String> map, Map<String, Object> paramsMap, String wordField, ArrayList<String> resultValues) {
        resultValues.removeIf(HRStringUtils::isEmpty);
        String muchflag = map.getOrDefault("muchflag", "");
        if (resultValues.size() > 1) {
            if (paramsMap != null && ObjectUtils.isNotEmpty((Object)paramsMap.get("replaceconfig"))) {
                String replaceconfig = (String)paramsMap.get("replaceconfig");
                if (HRStringUtils.equals((String)"1", (String)replaceconfig)) {
                    map.put(wordField, StringUtils.join(resultValues, (String)"\u3001"));
                } else {
                    map.put(wordField, "");
                }
            } else {
                map.put(wordField, "");
            }
            map.put("muchflag", muchflag + wordField + "\u3001");
        } else if (resultValues.size() == 1) {
            map.put(wordField, resultValues.get(0));
        } else {
            map.put(wordField, "");
        }
    }

    private List<DynamicObject> getRelateEntity2(List<DynamicObject> dyList, DynamicObject relateEntityDy, String mainentity, String entityNumber, List<DynamicObject> resultList) {
        DynamicObjectCollection entityMappingConfig = relateEntityDy.getDynamicObjectCollection("entitymappingconfig");
        for (DynamicObject dy : entityMappingConfig) {
            if (!dy.getDynamicObject("parententity").getString("number").equals(mainentity)) continue;
            String number = dy.getDynamicObject("entity").getString("number");
            DynamicObjectCollection subentryentity = dy.getDynamicObjectCollection("subentryentity");
            ArrayList qFilters = Lists.newArrayListWithCapacity((int)16);
            ArrayList leftEntitys = Lists.newArrayListWithCapacity((int)16);
            for (DynamicObject dyEntity : dyList) {
                DynamicObject[] ids;
                for (DynamicObject relateEntityField : subentryentity) {
                    String parentField = relateEntityField.getString("parententityfield");
                    String field = relateEntityField.getString("entityfield");
                    qFilters.add(new QFilter(field, "=", dyEntity.get(parentField)));
                }
                for (DynamicObject id : ids = BusinessDataServiceHelper.load((String)number, (String)"id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]))) {
                    leftEntitys.add(BusinessDataServiceHelper.loadSingle((Object)id.get("id"), (String)number));
                }
            }
            if (number.equals(entityNumber)) {
                resultList.addAll(leftEntitys);
                return resultList;
            }
            this.getRelateEntity2(leftEntitys, relateEntityDy, number, entityNumber, resultList);
        }
        return resultList;
    }

    private List<DynamicObject> getRelateEntity(List<DynamicObject> dyList, Long parentId, long entityId, List<DynamicObject> resultList, String filterCondition, DynamicObjectCollection keywordMappingDyColl, HashMap<Long, String> cachEntityFieldMap, HashMap<Long, List<DynamicObject>> cachEntityDynamicObjects, Map<Long, List<DynamicObject>> groupTplConfigByParentId, Map<Long, String> entityIdFilterConditionMap) {
        LOGGER.info("parentId:{},entityId:{}", (Object)parentId, (Object)entityId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
        List<DynamicObject> relateEntity = groupTplConfigByParentId.get(parentId);
        if (CollectionUtils.isEmpty(relateEntity)) {
            return resultList;
        }
        int i = 0;
        for (DynamicObject dynamicObject : relateEntity) {
            try {
                String number;
                long pkValue = (Long)dynamicObject.getPkValue();
                if (cachEntityDynamicObjects.containsKey(pkValue)) {
                    List<DynamicObject> leftEntitys = cachEntityDynamicObjects.get(pkValue);
                    if (pkValue == entityId) {
                        resultList.addAll(leftEntitys);
                        return resultList;
                    }
                    this.getRelateEntity(leftEntitys, (Long)dynamicObject.getPkValue(), entityId, resultList, filterCondition, keywordMappingDyColl, cachEntityFieldMap, cachEntityDynamicObjects, groupTplConfigByParentId, entityIdFilterConditionMap);
                    continue;
                }
                ArrayList qFilters = Lists.newArrayListWithCapacity((int)16);
                String isEntry = dynamicObject.getString("isentry");
                if (HRStringUtils.isNotEmpty((String)filterCondition)) {
                    Map conditionMap = (Map)SerializationUtils.fromJsonString((String)filterCondition, Map.class);
                    for (Map.Entry entry : conditionMap.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = SerializationUtils.toJsonString(entry.getValue());
                        if (pkValue != Long.parseLong(key)) continue;
                        QFilter qFilter = HRStringUtils.equals((String)"1", (String)isEntry) ? HRCSKeywordMappingService.convertJsonToQFilter(dynamicObject.getDynamicObject("parententity").getString("number"), value) : HRCSKeywordMappingService.convertJsonToQFilter(dynamicObject.getDynamicObject("sonentity").getString("number"), value);
                        qFilters.add(qFilter);
                    }
                }
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                String rule = dynamicObject.getString("rule");
                ArrayList leftEntitys = Lists.newArrayListWithCapacity((int)16);
                if (HRStringUtils.equals((String)"1", (String)isEntry)) {
                    number = dynamicObject.getDynamicObject("parententity").getString("number");
                    String entryNumber = dynamicObject.getString("entrynumber");
                    String[] split = entryNumber.split("\\.");
                    Object entryField = split[1];
                    QFilter qFilter = null;
                    if (HRStringUtils.isNotEmpty((String)rule)) {
                        qFilter = HRCSKeywordMappingService.convertJsonToQFilter(number, rule);
                        qFilters.add(qFilter);
                    }
                    List collect = dyList.stream().map(item -> item.getPkValue()).collect(Collectors.toList());
                    QFilter entityQfilter = new QFilter("id", "in", collect);
                    qFilters.add(entityQfilter);
                    ArrayList entryIds = Lists.newArrayListWithCapacity((int)16);
                    HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(number);
                    LOGGER.info("queryDataSet1 qFilters{}", (Object)qFilters.toString());
                    DataSet filterEntity = hrBaseServiceHelper.queryDataSet(number + i, "id," + (String)entryField, qFilters.toArray(new QFilter[qFilters.size()]));
                    while (filterEntity.hasNext()) {
                        Row next = filterEntity.next();
                        long entryId = (Long)next.get((String)entryField);
                        entryIds.add(entryId);
                    }
                    long start = System.currentTimeMillis();
                    for (DynamicObject dyEntity : dyList) {
                        DynamicObjectCollection entryColl = dyEntity.getDynamicObjectCollection((String)entryField);
                        Iterator iterator = entryColl.iterator();
                        while (iterator.hasNext()) {
                            DynamicObject next = (DynamicObject)iterator.next();
                            long id = (Long)next.getPkValue();
                            LOGGER.info("Row next ID1:{},number1:{}", (Object)id, (Object)number);
                            if (entryIds.contains(id)) continue;
                            iterator.remove();
                        }
                        leftEntitys.add(dyEntity);
                    }
                    long end = System.currentTimeMillis();
                    LOGGER.info("loop filterEntry task coast: {}.", (Object)(end - start));
                } else {
                    number = dynamicObject.getDynamicObject("sonentity").getString("number");
                    QFilter qFilter = null;
                    if (HRStringUtils.isNotEmpty((String)rule)) {
                        qFilter = HRCSKeywordMappingService.convertJsonToQFilter(number, rule);
                        qFilters.add(qFilter);
                    }
                    for (DynamicObject object : dynamicObjectCollection) {
                        String parentField = object.getString("parentfield");
                        String field = object.getString("sonfield");
                        List collect = dyList.stream().map(item -> item.get(parentField)).collect(Collectors.toList());
                        qFilters.add(new QFilter(field, "in", collect));
                    }
                    HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(number);
                    HashSet currentFields = Sets.newHashSetWithExpectedSize((int)16);
                    this.getCurrentField(keywordMappingDyColl, serviceHelper, dynamicObject, qFilters, leftEntitys, hrBaseServiceHelper, currentFields, cachEntityFieldMap, groupTplConfigByParentId);
                }
                ++i;
                if (pkValue == entityId) {
                    resultList.addAll(leftEntitys);
                    return resultList;
                }
                this.getRelateEntity(leftEntitys, (Long)dynamicObject.getPkValue(), entityId, resultList, filterCondition, keywordMappingDyColl, cachEntityFieldMap, cachEntityDynamicObjects, groupTplConfigByParentId, entityIdFilterConditionMap);
            }
            catch (Exception exception) {
                LOGGER.error("getRelateEntity error", (Throwable)exception);
            }
        }
        return resultList;
    }

    private void getCurrentField(DynamicObjectCollection keywordMappingDyColl, HRBaseServiceHelper serviceHelper, DynamicObject dynamicObject, ArrayList<QFilter> qFilters, ArrayList<DynamicObject> leftEntitys, HRBaseServiceHelper hrBaseServiceHelper, Set<String> currentFields, HashMap<Long, String> cachEntityFieldMap, Map<Long, List<DynamicObject>> groupTplConfigByParentId) {
        String fieldStr = "";
        if (!cachEntityFieldMap.containsKey(dynamicObject.getPkValue())) {
            List<DynamicObject> currentSonEntityArr = groupTplConfigByParentId.get((Long)dynamicObject.getPkValue());
            if (currentSonEntityArr != null && currentSonEntityArr.size() > 0) {
                for (DynamicObject currentSonEntity : currentSonEntityArr) {
                    String isEntry = currentSonEntity.getString("isentry");
                    if (HRStringUtils.equals((String)"1", (String)isEntry)) {
                        String entryNumber = currentSonEntity.getString("entrynumber");
                        String[] split = entryNumber.split("\\.");
                        String entryField = split[1];
                        currentFields.add(entryField);
                    }
                    DynamicObjectCollection currentSonEntityFieldColl = currentSonEntity.getDynamicObjectCollection("entryentity");
                    for (DynamicObject currentSonEntityField : currentSonEntityFieldColl) {
                        String currSonEntityParentField = currentSonEntityField.getString("parentfield");
                        currentFields.add(currSonEntityParentField);
                    }
                }
            }
            for (DynamicObject keywordMapping : keywordMappingDyColl) {
                DynamicObject relateDy;
                long relateEntityId = keywordMapping.getLong("relateentityid");
                if (relateEntityId == 0L) continue;
                String entityField = keywordMapping.getString("entityfield");
                if (relateEntityId == (Long)dynamicObject.getPkValue()) {
                    currentFields.add(entityField);
                }
                if ((relateDy = serviceHelper.queryOne((Object)relateEntityId)) == null) continue;
                String isEntry = relateDy.getString("isentry");
                long parentid = relateDy.getLong("parentid");
                if (parentid != (Long)dynamicObject.getPkValue() || !HRStringUtils.equals((String)"1", (String)isEntry)) continue;
                String[] split = entityField.split("\\.");
                if (split.length >= 3) {
                    currentFields.add(split[0] + "." + split[1]);
                }
                currentFields.add(entityField);
            }
            fieldStr = HRCSListUtils.join(currentFields, (String)",");
            cachEntityFieldMap.put((Long)dynamicObject.getPkValue(), fieldStr);
        } else {
            fieldStr = cachEntityFieldMap.get(dynamicObject.getPkValue());
        }
        LOGGER.info("queryDataSet2 join={}", (Object)fieldStr);
        LOGGER.info("queryDataSet2 qFilters={}", (Object)qFilters.toString());
        DynamicObject[] query = hrBaseServiceHelper.query(fieldStr, qFilters.toArray(new QFilter[0]));
        leftEntitys.addAll(Arrays.asList(query));
    }

    private String getObject2String(DynamicObject dy, String entityField, Object fieldValue, String targetField, String multLang) {
        String fieldValueStr;
        block33: {
            String number;
            fieldValueStr = "";
            if (fieldValue instanceof DynamicObject) {
                fieldValueStr = ((DynamicObject)fieldValue).getString("name");
            } else if (fieldValue instanceof List) {
                fieldValueStr = fieldValue.toString();
            } else if (fieldValue instanceof Date) {
                number = dy.getDataEntityType().getName();
                String pattern = fieldCach.get(number + "." + targetField);
                if (HRStringUtils.isEmpty((String)pattern)) {
                    pattern = EContractServiceHelper.getTimeMask((String)number, (String)targetField);
                    fieldCach.put(number + "." + targetField, pattern);
                }
                pattern = HRStringUtils.isEmpty((String)pattern) ? "yyyy-MM-dd" : pattern.replace("YYYY", "yyyy").replace("DD", "dd");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                fieldValueStr = simpleDateFormat.format((Date)fieldValue);
            } else if (fieldValue instanceof OrmLocaleValue) {
                if (HRStringUtils.isEmpty((String)multLang)) {
                    fieldValueStr = ((OrmLocaleValue)fieldValue).getLocaleValue();
                } else {
                    try {
                        fieldValueStr = ((OrmLocaleValue)fieldValue).get((Object)multLang);
                    }
                    catch (Exception exception) {
                        fieldValueStr = ((OrmLocaleValue)fieldValue).getLocaleValue();
                    }
                }
            } else if (fieldValue instanceof Boolean) {
                fieldValueStr = Boolean.toString((Boolean)fieldValue);
            } else if (fieldValue instanceof Integer) {
                Integer value = (Integer)fieldValue;
                String number2 = dy.getDataEntityType().getName();
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)dy.getDataEntityType().getProperties().get((Object)targetField);
                if (iDataEntityProperty instanceof TimeProp) {
                    if (value == -1) {
                        return "";
                    }
                    String pattern = fieldCach.get(number2 + "." + targetField);
                    if (HRStringUtils.isEmpty((String)pattern)) {
                        pattern = EContractServiceHelper.getTimeMask((String)number2, (String)targetField);
                        fieldCach.put(number2 + "." + targetField, pattern);
                    }
                    if (HRStringUtils.isEmpty((String)pattern)) {
                        pattern = ResManager.loadKDString((String)"HH\u65f6mm\u5206ss\u79d2", (String)"HRCSKeywordMappingService_0", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]);
                    }
                    int hh = value / 3600;
                    int mm = (value - hh * 60 * 60) / 60;
                    int ss = value - hh * 60 * 60 - mm * 60;
                    fieldValueStr = this.getFormatTimeValue(hh, mm, ss, pattern);
                } else {
                    fieldValueStr = ((Integer)fieldValue).toString();
                }
            } else if (fieldValue instanceof Long) {
                fieldValueStr = ((Long)fieldValue).toString();
            } else if (fieldValue instanceof BigDecimal) {
                number = dy.getDataEntityType().getName();
                DynamicProperty property = EntityMetadataCache.getDataEntityType((String)number).getProperty(targetField);
                if (property instanceof AmountProp) {
                    HRBaseServiceHelper hrBaseServiceHelper;
                    DynamicObject dynamicObject;
                    DynamicObject currency;
                    AmountProp amountfield = (AmountProp)property;
                    String controlPropName = amountfield.getControlPropName();
                    int amtPrecision = 2;
                    if (HRStringUtils.isNotEmpty((String)controlPropName) && (currency = (dynamicObject = (hrBaseServiceHelper = new HRBaseServiceHelper(number)).queryOne(controlPropName, dy.getPkValue())).getDynamicObject(controlPropName)) != null) {
                        amtPrecision = (Integer)currency.get("amtprecision");
                    }
                    fieldValueStr = ((BigDecimal)fieldValue).setScale(amtPrecision, RoundingMode.HALF_DOWN).toPlainString();
                } else {
                    fieldValueStr = ((BigDecimal)fieldValue).setScale(2, RoundingMode.HALF_DOWN).stripTrailingZeros().toPlainString();
                }
            } else {
                fieldValueStr = (String)fieldValue;
            }
            if (null == fieldValueStr || "null".equals(fieldValueStr)) {
                fieldValueStr = "";
            }
            DynamicProperty property = null;
            try {
                property = dy.getDynamicObjectType().getProperty(entityField);
                if (property instanceof ComboProp) {
                    ComboProp comboProp = (ComboProp)property;
                    String tmpValue = fieldValueStr;
                    ValueMapItem mapItem = comboProp.getComboItems().stream().filter(item -> tmpValue.equals(item.getValue())).findFirst().get();
                    fieldValueStr = mapItem == null ? fieldValueStr : mapItem.getName().getLocaleValue();
                }
            }
            catch (Exception exception) {
                LOGGER.error("transFieldTypeToStr exception:", (Throwable)exception);
                if (property == null) break block33;
                LOGGER.info("transFieldTypeToStr exception:{}", (Object)property.getClass().getName());
            }
        }
        return fieldValueStr;
    }

    private String getFormatTimeValue(int hh, int mm, int ss, String pattern) {
        String hhStr = "";
        String mmStr = "";
        String ssStr = "";
        hhStr = hh < 10 ? "0" + hh : hh + "";
        mmStr = mm < 10 ? "0" + mm : mm + "";
        ssStr = ss < 10 ? "0" + ss : ss + "";
        String replace = pattern.replace("HH", hhStr).replace("mm", mmStr).replace("ss", ssStr);
        if (replace.contains("a")) {
            replace = hh < 12 ? replace.replace("a", ResManager.loadKDString((String)"\u4e0a\u5348", (String)"HRCSKeywordMappingService_1", (String)"hrmp-hrcs-mservice", (Object[])new Object[0])) : replace.replace("a", ResManager.loadKDString((String)"\u4e0b\u5348", (String)"HRCSKeywordMappingService_2", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]));
        }
        return replace;
    }

    private static QFilter convertJsonToQFilter(String entityId, String dataRuleJson) {
        if (HRStringUtils.isEmpty((String)dataRuleJson)) {
            return null;
        }
        return HRPermCommonUtil.getQFilterFromFilterCondition((String)entityId, (String)dataRuleJson);
    }

    private ArrayList<String> getFieldValue(String entityNumber, DynamicObject entity, String entityField, String filterCondition, String[] split, int i, ArrayList<String> resultList, String maingEntityFlag, String rootId, String multLang) {
        if (split.length < 1) {
            return null;
        }
        LOGGER.info("entityNumber:{},entityField:{}", (Object)entityNumber, (Object)entityField);
        if ("1".equals(maingEntityFlag)) {
            QFilter qFilter = null;
            if (HRStringUtils.isNotEmpty((String)filterCondition)) {
                Map conditionMap = (Map)SerializationUtils.fromJsonString((String)filterCondition, Map.class);
                String condition = SerializationUtils.toJsonString(conditionMap.get(rootId));
                if (HRStringUtils.isEmpty((String)condition)) {
                    return null;
                }
                qFilter = HRCSKeywordMappingService.convertJsonToQFilter(entityNumber, condition);
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
            if (qFilter != null) {
                DataSet filterEntity = hrBaseServiceHelper.queryDataSet("entityNumber" + i, entityField, new QFilter[]{qFilter, new QFilter("id", "=", (Object)entity.getLong("id"))});
                while (filterEntity.hasNext()) {
                    Row next = filterEntity.next();
                    Object result = next.get(entityField);
                    String strValue = this.getObject2String(entity, entityField, result, entityField, multLang);
                    resultList.add(strValue);
                }
            } else if (this.getMappingFiledValue(entityNumber, entity, entityField, split, resultList, multLang)) {
                return resultList;
            }
        } else if (this.getMappingFiledValue(entityNumber, entity, entityField, split, resultList, multLang)) {
            return resultList;
        }
        return resultList;
    }

    private boolean getMappingFiledValue(String entityNumber, DynamicObject entity, String entityField, String[] split, ArrayList<String> resultList, String multLang) {
        int index = 0;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)split[index]);
        if (split.length - 1 == index) {
            if (iDataEntityProperty instanceof EntryProp) {
                DynamicObjectCollection collection = entity.getDynamicObjectCollection(split[index]);
                if (collection == null) {
                    return true;
                }
                String strValue = this.getObject2String(entity, split[index], collection, split[index], multLang);
                resultList.add(strValue);
            } else if (iDataEntityProperty instanceof BasedataProp) {
                DynamicObject dynamicObject = entity.getDynamicObject(split[index]);
                if (dynamicObject == null) {
                    return true;
                }
                String strValue = this.getObject2String(entity, split[index], dynamicObject, split[index], multLang);
                resultList.add(strValue);
            } else {
                Object result = entity.get(split[index]);
                if (result == null) {
                    return true;
                }
                String strValue = this.getObject2String(entity, split[index], result, split[index], multLang);
                resultList.add(strValue);
            }
        } else if (iDataEntityProperty instanceof EntryProp) {
            DynamicObjectCollection collection = entity.getDynamicObjectCollection(split[index]);
            if (collection == null) {
                return true;
            }
            this.entryEntity(split, index, collection, resultList, iDataEntityProperty, multLang);
        } else if (iDataEntityProperty instanceof BasedataProp) {
            LOGGER.info("split:{},field:{},fieldvalue:{}", new Object[]{split, split[index], entity.get(split[index])});
            DynamicObject dynamicObject = entity.getDynamicObject(split[index]);
            if (dynamicObject == null) {
                return true;
            }
            this.baseDataEntity(split, index, dynamicObject, resultList, iDataEntityProperty, multLang);
        }
        return false;
    }

    private void entryEntity(String[] split, int index, DynamicObjectCollection collection, ArrayList<String> resultList, IDataEntityProperty iDataEntityProperty, String multLang) {
        block6: {
            DynamicProperty property;
            block7: {
                block5: {
                    if (split.length - 1 != ++index) break block5;
                    for (DynamicObject dynamicObject : collection) {
                        Object value = dynamicObject.get(split[index]);
                        String strValue = this.getObject2String(dynamicObject, split[index], value, split[index], multLang);
                        resultList.add(strValue);
                    }
                    break block6;
                }
                DynamicObjectType dynamicCollectionItemPropertyType = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType();
                property = dynamicCollectionItemPropertyType.getProperty(split[index]);
                if (!(property instanceof EntryProp)) break block7;
                for (DynamicObject dynamicObject : collection) {
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(split[index]);
                    if (dynamicObjectCollection == null) {
                        return;
                    }
                    this.entryEntity(split, index, dynamicObjectCollection, resultList, (IDataEntityProperty)property, multLang);
                }
                break block6;
            }
            if (!(property instanceof BasedataProp)) break block6;
            for (DynamicObject dynamicObject : collection) {
                DynamicObject subDynamicObject = dynamicObject.getDynamicObject(split[index]);
                if (subDynamicObject == null) {
                    return;
                }
                this.baseDataEntity(split, index, subDynamicObject, resultList, (IDataEntityProperty)property, multLang);
            }
        }
    }

    private void baseDataEntity(String[] split, int index, DynamicObject dynamicObject, ArrayList<String> resultList, IDataEntityProperty iDataEntityProperty, String multLang) {
        if (split.length - 1 == ++index) {
            Object value = dynamicObject.get(split[index]);
            if (value == null) {
                return;
            }
            String strValue = this.getObject2String(dynamicObject, split[index], value, split[index], multLang);
            resultList.add(strValue);
        } else {
            String baseEntityId = ((BasedataProp)iDataEntityProperty).getBaseEntityId();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            IDataEntityProperty subEntityProperty = (IDataEntityProperty)properties.get((Object)split[index]);
            if (subEntityProperty instanceof EntryProp) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(split[index]);
                if (dynamicObjectCollection == null) {
                    return;
                }
                this.entryEntity(split, index, dynamicObjectCollection, resultList, subEntityProperty, multLang);
            } else if (subEntityProperty instanceof BasedataProp) {
                DynamicObject subDynamicObject = dynamicObject.getDynamicObject(split[index]);
                if (subDynamicObject == null) {
                    return;
                }
                this.baseDataEntity(split, index, subDynamicObject, resultList, subEntityProperty, multLang);
            }
        }
    }
}

