/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hrcs.bussiness.service.ProjStrategyServiceHelper;
import kd.hr.hrcs.bussiness.strategy.StrategyApiServiceHelper;
import kd.hr.hrcs.mservice.api.IHRCSProjStrategyService;

public class HRCSProjStrategyService
implements IHRCSProjStrategyService {
    private static final Log LOGGER = LogFactory.getLog(HRCSProjStrategyService.class);

    public HRMServiceResult addStrategyByProjectTeam(List<Long> projectTeamList) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        if (CollectionUtils.isEmpty(projectTeamList)) {
            result.setSuccess(false);
            result.setMessage("addStrategyByProjectTeam() projectTeamList is empty.");
            LOGGER.info(result.getMessage());
            return result;
        }
        try (TXHandle txHandle = TX.required();){
            ProjStrategyServiceHelper.addStrategyByProjectTeam(projectTeamList, (String)"hrcs_projempstrategy", (boolean)true);
            ProjStrategyServiceHelper.addStrategyByProjectTeam(projectTeamList, (String)"hrcs_projorgstrategy", (boolean)true);
        }
        return result;
    }

    public HRMServiceResult enableStrategy(List<Long> projectTeamIds) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        if (CollectionUtils.isEmpty(projectTeamIds)) {
            result.setSuccess(false);
            result.setMessage("enableStrategy() adminOrgIds is empty.");
            LOGGER.info(result.getMessage());
            return result;
        }
        LOGGER.info("enableStrategy() projectTeamIds:{}", projectTeamIds);
        try (TXHandle txHandle = TX.required();){
            ProjStrategyServiceHelper.enableStrategyByProjectTeamIds(projectTeamIds);
        }
        LOGGER.info("enableStrategy() result:{}", (Object)result.getMessage());
        return result;
    }

    public HRMServiceResult disableStrategy(List<Long> projectTeamIds) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        if (CollectionUtils.isEmpty(projectTeamIds)) {
            result.setSuccess(false);
            result.setMessage("disableStrategy() adminOrgIds is empty.");
            LOGGER.info(result.getMessage());
            return result;
        }
        LOGGER.info("disableStrategy() projectTeamIds:{}", projectTeamIds);
        try (TXHandle txHandle = TX.required();){
            ProjStrategyServiceHelper.disableStrategyByProjectTeamIds(projectTeamIds);
        }
        LOGGER.info("disableStrategy() result:{}", (Object)result.getMessage());
        return result;
    }

    public List<Map<String, Long>> getHrBuByBusinessType(Map<Long, Set<Long>> projTeamIds2BusinessType, Long businessObjectId) {
        return ProjStrategyServiceHelper.getHrBuByBusinessType(projTeamIds2BusinessType, (Long)businessObjectId);
    }

    public HRMServiceResult updateStrategyByProjectTeam(List<Map<String, Object>> params) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        if (CollectionUtils.isEmpty(params)) {
            result.setSuccess(false);
            result.setMessage("updateStrategyByProjectTeam() adminOrgIds is empty.");
            LOGGER.info(result.getMessage());
            return result;
        }
        LOGGER.info("updateStrategyByProjectTeam() params:{}", params);
        try (TXHandle txHandle = TX.required();){
            ProjStrategyServiceHelper.batchModifyProjStrategyByOrg(params);
        }
        LOGGER.info("updateStrategyByProjectTeam() result:{}", (Object)result.getMessage());
        return result;
    }
}

