/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hrcs.bussiness.service.StrategyServiceHelper;
import kd.hr.hrcs.bussiness.strategy.StrategyApiServiceHelper;
import kd.hr.hrcs.mservice.api.IHRCSStrategyService;

public class HRCSStrategyService
implements IHRCSStrategyService {
    private static final Log LOG = LogFactory.getLog(HRCSStrategyService.class);
    private static ExecutorService executorService = ThreadPools.newExecutorService((String)"HRCSStrategyService.threadpool", (int)5);

    public HRMServiceResult enableStrategy(List<Long> orgIds) {
        return StrategyServiceHelper.enableOrgStrategyByOrgTwice(orgIds);
    }

    public HRMServiceResult disableStrategy(List<Long> orgIdList) {
        return StrategyServiceHelper.disableStrategyByOrg(orgIdList);
    }

    public HRMServiceResult synStrategyAfterOrgChangedPassCompany(List<Map<Long, DynamicObject>> list) {
        return StrategyServiceHelper.synStrategyAfterOrgChangedPassCompany(list);
    }

    public Map<String, Object> getHrbuFromManageEmpStrategy(Long orgId, Long personId, Long bussinessField, Long perGroupId) {
        return StrategyServiceHelper.getHrbuFromManageEmpStrategy((Long)orgId, (Long)personId, (Long)bussinessField, (Long)perGroupId);
    }

    public Map<String, Object> getHRBUFromManageOrgStrategy(Long orgId, Long bussinessField) {
        return StrategyServiceHelper.getHRBUFromManageOrgStrategy((Long)orgId, (Long)bussinessField);
    }

    public HRMServiceResult addStrategyByNewOrg(List<DynamicObject> orgDyList) {
        return StrategyServiceHelper.enableOrgStrategyByOrg(orgDyList);
    }

    public HRMServiceResult handleAdminOrgStrategyEntry(Long orgteamId, Long parentOrgteamId) {
        return StrategyServiceHelper.handleJuniorAdminOrgStragyByParentOrgId((Long)orgteamId, (Long)parentOrgteamId);
    }

    public HRMServiceResult batchModifyStrategyByOrg(List<Map<String, Object>> params) {
        return StrategyApiServiceHelper.batchModifyStrategyByOrg(params);
    }

    public List<Map<String, Long>> getHrBuByBusinessType(Map<Long, Set<Long>> orgId2BusinessType, Long businessObjectId) {
        int partition = 1000;
        if (orgId2BusinessType.size() > partition) {
            List<Map<String, Long>> result = Collections.synchronizedList(Lists.newArrayListWithExpectedSize((int)orgId2BusinessType.size()));
            List partitionList = Lists.partition(new ArrayList<Long>(orgId2BusinessType.keySet()), (int)partition);
            RequestContext requestContext = RequestContext.get();
            partitionList.parallelStream().forEach(list -> this.futureGet(executorService.submit(() -> {
                RequestContext.copyAndSet((RequestContext)requestContext);
                result.addAll(StrategyApiServiceHelper.getHrBuByBusinessType(list.stream().collect(Collectors.toMap(Function.identity(), orgId2BusinessType::get)), (Long)businessObjectId));
            })));
            return result;
        }
        return StrategyApiServiceHelper.getHrBuByBusinessType(orgId2BusinessType, (Long)businessObjectId);
    }

    public Map<Long, Set<Long>> judgeStrategyExist4HrBu(Map<Long, Set<Long>> hrBuAndBusinessTypes) {
        return StrategyApiServiceHelper.judgeStrategyExist4HrBu(hrBuAndBusinessTypes);
    }

    private <T> T futureGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            LOG.warn("HRCSStrategyService--futureGet() error:", (Throwable)exception);
            return null;
        }
    }
}

