/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.webapi.econtract;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.ECPersonAuthRecordService;
import kd.hr.hrcs.bussiness.service.econtract.EContNotifyService;
import kd.hr.hrcs.webapi.econtract.AbstractContractApiPlugin;
import kd.hr.hrcs.webapi.econtract.EContApiResult;

public class FaceAuthNotifyApiPlugin
extends AbstractContractApiPlugin {
    private static final Log LOGGER = LogFactory.getLog(FaceAuthNotifyApiPlugin.class);

    @Override
    String interfaceName() {
        return "hrPersonVerifyNotify";
    }

    @Override
    String uniqueKey(Map<String, Object> data) {
        return (String)data.get("userId");
    }

    @Override
    protected ApiResult doBusiness(Map<String, Object> data) {
        LOGGER.info("kd-contract-api-faceauthnotify params{}", data);
        String userId = (String)data.get("userId");
        String resultCode = (String)data.get("resultCode");
        String resultDesc = (String)data.get("resultDesc");
        LOGGER.info("kd-contract-api-faceauthnotify userid:{} resultCode\uff1a{},resultDesc:{}", new Object[]{userId, resultCode, resultDesc});
        if ("1".equals(resultCode)) {
            DynamicObject userInfo = ECPersonAuthRecordService.queryUserInfo((String)userId);
            ECPersonAuthRecordService.authSuccess((DynamicObject)userInfo);
            this.notifyBiz(userInfo);
        }
        return EContApiResult.success(null);
    }

    private void notifyBiz(DynamicObject userInfo) {
        String cloud = userInfo.getString("cloud");
        String appNum = userInfo.getString("appnum");
        if (this.strIsEmpty(cloud) || this.strIsEmpty(appNum)) {
            return;
        }
        String servName = EContNotifyService.queryAuthNotifyServName((String)cloud, (String)appNum);
        if (this.strIsEmpty(servName)) {
            return;
        }
        Long naturalId = userInfo.getLong("personid.id");
        Long candidateId = userInfo.getLong("hcfperid.id");
        LOGGER.info("kd-contract-api-faceauthnotify to notify biz cloud:{}, appNum:{}, servName{}, naturalId{} candidateId{}", new Object[]{cloud, appNum, servName, naturalId, candidateId});
        try {
            HRMServiceHelper.invokeBizService((String)cloud, (String)appNum, (String)servName, (String)"authNotify", (Object[])new Object[]{naturalId, candidateId});
        }
        catch (Exception e) {
            LOGGER.info("kd-contract-api-faceauthnotify to notify biz err {}", (Object)e.getMessage());
        }
    }
}

