/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.activity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivitySchemeServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityTreeServiceHelper;

public class BaseActivityTreeListPlugin
extends StandardTreeListPlugin
implements TreeNodeQueryListener {
    private ActivityTreeServiceHelper treeHelper;

    public void initialize() {
        super.initialize();
        this.getPageCache().put("customfilter", SerializationUtils.toJsonString(new ArrayList()));
        TreeView treeView = this.getTreeView();
        if (null != treeView) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
            this.treeHelper = new ActivityTreeServiceHelper(treeView);
            treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (null != this.treeHelper) {
            this.treeHelper.reBuildWholeTree();
        }
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        String leftTreeQFilterJson = this.getPageCache().get("lefttree_qfilter_json");
        if (HRStringUtils.isNotEmpty((String)leftTreeQFilterJson)) {
            evt.getQFilters().add(QFilter.fromSerializedString((String)leftTreeQFilterJson));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String nodeId = (String)treeNodeEvent.getNodeId();
        String parentNodeId = (String)treeNodeEvent.getParentNodeId();
        TreeView leftTree = (TreeView)treeNodeEvent.getSource();
        String id = String.valueOf(nodeId);
        if (HRStringUtils.equals((String)"1010", (String)id)) {
            this.getPageCache().remove("lefttree_qfilter_json");
            return;
        }
        String[] idArr = id.split("_split_");
        if (idArr.length < 2) {
            TreeNode rootNode = new TreeNode();
            rootNode.setId("1010");
            leftTree.focusNode(rootNode);
            return;
        }
        String nodeIdPrefix = idArr[0];
        String trueId = idArr[1];
        List<Object> appIdList = Lists.newArrayListWithCapacity((int)16);
        if (HRStringUtils.equals((String)"1", (String)nodeIdPrefix)) {
            appIdList = ActivitySchemeServiceHelper.getAppByHbssCloudId((String)trueId);
            leftTree.queryTreeNodeChildren(parentNodeId, nodeId);
        } else if (HRStringUtils.equals((String)"2", (String)nodeIdPrefix)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
            QFilter qFilter = new QFilter("masterid", "=", (Object)trueId);
            DynamicObject dynamicObject = serviceHelper.queryOne((Object)trueId);
            qFilter.or(new QFilter("id", "=", (Object)dynamicObject.getString("masterid")));
            appIdList = Arrays.stream(serviceHelper.query("id", new QFilter[]{qFilter})).map(it -> it.getString("id")).collect(Collectors.toList());
            appIdList.add(trueId);
            leftTree.queryTreeNodeChildren(parentNodeId, nodeId);
        }
        QFilter qFilter = new QFilter("app", "in", (Object)appIdList);
        this.getPageCache().put("lefttree_qfilter_json", qFilter.toSerializedString());
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        if (event.getNodeId() != null) {
            String nodeId = event.getNodeId().toString();
            this.treeHelper.handleExpandNodeClick(nodeId);
        }
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl("treeview");
    }
}

