/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.calendar;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.log.ModifyDirtyManager;
import kd.hr.hbp.business.service.operatelog.OperateLogService;
import kd.hr.hbp.common.model.DimValueResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.calendar.WorkingPlanServiceHelper;
import kd.hr.hrcs.bussiness.service.perm.check.DimService;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRBizPermServiceHelper;
import kd.hr.hrcs.formplugin.web.calendar.WorkingPlanCheckUtil;

public class WorkingPlanEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject eventObject) {
        long wpId;
        Object id;
        super.beforeBindData(eventObject);
        Map paramsMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("15NPDX/GJFOO", Long.valueOf(RequestContext.get().getOrgId())));
        if (paramsMap != null) {
            this.showChooseScope("locationpanel", paramsMap.get("workplace"));
            this.showChooseScope("orgteampanel", paramsMap.get("orgteam"));
            this.showChooseScope("controlscopepanel", paramsMap.get("controlscope"));
            this.showChooseScope("legalorgpanel", paramsMap.get("legalpersionorg"));
        }
        if ((id = this.getView().getFormShowParameter().getCustomParam("id")) != null && (wpId = Long.parseLong(id.toString())) > 0L) {
            DynamicObject scopeDy = WorkingPlanServiceHelper.loadScopeByWpId((Long)wpId);
            WorkingPlanServiceHelper.copyScopeValueForWorkingPlan((DynamicObject)scopeDy, (DynamicObject)this.getModel().getDataEntity(), (boolean)false);
            DynamicObject wpObj = WorkingPlanServiceHelper.getWorkingPlanFromPlatform((long)wpId);
            WorkingPlanServiceHelper.copyBasicInfoForWorkingPlan((DynamicObject)this.getModel().getDataEntity(true), (DynamicObject)wpObj);
            WorkingPlanServiceHelper.copyEntryForWorkingPlan((DynamicObject)this.getModel().getDataEntity(true), (DynamicObject)wpObj, (boolean)false, (IFormView)this.getView());
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.setEnableByOtherDays();
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        OperationStatus status;
        long wpId;
        super.preOpenForm(e);
        Object id = e.getFormShowParameter().getCustomParam("id");
        if (id != null && (wpId = Long.parseLong(id.toString())) > 0L && OperationStatus.EDIT.equals((Object)(status = e.getFormShowParameter().getStatus()))) {
            DynamicObject wpObj = WorkingPlanServiceHelper.getWorkingPlanFromPlatform((long)wpId);
            String appId = MetadataDao.getAppIdByFormId((String)MetadataDao.getIdByNumber((String)"hrcs_workingplanquery", (MetaCategory)MetaCategory.Form));
            Long dimId = DimService.getDimIdByNumber((String)"country");
            DimValueResultWithSub result = HRBizPermServiceHelper.getEntityDimValueWithSub((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"hrcs_workingplanquery", (String)"4715a0df000000ac", (Long)dimId);
            if (!result.isAll()) {
                Set dimValues = result.getDimValues();
                Object value = wpObj.get("countryid.id");
                boolean fail = dimValues.stream().noneMatch(dimValue -> dimValue.getValue().equals(value.toString()));
                if (fail) {
                    e.getFormShowParameter().setStatus(OperationStatus.VIEW);
                }
            }
        }
        this.setCaption(e.getFormShowParameter());
    }

    private void showChooseScope(String flexPanelId, Object isShow) {
        if (isShow instanceof Boolean) {
            this.getView().setVisible((Boolean)isShow, new String[]{flexPanelId});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit countryEdit = (BasedataEdit)this.getView().getControl("countryid");
        countryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit holidayEdit = (BasedataEdit)this.getView().getControl("holiday1");
        holidayEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("holiday1".equals(name)) {
            DynamicObject country = this.getModel().getDataEntity().getDynamicObject("countryid");
            if (country == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6\uff0c\u56fd\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkingPlanFormPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity2");
            ArrayList holidayIdList = Lists.newArrayListWithExpectedSize((int)dynamicObjectCollection.size());
            dynamicObjectCollection.forEach(row -> {
                DynamicObject holiday = row.getDynamicObject("holiday1");
                if (holiday != null) {
                    holidayIdList.add(holiday.getLong("id"));
                }
            });
            QFilter filter = new QFilter("countryid", "=", (Object)country.getLong("id"));
            filter.or(new QFilter("countryid", "is null", null)).or(new QFilter("countryid", "=", (Object)0)).and(new QFilter("id", "not in", (Object)holidayIdList));
            beforeF7SelectEvent.addCustomQFilter(filter);
        } else if ("countryid".equals(name)) {
            QFilter filterByCountry = this.getFilterByCountry();
            if (filterByCountry != null) {
                beforeF7SelectEvent.addCustomQFilter(filterByCountry);
            }
            this.confirmCountryChange(beforeF7SelectEvent);
        }
    }

    private void confirmCountryChange(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection holidays = this.getModel().getEntryEntity("entryentity2");
        if (holidays == null || holidays.isEmpty() || ((DynamicObject)holidays.get(0)).getDynamicObject("holiday1") == null) {
            return;
        }
        ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("countryIdChangeCheck", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u5c06\u6e05\u7a7a\u5df2\u8bbe\u7f6e\u7684\u201c\u516c\u5171\u5047\u671f\u201d\u3002\u786e\u5b9a\u6267\u884c\u6b64\u64cd\u4f5c\u5417\uff1f", (String)"WorkingPlanFormPlugin_20", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
        beforeF7SelectEvent.setCancel(true);
    }

    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = i;
        }
        return intArray;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBack = evt.getCallBackId();
        int result = evt.getResult().getValue();
        if (HRStringUtils.equals((String)callBack, (String)"countryIdChangeCheck") && result == MessageBoxResult.Yes.getValue()) {
            int rowCount = this.getModel().getEntryRowCount("entryentity2");
            if (rowCount > 0) {
                this.getModel().deleteEntryRows("entryentity2", this.getIntArray(rowCount));
            }
            ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"bd_country", (boolean)false, (int)0, (boolean)true);
            CloseCallBack closeCallBack = new CloseCallBack();
            closeCallBack.setControlKey("countryid");
            fsp.setCloseCallBack(closeCallBack);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            ListFilterParameter listFilterParameter = fsp.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            QFilter filterByCountry = this.getFilterByCountry();
            if (filterByCountry != null) {
                qFilters.add(filterByCountry);
            }
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "workingtime": {
                this.getModel().deleteEntryData("entryentity");
                if (newValue == null) break;
                DynamicObject workingTime = (DynamicObject)newValue;
                this.showEntryRow(workingTime);
                break;
            }
            case "datetype1": {
                this.processOtherWorkingHours(newValue, e.getChangeSet()[0].getDataEntity().getInt("seq"));
                break;
            }
            case "hours1": {
                this.processSummary1(newValue, e.getChangeSet()[0].getDataEntity().getInt("seq"));
                break;
            }
            case "locationall": {
                this.cleanMulBaseData("workplace", newValue);
                break;
            }
            case "orgteamall": {
                this.cleanMulBaseData("orgteam", newValue);
                break;
            }
            case "controlscopeall": {
                this.cleanMulBaseData("controlscope", newValue);
                break;
            }
            case "legalorgall": {
                this.cleanMulBaseData("legalpersionorg", newValue);
                break;
            }
            case "workplace": {
                this.setAllFalse("locationall", newValue);
                break;
            }
            case "orgteam": {
                this.setAllFalse("orgteamall", newValue);
                break;
            }
            case "controlscope": {
                this.setAllFalse("controlscopeall", newValue);
                break;
            }
            case "legalpersionorg": {
                this.setAllFalse("legalorgall", newValue);
                break;
            }
        }
    }

    private void checkWorkTimeStartDate() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        DynamicObject workingTime = (DynamicObject)this.getModel().getValue("workingtime");
        Date date = workingTime.getDate("startdate");
        if (date == null) {
            return;
        }
        if (date.after(startDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u6a21\u5f0f\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u516c\u5171\u65e5\u5386\u5f00\u59cb\u65e5\u671f\u3002", (String)"WorkingPlanFormPlugin_21", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    private void processOtherWorkingHours(Object newValue, int seq) {
        String dataType = String.valueOf(newValue);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity1");
        if ("3".equals(dataType)) {
            DynamicObject currentRow = (DynamicObject)entry.get(seq - 1);
            currentRow.set("hours1", null);
            currentRow.set("summary1", null);
            this.getView().updateView("entryentity1");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject row = (DynamicObject)entry.get(i);
                if (!"3".equals(row.get("datetype1"))) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"hours1"});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, seq - 1, new String[]{"hours1"});
        }
    }

    private void processSummary1(Object newValue, int seq) {
        DynamicObject hoursStr = (DynamicObject)newValue;
        if (hoursStr == null) {
            this.getModel().setValue("summary1", null, seq - 1);
        } else {
            this.getModel().setValue("summary1", (Object)hoursStr.getString("hourssummary"), seq - 1);
        }
    }

    private void cleanMulBaseData(String mulBaseData, Object newValue) {
        boolean isClear;
        boolean bl = isClear = newValue instanceof Boolean && (Boolean)newValue != false;
        if (isClear) {
            this.getModel().setValue(mulBaseData, null);
            this.getView().updateView(mulBaseData);
        }
    }

    private void setAllFalse(String setAll, Object newValue) {
        DynamicObjectCollection baseDatas = (DynamicObjectCollection)newValue;
        if (newValue != null && !baseDatas.isEmpty()) {
            this.getModel().setValue(setAll, (Object)Boolean.FALSE);
            this.getView().updateView(setAll);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Object value = this.getModel().getValue("workingtime");
        if (value != null) {
            this.showEntryRow((DynamicObject)value);
        }
    }

    private void showEntryRow(DynamicObject value) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)value.getPkValue(), (String)"working_time");
        DynamicObjectCollection collection = (DynamicObjectCollection)dynamicObject.get("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("day", new Object[0]).addField("datetype", new Object[0]).addField("hours", new Object[0]).addField("summary", new Object[0]);
        for (DynamicObject object : collection) {
            String hoursId = object.getString("hours.id");
            String workHours = WorkingPlanServiceHelper.getWorkingHoursStr((IFormView)this.getView(), (String)hoursId);
            vs.addRow(new Object[]{object.getString("day"), object.getString("datetype"), hoursId, workHours});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.getDataEntity().getDataEntityState().setFromDatabase(true);
        int rowCount = model.getEntryRowCount("entryentity");
        if (rowCount > 0) {
            model.deleteEntryRows("entryentity", this.getIntArray(rowCount));
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!(args.getSource() instanceof FormOperate)) {
            return;
        }
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if ("do_preview".equals(operateKey)) {
            this.openPreviewForm();
            args.setCancel(true);
        } else if ("do_save".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            Long wpId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            this.getModel().setValue("wpid", (Object)wpId);
            WorkingPlanCheckUtil.checkBasicData(dataEntity, wpId);
            WorkingPlanCheckUtil.checkHoliday(dataEntity);
            WorkingPlanCheckUtil.checkOtherDay(dataEntity);
            WorkingPlanCheckUtil.checkScope(dataEntity);
            this.checkWorkTimeStartDate();
            DynamicObject wpObj = wpId == null || wpId == 0L ? WorkingPlanServiceHelper.newWorkingPlanObj() : WorkingPlanServiceHelper.getWorkingPlanFromPlatform((long)wpId);
            WorkingPlanServiceHelper.copyBasicInfoForWorkingPlan((DynamicObject)wpObj, (DynamicObject)dataEntity);
            WorkingPlanServiceHelper.copyEntryForWorkingPlan((DynamicObject)wpObj, (DynamicObject)dataEntity, (boolean)true, (IFormView)this.getView());
            wpObj.set("modifytime", (Object)new Date());
            ModifyDirtyManager modifyDirtyManager = new ModifyDirtyManager();
            modifyDirtyManager.init(wpObj.getDynamicObjectType(), new DynamicObject[]{wpObj}, "save");
            modifyDirtyManager.batchInsertLog(new DynamicObject[]{wpObj});
            WorkingPlanServiceHelper.saveWorkingPlanObj((DynamicObject)wpObj);
            DynamicObject scopeObj = null;
            if (wpId != null && wpId > 0L) {
                scopeObj = WorkingPlanServiceHelper.loadScopeByWpId((Long)wpId);
            }
            if (scopeObj == null) {
                scopeObj = WorkingPlanServiceHelper.newScopeObj();
            }
            WorkingPlanServiceHelper.copyScopeValueForWorkingPlan((DynamicObject)scopeObj, (DynamicObject)this.getModel().getDataEntity(), (boolean)true);
            scopeObj.set("wpid", wpObj.getPkValue());
            WorkingPlanServiceHelper.saveScopeObj((DynamicObject)scopeObj);
            args.setCancel(true);
            MultiLangEnumBridge operateName = new MultiLangEnumBridge("\u4fdd\u5b58", "RoleFuntionAssignEdit_6", "hrmp-hrcs-formplugin");
            MultiLangEnumBridge operateDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f", "RoleFuntionAssignEdit_5", "hrmp-hrcs-formplugin");
            OperateLogService.commonWriteLog((String)"15NPDX/GJFOO", (String)"hrcs_workingplanlist", (String)"do_save", (MultiLangEnumBridge)operateName, (MultiLangEnumBridge)operateDesc, (String[])new String[0]);
            this.getView().close();
        }
    }

    private void openPreviewForm() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (startDate != null && endDate != null) {
            String startDateStr = HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss");
            Map<String, Object> workTypeMap = this.processWorkType(startDateStr);
            List<Map<String, String>> holidayList = this.processHoliday(startDate, endDate);
            List<Map<String, String>> otherDayList = this.processOtherDays();
            FormShowParameter formShowParameter = WorkingPlanServiceHelper.getShowForm((Date)startDate, (Date)endDate, workTypeMap, holidayList, otherDayList);
            this.getView().showForm(formShowParameter);
        }
    }

    private Map<String, Object> processWorkType(String startDateFull) {
        DynamicObject workingTime = this.getModel().getDataEntity().getDynamicObject("workingtime");
        return WorkingPlanServiceHelper.processWorkType((DynamicObject)workingTime, (IFormView)this.getView(), (String)startDateFull);
    }

    private List<Map<String, String>> processHoliday(Date startDate, Date endDate) {
        DynamicObjectCollection holidays = this.getModel().getEntryEntity("entryentity2");
        return WorkingPlanServiceHelper.processHoliday((Date)startDate, (Date)endDate, (DynamicObjectCollection)holidays);
    }

    private List<Map<String, String>> processOtherDays() {
        DynamicObjectCollection otherDays = this.getModel().getEntryEntity("entryentity1");
        return WorkingPlanServiceHelper.processOtherDays((DynamicObjectCollection)otherDays, (IFormView)this.getView());
    }

    private void setEnableByOtherDays() {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity1");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            if (!"3".equals(row.get("datetype1"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"hours1"});
        }
    }

    private void setCaption(FormShowParameter formShowParameter) {
        OperationStatus status = formShowParameter.getStatus();
        LocaleString captionLocaleString = formShowParameter.getFormConfig().getCaption();
        String caption = captionLocaleString.getLocaleValue();
        switch (status) {
            case ADDNEW: {
                caption = ResManager.loadKDString((String)"\u65b0\u589e\u516c\u5171\u65e5\u5386", (String)"WorkingPlanEditPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                break;
            }
            case EDIT: {
                caption = ResManager.loadKDString((String)"\u4fee\u6539\u516c\u5171\u65e5\u5386", (String)"WorkingPlanEditPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                break;
            }
            case VIEW: {
                caption = ResManager.loadKDString((String)"\u67e5\u770b\u516c\u5171\u65e5\u5386", (String)"WorkingPlanEditPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        captionLocaleString.setLocaleValue(caption);
        formShowParameter.getFormConfig().setCaption(captionLocaleString);
    }

    private QFilter getFilterByCountry() {
        String appId = MetadataDao.getAppIdByFormId((String)MetadataDao.getIdByNumber((String)"hrcs_workingplanquery", (MetaCategory)MetaCategory.Form));
        Long dimId = DimService.getDimIdByNumber((String)"country");
        DimValueResultWithSub result = HRBizPermServiceHelper.getEntityDimValueWithSub((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"hrcs_workingplanquery", (String)"47156aff000000ac", (Long)dimId);
        if (result.isAll()) {
            return null;
        }
        Set countryIdSet = result.getDimValues().stream().map(dimValueSubInfo -> {
            if (dimValueSubInfo.getValue() != null) {
                return Long.valueOf(dimValueSubInfo.getValue());
            }
            return 0L;
        }).collect(Collectors.toSet());
        return new QFilter("id", "in", countryIdSet);
    }
}

