/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.econtract.KeywordMappingServiceHelper;
import kd.hr.hrcs.formplugin.web.econtract.TplVariableConfigParentPlugin;
import org.apache.commons.lang3.ObjectUtils;

public class AddTplVariableConfigPlugin
extends TplVariableConfigParentPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(AddTplVariableConfigPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit sonEntity = (BasedataEdit)this.getControl("sonentity");
        sonEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"parentfieldname", "sonfieldname"});
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String property = evt.getProperty().getName();
        if (HRStringUtils.equals((String)"sonentity", (String)property)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ((ListShowParameter)evt.getFormShowParameter()).setMultiSelect(false);
            String[] types = new String[]{"BaseFormModel", "BillFormModel"};
            showParameter.getListFilterParameter().setFilter(new QFilter("modeltype", "in", (Object)types));
        }
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        String fieldName = pca.getProperty().getName();
        ChangeData[] changeSet = pca.getChangeSet();
        if ("sonentity".equals(fieldName)) {
            this.getModel().deleteEntryData("entryentity");
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            filterGrid.SetValue(new FilterCondition());
            DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
            if (newValue == null) {
                return;
            }
            String number = newValue.getString("number");
            filterGrid.setEntityNumber(number);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)number);
            List fieldColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)entityType);
            List<Map<String, Object>> filterField = this.getFormHeadField(fieldColumns, number);
            filterGrid.setFilterColumns(filterField);
            String idByNumber = MetadataDao.getIdByNumber((String)newValue.getString("number"), (MetaCategory)MetaCategory.Form);
            this.getMetaData(idByNumber);
            this.getView().updateView("filtergridap");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setModelVal("parententityname", this.getParentAlias());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        LocaleString title = new LocaleString(ResManager.loadKDString((String)"\u6dfb\u52a0\u5b50\u4e1a\u52a1\u5bf9\u8c61", (String)"TplVariableConfigPlugin_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.getView().setFormTitle(title);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey)) {
            String ruleStr;
            boolean mustInput = this.checkMustInput();
            if (!mustInput) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u5b9e\u4f53\u4e0e\u5b50\u5b9e\u4f53\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"TplVariableConfigPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean checkSonEntityRelation = this.checkSonEntityRelation();
            if (!checkSonEntityRelation) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5b9e\u4f53\u5173\u8054\u5173\u7cfb\u3002", (String)"TplVariableConfigPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
            if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow()) && HRStringUtils.isNotEmpty((String)(ruleStr = SerializationUtils.toJsonString((Object)fc)))) {
                this.setModelVal("rule", ruleStr);
            }
            this.setModelVal("parententity", this.getParentEntity());
            this.setModelVal("mainentity", this.getMainEntity());
            this.setModelVal("parentid", this.getParentId());
            this.setModelVal("createorg", this.getOrgRootId());
            this.setModelVal("isentry", "0");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            OperationResult operationResult = args.getOperationResult();
            List successPkIds = operationResult.getSuccessPkIds();
            if (CollectionUtils.isEmpty((Collection)successPkIds)) {
                return;
            }
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject entity = (DynamicObject)this.getModel().getValue("sonentity");
            returnMap.put("number", entity.getString("number"));
            returnMap.put("id", successPkIds.get(0));
            KeywordMappingServiceHelper.updateModelUpgradFlag((String)this.getMainEntity(), (String)"1");
            this.getView().returnDataToParent((Object)returnMap);
        } else if (HRStringUtils.equals((String)operateKey, (String)"newentry")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("fieldcondition", (Object)ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TplVariableConfigPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), entryCurrentRowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("parentfieldname".equals(key)) {
            if (this.getParentEntity().equals(this.getMainEntity())) {
                this.showFieldForm(this.buildTreeNodesByEntityType(this.getParentEntity(), "", ""), this.getParentEntity(), "parentfieldname");
                return;
            }
            DynamicObject parent = KeywordMappingServiceHelper.getTplVariableConfig((Object)this.getParentId());
            if (HRStringUtils.equals((String)"1", (String)parent.getString("isentry"))) {
                String entryNumber = parent.getString("entrynumber");
                String[] split = entryNumber.split("\\.");
                this.showFieldForm(this.buildTreeNodesByEntityType(this.getParentEntity(), "", split[1]), this.getParentEntity(), "parentfieldname");
            } else {
                this.showFieldForm(this.buildTreeNodesByEntityType(this.getParentEntity(), "", ""), this.getParentEntity(), "parentfieldname");
            }
        } else if ("sonfieldname".equals(key)) {
            DynamicObject entity = (DynamicObject)this.getModel().getValue("sonentity");
            if (ObjectUtils.isEmpty((Object)entity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b50\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"TplVariableConfigPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            String number = entity.getString("number");
            this.showFieldForm(this.buildTreeNodesByEntityType(number, "", ""), number, "sonfieldname");
        }
    }

    private boolean checkMustInput() {
        DynamicObject sonEntity = (DynamicObject)this.getView().getModel().getValue("sonentity");
        return null != sonEntity;
    }

    private String getParentEntity() {
        String parent = (String)this.getView().getFormShowParameter().getCustomParam("parententity");
        return parent;
    }

    private String getMainEntity() {
        String mainEntity = (String)this.getView().getFormShowParameter().getCustomParam("mainentity");
        return mainEntity;
    }

    private String getParentAlias() {
        String parentAlias = (String)this.getView().getFormShowParameter().getCustomParam("parentalias");
        return parentAlias;
    }

    private Long getParentId() {
        if (this.getParentEntity().equals(this.getMainEntity())) {
            return Long.valueOf(KeywordMappingServiceHelper.getRootId((String)this.getMainEntity()));
        }
        String focusNode = (String)this.getView().getFormShowParameter().getCustomParam("parentid");
        return Long.valueOf(focusNode);
    }
}

