/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.econtract.ContractView;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.template.HRBasedataList;
import org.apache.commons.lang.StringUtils;

public class EContractListPlugin
extends HRBasedataList {
    private static final Log LOGGER = LogFactory.getLog(EContractListPlugin.class);
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_contractest");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            Donothing op = (Donothing)args.getSource();
            String key = op.getOperateKey();
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Object primaryKeyValue = listSelectedData.get(0).getPrimaryKeyValue();
            if ("tosign".equals(key)) {
                DynamicObject dyoInfo = this.getDyoInfo(primaryKeyValue);
                this.toSign(dyoInfo);
            } else if ("queryauthstatus".equals(key)) {
                DynamicObject dyoInfo = this.getDyoInfo(primaryKeyValue);
                this.queryAuthStatus(dyoInfo);
            } else if ("gethandsignurl".equals(key)) {
                DynamicObject dyoInfo = this.getDyoInfo(primaryKeyValue);
                this.getHandSignUrl(dyoInfo);
            } else if ("querysignstatus".equals(key)) {
                DynamicObject dyoInfo = this.getDyoInfo(primaryKeyValue);
                this.querysignstatus(dyoInfo);
            } else if ("previewanddown".equals(key)) {
                DynamicObject dyoInfo = this.getDyoInfo(primaryKeyValue);
                this.getprevanddwn(dyoInfo);
            } else if ("companysign".equals(key)) {
                DynamicObject dyoInfo = this.getDyoInfo(primaryKeyValue);
                this.companysign(dyoInfo);
            } else if ("contcancel".equals(key)) {
                DynamicObject dyoInfo = this.getDyoInfo(primaryKeyValue);
                this.cancle(dyoInfo);
            } else if ("iskdcloudsign".equals(key)) {
                DynamicObject dyoInfo = this.getDyoInfo(primaryKeyValue);
                this.isKDCloudSign(dyoInfo);
            } else if ("abolishsignflow".equals(key)) {
                DynamicObject dyoInfo = this.getDyoInfo(primaryKeyValue);
                BillShowParameter fsp = new BillShowParameter();
                fsp.setFormId("hrcs_contractest");
                fsp.setCustomParam("preContractNo", (Object)dyoInfo.getString("number"));
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "abolishsignflow"));
                fsp.setCaption(ResManager.loadKDString((String)"\u89e3\u9664\u52b3\u52a8\u5408\u540c", (String)"EContractListPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)fsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("abolishsignflow".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            String formType = (String)returnData.get("abolishsignflow");
            if (!HRStringUtils.equals((String)"1", (String)formType)) {
                return;
            }
            Object abolishsignflow = returnData.get("abolishsignflow");
            Object operationResult = returnData.get("operationResult");
            String preContractNo = (String)returnData.get("preContractNo");
            DynamicObject dyoInfo = this.getDyoInfo(operationResult);
            this.abolishSignFlow(preContractNo, dyoInfo);
        }
    }

    private void isKDCloudSign(DynamicObject dyoInfo) {
        String contractNo = dyoInfo.getString("number");
        LOGGER.info("to isKDCloudSign contractNo{}", (Object)contractNo);
        boolean isKDCloudSign = (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"isKDCloudSign", (Object[])new Object[]{contractNo});
        LOGGER.info("to isKDCloudSign rst{}", (Object)isKDCloudSign);
        this.getView().showSuccessNotification(" success, isKDCloudSign = " + isKDCloudSign);
    }

    private void abolishSignFlow(String number, DynamicObject dyoInfo) {
        SignReqParam sqp = this.getSignReqParam(dyoInfo);
        SignRespParam srp = (SignRespParam)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"abolish", (Object[])new Object[]{number, sqp});
        String authUrl = srp.getAuthUrl();
        dyoInfo.set("number", (Object)srp.getContractNo());
        if (StringUtils.isEmpty((String)authUrl)) {
            String signHandUrl = srp.getHandSignUrl();
            dyoInfo.set("signurl", (Object)signHandUrl);
            dyoInfo.set("authstatus", (Object)true);
            this.getView().showSuccessNotification("getHandSignUrl success");
        } else {
            dyoInfo.set("authurl", (Object)authUrl);
            this.getView().showTipNotification("need auth and repeat getHandSignUrl");
        }
        this.serviceHelper.updateOne(dyoInfo);
    }

    private void cancle(DynamicObject dyoInfo) {
        boolean cancelRst;
        String contractNo = dyoInfo.getString("number");
        if (StringUtils.isEmpty((String)contractNo)) {
            throw new KDBizException("contractNo is null");
        }
        Long fiorg = 100000L;
        SignReqParam sqp = this.getSignReqParam(dyoInfo);
        long lawentity = dyoInfo.getLong("lawentity.id");
        if (0L != lawentity) {
            LOGGER.info("to cancelNew contractNo{}", (Object)contractNo);
            cancelRst = (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"cancelNew", (Object[])new Object[]{sqp, contractNo});
            LOGGER.info("to cancelNew rst{}", (Object)cancelRst);
        } else {
            LOGGER.info("to cancel contractNo{}", (Object)contractNo);
            cancelRst = (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"cancel", (Object[])new Object[]{dyoInfo.getLong("org"), contractNo});
            LOGGER.info("to cancel rst{}", (Object)cancelRst);
        }
        if (cancelRst) {
            this.getView().showSuccessNotification("success");
        } else {
            this.getView().showTipNotification("fail");
        }
    }

    private void companysign(DynamicObject dyoInfo) {
        SignRespParam srp;
        String contractNo = dyoInfo.getString("number");
        if (StringUtils.isEmpty((String)contractNo)) {
            throw new KDBizException("contractNo is null");
        }
        Long tempId = dyoInfo.getLong("econttmp.id");
        Long fiorg = 100000L;
        LOGGER.info("to getprevanddwn contractNo{}", (Object)contractNo);
        SignReqParam sqp = this.getSignReqParam(dyoInfo);
        if (sqp == null) {
            return;
        }
        if (sqp.getTemplateTypeId() == null || sqp.getTemplateTypeId() == 0L) {
            SignReqParam signReqParam = new SignReqParam(Long.valueOf(dyoInfo.getLong("org")), sqp.getTemplateId(), sqp.getTemplateTypeId(), false);
            signReqParam.setLawEntityId(Long.valueOf(dyoInfo.getLong("lawentity.id")));
            srp = (SignRespParam)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"signNew", (Object[])new Object[]{signReqParam, contractNo});
        } else {
            srp = (SignRespParam)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"sign", (Object[])new Object[]{dyoInfo.getLong("org"), sqp.getTemplateTypeId(), contractNo});
        }
        LOGGER.info("to getprevanddwn rst{}", (Object)srp);
        ContractView sealInfo = srp.getSealInfo();
        this.getView().showMessage("download:" + String.join((CharSequence)",", sealInfo.getDownloadUrlList()) + "\r previewpc:" + sealInfo.getPreviewOfPcUrl() + "\n previewmobile:" + sealInfo.getPreviewOfPcUrl());
    }

    private void getprevanddwn(DynamicObject dyoInfo) {
        String contractNo = dyoInfo.getString("number");
        if (StringUtils.isEmpty((String)contractNo)) {
            throw new KDBizException("contractNo is null");
        }
        Long fiorg = 100000L;
        SignReqParam sqp = this.getSignReqParam(dyoInfo);
        LOGGER.info("to getprevanddwn contractNo{}", (Object)contractNo);
        SignRespParam srp = (SignRespParam)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"getPrevAndDownNew", (Object[])new Object[]{sqp, contractNo});
        LOGGER.info("to getprevanddwn rst{}", (Object)srp);
        ContractView sealInfo = srp.getSealInfo();
        this.getView().showMessage("download:" + sealInfo.getDownloadUrl() + "\r previewpc:" + sealInfo.getPreviewOfPcUrl() + "\n previewmobile:" + sealInfo.getPreviewOfPcUrl());
    }

    private void querysignstatus(DynamicObject dyoInfo) {
        String contractNo = dyoInfo.getString("number");
        if (StringUtils.isEmpty((String)contractNo)) {
            throw new KDBizException("contractNo is null");
        }
        Long fiorg = 100000L;
        Long naturalId = dyoInfo.getLong("person.id");
        Long candidateId = dyoInfo.getLong("candidate.id");
        LOGGER.info("to querysignstatus personid{},candidate{}", (Object)naturalId, (Object)candidateId);
        SignReqParam signReqParam = this.getSignReqParam(dyoInfo);
        boolean signStatus = (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"signStatus", (Object[])new Object[]{signReqParam, contractNo});
        LOGGER.info("to querysignstatus rst{}", (Object)signStatus);
        if (signStatus) {
            this.getView().showSuccessNotification("sign success");
        } else {
            this.getView().showTipNotification("signing!");
        }
    }

    private void queryAuthStatus(DynamicObject dyoInfo) {
        String contractNo = dyoInfo.getString("number");
        if (StringUtils.isEmpty((String)contractNo)) {
            throw new KDBizException("contractNo is null");
        }
        Long fiorg = 100000L;
        Long naturalId = dyoInfo.getLong("person.id");
        Long candidateId = dyoInfo.getLong("candidate.id");
        LOGGER.info("to queryAuthStatus personid{},candidate{}", (Object)naturalId, (Object)candidateId);
        SignReqParam sqp = this.getSignReqParam(dyoInfo);
        boolean authStatus = (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"authStatus", (Object[])new Object[]{sqp});
        LOGGER.info("to queryAuthStatus rst{}", (Object)authStatus);
        if (authStatus) {
            dyoInfo.set("authstatus", (Object)true);
            this.serviceHelper.updateOne(dyoInfo);
            this.getView().showSuccessNotification("auth success");
        } else {
            this.getView().showTipNotification("authing!");
        }
    }

    private void getHandSignUrl(DynamicObject dyoInfo) {
        String contractNo = dyoInfo.getString("number");
        boolean authstatus = dyoInfo.getBoolean("authstatus");
        if (StringUtils.isEmpty((String)contractNo) || !authstatus) {
            throw new KDBizException("contractNo is null or unauth");
        }
        DynamicObject fileinfo = ((DynamicObject)dyoInfo.getDynamicObjectCollection("attachmentfield").get(0)).getDynamicObject("fbasedataid");
        String url = fileinfo.getString("url");
        String allFileName = fileinfo.getString("name");
        String fileName = allFileName.substring(0, allFileName.lastIndexOf(".pdf"));
        SignReqParam sqp = this.genSignReqParam(dyoInfo, fileName, url);
        LOGGER.info("to getHandSignUrl personid{},candidate{}", (Object)sqp.getNaturalId(), (Object)sqp.getCandidateId());
        SignRespParam srp2 = (SignRespParam)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"getHandSignUrl", (Object[])new Object[]{contractNo, sqp});
        LOGGER.info("to getHandSignUrl rst{}", (Object)srp2);
        String handSignUrl = srp2.getHandSignUrl();
        dyoInfo.set("signurl", (Object)handSignUrl);
        if (StringUtils.isEmpty((String)handSignUrl)) {
            throw new KDBizException("can not get handsign url");
        }
        this.getView().showSuccessNotification("getHandSignUrl success");
        this.serviceHelper.updateOne(dyoInfo);
    }

    private void toSign(DynamicObject dyoInfo) {
        if (dyoInfo.getBoolean("ishandsign")) {
            this.getView().showTipNotification("repeat sign");
            return;
        }
        SignReqParam sqp = this.getSignReqParam(dyoInfo);
        if (sqp == null) {
            return;
        }
        LOGGER.info("to sign personid{},candidate{}", (Object)sqp.getNaturalId(), (Object)sqp.getCandidateId());
        SignRespParam signRespParam = (SignRespParam)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSEContractService", (String)"toSign", (Object[])new Object[]{sqp});
        LOGGER.info("to sign rst{}", (Object)signRespParam);
        dyoInfo.set("ishandsign", (Object)true);
        String authUrl = signRespParam.getAuthUrl();
        String contractNo = signRespParam.getContractNo();
        dyoInfo.set("number", (Object)contractNo);
        if (StringUtils.isEmpty((String)authUrl)) {
            String signHandUrl = signRespParam.getHandSignUrl();
            dyoInfo.set("signurl", (Object)signHandUrl);
            dyoInfo.set("authstatus", (Object)true);
            this.getView().showSuccessNotification("getHandSignUrl success");
        } else {
            dyoInfo.set("authurl", (Object)authUrl);
            this.getView().showTipNotification("need auth and repeat getHandSignUrl");
        }
        this.serviceHelper.updateOne(dyoInfo);
    }

    private SignReqParam getSignReqParam(DynamicObject dyoInfo) {
        DynamicObjectCollection collection = dyoInfo.getDynamicObjectCollection("attachmentfield");
        if (collection.isEmpty()) {
            this.getView().showTipNotification("file is null");
            return null;
        }
        SignReqParam sqp = this.genSignReqParam(dyoInfo, "", "");
        for (DynamicObject dynamicObject : collection) {
            DynamicObject fileinfo = dynamicObject.getDynamicObject("fbasedataid");
            String url = fileinfo.getString("url");
            String allFileName = fileinfo.getString("name");
            String fileName = allFileName.substring(0, allFileName.lastIndexOf(".pdf"));
            sqp.addFile(fileName, url);
        }
        return sqp;
    }

    private SignReqParam genSignReqParam(DynamicObject dyoInfo, String fileName, String filePath) {
        long org = dyoInfo.getLong("org");
        SignReqParam signReqParam = new SignReqParam(Long.valueOf(org), Long.valueOf(dyoInfo.getLong("econttmp.id")), null, dyoInfo.getBoolean("autosign"));
        signReqParam.setFiorg(Long.valueOf(org));
        signReqParam.setLawEntityId(Long.valueOf(dyoInfo.getLong("lawentity.id")));
        signReqParam.setSignMode(dyoInfo.getString("signmode"));
        signReqParam.setHandSignFrontUrl(dyoInfo.getString("handsignfronturl"));
        signReqParam.setAuthFrontUrl(dyoInfo.getString("authfronturl"));
        signReqParam.setNaturalId(Long.valueOf(dyoInfo.getLong("person.id")));
        signReqParam.setCandidateId(Long.valueOf(dyoInfo.getLong("candidate.id")));
        signReqParam.setName(dyoInfo.getString("name"));
        signReqParam.setIdentity(dyoInfo.getString("identity"));
        signReqParam.setMobile(dyoInfo.getString("mobile"));
        signReqParam.setBusinessId(dyoInfo.getString("businessid"));
        signReqParam.setAppNum(dyoInfo.getString("appnum"));
        signReqParam.setCloud(dyoInfo.getString("cloud"));
        if (dyoInfo.getDynamicObject("templatetype") != null && dyoInfo.getDynamicObject("econttmp") != null) {
            signReqParam.setTemplateTypeId(null);
            signReqParam.setTemplateId(Long.valueOf(dyoInfo.getDynamicObject("econttmp").getLong("id")));
        } else if (dyoInfo.getDynamicObject("templatetype") != null) {
            signReqParam.setTemplateTypeId(Long.valueOf(dyoInfo.getDynamicObject("templatetype").getLong("id")));
        } else if (dyoInfo.getDynamicObject("econttmp") != null) {
            signReqParam.setTemplateId(Long.valueOf(dyoInfo.getDynamicObject("econttmp").getLong("id")));
        }
        signReqParam.setIdentityType(String.valueOf(dyoInfo.getDynamicObject("identitytype").getLong("id")));
        return signReqParam;
    }

    private DynamicObject getDyoInfo(Object primaryKeyValue) {
        String selectField = "number,econttmp,person,candidate,name,mobile,cloud,org,identity,templatetype,identitytype,businessid,appnum,autosign,signmode,handsignfronturl,authfronturl,authstatus,ishandsign,attachmentfield,authurl,signurl,personsignway,lawentity,expirestime";
        return this.serviceHelper.queryOne(selectField, primaryKeyValue);
    }
}

