/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.ChargeLicGrpServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.ChargeSiteService;
import kd.hr.hrcs.bussiness.service.econtract.EContractService;
import kd.hr.hrcs.bussiness.service.econtract.EcontractChartService;

public class EContractSignChartPlugin
extends AbstractFormPlugin {
    private static final String WARN_CONFIG_PAGE = "hrcs_warnconfig";
    private static String HRCS_SIGNCHART = "hrcs_signchart";
    private static String MODIFY_PERMITEM_ID = "2RG79HZUS86E";
    private static final String DEFAULT_SIGN_STATUS = "-1";
    private static final String LICENSE_COMBOFIELD = "license_combofield";
    private static final String EDIT_CONFIG = "edit_config";
    private static final String SIGN_COMBOFIELD_YEAR = "sign_combofield_year";
    private static final String SIGN_COMBOFIELD_STATUS = "sign_combofield_status";
    private static final Log LOGGER = LogFactory.getLog(EContractSignChartPlugin.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MM");

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.drawChart();
        this.getView().updateView();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("warnconfig".equals(itemKey)) {
            long userId = RequestContext.get().getCurrUserId();
            boolean configWarningPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)"hrcs", (String)HRCS_SIGNCHART, (String)MODIFY_PERMITEM_ID);
            LOGGER.info("EContractSignChartPlugin config warning permission={}, userId={}.", (Object)configWarningPermission, (Object)userId);
            if (configWarningPermission) {
                this.showDesignerForm();
            }
        } else if ("barrefresh".equals(itemKey)) {
            this.drawChart();
            this.getView().updateView();
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String eventName;
        switch (eventName = event.getProperty().getName()) {
            case "license_combofield": {
                String year = (String)this.getView().getModel().getValue(LICENSE_COMBOFIELD);
                this.refreshSiteUsagePointLineChart(year, null);
                break;
            }
            case "sign_combofield_year": {
                String year = (String)this.getView().getModel().getValue(SIGN_COMBOFIELD_YEAR);
                String signStatus = (String)this.getView().getModel().getValue(SIGN_COMBOFIELD_STATUS);
                this.refreshSignRecordPointLineChart(year, signStatus, null);
                break;
            }
            case "sign_combofield_status": {
                String year = (String)this.getView().getModel().getValue(SIGN_COMBOFIELD_YEAR);
                String signStatus = (String)this.getView().getModel().getValue(SIGN_COMBOFIELD_STATUS);
                this.refreshSignRecordPointLineChart(year, signStatus, null);
                break;
            }
        }
    }

    private void showDesignerForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(WARN_CONFIG_PAGE);
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDIT_CONFIG));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (EDIT_CONFIG.equals(actionId) && "success".equals(closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EContractWarnConfigPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    private void drawChart() {
        Map siteMap = ChargeLicGrpServiceHelper.refreshLicGrpDetail();
        String year = String.valueOf(LocalDate.now().getYear());
        if (!siteMap.containsKey("totalSite")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbf\u95ee\u8bb8\u53ef\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"EContractSignChartPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        this.setComboEditItems(siteMap, year);
        EcontractChartService.drawSiteUsagePieChart((IFormView)this.getView(), (Map)siteMap);
        this.refreshSiteUsagePointLineChart(year, siteMap);
        EContractService eContractService = new EContractService();
        DynamicObject[] signRecodeInfos = eContractService.querySignRecodeInfo(null, DEFAULT_SIGN_STATUS);
        Map<String, Map<String, Integer>> signRecordMap = Arrays.stream(signRecodeInfos).collect(Collectors.groupingBy(dyObj -> {
            String signType = dyObj.getString("econtemplateid.signtype");
            return signType == null ? "" : signType;
        }, Collectors.groupingBy(dyObj -> dyObj.getString("signstatus"), Collectors.reducing(0, e -> 1, Integer::sum))));
        EcontractChartService.drawSignRecordPieChart((IFormView)this.getView(), signRecordMap);
        this.refreshSignRecordPointLineChart(year, DEFAULT_SIGN_STATUS, signRecodeInfos);
    }

    private void setComboEditItems(Map<String, Object> siteMap, String year) {
        List<String> yearList = this.getYearList(siteMap, year);
        List yearcomboItems = yearList.stream().map(yearStr -> new ComboItem(new LocaleString(yearStr), yearStr)).collect(Collectors.toList());
        ComboEdit licenseComboEdit = (ComboEdit)this.getControl(LICENSE_COMBOFIELD);
        licenseComboEdit.setComboItems(yearcomboItems);
        this.getView().getModel().setValue(LICENSE_COMBOFIELD, (Object)year);
        ComboEdit signComboEdit = (ComboEdit)this.getControl(SIGN_COMBOFIELD_YEAR);
        if (signComboEdit != null) {
            signComboEdit.setComboItems(yearcomboItems);
            this.getView().getModel().setValue(SIGN_COMBOFIELD_YEAR, (Object)year);
        }
    }

    private void refreshSiteUsagePointLineChart(String year, Map<String, Object> siteMap) {
        if (siteMap == null) {
            siteMap = ChargeSiteService.getSiteDetail();
        }
        PointLineChart siteUsagePLChart = (PointLineChart)this.getControl("siteusageplchart");
        Map<String, Integer> siteUsageMap = this.getSiteUsageDataByMonth(siteMap, year);
        EcontractChartService.drawSiteUsagePointLineChart((PointLineChart)siteUsagePLChart, siteUsageMap);
    }

    private void refreshSignRecordPointLineChart(String year, String signStatus, DynamicObject[] signRecodeInfos) {
        if (signRecodeInfos == null) {
            EContractService eContractService = new EContractService();
            signRecodeInfos = eContractService.querySignRecodeInfo(year, signStatus);
        }
        Map<String, Map<String, Integer>> signTypeMap = this.getSignRecordPointLineChartMap(year, signRecodeInfos, signStatus);
        PointLineChart signRecordPLChart = (PointLineChart)this.getControl("signrecordplchart");
        EcontractChartService.drawSignRecordPointLineChart((PointLineChart)signRecordPLChart, signTypeMap);
    }

    private Map<String, Map<String, Integer>> getSignRecordPointLineChartMap(String year, DynamicObject[] signRecodeInfos, String signStatus) {
        return Arrays.stream(signRecodeInfos).filter(dyObj -> {
            boolean signStatusMatch;
            boolean bl = signStatusMatch = DEFAULT_SIGN_STATUS.equals(signStatus) ? true : signStatus.equals(dyObj.getString("signstatus"));
            if (!signStatusMatch) {
                return false;
            }
            Date createTime = dyObj.getDate("createtime");
            if (createTime == null) {
                return false;
            }
            String empYear = String.valueOf(LocalDateTime.ofInstant(createTime.toInstant(), ZoneId.systemDefault()).getYear());
            return year.equals(empYear);
        }).collect(Collectors.groupingBy(dyObj -> {
            String signType = dyObj.getString("econtemplateid.signtype");
            return signType == null ? "" : signType;
        }, Collectors.groupingBy(dyObj -> {
            Date createTime = dyObj.getDate("createtime");
            if (createTime != null) {
                String monthVal = LocalDateTime.ofInstant(createTime.toInstant(), ZoneId.systemDefault()).format(DATE_TIME_FORMATTER);
                return monthVal;
            }
            return "";
        }, Collectors.reducing(0, e -> 1, Integer::sum))));
    }

    private Map<String, Integer> getSiteUsageDataByMonth(Map<String, Object> siteMap, String year) {
        Map<String, Integer> siteUsageMap = new HashMap<String, Integer>(1);
        Object subSiteObj = siteMap.get("siteSubTotalInfos");
        if (subSiteObj != null) {
            List subSiteList = (List)subSiteObj;
            siteUsageMap = subSiteList.stream().filter(map -> map.get("reduceDate").toString().startsWith(year)).collect(Collectors.groupingBy(subObj -> subObj.get("reduceDate").toString().split("-")[1], Collectors.summingInt(subObj -> Integer.parseInt(subObj.get("reduceCount").toString()))));
        }
        return siteUsageMap;
    }

    private List<String> getYearList(Map<String, Object> siteMap, String year) {
        Object subSiteObj = siteMap.get("siteSubTotalInfos");
        if (subSiteObj == null) {
            return Collections.singletonList(year);
        }
        List subSiteList = (List)subSiteObj;
        List<String> yearList = subSiteList.stream().map(subObj -> subObj.get("reduceDate").toString().split("-")[0]).distinct().sorted().collect(Collectors.toList());
        if (!yearList.contains(year)) {
            yearList.add(0, year);
        }
        return yearList;
    }
}

