/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class EntityFieldFilterCondition
extends HRDataBaseEdit
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(EntityFieldFilterCondition.class);
    private static final String SAVE_CLOSE = "saveClose";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        List fieldKey2List;
        String entityNum;
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        Map nodeInfo = (Map)this.getView().getFormShowParameter().getCustomParam("nodeInfo");
        List fieldKeyList = (List)this.getView().getFormShowParameter().getCustomParam("fieldKeyList");
        String isEntry = (String)nodeInfo.get("isEntry");
        if (HRStringUtils.equals((String)isEntry, (String)"1")) {
            entityNum = ((String)nodeInfo.get("entryNumber")).split("\\.")[0];
            fieldKey2List = fieldKeyList.stream().map(field -> field.substring(field.indexOf(".") + 1)).collect(Collectors.toList());
        } else {
            entityNum = (String)nodeInfo.get("entityNum");
            fieldKey2List = fieldKeyList;
        }
        filterGrid.setFilterFieldKeys(fieldKey2List);
        filterGrid.setEntityNumber(entityNum);
        String wordField = (String)this.getView().getFormShowParameter().getCustomParam("wordfield");
        String msgInfo = ResManager.loadKDString((String)"\u5f53\u6839\u636e\u7236\u5b50\u5173\u7cfb\u627e\u5230\u591a\u6761\u5b50\u4e1a\u52a1\u5bf9\u8c61\u6570\u636e\u65f6\uff0c\u53ef\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff08\u6b64\u8fc7\u6ee4\u6761\u4ef6\u4ec5\u4f5c\u7528\u4e8e\u53d8\u91cf%s\uff09", (String)"EntityFieldFilterCondition_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String finalMsgInfo = String.format(Locale.ROOT, msgInfo, wordField);
        Label link = (Label)this.getView().getControl("labelap");
        link.setText(finalMsgInfo);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (!"confirm".equals(formOperate.getOperateKey())) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
        if (fc != null) {
            Map nodeInfo = (Map)this.getView().getFormShowParameter().getCustomParam("nodeInfo");
            HashMap conditionMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty((Collection)fc.getFilterRow())) {
                conditionMap.put(nodeInfo.get("key"), fc);
            }
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
            returnData.put("filtercondition", SerializationUtils.toJsonString((Object)conditionMap));
            returnData.put("nodeInfo", nodeInfo);
            this.getView().returnDataToParent((Object)returnData);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        Map nodeInfo = (Map)this.getView().getFormShowParameter().getCustomParam("nodeInfo");
        String filterConditionStr = (String)this.getView().getFormShowParameter().getCustomParam("filtercondition");
        if (StringUtils.isEmpty((Object)filterConditionStr)) {
            return;
        }
        Map conditionsMap = (Map)SerializationUtils.fromJsonString((String)filterConditionStr, Map.class);
        Map filterCondition = (Map)conditionsMap.get(nodeInfo.get("key"));
        if (filterCondition != null && !filterCondition.isEmpty()) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)filterCondition), FilterCondition.class);
            filterGrid.SetValue(fc);
            this.getView().updateView("filtergridap");
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        String fieldName = beforeFilterF7SelectEvent.getFieldName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setLookUp(true);
    }
}

