/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.ext.hr.metadata.field.HisModelBasedataField;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;

public class FieldFilterCondition
extends HRDataBaseEdit
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(FieldFilterCondition.class);
    private static EntityMetadata metadata;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        String formnumber = (String)this.getView().getFormShowParameter().getCustomParam("formnumber");
        filterGrid.setEntityNumber(formnumber);
        String idByNumber = MetadataDao.getIdByNumber((String)formnumber, (MetaCategory)MetaCategory.Form);
        metadata = this.getRuntimeMetaData(idByNumber);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("confirm".equals(formOperate.getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
            if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow())) {
                String ruleStr = SerializationUtils.toJsonString((Object)fc);
                if (HRStringUtils.isNotEmpty((String)ruleStr)) {
                    HashMap returnData = Maps.newHashMapWithExpectedSize((int)16);
                    returnData.put("rule", ruleStr);
                    OrmLocaleValue conditionname = (OrmLocaleValue)this.getModelVal("conditionname");
                    returnData.put("conditionname", conditionname.getLocaleValue());
                    this.getView().returnDataToParent((Object)returnData);
                }
            } else {
                args.setCancel(true);
                String errorInfo = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u89c4\u5219\u3002", (String)"HRDataRuleEditPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errorInfo);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        String formnumber = (String)this.getView().getFormShowParameter().getCustomParam("formnumber");
        String ruleStr = (String)this.getView().getFormShowParameter().getCustomParam("filtercondition");
        String conditionName = (String)this.getView().getFormShowParameter().getCustomParam("conditionname");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formnumber);
        List filterColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)entityType);
        HRPermCommonUtil.removeExtraColumn((List)filterColumns, (MainEntityType)entityType);
        filterGrid.setFilterColumns(filterColumns);
        if (HRStringUtils.isNotEmpty((String)ruleStr)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)ruleStr, FilterCondition.class);
            filterGrid.SetValue(fc);
        }
        this.getModel().setValue("conditionname", (Object)conditionName);
        this.getView().updateView("filtergridap");
    }

    private EntityMetadata getRuntimeMetaData(String entityId) {
        long l1 = System.currentTimeMillis();
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        long l2 = System.currentTimeMillis();
        LOGGER.info("HisCommonFilterService.getRuntimeMetaData excute time " + (l2 - l1));
        return metadata;
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        String fieldName = beforeFilterF7SelectEvent.getFieldName();
        String substring = fieldName.substring(0, fieldName.indexOf("."));
        boolean judegHisModel = this.judegHisModel(substring);
        if (judegHisModel) {
            beforeFilterF7SelectEvent.getCustomParams().put("selData", false);
            beforeFilterF7SelectEvent.getCustomParams().put("bsedField", null);
            beforeFilterF7SelectEvent.getCustomParams().put("isShowEffDateControl", true);
            beforeFilterF7SelectEvent.getCustomParams().put("isShowCurrentNumAndName", true);
            beforeFilterF7SelectEvent.getCustomParams().put("isShowDisableData", false);
            beforeFilterF7SelectEvent.getCustomParams().put("effDateFieldType", "effDateRange");
            beforeFilterF7SelectEvent.getCustomParams().put("listFilterType", "by_version");
        }
        beforeFilterF7SelectEvent.getCustomParams().put("isShowUsed", false);
    }

    private boolean judegHisModel(String compareFieldName) {
        if (metadata == null) {
            return false;
        }
        List entityItems = metadata.getItems();
        if (entityItems == null) {
            return false;
        }
        for (EntityItem entityItem : entityItems) {
            HisModelBasedataField hisModelBasedataField;
            String selData;
            boolean isHisFieldAp = entityItem instanceof HisModelBasedataField;
            if (!isHisFieldAp || !HRStringUtils.equals((String)entityItem.getKey(), (String)compareFieldName) || !"bdversion".equals(selData = (hisModelBasedataField = (HisModelBasedataField)entityItem).getSelData())) continue;
            return true;
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setLookUp(true);
    }
}

