/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.econtract.HRWordUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.econtract.EContractServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.econtract.KeywordMappingServiceHelper;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class KeywordMappingPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(KeywordMappingPlugin.class);

    public void createNewData(BizDataEventArgs evt) {
        super.createNewData(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object conTemplateId = showParameter.getCustomParam("contempid");
        LOGGER.info("conTemplateId={}", conTemplateId);
        if (!(conTemplateId instanceof Integer) || !String.valueOf(conTemplateId).equals("0")) {
            String formNumber = (String)showParameter.getCustomParam("formnumber");
            LOGGER.info("formNumber={}", (Object)formNumber);
            DynamicObject formDy = KeywordMappingServiceHelper.loadKeywordMapping((String)formNumber, (Object)conTemplateId);
            if (!Objects.isNull(formDy)) {
                evt.setDataEntity((Object)formDy);
            }
        }
    }

    public void afterCreateNewData(EventObject evt) {
        IDataModel model = this.getModel();
        Long formId = (Long)model.getValue("id");
        if (formId.equals(0L)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Object conTemplateId = showParameter.getCustomParam("contempid");
            String formNumber = (String)showParameter.getCustomParam("formnumber");
            Object nowConTempId = showParameter.getCustomParam("nowContempid");
            LOGGER.info("conTemplateId={},nowConTempId={}", conTemplateId, nowConTempId);
            List<String> warnList = this.initEtryEntity(showParameter, nowConTempId, formNumber);
            this.initEntityField(model, conTemplateId, formNumber);
            if (null != warnList && warnList.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc6\u522b\u51fa%s\u4e2a\u683c\u5f0f\u9519\u8bef\u7684\u6a21\u677f\u53d8\u91cf\uff0c\u8bf7\u4fee\u6539\u6a21\u677f\u4e2d\u7684\u53d8\u91cf\u683c\u5f0f\uff0c\u5982${\u5458\u5de5\u59d3\u540d}\u3002", (String)"KeywordMappingPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{warnList.size()}));
            }
        } else {
            this.initIsEnableKeywordWithView(model);
        }
    }

    public void beforeClosed(BeforeClosedEvent args) {
        super.beforeClosed(args);
        String isChanged = this.getView().getPageCache().get("isChange");
        String saveClose = this.getView().getPageCache().get("saveClose");
        if (HRStringUtils.equals((String)isChanged, (String)"1") && !HRStringUtils.equals((String)saveClose, (String)"1")) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("beforeCloseConfirm", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"KeywordMappingPlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"KeywordMappingPlugin_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u5982\u679c\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"KeywordMappingPlugin_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if ("beforeCloseConfirm".equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().getPageCache().remove("isChange");
            this.getView().close();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"showkeywordf7", (CharSequence)formOperate.getOperateKey())) {
            this.showEntityFieldMappingF7();
        } else if (StringUtils.equals((CharSequence)"customize", (CharSequence)formOperate.getOperateKey())) {
            this.showCustomizeMappingF7();
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            this.getView().getPageCache().put("saveClose", "1");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("customize".equals(actionId)) {
            JSONObject returnData = (JSONObject)evt.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            this.showCustomizeMapping(returnData);
        } else if ("showkeywordf7".equals(actionId)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            ListSelectedRowCollection selectedRowCol = (ListSelectedRowCollection)returnData.get("selectedRowCol");
            if (selectedRowCol == null || selectedRowCol.isEmpty()) {
                return;
            }
            this.showEntityFieldMapping(selectedRowCol, (String)returnData.get("filtercondition"));
        }
    }

    private void showEntityFieldMapping(ListSelectedRowCollection selectedRowCol, String filterCondition) {
        boolean notChange;
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        String oldEntityNumber = (String)this.getModel().getValue("entitynumber", index);
        String oldEntityField = (String)this.getModel().getValue("entityfield", index);
        String oldEntityName = (String)this.getModel().getValue("entityname", index);
        String oldEntityFieldName = (String)this.getModel().getValue("entityfieldname", index);
        String oldRelEntityId = this.getModel().getValue("relateentityid", index).toString();
        ListSelectedRow selectedRowModel = selectedRowCol.get(0);
        Map selectRowMap = (Map)SerializationUtils.fromJsonString((String)selectedRowModel.toString(), Map.class);
        String entityNumber = (String)selectRowMap.get("entityNumber");
        String entityField = (String)selectRowMap.get("number");
        String entityName = (String)selectRowMap.get("entityLocalName");
        String entityFieldName = (String)selectRowMap.get("localName");
        String relateEntityId = selectRowMap.get("entityId").toString();
        boolean bl = notChange = HRStringUtils.equals((String)oldEntityNumber, (String)entityNumber) && HRStringUtils.equals((String)oldEntityField, (String)entityField) && HRStringUtils.equals((String)oldEntityName, (String)entityName) && HRStringUtils.equals((String)oldEntityFieldName, (String)entityFieldName) && HRStringUtils.equals((String)oldRelEntityId, (String)relateEntityId);
        if (notChange) {
            return;
        }
        this.getView().getPageCache().put("isChange", "1");
        this.getModel().setValue("entityfield", (Object)entityField, index);
        this.getModel().setValue("entityfieldname", (Object)entityFieldName, index);
        Object conTemplateId = this.getView().getFormShowParameter().getCustomParam("contempid");
        if (!Objects.isNull(entityNumber)) {
            this.getModel().setValue("entitynumber", (Object)entityNumber, index);
        }
        if (!Objects.isNull(entityName)) {
            this.getModel().setValue("entityname", (Object)entityName, index);
        }
        this.getModel().setValue("relateentityid", (Object)relateEntityId, index);
        String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\uff1a%1$s\u3001%2$s\u3002", (String)"KeywordMappingPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String mappingMsg = String.format(Locale.ROOT, msg, entityName, entityFieldName);
        this.getModel().setValue("fieldmapping", (Object)mappingMsg, index);
        this.getModel().setValue("iscustomize", (Object)"0", index);
        this.getModel().setValue("customizekey", (Object)"", index);
    }

    private String buildFilterDesc(String msg, String entityNumber, String filterConditionAllMapStr, String relateEntityId) {
        return msg;
    }

    private void showCustomizeMapping(JSONObject returnData) {
        String customizeKey;
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        String oldCustomizeKey = (String)this.getModel().getValue("customizekey", index);
        if (HRStringUtils.equals((String)oldCustomizeKey, (String)(customizeKey = returnData.getString("customizeKey")))) {
            return;
        }
        this.getView().getPageCache().put("isChange", "1");
        this.getModel().setValue("iscustomize", (Object)"1", index);
        this.getModel().setValue("customizekey", (Object)customizeKey, index);
        this.getModel().setValue("entityfield", (Object)"", index);
        this.getModel().setValue("entityfieldname", (Object)"", index);
        this.getModel().setValue("entitynumber", (Object)"", index);
        this.getModel().setValue("entityname", (Object)"", index);
        this.getModel().setValue("filtercondition", (Object)"", index);
        String msg = ResManager.loadKDString((String)"\u6620\u5c04Key\uff1a%s", (String)"KeywordMappingPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("fieldmapping", (Object)String.format(Locale.ROOT, msg, customizeKey), index);
    }

    private void clearDeleteEntity(Object conTemplateId) {
        DynamicObject relateEntityByContempid = EContractServiceHelper.getRelateEntityByContempid((Long)((Long)conTemplateId));
        if (relateEntityByContempid == null) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            String modelEntityNumber = ((DynamicObject)entryEntity.get(i)).getString("entitynumber");
            if (!this.checkDelete(modelEntityNumber, relateEntityByContempid)) continue;
            this.getModel().setValue("entityname", null, i);
            this.getModel().setValue("entitynumber", null, i);
            this.getModel().setValue("entityfieldname", null, i);
            this.getModel().setValue("entityfield", null, i);
            this.getModel().setValue("conditionname", null, i);
            this.getModel().setValue("filtercondition", null, i);
        }
    }

    private boolean checkDelete(String entityNumber, DynamicObject relateEntityByContempid) {
        DynamicObjectCollection dynamicObjectCollection = relateEntityByContempid.getDynamicObjectCollection("entryentity");
        if (dynamicObjectCollection == null) {
            return false;
        }
        List number = dynamicObjectCollection.stream().map(entity -> entity.getDynamicObject("entityname").getString("number")).collect(Collectors.toList());
        return !number.contains(entityNumber) && !entityNumber.equals(relateEntityByContempid.getDynamicObject("mainentity").get("number"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> initEtryEntity(FormShowParameter showParameter, Object nowContempid, String formNumber) {
        String url = (String)showParameter.getCustomParam("attamchmentPath");
        boolean isTempFile = (Boolean)showParameter.getCustomParam("isTempFile");
        List<String> list = null;
        try (XWPFDocument document = HRWordUtils.getXWPFDocumentFromUrl((String)url, (boolean)isTempFile);){
            if (Objects.isNull(document)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20docx\u683c\u5f0f\u6587\u4ef6\u3002", (String)"KeywordMappingPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                List<String> list2 = list;
                return list2;
            }
            StringBuffer strFormWord = HRWordUtils.getStringFormWord((XWPFDocument)document);
            Set keywordSet = HRWordUtils.getAllKeywords((StringBuffer)strFormWord);
            if (keywordSet.size() <= 0) return list;
            list = this.setEntryEntity(keywordSet, formNumber, nowContempid);
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            grid.addPackageDataListener(this::packageData);
            return list;
        }
        catch (IOException exception) {
            LOGGER.error("read word file error", (Throwable)exception);
        }
        return list;
    }

    private void packageData(PackageDataEvent event) {
        Object str = event.getRowData().get("isenablekeyword");
        if (event.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)event.getSource()).getKey())) {
            List operationColItems = (List)event.getFormatValue();
            for (OperationColItem operationColItem : operationColItems) {
                if (!"customize".equalsIgnoreCase(operationColItem.getOperationKey()) && !"showkeywordf7".equalsIgnoreCase(operationColItem.getOperationKey()) || !str.toString().equals("0")) continue;
                operationColItem.setLocked(true);
            }
        }
    }

    private List<String> setEntryEntity(Set<String> keywordSet, String formNumber, Object nowContempid) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)10);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("isenablekeyword", new Object[0]);
        setter.addField("wordfield", new Object[0]);
        setter.addField("entityfield", new Object[0]);
        setter.addField("entitynumber", new Object[0]);
        setter.addField("entityfieldname", new Object[0]);
        setter.addField("entityname", new Object[0]);
        setter.addField("filtercondition", new Object[0]);
        setter.addField("fieldmapping", new Object[0]);
        setter.addField("iscustomize", new Object[0]);
        setter.addField("customizekey", new Object[0]);
        setter.addField("relateentityid", new Object[0]);
        DynamicObject nowDy = KeywordMappingServiceHelper.loadKeywordMapping((String)formNumber, (Object)nowContempid);
        if (Objects.isNull(nowContempid) || HRObjectUtils.isEmpty((Object)nowDy)) {
            for (String wordField : keywordSet) {
                String isEnableKeyword = this.checkWordField(wordField, list);
                setter.addRow(new Object[]{isEnableKeyword, wordField, "", "", "", ""});
            }
        } else {
            DynamicObjectCollection collection = nowDy.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection newColl = KeywordMappingServiceHelper.compareKeyword(keywordSet, (DynamicObjectCollection)collection, (boolean)false);
            for (DynamicObject showDy : newColl) {
                String msg;
                String wordField = showDy.getString("wordfield");
                String isEnableKeyword = this.checkWordField(wordField, list);
                String entityField = showDy.getString("entityfield");
                String entityNumber = showDy.getString("entitynumber");
                String entityFieldName = showDy.getString("entityfieldname");
                String entityName = showDy.getString("entityname");
                String filterCondition = showDy.getString("filtercondition");
                String isCustomize = showDy.getString("iscustomize");
                String customizeKey = showDy.getString("customizekey");
                String relateEntityId = showDy.getString("relateentityid");
                String fieldMapping = "";
                if (StringUtils.equals((CharSequence)isCustomize, (CharSequence)"1")) {
                    msg = ResManager.loadKDString((String)"\u6620\u5c04Key\uff1a%s", (String)"KeywordMappingPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                    fieldMapping = String.format(Locale.ROOT, msg, customizeKey);
                } else if (StringUtils.isNotEmpty((CharSequence)entityField)) {
                    msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\uff1a%1$s\u3001%2$s\u3002", (String)"KeywordMappingPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                    fieldMapping = String.format(Locale.ROOT, msg, entityName, entityFieldName);
                    fieldMapping = this.buildFilterDesc(fieldMapping, entityNumber, filterCondition, relateEntityId);
                }
                setter.addRow(new Object[]{isEnableKeyword, wordField, entityField, entityNumber, entityFieldName, entityName, filterCondition, fieldMapping, isCustomize, customizeKey, relateEntityId});
            }
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
        return list;
    }

    private void initIsEnableKeywordWithView(IDataModel model) {
        if (!HRObjectUtils.isEmpty((Object)model.getValue("entryentity"))) {
            DynamicObjectCollection collection = (DynamicObjectCollection)model.getValue("entryentity");
            for (int i = 0; i < collection.size(); ++i) {
                String msg;
                model.setValue("isenablekeyword", (Object)"1", i);
                DynamicObject mapping = (DynamicObject)collection.get(i);
                String isCustomize = mapping.getString("iscustomize");
                if ("1".equals(isCustomize)) {
                    String customizeKey = mapping.getString("customizekey");
                    msg = ResManager.loadKDString((String)"\u6620\u5c04Key\uff1a%s", (String)"KeywordMappingPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                    this.getModel().setValue("fieldmapping", (Object)String.format(Locale.ROOT, msg, customizeKey), i);
                    continue;
                }
                String entityName = mapping.getString("entityname");
                if (HRStringUtils.isEmpty((String)entityName)) continue;
                msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\uff1a%1$s\u3001%2$s\u3002", (String)"KeywordMappingPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                String msgLocale = String.format(Locale.ROOT, msg, mapping.getString("entityname"), mapping.getString("entityfieldname"));
                String filterCondDB = mapping.getString("filtercondition");
                msgLocale = this.buildFilterDesc(msgLocale, mapping.getString("entitynumber"), filterCondDB, mapping.getString("relateentityid"));
                this.getModel().setValue("fieldmapping", (Object)msgLocale, i);
            }
        }
    }

    private String checkWordField(String wordField, List<String> list) {
        String isEnableKeyword = "1";
        int endIndex = wordField.indexOf("}");
        if (endIndex == -1) {
            isEnableKeyword = "0";
            list.add(wordField);
        }
        return isEnableKeyword;
    }

    private void initEntityField(IDataModel model, Object conTemplateId, String formNumber) {
        model.setValue("contempid", conTemplateId);
        model.setValue("formnumber", (Object)formNumber);
    }

    private void showCustomizeMappingF7() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_customizemp");
        Map<String, String> formMap = this.setFormNumberList();
        Object conTemplateId = this.getView().getFormShowParameter().getCustomParam("contempid");
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        String entityDy = (String)this.getModel().getValue("wordfield", index);
        String entityfield = (String)this.getModel().getValue("entityfield", index);
        String entitynumber = (String)this.getModel().getValue("entitynumber", index);
        showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u914d\u7f6e%s\u53d6\u503c\u5173\u7cfb", (String)"KeywordMappingPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), entityDy));
        showParameter.setCustomParam("formNumberList", formMap);
        showParameter.setCustomParam("contempid", conTemplateId);
        showParameter.setCustomParam("formnumber", this.getModel().getValue("formnumber"));
        showParameter.setCustomParam("entityfield", (Object)entityfield);
        showParameter.setCustomParam("entitynumber", (Object)entitynumber);
        Object nowConTempId = this.getView().getFormShowParameter().getCustomParam("nowContempid");
        showParameter.setCustomParam("nowContempid", nowConTempId);
        String customizeKey = (String)this.getModel().getValue("customizekey", index);
        if (StringUtils.isNotEmpty((CharSequence)customizeKey)) {
            showParameter.setCustomParam("customizekey", (Object)customizeKey);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "customize"));
        this.getView().showForm(showParameter);
    }

    private void showEntityFieldMappingF7() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hrcs_entityfieldmpf7tree");
        showParameter.setBillFormId("hrcs_entityfieldmp");
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        showParameter.setMultiSelect(false);
        StyleCss css = new StyleCss();
        css.setWidth("900px");
        css.setHeight("650px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        Map<String, String> formMap = this.setFormNumberList();
        Object conTemplateId = this.getView().getFormShowParameter().getCustomParam("contempid");
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        String entityDy = (String)this.getModel().getValue("wordfield", index);
        String filterCondition = (String)this.getModel().getValue("filtercondition", index);
        String entityfield = (String)this.getModel().getValue("entityfield", index);
        String entitynumber = (String)this.getModel().getValue("entitynumber", index);
        String relateEntityId = this.getModel().getValue("relateentityid", index).toString();
        showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u914d\u7f6e%s\u53d6\u503c\u5173\u7cfb", (String)"KeywordMappingPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), entityDy));
        showParameter.setCustomParam("formNumberList", formMap);
        showParameter.setCustomParam("contempid", conTemplateId);
        showParameter.setCustomParam("formnumber", this.getModel().getValue("formnumber"));
        showParameter.setCustomParam("mappingEntity", this.getView().getFormShowParameter().getCustomParam("mappingEntity"));
        showParameter.setCustomParam("filtercondition", (Object)filterCondition);
        showParameter.setCustomParam("entityfield", (Object)entityfield);
        showParameter.setCustomParam("entitynumber", (Object)entitynumber);
        Object nowConTempId = this.getView().getFormShowParameter().getCustomParam("nowContempid");
        showParameter.setCustomParam("nowContempid", nowConTempId);
        showParameter.setCustomParam("wordfield", (Object)entityDy);
        showParameter.setCustomParam("relateentityid", (Object)relateEntityId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showkeywordf7"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Map<String, String> setFormNumberList() {
        Map formMap = (Map)this.getView().getFormShowParameter().getCustomParam("mappingEntity");
        return formMap;
    }
}

