/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.econtract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.application.impl.common.HrEntityCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.HRBaseDataUtils;
import kd.hr.hrcs.bussiness.servicehelper.econtract.KeywordMappingServiceHelper;
import kd.hr.hrcs.common.util.EntityFieldTreeUtil;
import kd.hr.hrcs.formplugin.web.econtract.TplVariableConfigParentPlugin;
import org.apache.commons.lang3.ObjectUtils;

public class TplVariableConfigPlugin
extends TplVariableConfigParentPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener {
    private static final Log LOGGER = LogFactory.getLog(TplVariableConfigPlugin.class);
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView fieldPermTreeView = (TreeView)this.getControl("treeviewap");
        fieldPermTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BasedataEdit sonEntity = (BasedataEdit)this.getControl("sonentity");
        sonEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"parentfieldname", "sonfieldname"});
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent see) {
                IPageCache pageCache = TplVariableConfigPlugin.this.getView().getPageCache();
                TreeView tv = (TreeView)TplVariableConfigPlugin.this.getView().getControl("treeviewap");
                String searchText = see.getText();
                if (StringUtils.isNotEmpty((String)searchText)) {
                    String lastSearchText = pageCache.get("lastSearchText");
                    if (searchText.equals(lastSearchText)) {
                        String searchResultStr = pageCache.get("searchResult");
                        if (StringUtils.isNotEmpty((String)searchResultStr)) {
                            List searchResult = SerializationUtils.fromJsonStringToList((String)searchResultStr, String[].class);
                            int searchIndex = Integer.parseInt(pageCache.get("searchIndex"));
                            if (searchIndex == searchResult.size()) {
                                searchIndex = 0;
                            }
                            String[] searchInfo = (String[])searchResult.get(searchIndex);
                            TreeNode treeNode = new TreeNode();
                            treeNode.setId(searchInfo[1]);
                            treeNode.setParentid(searchInfo[2]);
                            pageCache.put("searchIndex", searchIndex + 1 + "");
                            tv.focusNode(treeNode);
                            tv.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                        } else {
                            TplVariableConfigPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"TplVariableConfigPlugin_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                        }
                    } else {
                        List treeNodeInfos = SerializationUtils.fromJsonStringToList((String)pageCache.get("treeNodeInfos"), String[].class);
                        ArrayList<String[]> searchResult = new ArrayList<String[]>(treeNodeInfos.size());
                        for (String[] treeNodeInfo : treeNodeInfos) {
                            if (!treeNodeInfo[0].contains(searchText)) continue;
                            searchResult.add(treeNodeInfo);
                        }
                        if (CollectionUtils.isEmpty(searchResult)) {
                            TplVariableConfigPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"TplVariableConfigPlugin_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                        } else {
                            pageCache.put("searchResult", SerializationUtils.toJsonString(searchResult));
                            pageCache.put("lastSearchText", searchText);
                            String[] searchInfo = (String[])searchResult.get(0);
                            TreeNode treeNode = new TreeNode();
                            treeNode.setId(searchInfo[1]);
                            treeNode.setParentid(searchInfo[2]);
                            pageCache.put("searchIndex", "1");
                            tv.focusNode(treeNode);
                            tv.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                        }
                    }
                }
            }
        });
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String property = evt.getProperty().getName();
        if (HRStringUtils.equals((String)"sonentity", (String)property)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ((ListShowParameter)evt.getFormShowParameter()).setMultiSelect(false);
            String[] types = new String[]{"BaseFormModel", "BillFormModel"};
            showParameter.getListFilterParameter().setFilter(new QFilter("modeltype", "in", (Object)types));
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String evName = e.getEventName();
        if (!"fieldmptreeap".equals(key)) {
            return;
        }
        String msg = e.getEventArgs();
        Map clickData = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
        String nodeId = (String)clickData.get("key");
        String modifyNode = this.getPageCache().get("modifyNodeId");
        if (HRStringUtils.isNotEmpty((String)modifyNode)) {
            this.getPageCache().put("nextNode", nodeId);
            this.getPageCache().put("nextParentNode", (String)clickData.get("parentId"));
            String focusNodeId = this.getPageCache().get("focusNodeId");
            String parentNodeId = this.getPageCache().get("parentNodeId");
            TreeNode root = new TreeNode(parentNodeId, focusNodeId, this.getMainEntityName());
            KeywordMappingServiceHelper.initEntityTree((TreeNode)root, (IFormView)this.getView(), (String)KeywordMappingServiceHelper.getRootId((String)this.getMainEntity()), (String)this.getMainEntityName(), (String)"0");
            TreeView tv = (TreeView)this.getView().getControl("treeviewap");
            tv.addTreeNodeClickListener((TreeNodeClickListener)this);
            tv.focusNode(root);
            this.getView().updateView("treeviewap");
            tv.treeNodeClick((String)clickData.get("parentId"), nodeId);
            return;
        }
        this.getPageCache().put("focusNodeId", nodeId);
        this.getPageCache().put("parentNodeId", (String)clickData.get("parentId"));
        TreeView tv = (TreeView)this.getView().getControl("treeviewap");
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.treeNodeClick((String)clickData.get("parentId"), nodeId);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = e.getFormShowParameter();
        if (HRBaseDataUtils.skipControlPageLabel((FormShowParameter)showParameter)) {
            return;
        }
        MetadataReader metadataReader = new MetadataReader();
        String formId = showParameter.getFormId();
        String formIdStr = metadataReader.loadIdByNumber(formId, MetaCategory.Entity);
        if (HRStringUtils.isEmpty((String)formIdStr)) {
            return;
        }
        LOGGER.info("HRBaseDataTplEdit handleUE formId:" + formId);
        if (HRStringUtils.isNotEmpty((String)formId) && showParameter instanceof BillShowParameter) {
            List parentEntity = HrEntityCommonService.getInstance().getParentEntity(formId);
            List templateDlgList = Arrays.stream(HRBaseConstants.templateDlg).collect(Collectors.toList());
            for (String templateDlgStr : templateDlgList) {
                if (!parentEntity.contains(templateDlgStr)) continue;
                return;
            }
            String tittle = ResManager.loadKDString((String)"\u53d6\u503c\u5bf9\u8c61\u914d\u7f6e", (String)"TplVariableConfigPlugin_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            showParameter.setCaption(tittle);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        KeywordMappingServiceHelper.saveMainEntity((String)this.getMainEntity());
        Map formMap = (Map)this.getView().getFormShowParameter().getCustomParam("mappingEntity");
        if (null == formMap) {
            return;
        }
        this.controlsVisible();
        String focusNodeId = "";
        String parentNodeId = "";
        String modifyNode = this.getPageCache().get("modifyNodeId");
        if (HRStringUtils.isNotEmpty((String)modifyNode)) {
            focusNodeId = this.getPageCache().get("nextNode");
            parentNodeId = this.getPageCache().get("nextParentNode");
        } else {
            focusNodeId = this.getPageCache().get("focusNodeId");
            parentNodeId = this.getPageCache().get("parentNodeId");
        }
        TreeNode root = HRStringUtils.isEmpty((String)focusNodeId) || HRStringUtils.isEmpty((String)parentNodeId) ? this.getRootNode() : new TreeNode(parentNodeId, focusNodeId, "");
        String treeNodeClick = this.getView().getPageCache().get("treeNodeClick");
        KeywordMappingServiceHelper.initEntityTree((TreeNode)root, (IFormView)this.getView(), (String)KeywordMappingServiceHelper.getRootId((String)this.getMainEntity()), (String)this.getMainEntityName(), (String)treeNodeClick);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void controlsVisible() {
        this.hiddenControls();
        String dataId = this.getPageCache().get("dataId");
        if (this.getMainEntity().equals(this.getFocusEntity()) || HRStringUtils.isEmpty((String)this.getFocusEntity())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo", "advconap", "advconap1", "modifyentity", "deleteentity"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"pictureflex", "addentity"});
        } else if (HRStringUtils.equals((String)dataId, (String)this.getFocusNode())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fs_baseinfo", "advconap", "advconap1", "save", "cancel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"modifyentity", "pictureflex", "deleteentity", "addentity"});
            this.showControls();
            this.hiddenEntryControls();
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fs_baseinfo", "advconap", "advconap1", "modifyentity", "deleteentity", "addentity"});
            if (HRStringUtils.equals((String)"1", (String)this.getFocusEntity())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"pictureflex"});
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getPageCache().remove("dataId");
        String lastTreeNodeId = this.getPageCache().get("focusNodeId");
        String lastTreeNodeParentId = this.getPageCache().get("parentNodeId");
        String confirmFlag = this.getPageCache().get("confirmFlag");
        String modifyNode = this.getPageCache().get("modifyNodeId");
        if (HRStringUtils.isNotEmpty((String)modifyNode)) {
            this.getView().getPageCache().put("treeNodeClick", "2");
        } else {
            this.getView().getPageCache().put("treeNodeClick", "1");
        }
        if (!HRStringUtils.equals((String)"1", (String)confirmFlag)) {
            if (this.checkDataChange()) {
                evt.setCancel(true);
                return;
            }
            if (HRStringUtils.isNotEmpty((String)modifyNode)) {
                lastTreeNodeId = this.getPageCache().get("nextNode");
                lastTreeNodeParentId = this.getPageCache().get("nextParentNode");
                this.getPageCache().put("focusNodeId", lastTreeNodeId);
                this.getPageCache().put("parentNodeId", lastTreeNodeParentId);
            }
            this.getPageCache().remove("modifyNodeId");
        }
        if (HRStringUtils.isEmpty((String)lastTreeNodeParentId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fs_baseinfo"});
        }
        String focusNode = this.getFocusNode();
        this.getModel().deleteEntryData("entryentity");
        if (HRStringUtils.isEmpty((String)focusNode) || "0".equals(focusNode)) {
            this.controlsVisible();
            this.getView().updateView();
            return;
        }
        if (this.getMainEntity().equals(this.getFocusEntity()) || HRStringUtils.isEmpty((String)this.getFocusEntity())) {
            this.getView().updateView();
            return;
        }
        DynamicObject tplVariableConfig = KeywordMappingServiceHelper.getTplVariableConfig((Object)focusNode);
        this.fillFormData(tplVariableConfig);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("addentity".equals(operateKey)) {
            BillShowParameter fsp = new BillShowParameter();
            HashMap<String, String> params = new HashMap<String, String>(16);
            Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addentity"));
            params.putAll(originalCustParams);
            String focusEntity = this.getFocusEntity();
            String parentAlias = "";
            DynamicObject tplVariableConfig = KeywordMappingServiceHelper.getTplVariableConfig((Object)Long.valueOf(this.getFocusNode()));
            parentAlias = tplVariableConfig.getLocaleString("sonentityalias").getLocaleValue();
            if (HRStringUtils.equals((String)"1", (String)focusEntity)) {
                params.put("parententity", tplVariableConfig.getDynamicObject("parententity").getString("number"));
                params.put("parentalias", tplVariableConfig.getString("entryname"));
            } else {
                params.put("parententity", focusEntity);
                params.put("parentalias", HRStringUtils.isEmpty((String)parentAlias) ? tplVariableConfig.getDynamicObject("sonentity").getLocaleString("name").getLocaleValue() : parentAlias);
            }
            params.put("mainentity", this.getMainEntity());
            params.put("parentid", this.getFocusNode());
            fsp.setCustomParams(params);
            fsp.setFormId("hrcs_addtplvariableconfig");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)fsp);
        } else if ("modifyentity".equals(operateKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"modifyentity", "addentity", "deleteentity"});
            this.getPageCache().put("dataId", this.getFocusNode());
            this.getPageCache().put("modifyNodeId", this.getFocusNode());
            this.showControls();
            this.hiddenEntryControls();
        } else if ("save".equals(operateKey)) {
            boolean mustInput = this.checkMustInput();
            if (!mustInput) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u5b9e\u4f53\u4e0e\u5b50\u5b9e\u4f53\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"TplVariableConfigPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean checkSonEntityRelation = this.checkSonEntityRelation();
            if (!checkSonEntityRelation) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5b9e\u4f53\u5173\u8054\u5173\u7cfb\u3002", (String)"TplVariableConfigPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
            if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow())) {
                String ruleStr = SerializationUtils.toJsonString((Object)fc);
                if (HRStringUtils.isNotEmpty((String)ruleStr)) {
                    this.setModelVal("rule", ruleStr);
                }
            } else {
                this.setModelVal("rule", "");
            }
        } else if ("deleteentity".equals(operateKey)) {
            boolean issyspreset = (Boolean)this.getModelVal("issyspreset");
            if (issyspreset) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TplVariableConfigPlugin_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formnumber");
            ((AbstractOperate)args.getSource()).getOption().setVariableValue("deleteParam", formNumber);
            String deleteFlag = this.getPageCache().get("deleteFlag");
            if (!this.checkDelete() && !"1".equals(deleteFlag)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmdelete", (IFormPlugin)this);
                String strs = ResManager.loadKDString((String)"\u5220\u9664\u8be5\u4e1a\u52a1\u5bf9\u8c61\u5c06\u540c\u65f6\u5220\u9664\u5176\u5b50\u4e1a\u52a1\u5bf9\u8c61\u3002\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"TplVariableConfigPlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(strs, MessageBoxOptions.OKCancel, confirmCallBacks);
                args.setCancel(true);
                return;
            }
            if (this.checkDelete() && !"1".equals(deleteFlag)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmdelete", (IFormPlugin)this);
                String strs = ResManager.loadKDString((String)"\u5220\u9664\u8be5\u4e1a\u52a1\u5bf9\u8c61\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"TplVariableConfigPlugin_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(strs, MessageBoxOptions.OKCancel, confirmCallBacks);
                args.setCancel(true);
            }
        } else if ("cancel".equals(operateKey)) {
            this.getPageCache().put("nextNode", this.getPageCache().get("focusNodeId"));
            this.getPageCache().put("nextParentNode", this.getPageCache().get("parentNodeId"));
            if (this.checkCancelDataChange()) {
                args.setCancel(true);
            } else {
                this.getPageCache().remove("dataId");
                this.getPageCache().remove("modifyNodeId");
                this.getView().updateView();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        super.afterDoOperation(afterDoOperationEventArgs);
        if (HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"deleteentity")) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                TreeNode root = this.getRootNode();
                TreeView tv = (TreeView)this.getView().getControl("treeviewap");
                tv.focusNode(root);
                tv.treeNodeClick(root.getParentid(), root.getId());
                this.getPageCache().put("focusNodeId", root.getId());
                this.getPageCache().put("parentNodeId", root.getParentid());
                this.getPageCache().remove("deleteFlag");
                this.getModel().createNewData(null);
                this.getView().getPageCache().put("treeNodeClick", "2");
                this.getView().updateView();
            } else {
                this.getPageCache().remove("deleteFlag");
            }
        } else if (HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"save") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.setModelVal("rule", this.getFilterCondition());
            this.getView().setVisible(Boolean.TRUE, new String[]{"modifyentity", "addentity", "deleteentity"});
            this.getPageCache().remove("dataId");
            this.getPageCache().remove("modifyNodeId");
            this.hiddenControls();
            this.updateEntryName(afterDoOperationEventArgs);
            this.getView().getPageCache().put("treeNodeClick", "2");
            KeywordMappingServiceHelper.updateModelUpgradFlag((String)this.getMainEntity(), (String)"1");
            this.getView().updateView();
        }
    }

    private void updateEntryName(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObject[] entityByParentId = KeywordMappingServiceHelper.findEntityByParentId((long)((Long)afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0)));
        DynamicObject tplVariableConfig = KeywordMappingServiceHelper.getTplVariableConfig((Object)((Long)afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0)));
        String parentIsEntry = tplVariableConfig.getString("isentry");
        if ("1".equals(parentIsEntry)) {
            return;
        }
        String name = this.getShowName(tplVariableConfig);
        for (DynamicObject dynamicObject : entityByParentId) {
            String isEntry = dynamicObject.getString("isentry");
            if (!"1".equals(isEntry)) continue;
            String entryName = dynamicObject.getString("entryname");
            String[] split = entryName.split("\\.");
            String newEntryName = name + "." + split[1];
            dynamicObject.set("entryname", (Object)newEntryName);
            this.serviceHelper.updateOne(dynamicObject);
        }
    }

    private String getShowName(DynamicObject tplVariableConfig) {
        ILocaleString sonLocal;
        ILocaleString localeString = tplVariableConfig.getLocaleString("sonentityalias");
        String name = null == localeString || localeString.size() == 0 || HRStringUtils.isEmpty((String)localeString.getLocaleValue()) ? ((sonLocal = tplVariableConfig.getDynamicObject("sonentity").getLocaleString("name")) == null || sonLocal.size() == 0 || HRStringUtils.isEmpty((String)sonLocal.getLocaleValue()) ? tplVariableConfig.getDynamicObject("sonentity").getString("number") : sonLocal.getLocaleValue()) : localeString.getLocaleValue();
        return name;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("parentfieldname".equals(key)) {
            String focusNode = this.getFocusNode();
            DynamicObject tplVariableConfig = KeywordMappingServiceHelper.getTplVariableConfig((Object)focusNode);
            long aLong = tplVariableConfig.getLong("parentid");
            if (aLong == 0L) {
                this.showFieldForm(this.buildTreeNodesByEntityType(this.getMainEntity(), "", ""), this.getMainEntity(), "parentfieldname");
            } else {
                DynamicObject parent = KeywordMappingServiceHelper.getTplVariableConfig((Object)tplVariableConfig.get("parentid"));
                if (HRStringUtils.equals((String)"1", (String)parent.getString("isentry"))) {
                    String entryNumber = parent.getString("entrynumber");
                    String[] split = entryNumber.split("\\.");
                    this.showFieldForm(this.buildTreeNodesByEntityType(split[0], "", split[1]), split[0], "parentfieldname");
                } else {
                    String number = tplVariableConfig.getDynamicObject("parententity").getString("number");
                    this.showFieldForm(this.buildTreeNodesByEntityType(number, "", ""), number, "parentfieldname");
                }
            }
        } else if ("sonfieldname".equals(key)) {
            DynamicObject entity = (DynamicObject)this.getModel().getValue("sonentity");
            String entryNumber = (String)this.getModel().getValue("entrynumber");
            if (!HRStringUtils.isEmpty((String)entryNumber)) {
                return;
            }
            if (ObjectUtils.isEmpty((Object)entity) && HRStringUtils.isEmpty((String)entryNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b50\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"TplVariableConfigPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            String number = entity.getString("number");
            this.showFieldForm(this.buildTreeNodesByEntityType(number, "", ""), number, "sonfieldname");
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.contains("addentity")) {
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (Objects.isNull(returnData) || returnData.size() == 0) {
                return;
            }
            String number = (String)returnData.get("number");
            Object id = returnData.get("id");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_tplvariableconfig");
            DynamicObject parentDy = serviceHelper.queryOne(id);
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof EntryProp)) continue;
                String alias = ((EntryProp)property).getDynamicCollectionItemPropertyType().getAlias();
                if (Objects.isNull(property.getDisplayName()) || HRStringUtils.isEmpty((String)alias) || Objects.isNull(dataEntityType.getDisplayName())) continue;
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                dynamicObject.set("status", parentDy.get("status"));
                dynamicObject.set("creator", parentDy.get("creator"));
                dynamicObject.set("enable", parentDy.get("enable"));
                dynamicObject.set("ctrlstrategy", parentDy.get("ctrlstrategy"));
                dynamicObject.set("parententity", (Object)number);
                dynamicObject.set("mainentity", (Object)this.getMainEntity());
                dynamicObject.set("parentid", id);
                dynamicObject.set("createorg", (Object)this.getOrgRootId());
                String entityName = dataEntityType.getDisplayName().getLocaleValue();
                String entityDisName = HRStringUtils.isEmpty((String)entityName) ? dataEntityType.getName() : entityName;
                String entryName = property.getDisplayName().getLocaleValue();
                String entryDisName = HRStringUtils.isEmpty((String)entryName) ? property.getName() : entryName;
                ILocaleString localeString = parentDy.getLocaleString("sonentityalias");
                String entryText = localeString == null || localeString.size() == 0 ? entityDisName + "." + entryDisName : localeString.getLocaleValue() + "." + entryDisName;
                dynamicObject.set("entryname", (Object)entryText);
                dynamicObject.set("entrynumber", (Object)(dataEntityType.getName() + "." + property.getName()));
                dynamicObject.set("isentry", (Object)"1");
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                DynamicObject entryDy = serviceHelper.generateEmptyEntryDynamicObject("entryentity");
                entryDy.set("parentfield", (Object)"id");
                entryDy.set("parentfieldname", (Object)"id");
                entryDy.set("sonfieldname", (Object)"id");
                entryDy.set("sonfield", (Object)"id");
                entryDy.set("seq", (Object)1);
                entryDy.set("fieldcondition", (Object)ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TplVariableConfigPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                dynamicObjectCollection.add((Object)entryDy);
                dynamicObject.set("entryentity", (Object)dynamicObjectCollection);
                serviceHelper.saveOne(dynamicObject);
            }
            TreeView tv = (TreeView)this.getView().getControl("treeviewap");
            TreeNode focusNode = new TreeNode(this.getFocusNode(), id.toString(), parentDy.getLocaleString("sonentityalias").getLocaleValue());
            this.getPageCache().put("nextNode", focusNode.getId());
            this.getPageCache().put("nextParentNode", focusNode.getParentid());
            this.getPageCache().put("focusNodeId", focusNode.getId());
            this.getPageCache().put("parentNodeId", focusNode.getParentid());
            this.getView().getPageCache().put("treeNodeClick", "2");
            KeywordMappingServiceHelper.initEntityTree((TreeNode)focusNode, (IFormView)this.getView(), (String)KeywordMappingServiceHelper.getRootId((String)this.getMainEntity()), (String)this.getMainEntityName(), (String)this.getView().getPageCache().get("treeNodeClick"));
            tv.addTreeNodeClickListener((TreeNodeClickListener)this);
            tv.treeNodeClick(focusNode.getParentid(), focusNode.getId());
            this.hiddenControls();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("switchForm".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                String modifyNode = this.getPageCache().get("modifyNodeId");
                String lastTreeNodeId = "";
                String lastTreeNodeParentId = "";
                if (HRStringUtils.isNotEmpty((String)modifyNode)) {
                    lastTreeNodeId = this.getPageCache().get("nextNode");
                    lastTreeNodeParentId = this.getPageCache().get("nextParentNode");
                } else {
                    lastTreeNodeId = this.getPageCache().get("focusNodeId");
                    lastTreeNodeParentId = this.getPageCache().get("parentNodeId");
                }
                this.getPageCache().put("focusNodeId", lastTreeNodeId);
                this.getPageCache().put("parentNodeId", lastTreeNodeParentId);
                TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
                treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
                TreeNode focusNode = new TreeNode(lastTreeNodeParentId, lastTreeNodeId, null);
                treeView.focusNode(focusNode);
                this.getPageCache().put("confirmFlag", "1");
                treeView.treeNodeClick(lastTreeNodeParentId, lastTreeNodeId);
                this.getPageCache().remove("confirmFlag");
                this.getPageCache().remove("modifyNodeId");
            }
        } else if ("confirmdelete".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getPageCache().put("deleteFlag", "1");
            this.getView().invokeOperation("deleteentity");
        }
    }

    private TreeNode getRootNode() {
        String rootId = KeywordMappingServiceHelper.getRootId((String)this.getMainEntity());
        TreeNode root = new TreeNode("0", rootId, this.getMainEntityName());
        return root;
    }

    private void hiddenControls() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"addentry", "deleteentry", "up", "down", "save", "cancel"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"filtergridap", "entryentity", "fs_baseinfo"});
    }

    private void showControls() {
        boolean issyspreset = (Boolean)this.getModelVal("issyspreset");
        if (issyspreset) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addentry", "deleteentry", "up", "down"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"save", "cancel"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"filtergridap", "fs_baseinfo"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"addentry", "deleteentry", "up", "down", "save", "cancel"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"filtergridap", "entryentity", "fs_baseinfo"});
        }
    }

    private void hiddenEntryControls() {
        if (HRStringUtils.equals((String)"1", (String)this.getFocusEntity())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"addentry", "deleteentry", "up", "down"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    private String getFocusNode() {
        String focusNodeId = this.getPageCache().get("focusNodeId");
        if (HRStringUtils.isEmpty((String)focusNodeId)) {
            focusNodeId = KeywordMappingServiceHelper.getRootId((String)this.getMainEntity());
        }
        return focusNodeId;
    }

    private String getMainEntity() {
        Map formMap = (Map)this.getView().getFormShowParameter().getCustomParam("mappingEntity");
        if (null == formMap) {
            return "";
        }
        String mainNumber = "";
        for (Map.Entry entry : formMap.entrySet()) {
            mainNumber = (String)entry.getKey();
        }
        return mainNumber;
    }

    private String getMainEntityName() {
        Map formMap = (Map)this.getView().getFormShowParameter().getCustomParam("mappingEntity");
        if (null == formMap) {
            return "";
        }
        String value = "";
        for (Map.Entry entry : formMap.entrySet()) {
            value = (String)entry.getValue();
        }
        return value;
    }

    private String getFocusEntity() {
        String focusNode = this.getFocusNode();
        if (HRStringUtils.isEmpty((String)focusNode)) {
            return null;
        }
        DynamicObject tplVariableConfig = KeywordMappingServiceHelper.getTplVariableConfig((Object)focusNode);
        DynamicObject dynamicObject = tplVariableConfig.getDynamicObject("sonentity");
        return dynamicObject == null ? "1" : tplVariableConfig.getDynamicObject("sonentity").getString("number");
    }

    private void fillFormData(DynamicObject tplVariableConfig) {
        DynamicObjectCollection entryentity = tplVariableConfig.getDynamicObjectCollection("entryentity");
        if (tplVariableConfig.getDynamicObject("parententity") != null) {
            String parentNumber = tplVariableConfig.getDynamicObject("parententity").getString("number");
            String isEntry = tplVariableConfig.getString("isentry");
            String sonNumber = "";
            sonNumber = HRStringUtils.equals((String)"1", (String)isEntry) ? tplVariableConfig.getString("entrynumber") : tplVariableConfig.getDynamicObject("sonentity").getString("number");
            for (DynamicObject dynamicObject : entryentity) {
                String parentField = dynamicObject.getString("parentfield");
                String sonField = dynamicObject.getString("sonfield");
                String parentFieldLang = parentNumber + "." + parentField;
                String sonFieldLang = sonNumber + "." + sonField;
                dynamicObject.set("parentfieldname", (Object)EntityFieldTreeUtil.getDisplayNameContainsEntry((String)parentFieldLang, (Boolean)Boolean.FALSE));
                if (HRStringUtils.equals((String)"1", (String)isEntry)) {
                    dynamicObject.set("sonfieldname", (Object)"id");
                } else {
                    dynamicObject.set("sonfieldname", (Object)EntityFieldTreeUtil.getDisplayNameContainsEntry((String)sonFieldLang, (Boolean)Boolean.FALSE));
                }
                dynamicObject.set("fieldcondition", (Object)ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TplVariableConfigPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
        this.getModel().createNewData((Object)tplVariableConfig);
        this.initFilterGrid(tplVariableConfig);
        this.getView().updateView();
    }

    private void initFilterGrid(DynamicObject tplVariableConfig) {
        String idByNumber;
        DynamicObject sonentity = tplVariableConfig.getDynamicObject("sonentity");
        String rule = tplVariableConfig.getString("rule");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        DynamicObject parententity = tplVariableConfig.getDynamicObject("parententity");
        if (null == sonentity) {
            if (null == parententity) {
                return;
            }
            filterGrid.setEntityNumber(parententity.getString("number"));
            idByNumber = MetadataDao.getIdByNumber((String)parententity.getString("number"), (MetaCategory)MetaCategory.Form);
            this.getMetaData(idByNumber);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)parententity.getString("number"));
            List fieldColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)entityType);
            List<Map<String, Object>> filterField = this.getFilterField(fieldColumns, tplVariableConfig, "1");
            filterGrid.setFilterColumns(filterField);
        } else {
            filterGrid.setEntityNumber(sonentity.getString("number"));
            idByNumber = MetadataDao.getIdByNumber((String)sonentity.getString("number"), (MetaCategory)MetaCategory.Form);
            this.getMetaData(idByNumber);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)sonentity.getString("number"));
            List fieldColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)entityType);
            List<Map<String, Object>> filterField = this.getFormHeadField(fieldColumns, sonentity.getString("number"));
            filterGrid.setFilterColumns(filterField);
        }
        if (HRStringUtils.isNotEmpty((String)rule)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
            filterGrid.SetValue(fc);
        } else {
            filterGrid.SetValue(new FilterCondition());
        }
    }

    private List<Map<String, Object>> getFilterField(List<Map<String, Object>> fieldColumns, DynamicObject tplVariableConfig, String entryFlag) {
        if ("1".equals(entryFlag)) {
            String entryNumber = tplVariableConfig.getString("entrynumber");
            String[] split = entryNumber.split("\\.");
            Set allHRCloudId = HRCloudServiceHelper.getAllHRCloudId();
            List<Map<String, Object>> fieldList = fieldColumns.stream().filter(fieldMap -> {
                String entryEntity = (String)fieldMap.get("entryEntity");
                if (HRStringUtils.equals((String)entryEntity, (String)split[1])) {
                    return this.removeNotHrEntity((Map)fieldMap, allHRCloudId);
                }
                return false;
            }).collect(Collectors.toList());
            return fieldList;
        }
        return null;
    }

    private boolean checkDataChange() {
        boolean isChange = this.judgeDataChange();
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u4fdd\u5b58", (String)"TplVariableConfigPlugin_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u5207\u6362", (String)"TplVariableConfigPlugin_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u5207\u6362\u4e1a\u52a1\u5bf9\u8c61\uff1f\u5982\u679c\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TplVariableConfigPlugin_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("switchForm", (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return isChange;
    }

    private boolean checkCancelDataChange() {
        boolean isChange = this.judgeDataChange();
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"DisplaySchemePlugin_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"DisplaySchemePlugin_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u5982\u679c\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DisplaySchemePlugin_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("switchForm", (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return isChange;
    }

    private boolean judgeDataChange() {
        String modifyNode = this.getPageCache().get("modifyNodeId");
        boolean isChange = this.getModel().getDataChanged() && HRStringUtils.isNotEmpty((String)modifyNode);
        boolean filterChange = this.compareFilterControls(modifyNode) && HRStringUtils.isNotEmpty((String)modifyNode);
        return isChange || filterChange;
    }

    private boolean compareFilterControls(String modifyNode) {
        if (HRStringUtils.isEmpty((String)modifyNode)) {
            return false;
        }
        DynamicObject dynamicObject = this.serviceHelper.queryOne((Object)modifyNode);
        String rule = dynamicObject.getString("rule");
        String filterCondition = this.getFilterCondition();
        DynamicObject sonEntity = dynamicObject.getDynamicObject("sonentity");
        String entity = "";
        if (null == sonEntity) {
            String entryNumber = dynamicObject.getString("entrynumber");
            String[] split = entryNumber.split("\\.");
            entity = split[0];
        } else {
            entity = sonEntity.getString("number");
        }
        QFilter newQFilter = HRStringUtils.isEmpty((String)filterCondition) ? new QFilter("1", "=", (Object)"1") : KeywordMappingServiceHelper.convertJsonToQFilter((String)entity, (String)filterCondition);
        QFilter oldQFilter = HRStringUtils.isEmpty((String)rule) ? new QFilter("1", "=", (Object)"1") : KeywordMappingServiceHelper.convertJsonToQFilter((String)entity, (String)rule);
        String newQFilterStr = newQFilter.toSerializedString();
        String oldQFilterStr = oldQFilter.toSerializedString();
        boolean equals = oldQFilterStr.equals(newQFilterStr);
        return !equals;
    }

    private String getFilterCondition() {
        String ruleStr;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
        fc.getFilterRow();
        if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow()) && HRStringUtils.isNotEmpty((String)(ruleStr = SerializationUtils.toJsonString((Object)fc)))) {
            return ruleStr;
        }
        return "";
    }

    private boolean checkMustInput() {
        DynamicObject parentEntity = (DynamicObject)this.getView().getModel().getValue("parententity");
        DynamicObject sonEntity = (DynamicObject)this.getView().getModel().getValue("sonentity");
        return HRStringUtils.equals((String)"1", (String)this.getFocusEntity()) || null != parentEntity && null != sonEntity;
    }

    private boolean checkDelete() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        DynamicObject[] entityByParentId = KeywordMappingServiceHelper.findEntityByParentId((long)pkValue);
        return null == entityByParentId || entityByParentId.length <= 0;
    }
}

