/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.encryptapi;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class EncryptApiConfigPlugin
extends HRDataBaseEdit {
    private static final String ENCRYPT_API = "encryptapi";
    private static final String ENCRYPT_SCHEME = "encryptscheme";
    private static final String OPEN_ENCRYPT_CALL_BACK = "openEncryptCallBack";
    private static final String CLOSE_ENCRYPT_CALL_BACK = "closeEncryptCallBack";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Boolean isPrivacyOpen = (Boolean)this.getModel().getValue(ENCRYPT_API);
        if (isPrivacyOpen != null && isPrivacyOpen.booleanValue()) {
            this.setEncryptSchemeValue();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENCRYPT_SCHEME});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (ENCRYPT_API.equals(fieldKey)) {
            Boolean isPrivacyOpen = (Boolean)e.getChangeSet()[0].getNewValue();
            if (isPrivacyOpen != null && isPrivacyOpen.booleanValue()) {
                String format = ResManager.loadKDString((String)"\u542f\u7528\u540e\uff0c\u5c06\u6839\u636e\u52a0\u5bc6\u65b9\u6848\u5728\u521d\u59cb\u5316\u5b9a\u8c03\u85aa\u8bb0\u5f55\u540c\u6b65\u81f3\u85aa\u916c\u7ba1\u7406\u65f6\u8fdb\u884c\u6570\u636e\u52a0\u5bc6\u4f20\u8f93\uff0c\u63d0\u4f9b\u66f4\u9ad8\u7b49\u7ea7\u7684\u6570\u636e\u5b89\u5168\u4fdd\u969c\u3002", (String)"EncryptApiConfigPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(format, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(OPEN_ENCRYPT_CALL_BACK));
            } else {
                String format = ResManager.loadKDString((String)"\u5173\u95ed\u540e\uff0c\u5df2\u8c03\u7528\u201c\u9ed8\u8ba4\u52a0\u5bc6\u65b9\u6848\u201d\u65b9\u6cd5\u7684\u6570\u636e\u5c06\u65e0\u6cd5\u8fdb\u884c\u52a0\u5bc6\u4f20\u8f93\uff0c\u786e\u8ba4\u5173\u95ed\uff1f", (String)"EncryptApiConfigPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(format, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CLOSE_ENCRYPT_CALL_BACK));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String callBackId;
            switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
                case "openEncryptCallBack": {
                    this.setEncryptSchemeValue();
                    break;
                }
                case "closeEncryptCallBack": {
                    this.getView().getModel().setValue(ENCRYPT_SCHEME, null);
                    this.getView().setVisible(Boolean.FALSE, new String[]{ENCRYPT_SCHEME});
                    break;
                }
            }
        } else {
            String callBackId;
            switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
                case "openEncryptCallBack": {
                    this.updateEncryptCheckBoxValue(false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{ENCRYPT_SCHEME});
                    break;
                }
                case "closeEncryptCallBack": {
                    this.updateEncryptCheckBoxValue(true);
                    this.setEncryptSchemeValue();
                    break;
                }
            }
        }
    }

    private void updateEncryptCheckBoxValue(boolean flag) {
        this.getModel().beginInit();
        this.getModel().setValue(ENCRYPT_API, (Object)flag);
        this.getModel().endInit();
        this.getView().updateView(ENCRYPT_API);
    }

    private void setEncryptSchemeValue() {
        this.getView().setVisible(Boolean.TRUE, new String[]{ENCRYPT_SCHEME});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(ENCRYPT_SCHEME);
        basedataEdit.setMustInput(true);
    }
}

