/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.esign;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateSealQuery;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.constant.ESignAppCfgEditPage;
import kd.hr.hrcs.bussiness.service.esign.factory.BaseESignSrvFactory;
import kd.hr.hrcs.bussiness.service.esign.res.ResponseData;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignSPMgrUtil;
import kd.hr.hrcs.bussiness.service.esign.util.EncryptionSchemeUtil;
import kd.hr.hrcs.formplugin.common.HrcsFormpluginRes;
import org.apache.commons.lang3.ObjectUtils;

public class ESignAppCfgEdit
extends HRDataBaseEdit
implements ESignAppCfgEditPage,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(ESignAppCfgEdit.class);

    public void initialize() {
        super.initialize();
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object spId = this.getView().getParentView().getModel().getValue("id");
        if (ObjectUtils.isNotEmpty((Object)spId) && (Long)spId != 0L) {
            if (ESignSPMgrUtil.isFdd((long)((Long)spId))) {
                int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", 1);
                IDataModel model = this.getModel();
                model.setValue("key", (Object)"businessId", rowIndex[0]);
                model.setValue("desc", (Object)ResManager.loadKDString((String)"\u514d\u9a8c\u8bc1\u7b7e\u573a\u666f\u7801", (String)HrcsFormpluginRes.ESignAppCfgEdit_1.resId(), (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), rowIndex[0]);
                model.setValue("value", (Object)" ", rowIndex[0]);
            }
        } else {
            IPageCache pageCache = this.getView().getParentView().getPageCache();
            this.getModel().setValue("temprelspid", (Object)pageCache.get("temprelspid"));
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnsave", "btncancel", "btnclose"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("corporate");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "btnsave": {
                break;
            }
            case "btncancel": 
            case "btnclose": {
                this.getView().close();
            }
        }
    }

    private void setEncodeAppSecret() {
        String appSecret = this.getModelValStr("appsecret");
        if ("******".equals(appSecret)) {
            return;
        }
        long enSchemeId = EncryptionSchemeUtil.getEncryptionSchemeId();
        if (HRStringUtils.isNotEmpty((String)appSecret) && enSchemeId != 0L) {
            JSONObject encodeData = PermissionServiceHelper.encryptData((long)enSchemeId, (String)appSecret);
            if (encodeData.getBoolean("success").booleanValue()) {
                this.getModel().setValue("appsecreten", (Object)encodeData.getString("data"));
                this.getModel().setValue("appsecret", (Object)"******");
            } else {
                logger.error("encodeData:{}", (Object)encodeData);
            }
        }
    }

    private void setAppSecret() {
        JSONObject decodeData;
        String encodeAppSecret = this.getModelValStr("appsecreten");
        long enSchemeId = EncryptionSchemeUtil.getEncryptionSchemeId();
        if (HRStringUtils.isNotEmpty((String)encodeAppSecret) && enSchemeId != 0L && (decodeData = PermissionServiceHelper.decryptData((long)enSchemeId, (String)encodeAppSecret)).getBoolean("success").booleanValue()) {
            this.getModel().setValue("appsecret", (Object)decodeData.getString("data"));
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject spDyn = (DynamicObject)this.getModelVal("esignsp");
        FormOperate fo = (FormOperate)args.getSource();
        switch (fo.getOperateKey()) {
            case "save": {
                BaseESignSrvFactory srvFactory;
                CorporateSealQuery corporateSealQuery;
                DynamicObjectCollection eSignSPSrvClazzs;
                boolean isNew;
                boolean bl = isNew = !this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                if (isNew) {
                    if (!this.checkMustInput()) {
                        return;
                    }
                    for (String needClearBlankField : needClearBlankFields) {
                        String pageValue = this.getModelValStr(needClearBlankField);
                        pageValue = pageValue.trim();
                        this.getModel().setValue(needClearBlankField, (Object)pageValue);
                    }
                    this.clearEntryBlank();
                    String appId = this.getModelValStr("appid");
                    QFilter appIdQFilter = HRQFilterHelper.buildEql((String)"appid", (Object)appId);
                    Object tempRelSpId = this.getModel().getValue("temprelspid");
                    QFilter spIdQFilter = StringUtils.isNotBlank((Object)tempRelSpId) ? HRQFilterHelper.buildEql((String)"temprelspid", (Object)tempRelSpId) : HRQFilterHelper.buildEql((String)"esignsp", (Object)spDyn.getPkValue());
                    boolean exists = ESignDBServiceUtil.eSignAppCfgService.isExists(new QFilter[]{appIdQFilter, spIdQFilter});
                    if (exists) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u670d\u52a1\u5546\u5df2\u914d\u7f6eAppID\u4e3a\u201c%s\u201d\u7684\u5e94\u7528\uff0c\u4e00\u4e2a\u670d\u52a1\u5546\u4e0b\u53ea\u652f\u6301\u914d\u7f6e\u4e00\u6761\u3002", (String)HrcsFormpluginRes.ESignAppCfgEdit_2.resId(), (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), appId));
                        args.setCancel(true);
                        return;
                    }
                }
                if (CollectionUtils.isEmpty((Collection)(eSignSPSrvClazzs = this.getView().getParentView().getModel().getEntryEntity("entryentity")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u670d\u52a1\u7c7b\u6ce8\u518c\u3002", (String)HrcsFormpluginRes.ESignSPMgrEdit_1.resId(), (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Map<String, String> instanceMap = eSignSPSrvClazzs.stream().collect(Collectors.toMap(it -> it.getString("interface"), it -> it.getString("plugin")));
                DynamicObject corporate = (DynamicObject)this.getModel().getValue("corporate");
                String spId = ObjectUtils.isNotEmpty((Object)spDyn) ? String.valueOf(spDyn.getPkValue()) : this.getModelValStr("temprelspid");
                ESignAppInfo eSignAppInfo = ESignAppInfo.build((String)spId, (String)String.valueOf(corporate.getPkValue()), (String)this.getModelValStr("appid"), (String)this.getModelValStr("appsecret"), (String)this.getModelValStr("serverurl"), (String)this.getModelValStr("thirdcorpid"), (String)"", (Long)0L, null);
                DynamicObjectCollection entryExtParams = this.getModel().getEntryEntity("entryentity");
                if (entryExtParams != null && entryExtParams.size() > 0) {
                    Map<String, String> extParams = entryExtParams.stream().collect(Collectors.toMap(dyn -> dyn.getString("key"), dyn -> dyn.getString("value")));
                    eSignAppInfo.setExtParams(extParams);
                }
                if (ObjectUtils.isEmpty((Object)(corporateSealQuery = (srvFactory = new BaseESignSrvFactory(eSignAppInfo, instanceMap)).getCorporateSealQuery()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u670d\u52a1\u7c7b\u6ce8\u518c\u3002", (String)HrcsFormpluginRes.ESignSPMgrEdit_1.resId(), (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ResponseData responseData = corporateSealQuery.check(eSignAppInfo);
                if (responseData.isFail()) {
                    throw new KDBizException(responseData.getMsg());
                }
                this.setEncodeAppSecret();
                return;
            }
        }
        if (!this.clearEntryBlank()) {
            // empty if block
        }
    }

    private boolean checkMustInput() {
        for (String needClearBlankField : needClearBlankFields) {
            String pageValue = this.getModelValStr(needClearBlankField);
            if (!StringUtils.isBlank((CharSequence)pageValue)) continue;
            return false;
        }
        DynamicObject corporate = (DynamicObject)this.getModel().getValue("corporate");
        if (ObjectUtils.isEmpty((Object)corporate)) {
            return false;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dyn = (DynamicObject)entryEntity.get(i);
                for (String needClearBlankField : needClearBlankEntryFields) {
                    String pageValue = dyn.getString(needClearBlankField);
                    if (!StringUtils.isBlank((CharSequence)pageValue)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean clearEntryBlank() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dyn = (DynamicObject)entryEntity.get(i);
                for (String needClearBlankField : needClearBlankEntryFields) {
                    String pageValue = dyn.getString(needClearBlankField);
                    if (StringUtils.isBlank((CharSequence)pageValue)) {
                        return false;
                    }
                    pageValue = pageValue.trim();
                    this.getModel().setValue(needClearBlankField, (Object)pageValue, i);
                }
            }
        }
        return true;
    }

    public void beforeBindData(EventObject args) {
        super.beforeBindData(args);
        Object spId = this.getView().getParentView().getModel().getValue("id");
        if (ObjectUtils.isNotEmpty((Object)spId) && (Long)spId != 0L) {
            this.getModel().setValue("esignsp", spId);
            if (ESignSPMgrUtil.isFdd((long)((Long)spId))) {
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"key"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"desc"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap"});
                DynamicObject entryEntity = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(0);
                entryEntity.getDataEntityState().setBizChanged(true);
                entryEntity.getDataEntityState().setBizChangeFlags(new long[]{1L});
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            view.setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
        }
        this.setAppSecret();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate instanceof Save && StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            OpBizRuleSetServiceHelper.clearCache();
            HashMap<String, Object> returnData = new HashMap<String, Object>(2);
            IDataModel model = this.getModel();
            returnData.put("bdesignappcfg", model.getValue("id"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if (formOperate instanceof Save && StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            this.setAppSecret();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName = evt.getProperty().getName();
        if ("corporate".equals(propertyName)) {
            Set cropIds;
            DynamicObject spDyn = (DynamicObject)this.getModel().getValue("esignsp");
            if (spDyn != null) {
                cropIds = ESignAppCfgUtil.getCorporateIdsBySPId((Long)spDyn.getLong("id"));
            } else {
                IPageCache pageCache = this.getView().getParentView().getPageCache();
                cropIds = ESignAppCfgUtil.getCorporateIdsByTempSPId((String)pageCache.get("temprelspid"));
            }
            if (CollectionUtils.isNotEmpty((Collection)cropIds)) {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)cropIds));
            }
        }
    }
}

