/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.esign;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.esign.constant.ESignCOSealEditPage;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOSealMgrUtil;
import org.apache.commons.lang3.ObjectUtils;

public class ESignCOSealEdit
extends HRDataBaseEdit
implements ESignCOSealEditPage {
    private static final Log LOGGER = LogFactory.getLog(ESignCOSealEdit.class);

    public void afterCreateNewData(EventObject e) {
        String appNumber;
        String corporateNumber;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long spId = (Long)formShowParameter.getCustomParam("spId");
        if (ObjectUtils.isNotEmpty((Object)spId)) {
            this.getModel().setValue("esignsp", (Object)spId);
        }
        if (StringUtils.isNotBlank((CharSequence)(corporateNumber = (String)formShowParameter.getCustomParam("corporateNumber")))) {
            this.getModel().setValue("corporate", (Object)ESignCOSealMgrUtil.getCorporateId((String)corporateNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)(appNumber = (String)formShowParameter.getCustomParam("appNumber")))) {
            this.getModel().setValue("esignapp", (Object)ESignAppCfgUtil.getESignAppId((String)appNumber));
        }
        BasedataEdit sealTypeControl = (BasedataEdit)this.getControl("sealtype");
        this.setMustInput(sealTypeControl);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"sealpic"});
        } else {
            String thirdAuditStatus = (String)this.getModel().getValue("thirdauditstatus");
            if ("2".equals(thirdAuditStatus)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"sealpic"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"sealpic"});
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.sealSortControl();
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnsave", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName = args.getProperty().getName();
        if ("sealsortradiogrp".equals(propName)) {
            this.sealSortControl();
        }
    }

    private void sealSortControl() {
        BasedataEdit sealTypeControl = (BasedataEdit)this.getControl("sealtype");
        String sealSort = this.getModelValStr("sealsortradiogrp");
        if ("larseal".equals(sealSort)) {
            this.setNotMustInput(sealTypeControl);
            this.setModelNullVal("sealtype");
            this.hide("sealtype");
        } else {
            this.setMustInput(sealTypeControl);
            this.show("sealtype");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate instanceof Save && StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            OpBizRuleSetServiceHelper.clearCache();
            HashMap returnData = new HashMap(0);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

