/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Html;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.formula.cal.FormulaAnalysis;
import kd.hr.hbp.business.service.formula.cal.template.FormulaParse;
import kd.hr.hbp.business.service.formula.entity.freemarker.FormulaDescFreemarkerVO;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.ParamItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.util.FreemarkerUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.common.util.CodeUtils;

public class FunctionOnlineTestEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(FunctionOnlineTestEdit.class);
    private static final String FIELD_FUNCTION_PARAM_ENTITY = "functionparamentity";
    private static final String FIELD_RESULT = "result";
    private static final String FIELD_PARAM_NAME = "paramname";
    private static final String FIELD_PARAM_VALUE = "paramvalue";
    private static final String HTML_FUNCTION_DESC = "functiondeschtml";
    private static final String BTN_ONLINE_TEST = "onlinetestbtn";
    private static final String TEMPLATE_NAME = "FormulaEditDesc";
    private static final String OP_TEST_FUNCTION = "testfunction";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.nonNull(formShowParameter.getCustomParam("functionItem"))) {
            FunctionItem functionItem = (FunctionItem)((JSONObject)formShowParameter.getCustomParam("functionItem")).toJavaObject(FunctionItem.class);
            this.initParamEntity(functionItem);
            this.initFunctionDescHtml(functionItem);
            if (HRStringUtils.isEmpty((String)((String)formShowParameter.getCustomParam("funcExp")))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u51fd\u6570\u4f53\u540e\u518d\u8fdb\u884c\u5728\u7ebf\u8c03\u8bd5\u51fd\u6570\u3002", (String)"FunctionOnlineTestEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ONLINE_TEST});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (HRStringUtils.equals((String)OP_TEST_FUNCTION, (String)operate.getOperateKey()) && Objects.nonNull(formShowParameter.getCustomParam("functionItem"))) {
            FunctionItem functionItem = (FunctionItem)((JSONObject)formShowParameter.getCustomParam("functionItem")).toJavaObject(FunctionItem.class);
            String funcExp = (String)formShowParameter.getCustomParam("funcExp");
            JSONArray importPackages = (JSONArray)formShowParameter.getCustomParam("importPackages");
            Set importPackageSet = importPackages.stream().map(String::valueOf).collect(Collectors.toSet());
            importPackageSet.addAll(FormulaAnalysis.getFormulaImportPackage());
            try {
                Method method = CodeUtils.getMethod(FormulaParse.class, (String)funcExp, importPackageSet);
                Object[] paramValues = this.prepareParamValue(functionItem.getParams(), this.getModel().getEntryEntity(FIELD_FUNCTION_PARAM_ENTITY));
                Object value = method.invoke(method.getDeclaringClass().newInstance(), paramValues);
                if (value instanceof Date) {
                    value = HRDateTimeUtils.format((Date)((Date)value));
                }
                this.getModel().setValue(FIELD_RESULT, (Object)JSON.toJSONString((Object)value));
            }
            catch (KDBizException e) {
                this.getView().showErrorNotification(e.getMessage());
                args.setCancel(true);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                this.getView().showErrorNotification(e.getCause().getMessage());
                args.setCancel(true);
            }
        }
    }

    private void initFunctionDescHtml(FunctionItem functionItem) {
        Html html = (Html)this.getView().getControl(HTML_FUNCTION_DESC);
        try {
            html.setConent(new FreemarkerUtil(FunctionOnlineTestEdit.class, "/formula/template").process((Object)new FormulaDescFreemarkerVO(functionItem), TEMPLATE_NAME));
        }
        catch (Exception exception) {
            this.getView().showErrorNotification("freemarker_analysis_error:" + exception.getMessage());
        }
    }

    private void initParamEntity(FunctionItem functionItem) {
        List params;
        int fieldRowCount = this.getModel().getEntryRowCount(FIELD_FUNCTION_PARAM_ENTITY);
        if (fieldRowCount > 0) {
            this.getModel().deleteEntryRows(FIELD_FUNCTION_PARAM_ENTITY, this.getIntArray(fieldRowCount));
        }
        if (Objects.nonNull(params = functionItem.getParams()) && params.size() > 0) {
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(FIELD_FUNCTION_PARAM_ENTITY, params.size());
            for (int index = 0; index < params.size(); ++index) {
                this.getModel().setValue(FIELD_PARAM_NAME, (Object)((ParamItem)params.get(index)).getParamName(), rowIndex[index]);
            }
        }
    }

    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int rowI = 0; rowI < intArray.length; ++rowI) {
            intArray[rowI] = rowI;
        }
        return intArray;
    }

    private Object[] prepareParamValue(List<ParamItem> params, DynamicObjectCollection entity) {
        Object[] paramValues = new Object[params.size()];
        for (int index = 0; index < params.size(); ++index) {
            ParamItem paramItem = params.get(index);
            DynamicObject dy = (DynamicObject)entity.get(index);
            DataTypeEnum dataType = paramItem.getParamDataType();
            String paramName = dy.getString(FIELD_PARAM_NAME);
            String paramValueStr = dy.getString(FIELD_PARAM_VALUE);
            if (HRStringUtils.isEmpty((String)paramValueStr)) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u53c2\u6570 {0} \u4e0d\u80fd\u4e3a\u7a7a", (String)"FunctionOnlineTestEdit_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), paramName));
            }
            try {
                Object paramValue;
                switch (dataType) {
                    case NUM: {
                        paramValue = new BigDecimal(paramValueStr);
                        break;
                    }
                    case INT: {
                        paramValue = Integer.valueOf(paramValueStr);
                        break;
                    }
                    case TEXT: {
                        paramValue = paramValueStr;
                        break;
                    }
                    case BOOLEAN: {
                        paramValue = "1".equals(paramValueStr) ? Boolean.TRUE : ("0".equals(paramValueStr) ? Boolean.FALSE : Boolean.valueOf(paramValueStr));
                        break;
                    }
                    case DATE: 
                    case DATETIME: {
                        paramValue = this.parseDate(paramValueStr);
                        break;
                    }
                    case ARRAY_NUM: 
                    case ARRAY_STRING: 
                    case ARRAY_INT: 
                    case ARRAY_OBJECT: 
                    case ARRAY_BOOLEAN: 
                    case ARRAY_DATE: {
                        JSONArray paramValueObjArray = null;
                        try {
                            paramValueObjArray = JSONArray.parseArray((String)paramValueStr);
                        }
                        catch (Exception e) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u7ec4\u53c2\u6570\u89e3\u6790JSONArray\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7ed3\u6784\u3002", (String)"FunctionOnlineTestEdit_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                        }
                        paramValue = this.parseArrayValue(dataType, paramValueObjArray);
                        break;
                    }
                    default: {
                        paramValue = paramValueStr;
                    }
                }
                paramValues[index] = paramValue;
                continue;
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53c2\u6570\u201c%1$s\u201d\u7684\u503c\u4e0e\u53c2\u6570\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002\u8bf7\u8f93\u5165\u201c%2$s\u201d\u7c7b\u578b\u7684\u503c\u3002", (String)"FunctionOnlineTestEdit_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), paramName, dataType.getAlias()));
            }
        }
        return paramValues;
    }

    private Object parseArrayValue(DataTypeEnum dataType, JSONArray paramValueObjArray) {
        A[] paramValue = null;
        IntStream indexStream = IntStream.range(0, paramValueObjArray.size());
        switch (dataType) {
            case ARRAY_NUM: {
                paramValue = indexStream.mapToObj(i -> new BigDecimal(String.valueOf(paramValueObjArray.get(i)))).toArray(BigDecimal[]::new);
                break;
            }
            case ARRAY_INT: {
                paramValue = indexStream.mapToObj(i -> Integer.valueOf(String.valueOf(paramValueObjArray.get(i)))).toArray(Integer[]::new);
                break;
            }
            case ARRAY_BOOLEAN: {
                paramValue = indexStream.mapToObj(i -> "1".equals(paramValueObjArray.get(i)) ? Boolean.TRUE : ("0".equals(paramValueObjArray.get(i)) ? Boolean.FALSE : Boolean.valueOf(String.valueOf(paramValueObjArray.get(i))))).toArray(Boolean[]::new);
                break;
            }
            case ARRAY_DATE: {
                paramValue = indexStream.mapToObj(i -> this.parseDate(String.valueOf(paramValueObjArray.get(i)))).toArray(Date[]::new);
                break;
            }
            case ARRAY_OBJECT: {
                paramValue = indexStream.mapToObj(i -> String.valueOf(paramValueObjArray.get(i))).toArray(Object[]::new);
                break;
            }
            default: {
                paramValue = indexStream.mapToObj(i -> String.valueOf(paramValueObjArray.get(i))).toArray(String[]::new);
            }
        }
        return paramValue;
    }

    private Date parseDate(String dateStr) {
        try {
            return HRDateTimeUtils.parseDate((String)dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e5\u671f\u53c2\u6570\u201c%s\u201d\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u6309\u7167\u63a8\u8350\u683c\u5f0f\u586b\u5199\u3002", (String)"FunctionOnlineTestEdit_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), dateStr));
        }
    }
}

