/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.hismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.constants.hismodel.HisEntityDependentConstants;

@ExcludeFromJacocoGeneratedReport
public class EDEntityRelationFieldPlugin
extends AbstractFormPlugin
implements HisEntityDependentConstants {
    private static final String TREE_VIEW = "treeviewap";
    private static final String TREE_ROOT_CACHE_KEY = "treeRoot";

    public void beforeBindData(EventObject e) {
        String entityNum = (String)this.getView().getFormShowParameter().getCustomParam("entityNum");
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam("entityName");
        TreeView tv = (TreeView)this.getView().getControl(TREE_VIEW);
        TreeNode rootNode = new TreeNode(null, entityNum, entityName, true);
        rootNode.setIsOpened(true);
        for (TreeNode treeNode : this.getFieldNodeList(entityNum)) {
            rootNode.addChild(treeNode);
        }
        tv.addNode(rootNode);
        this.getPageCache().put("entityNum", entityNum);
        this.getPageCache().put(TREE_ROOT_CACHE_KEY, SerializationUtils.toJsonString((Object)rootNode));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"ok")) {
            TreeView tv = (TreeView)this.getView().getControl(TREE_VIEW);
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (HRStringUtils.isEmpty((String)focusNodeId)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u3002", (String)"SelectEntityFieldsPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                return;
            }
            String rootNodeStr = this.getPageCache().get(TREE_ROOT_CACHE_KEY);
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            TreeNode treeNode = rootNode.getTreeNode(focusNodeId);
            String number = treeNode.getId();
            String otherFieldType = (String)this.getView().getFormShowParameter().getCustomParam("fieldType");
            String thisFieldType = (String)treeNode.getData();
            if (!this.validateFieldType(args, thisFieldType, otherFieldType)) {
                return;
            }
            String displayName = treeNode.getText();
            HashMap returnDataMap = Maps.newHashMapWithExpectedSize((int)16);
            returnDataMap.put("displayName", displayName);
            returnDataMap.put("number", number);
            returnDataMap.put("fieldType", thisFieldType);
            this.getView().returnDataToParent((Object)returnDataMap);
        }
    }

    private List<TreeNode> getFieldNodeList(String entityNum) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNum);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList nodeList = Lists.newArrayListWithExpectedSize((int)properties.size());
        for (IDataEntityProperty property : properties) {
            if (property.getDisplayName() == null || property.getPropertyType() == null) continue;
            TreeNode rootNode = new TreeNode(entityNum, property.getName(), property.getDisplayName().getLocaleValue(), false);
            rootNode.setData((Object)property.getPropertyType().getName());
            nodeList.add(rootNode);
        }
        return nodeList;
    }

    private boolean validateFieldType(BeforeDoOperationEventArgs args, String thisFieldType, String otherFieldType) {
        boolean isPass = true;
        if (HRStringUtils.isEmpty((String)otherFieldType)) {
            return true;
        }
        if (!HRStringUtils.equals((String)thisFieldType, (String)otherFieldType)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u540c\u7c7b\u578b\u5b57\u6bb5\u5173\u8054\uff0c\u8bf7\u66f4\u6539\u3002", (String)"SelectEntityFieldsPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            isPass = false;
        }
        return isPass;
    }
}

