/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.hismodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.hismodel.model.constant.HisSystemConstants;

public class HisEntityRegEdit
extends HRDataBaseEdit
implements HisSystemConstants {
    private static final String IGNORE_FIELD = "ignorefield";
    private final Set<String> ignoreFields = Stream.of("modifier", "creator", "createtime", "enable", "masterid", "status", "modifytime", "disabler", "disabledate", "bsed", "bsled", "boid", "iscurrentversion", "datastatus", "sourcevid", "firstbsed", "changebsed", "ismodify", "bred", "brled", "brfd", "hisversion", "versionsource").collect(Collectors.toSet());

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject entityDy = model.getDataEntity().getDynamicObject("entity");
        if (!ObjectUtils.isEmpty((Object)entityDy)) {
            String entity = entityDy.getString("number");
            this.buildMulComboFeild(entity);
            String inhRelation = HisCommonService.getInstance().entityInhRelation(entity);
            if (HRStringUtils.equals((String)inhRelation, (String)EnumEntityTpl.LINETIMESEQ_TPL.getNumber())) {
                return;
            }
            if (HRStringUtils.equals((String)inhRelation, (String)EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber())) {
                view.setVisible(Boolean.FALSE, new String[]{"effectdataversion", "setdisabledate"});
                return;
            }
            if (HRStringUtils.equals((String)inhRelation, (String)EnumEntityTpl.COMMON_TPL.getNumber())) {
                view.setVisible(Boolean.FALSE, new String[]{"effectdataversion", "setdisabledate", "openrevise"});
            }
        }
        view.setVisible(Boolean.FALSE, new String[]{"effectdataversion", "setdisabledate", "openrevise"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String property = args.getProperty().getName();
        if (property.equals("entity")) {
            ChangeData[] changeSet = args.getChangeSet();
            ChangeData changeData = changeSet[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (!ObjectUtils.isEmpty((Object)newValue)) {
                String entity = newValue.getString("number");
                String inhRelation = HisCommonService.getInstance().entityInhRelation(entity);
                if (HRStringUtils.equals((String)inhRelation, (String)EnumEntityTpl.LINETIMESEQ_TPL.getNumber())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"effectdataversion", "setdisabledate"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"openrevise"});
                } else if (HRStringUtils.equals((String)inhRelation, (String)EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber())) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"effectdataversion", "setdisabledate"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"openrevise"});
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e26\u5386\u53f2\u7684\u5b9e\u4f53\u3002", (String)"HisEntityRegEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.buildMulComboFeild(entity);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"effectdataversion", "setdisabledate", "openrevise"});
                this.getModel().getDataEntity().set("effectdataversion", (Object)"-");
                this.clearMulComboField();
            }
        }
    }

    private void clearMulComboField() {
        MulComboEdit mulcombofield = (MulComboEdit)this.getControl(IGNORE_FIELD);
        mulcombofield.setComboItems(null);
        this.getView().updateView(IGNORE_FIELD);
    }

    private void buildMulComboFeild(String entity) {
        MulComboEdit mulcombofield = (MulComboEdit)this.getControl(IGNORE_FIELD);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        Map allFields = mainEntityType.getAllFields();
        for (Map.Entry entry : allFields.entrySet()) {
            String fieldNumber = (String)entry.getKey();
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            if (this.ignoreFields.contains(fieldNumber)) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(fieldNumber + "\t" + property.getDisplayName()));
            comboItem.setValue(fieldNumber);
            comboItems.add(comboItem);
        }
        if (comboItems.size() > 0) {
            mulcombofield.setComboItems(comboItems);
            this.getView().updateView(IGNORE_FIELD);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"save", (String)formOperate.getOperateKey())) {
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            String inhRelation = HisCommonService.getInstance().entityInhRelation(entity.getString("number"));
            if (HRStringUtils.equals((String)inhRelation, (String)EnumEntityTpl.COMMON_TPL.getNumber())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e26\u5386\u53f2\u7684\u5b9e\u4f53\u3002", (String)"HisEntityRegEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

