/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.hismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

@ExcludeFromJacocoGeneratedReport
public class HisRpcConfig
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String BIZ_APP = "bizapp";

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ArrayList listFilters = Lists.newArrayList();
        ArrayList treeFilters = Lists.newArrayList();
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (HRStringUtils.equals((String)fieldKey, (String)BIZ_APP) || HRStringUtils.equals((String)fieldKey, (String)"taskbizapp")) {
            Set allHRCommonCloudIds = HRCloudServiceHelper.getAllHRCommonCloudIds();
            if (!allHRCommonCloudIds.isEmpty()) {
                listFilters.add(new QFilter("bizcloud", "in", (Object)allHRCommonCloudIds));
            }
            if (HRStringUtils.equals((String)fieldKey, (String)"taskbizapp")) {
                Set<String> excludedAppSet = this.getExcludedAppSet((Long)this.getModel().getValue("id"));
                listFilters.add(new QFilter("id", "not in", excludedAppSet));
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"entity") || HRStringUtils.equals((String)fieldKey, (String)"excludeentity")) {
            this.setEntityFilter(showParameter);
        }
        if (!listFilters.isEmpty()) {
            showParameter.getListFilterParameter().setQFilters((List)listFilters);
        }
        if (!treeFilters.isEmpty()) {
            showParameter.getTreeFilterParameter().setQFilters((List)treeFilters);
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit bizAppEdit = (BasedataEdit)this.getView().getControl(BIZ_APP);
        bizAppEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taskBizAppEdit = (BasedataEdit)this.getView().getControl("taskbizapp");
        taskBizAppEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entityEdit = (BasedataEdit)this.getView().getControl("entity");
        entityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entityEdit2 = (BasedataEdit)this.getView().getControl("excludeentity");
        entityEdit2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("addentity".equals(formOperate.getOperateKey())) {
            ListShowParameter showParameter = this.getEntityShowParameter("addEntity");
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("exclnewentry".equals(formOperate.getOperateKey())) {
            ListShowParameter showParameter = this.getEntityShowParameter("exclNewEntry");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)actionId, (String)"addEntity")) {
            this.newEntryRow("entryentity", "entity", returnData);
        } else if (HRStringUtils.equals((String)actionId, (String)"exclNewEntry")) {
            this.newEntryRow("excludeentryentity", "excludeentity", returnData);
        }
    }

    private void setEntityFilter(ListShowParameter showParameter) {
        DynamicObjectCollection taskBizApp = (DynamicObjectCollection)this.getModel().getValue("taskbizapp");
        ArrayList appIdList = Lists.newArrayListWithExpectedSize((int)taskBizApp.size());
        for (DynamicObject app : taskBizApp) {
            String id = app.getDynamicObject("fbasedataid").getString("id");
            appIdList.add(id);
        }
        showParameter.setCustomParam("bizappids", (Object)(appIdList.isEmpty() ? null : SerializationUtils.toJsonString((Object)appIdList)));
    }

    private ListShowParameter getEntityShowParameter(String actionId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_treelistf7");
        showParameter.setBillFormId("hbp_entityobject");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setLookUp(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960");
        styleCss.setHeight("580");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setMultiSelect(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.setEntityFilter(showParameter);
        return showParameter;
    }

    private void newEntryRow(String entryNumber, String entityFieldKey, Object returnData) {
        if (returnData != null) {
            ListSelectedRowCollection selectedRowCol = (ListSelectedRowCollection)returnData;
            ArrayList idList = Lists.newArrayListWithExpectedSize((int)selectedRowCol.size());
            selectedRowCol.forEach(row -> idList.add(row.getPrimaryKeyValue()));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbp_entityobject");
            DynamicObject[] results = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)idList)});
            Map<Object, DynamicObject> entityMap = Arrays.stream(results).collect(Collectors.toMap(result -> result.get("id"), result -> result));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryNumber);
            selectedRowCol.forEach(row -> {
                DynamicObject dynamicObject = new DynamicObject(entryEntity.getDynamicObjectType());
                dynamicObject.set(entityFieldKey, entityMap.get(row.getPrimaryKeyValue()));
                this.getModel().createNewEntryRow(entryNumber, dynamicObject);
            });
        }
    }

    private Set<String> getExcludedAppSet(long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_taskconfig");
        DynamicObject[] results = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "!=", (Object)id)});
        HashSet excludeAppIdList = Sets.newHashSetWithExpectedSize((int)results.length);
        for (DynamicObject result : results) {
            DynamicObjectCollection taskBizApps = result.getDynamicObjectCollection("taskbizapp");
            for (DynamicObject taskBizApp : taskBizApps) {
                String appId = taskBizApp.getString("fbasedataid.id");
                excludeAppIdList.add(appId);
            }
        }
        return excludeAppIdList;
    }
}

