/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.hismodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.service.hismodel.model.constant.HisSystemConstants;
import kd.hr.hrcs.bussiness.servicehelper.hismodel.HisVerCpColCfgServiceHelper;

public class HisVerCpColCfgListDataProvider
extends ListDataProvider
implements HisSystemConstants {
    private static final Log LOGGER = LogFactory.getLog(HisVerCpColCfgListDataProvider.class);

    public DynamicObjectCollection getData(int arg0, int arg1) {
        DynamicObjectCollection rows = super.getData(arg0, arg1);
        if (rows.isEmpty()) {
            return rows;
        }
        ArrayList<Object> pkIds = new ArrayList<Object>();
        for (DynamicObject row : rows) {
            pkIds.add(row.getPkValue());
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_vercpcolcfg");
        QFilter[] pkIdsFilter = new QFilter[]{new QFilter("id", "in", pkIds)};
        DynamicObject[] verCps = helper.query("entryentity.id,entryentity.colflag", pkIdsFilter);
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            String entityNumber = row.getString("entitytype.number");
            if (null == entityNumber) {
                LOGGER.info("entitytype-is-not-exists,entitytype={}", row.get("entitytype_id"));
                iterator.remove();
                continue;
            }
            row.set("cpcol", (Object)this.buildVerCpColContent(row, verCps));
        }
        return rows;
    }

    private String buildVerCpColContent(DynamicObject row, DynamicObject[] verCps) {
        String entityNumber = row.getString("entitytype.number");
        DynamicObjectCollection verCpEntry = new DynamicObjectCollection();
        for (int i = 0; i < verCps.length; ++i) {
            if (!ObjectUtils.nullSafeEquals((Object)row.getPkValue(), (Object)verCps[i].getPkValue())) continue;
            verCpEntry = verCps[i].getDynamicObjectCollection("entryentity");
            break;
        }
        if (CollectionUtils.isEmpty((Collection)verCpEntry)) {
            return "";
        }
        Map entityAllCol = HisVerCpColCfgServiceHelper.getEntityVerCpCol((String)entityNumber);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < verCpEntry.size(); ++i) {
            Map entityCol = (Map)entityAllCol.get(((DynamicObject)verCpEntry.get(i)).getString("colflag"));
            if (CollectionUtils.isEmpty((Map)entityCol)) continue;
            LocaleString colName = (LocaleString)entityCol.get("colname");
            if (i == verCpEntry.size() - 1) {
                sb.append(colName.getLocaleValue());
                continue;
            }
            sb.append(colName.getLocaleValue()).append("; ");
        }
        return sb.toString();
    }
}

