/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelDataService;
import kd.hr.hrcs.bussiness.util.GenFieldUtil;
import kd.hr.hrcs.common.constants.label.LblStrategyConstants;
import kd.hr.hrcs.formplugin.web.label.LabelDataEntryGrid;
import kd.hr.hrcs.formplugin.web.label.LabelDownTemplatePlugin;

public class LabelAddDataPlugin
extends LabelDownTemplatePlugin
implements LblStrategyConstants {
    private static final Log LOGGER = LogFactory.getLog(LabelAddDataPlugin.class);
    private static final String ENTRY_KEY = "entryKey";
    private static final String KEY_FILTER = "qFilter";
    private static final String NEW_ENTRY = "entryentity1";

    public void createNewData(BizDataEventArgs e) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
        this.getView().addCustomControls(new String[]{NEW_ENTRY});
    }

    @Override
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        this.targetKey = "flexpanelap2";
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        List itemsList = (List)((Map)e.getItems().get(0)).get("items");
        if (itemsList.isEmpty()) {
            showParameter.setCustomParam(ENTRY_KEY, (Object)NEW_ENTRY);
        } else {
            showParameter.setCustomParam(ENTRY_KEY, (Object)"entryentity");
        }
        EntryAp entryAp = this.generateEntryAp(showParameter);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        items.add(entryAp.createControl());
        HashMap mapHead = Maps.newHashMapWithExpectedSize((int)2);
        mapHead.put("id", "flexpanelap");
        mapHead.put("items", items);
        e.getItems().add(mapHead);
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType oldMainType = e.getNewEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LabelDataListPlugin", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    @Override
    public void beforeBindData(EventObject e) {
        this.targetKey = "flexpanelap2";
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Container myFldPanel = (Container)this.getView().getControl(this.targetKey);
        if (myFldPanel.getItems().isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1"});
        }
        EntryAp entryAp = this.generateEntryAp(formShowParameter);
        Container container = (Container)this.getView().getControl("flexpanelap");
        LabelDataEntryGrid labelDataEntryGrid = this.newEntryGrid((EntryGrid)entryAp.buildRuntimeControl());
        String entryKey = (String)formShowParameter.getCustomParam(ENTRY_KEY);
        labelDataEntryGrid.setEntryKey(entryKey);
        this.fillEntryData(labelDataEntryGrid, null);
        container.getItems().add(labelDataEntryGrid);
        this.getView().createControlIndex(container.getItems());
        this.getView().setVisible(Boolean.valueOf(!"entryentity".equals(entryKey)), new String[]{NEW_ENTRY});
        this.getView().setVisible(Boolean.valueOf(!NEW_ENTRY.equals(entryKey)), new String[]{"entryentity"});
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if ("entryentity".equalsIgnoreCase(e.getKey()) || NEW_ENTRY.equalsIgnoreCase(e.getKey())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            EntryAp entryAp = this.generateEntryAp(formShowParameter);
            EntryGrid entryGrid = (EntryGrid)entryAp.buildRuntimeControl();
            for (Control item : entryGrid.getItems()) {
                item.setView(this.getView());
            }
            LabelDataEntryGrid labelDataEntryGrid = this.newEntryGrid(entryGrid);
            labelDataEntryGrid.setEntryKey(e.getKey());
            String filterStr = this.getPageCache().get(KEY_FILTER);
            labelDataEntryGrid.setFilter(filterStr == null ? null : QFilter.fromSerializedString((String)filterStr));
            String idStr = this.getPageCache().get("id");
            if (!HRStringUtils.isEmpty((String)idStr)) {
                List idList = (List)SerializationUtils.fromJsonString((String)idStr, List.class);
                labelDataEntryGrid.setIdList(idList);
            }
            long lblObjId = Long.parseLong((String)formShowParameter.getCustomParam("labelobject"));
            labelDataEntryGrid.setLabelDataService(new LabelDataService(lblObjId, false));
            e.setControl((Control)labelDataEntryGrid);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String entryKey = (String)this.getView().getFormShowParameter().getCustomParam(ENTRY_KEY);
        if ("query".equals(formOperate.getOperateKey())) {
            String fieldStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldKeyList");
            Map fieldKeyMap = (Map)SerializationUtils.fromJsonString((String)fieldStr, Map.class);
            QFilter filter = null;
            for (Map.Entry fieldKeyEntry : fieldKeyMap.entrySet()) {
                QFilter subFilter = GenFieldUtil.getQFilter((String)((String)fieldKeyEntry.getKey()), (String)((String)fieldKeyEntry.getValue()), (IFormView)this.getView());
                if (filter != null) {
                    filter.and(subFilter);
                    continue;
                }
                filter = subFilter;
            }
            LabelDataEntryGrid newEntryGrid = (LabelDataEntryGrid)this.getControl(entryKey);
            this.fillEntryData(newEntryGrid, filter);
            this.getView().updateView(entryKey);
        } else if ("reset".equals(formOperate.getOperateKey())) {
            String fieldStr = (String)this.getView().getFormShowParameter().getCustomParam("fieldKeyList");
            Map fieldKeyMap = (Map)SerializationUtils.fromJsonString((String)fieldStr, Map.class);
            for (Map.Entry entry : fieldKeyMap.entrySet()) {
                this.getModel().setValue((String)entry.getKey(), null);
            }
            LabelDataEntryGrid newEntryGrid = (LabelDataEntryGrid)this.getControl(entryKey);
            this.fillEntryData(newEntryGrid, null);
            this.getView().updateView(entryKey);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String entryKey = (String)this.getView().getFormShowParameter().getCustomParam(ENTRY_KEY);
        if ("save".equals(afterDoOperationEventArgs.getOperateKey())) {
            LabelDataEntryGrid entryGrid = (LabelDataEntryGrid)this.getControl(entryKey);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
            ArrayList idList = Lists.newArrayListWithExpectedSize((int)selectRows.length);
            for (int selectRow : selectRows) {
                Object id = ((DynamicObject)entryEntity.get(selectRow)).get("id");
                idList.add(id);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)idList));
        }
    }

    private LabelDataEntryGrid newEntryGrid(EntryGrid oldEntryGrid) {
        LabelDataEntryGrid newEntryGrid = new LabelDataEntryGrid();
        newEntryGrid.getItems().addAll(oldEntryGrid.getItems());
        newEntryGrid.setKey(oldEntryGrid.getKey());
        newEntryGrid.setEntryKey(oldEntryGrid.getEntryKey());
        newEntryGrid.setModel(oldEntryGrid.getModel());
        newEntryGrid.setView(this.getView());
        newEntryGrid.setRealSplitPage(true);
        newEntryGrid.setSplitPage(true);
        newEntryGrid.setPageRow(20);
        return newEntryGrid;
    }

    private EntryAp generateEntryAp(FormShowParameter formShowParameter) {
        Map fieldKeyPropMap;
        LabelDataService service;
        String fieldPropMapStr = (String)formShowParameter.getCustomParam("fieldPropType");
        if (HRStringUtils.isEmpty((String)fieldPropMapStr)) {
            long lblObjId = Long.parseLong((String)formShowParameter.getCustomParam("labelobject"));
            service = new LabelDataService(lblObjId, false);
            fieldKeyPropMap = service.getFieldKeyPropMap();
            formShowParameter.setCustomParam("fieldPropType", (Object)SerializationUtils.toJsonString((Object)fieldKeyPropMap));
        } else {
            service = new LabelDataService();
            fieldKeyPropMap = (Map)SerializationUtils.fromJsonString((String)fieldPropMapStr, Map.class);
        }
        EntryAp entryAp = service.generateEntryAp(fieldKeyPropMap);
        entryAp.setId((String)formShowParameter.getCustomParam(ENTRY_KEY));
        entryAp.setKey((String)formShowParameter.getCustomParam(ENTRY_KEY));
        if (NEW_ENTRY.equals(entryAp.getKey())) {
            entryAp.setHeight(new LocaleString("540px"));
        } else {
            entryAp.setHeight(new LocaleString("420px"));
        }
        return entryAp;
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        LabelDataService service = new LabelDataService();
        EntryProp entryProp = service.registerDynamicProps(this.getView().getFormShowParameter());
        entryProp.setName((String)this.getView().getFormShowParameter().getCustomParam(ENTRY_KEY));
        EntryType itemType = (EntryType)entryProp.getItemType();
        itemType.setName(entryProp.getName());
        itemType.setExtendName(entryProp.getName());
        newMainType.addProperty((DynamicProperty)entryProp);
    }

    private void fillEntryData(LabelDataEntryGrid newEntryGrid, QFilter qFilter) {
        IFormView view = this.getView();
        String idStr = (String)view.getFormShowParameter().getCustomParam("id");
        QFilter idQFilter = null;
        if (!HRStringUtils.isEmpty((String)idStr)) {
            Set idStrList = (Set)SerializationUtils.fromJsonString((String)idStr, Set.class);
            if (!CollectionUtils.isEmpty((Collection)idStrList)) {
                List idList = idStrList.stream().map(Long::parseLong).collect(Collectors.toList());
                idQFilter = new QFilter("id", "not in", idList);
                if (qFilter != null) {
                    idQFilter.and(qFilter);
                }
            }
        } else {
            idQFilter = qFilter;
        }
        String lblObjFilterStr = (String)view.getFormShowParameter().getCustomParam("labelObjFilter");
        if (!HRStringUtils.isEmpty((String)lblObjFilterStr)) {
            if (idQFilter != null) {
                idQFilter.and(QFilter.fromSerializedString((String)lblObjFilterStr));
            } else {
                idQFilter = QFilter.fromSerializedString((String)lblObjFilterStr);
            }
        }
        long lblObjId = Long.parseLong((String)view.getFormShowParameter().getCustomParam("labelobject"));
        LabelDataService service = new LabelDataService(lblObjId, false);
        HRComplexObjContext idCountContext = service.getIdCountContext(idQFilter);
        idCountContext.setAlgoXDetailOptimize(false);
        ReportQueryService countQueryService = new ReportQueryService(idCountContext);
        List dataList = countQueryService.queryMap(0, 100000);
        LinkedHashSet idSet = Sets.newLinkedHashSetWithExpectedSize((int)dataList.size());
        for (Map dataMap : dataList) {
            idSet.add(dataMap.get("id"));
        }
        newEntryGrid.setLabelDataService(service);
        newEntryGrid.setFilter(idQFilter);
        newEntryGrid.setIdList(Lists.newArrayList((Iterable)idSet));
        AbstractGrid.GridState entryState = newEntryGrid.getEntryState();
        entryState.setCurrentPageIndex(Integer.valueOf(1));
    }
}

