/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelDataService;
import org.apache.commons.lang.StringUtils;

public class LabelDataEntryGrid
extends EntryGrid {
    private static final Log LOGGER = LogFactory.getLog(LabelDataEntryGrid.class);
    private List<Map<String, Object>> data = Lists.newArrayList();
    private Map<Object, String> userNameMap;
    private LabelDataService labelDataService;
    private int rowCount;
    private List<Map<String, Object>> filterData;
    private boolean isRealSplitPage = false;
    private QFilter filter;
    private List<Object> idList;

    public boolean isRealSplitPage() {
        return this.isRealSplitPage;
    }

    public void setRealSplitPage(boolean realSplitPage) {
        this.isRealSplitPage = realSplitPage;
    }

    public QFilter getFilter() {
        return this.filter;
    }

    public void setFilter(QFilter filter) {
        this.filter = filter;
        this.getView().getPageCache().put("qFilter", filter == null ? null : filter.toSerializedString());
    }

    public List<Object> getIdList() {
        return this.idList;
    }

    public void setIdList(List<Object> idList) {
        this.idList = idList;
        this.rowCount = idList.size();
        this.getView().getPageCache().put("id", SerializationUtils.toJsonString(idList));
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public LabelDataService getLabelDataService() {
        return this.labelDataService;
    }

    public void setLabelDataService(LabelDataService labelDataService) {
        labelDataService.generateEntryAndRelField();
        this.labelDataService = labelDataService;
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public boolean isNeedPaged() {
        return true;
    }

    public void bindData(BindingContext bct) {
        GridConfigRenderUtils.renderGridConfig((IFormView)this.getView(), (String)this.getEntryKey());
        if (this.isRealSplitPage) {
            AbstractGrid.GridState entryState = this.getEntryState();
            this.updateData(0, entryState.getPageRows());
        }
        try (TraceSpan ignored = Tracer.create((String)"CustomTreeEntryGrid", (String)"bindData");){
            this.entryGridBindPageData();
        }
    }

    public void entryGridBindPageData() {
        int endIndex;
        AbstractGrid.GridState entryState = this.getEntryState();
        int startIndex = 0;
        int rowCount = this.getRowCount();
        int pageCount = 0;
        if (this.isNeedPaged()) {
            int pageShowRows = entryState.getPageRows();
            int currPageIndex = entryState.getCurrentPageIndex();
            pageCount = rowCount / pageShowRows + (rowCount % pageShowRows > 0 ? 1 : 0);
            if (pageCount == 0) {
                pageCount = 1;
            }
            if (currPageIndex < 1) {
                entryState.setCurrentPageIndex(Integer.valueOf(1));
            } else if (currPageIndex > pageCount) {
                entryState.setCurrentPageIndex(Integer.valueOf(pageCount));
            }
            startIndex = (currPageIndex - 1) * pageShowRows;
            endIndex = Math.min(startIndex + this.getPageRow(), rowCount);
        } else {
            endIndex = rowCount;
        }
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList objs = Lists.newArrayListWithExpectedSize((int)10);
        Object[] dataEntities = this.getEntryDataEntities(startIndex, endIndex);
        if (!ObjectUtils.isEmpty((Object[])dataEntities)) {
            this.handleEntryData(objs, rows, (DynamicObject[])dataEntities);
        }
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("rowcount", rowCount);
        data.put("rows", rows);
        data.put("pagerows", entryState.getPageRows());
        data.put("pageindex", entryState.getCurrentPageIndex());
        data.put("isSplitPage", true);
        data.put("phide", !this.isNeedPaged());
        data.put("pagecount", pageCount);
        data.put("datacount", rowCount);
        data.put("dataindex", this.getDataIndex());
        this.fireBindEntryGridDataEvent(objs, data, startIndex);
        IDataEntityProperty property = this.getModel().getProperty(this.getEntryKey());
        if (property instanceof SubEntryProp) {
            data.put("pr", this.getModel().getEntryCurrentRowIndex(property.getParent().getName()));
        }
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.setEntryProperty(this.getKey(), "data", (Object)data);
        this.selectRows(-1);
    }

    private void handleEntryData(List<RowDataEntity> objs, List<Object> rows, DynamicObject[] dataEntities) {
        String entryKey = this.getEntryKey();
        EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get(entryKey);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection(entryKey);
        dynamicObjectCollection.clear();
        this.getModel().getDataEntity().getDynamicObjectCollection(entryKey).setStartRowIndex(0);
        for (int i = 0; i < dataEntities.length; ++i) {
            objs.add(new RowDataEntity(i, dataEntities[i]));
            dynamicObjectCollection.add((Object)dataEntities[i]);
        }
        if (this.getRuleCount() > 0) {
            RuleContainer ruleContainer = (RuleContainer)this.getView().getService(RuleContainer.class);
            ruleContainer.raise(new RaiseEventSource(RaiseEventType.Initialized, objs, (IDataEntityType)entityType), (RuleExecuteContext)new FormRuleExecuteContext(this.getView()));
        }
        objs.forEach(rowDataEntity -> {
            BindingContext bindCtx = new BindingContext((IDataEntityType)entityType, rowDataEntity.getDataEntity(), rowDataEntity.getRowIndex());
            rows.add(this.getRowBindValue(bindCtx));
        });
    }

    protected int getRowCount() {
        if (!this.isRealSplitPage) {
            if (this.filterData != null) {
                this.rowCount = this.filterData.size();
            } else if (this.data != null) {
                this.rowCount = this.data.size();
            }
        }
        return this.rowCount;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data = data;
        ArrayList userIdList = Lists.newArrayListWithExpectedSize((int)data.size());
        for (Map<String, Object> dataMap : data) {
            Object labelPerson = dataMap.get("labelperson");
            if (labelPerson == null) continue;
            userIdList.add(Long.parseLong((String)labelPerson));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject[] users = serviceHelper.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", (Object)userIdList)});
        this.userNameMap = Arrays.stream(users).collect(Collectors.toMap(us -> us.getString("id"), us -> us.getString("name")));
    }

    protected DynamicObject[] getEntryDataEntities(int startIndex, int endIndex) {
        if (CollectionUtils.isEmpty(this.data)) {
            return new DynamicObject[0];
        }
        int size = endIndex - startIndex;
        ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)size);
        if (this.isRealSplitPage) {
            startIndex = 0;
            endIndex = size;
        }
        String entryKey = this.getEntryKey();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(entryKey);
        DataEntityPropertyCollection properties = dynamicObjectCollection.getDynamicObjectType().getProperties();
        List<Map<String, Object>> realData = this.filterData != null ? this.filterData : this.data;
        for (int i = startIndex; i < endIndex; ++i) {
            Map<String, Object> dataMap = realData.get(i);
            DynamicObject row = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            for (IDataEntityProperty property : properties) {
                String propKey = property.getName();
                Object data = dataMap.get(propKey);
                if (data == null) continue;
                if (property instanceof BasedataProp) {
                    DynamicObjectType dynamicComplexPropertyType = ((BasedataProp)property).getDynamicComplexPropertyType();
                    DynamicObject dynamicObject = new DynamicObject(dynamicComplexPropertyType);
                    dynamicObject.set("id", data);
                    dynamicObject.set("name", (Object)new LocaleString(this.userNameMap.get(data)));
                    data = dynamicObject;
                }
                row.set(property, this.convertData(property, data));
            }
            dynamicObjects.add(row);
        }
        return dynamicObjects.toArray(new DynamicObject[0]);
    }

    public void getGridDataByFilter(List<Map<String, List<Object>>> filter) {
        super.getGridDataByFilter(filter);
        if (this.isRealSplitPage) {
            QFilter copy;
            QFilter qFilterByEntryQuery = this.getQFilterByEntryQuery();
            if (qFilterByEntryQuery != null) {
                if (this.filter != null) {
                    copy = this.filter.copy();
                    copy.and(qFilterByEntryQuery);
                } else {
                    copy = qFilterByEntryQuery;
                }
                this.getView().getPageCache().put("qFilterByEntryQuery", copy.toSerializedString());
            } else {
                this.getView().getPageCache().put("qFilterByEntryQuery", null);
                copy = this.filter;
            }
            HRComplexObjContext idCountContext = this.labelDataService.getIdCountContext(copy);
            idCountContext.setAlgoXDetailOptimize(false);
            ReportQueryService countQueryService = new ReportQueryService(idCountContext);
            List dataList = countQueryService.queryMap(0, 100000);
            HashSet idSet = Sets.newHashSetWithExpectedSize((int)dataList.size());
            for (Map dataMap : dataList) {
                idSet.add(dataMap.get("id"));
            }
            this.setIdList(Lists.newArrayList((Iterable)idSet));
        } else {
            this.setFilterData();
        }
        this.setPageIndex(1);
    }

    public void setPageIndex(int pageIndex) {
        AbstractGrid.GridState entryState = this.getEntryState();
        entryState.setCurrentPageIndex(Integer.valueOf(pageIndex));
        if (this.isRealSplitPage) {
            Integer pageRows = entryState.getPageRows();
            int startIndex = (pageIndex - 1) * pageRows;
            this.updateData(startIndex, pageRows);
        }
        this.entryGridBindPageData();
    }

    public void setPageRows(int rows) {
        AbstractGrid.GridState entryState = this.getEntryState();
        entryState.setPageRows(rows);
        if (this.isRealSplitPage) {
            this.updateData(0, rows);
        }
        this.entryGridBindPageData();
    }

    private void updateData(int startIndex, int rows) {
        ArrayList pageIdList = Lists.newArrayListWithExpectedSize((int)rows);
        int count = Math.min(rows, this.idList.size() - startIndex);
        for (int i = startIndex; i < startIndex + count; ++i) {
            pageIdList.add(this.idList.get(i));
        }
        QFilter qFilter = new QFilter("id", "in", (Object)pageIdList);
        String qFilterByEntryQuery = this.getView().getPageCache().get("qFilterByEntryQuery");
        if (!HRStringUtils.isEmpty((String)qFilterByEntryQuery)) {
            qFilter.and(QFilter.fromSerializedString((String)qFilterByEntryQuery));
        } else if (this.filter != null) {
            qFilter.and(this.filter);
        }
        this.setData(this.labelDataService.getEntryDataList(qFilter));
    }

    private Object convertData(IDataEntityProperty property, Object data) {
        if (property instanceof DateTimeProp && data instanceof String) {
            try {
                return HRDateTimeUtils.parseDate((String)((String)data));
            }
            catch (ParseException e) {
                LOGGER.error("convertData_ParseException:{}", (Object)e.getMessage());
            }
        }
        return data;
    }

    private void setFilterData() {
        FilterBuilder filterBuilder = this.getFilterBuilder();
        String[] filterScripts = filterBuilder.buildFilterScript();
        String entryKey = this.getEntryKey();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(entryKey);
        DataEntityPropertyCollection properties = dynamicObjectCollection.getDynamicObjectType().getProperties();
        if (filterScripts != null && filterScripts.length != 0 && !StringUtils.isBlank((String)filterScripts[0])) {
            String preCondition = filterScripts[0];
            RowDataModel rowModel = new RowDataModel(entryKey, this.getModel());
            ExpressionParameter parameter = new ExpressionParameter(preCondition, rowModel);
            int j = 0;
            this.filterData = Lists.newArrayListWithExpectedSize((int)this.data.size());
            for (Map<String, Object> dataRow : this.data) {
                DynamicObject row = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
                for (IDataEntityProperty property : properties) {
                    String propKey = property.getName();
                    Object data = dataRow.get(propKey);
                    if (data == null) continue;
                    if (property instanceof BasedataProp) {
                        DynamicObjectType dynamicComplexPropertyType = ((BasedataProp)property).getDynamicComplexPropertyType();
                        DynamicObject dynamicObject = new DynamicObject(dynamicComplexPropertyType);
                        dynamicObject.set("id", data);
                        dynamicObject.set("name", (Object)new LocaleString(this.userNameMap.get(data)));
                        data = dynamicObject;
                    }
                    row.set(property, this.convertData(property, data));
                }
                parameter.setRowIndex(j);
                parameter.setActiveRow((Object)row);
                Object expValue = CalcExprParser.getExpressionValue((ExpressionParameter)parameter);
                if (expValue != null && ((Boolean)expValue).booleanValue()) {
                    this.filterData.add(dataRow);
                }
                ++j;
            }
        } else {
            this.filterData = this.data;
        }
    }

    private FilterBuilder getFilterBuilder() {
        String entryKey = this.getEntryKey();
        EntryQueryParam queryParam = this.getModel().getEntryQueryParam(entryKey);
        return new FilterBuilder(this.getModel().getDataEntityType(), queryParam.buildFilterCondition());
    }

    private QFilter getQFilterByEntryQuery() {
        int length;
        FilterBuilder filterBuilder = this.getFilterBuilder();
        filterBuilder.buildFilter();
        List qFilters = filterBuilder.getQFilters();
        QFilter filter = null;
        int n = length = "entryentity".equals(this.getEntryKey()) ? 13 : 14;
        if (!qFilters.isEmpty()) {
            ArrayList removeList = Lists.newArrayListWithExpectedSize((int)qFilters.size());
            for (QFilter qFilter : qFilters) {
                String property = qFilter.getProperty();
                if (property.length() < length) {
                    removeList.add(qFilter);
                    continue;
                }
                String newProperty = property.substring(length - 1);
                qFilter.setProperty(newProperty);
                List nests = qFilter.getNests(true);
                qFilter.clearNests();
                for (QFilter.QFilterNest nest : nests) {
                    QFilter nestFilter = nest.getFilter();
                    if (nestFilter.getProperty().length() < length) continue;
                    String newNestProperty = nestFilter.getProperty().substring(length - 1);
                    nestFilter.setProperty(newNestProperty);
                    qFilter.addFirstNest(nestFilter, nest.getOp());
                }
            }
            qFilters.removeAll(removeList);
            List<QFilter> newQFilterList = this.transformProperty(qFilters);
            if (newQFilterList.size() > 0) {
                filter = newQFilterList.get(0);
                for (int i = 1; i < newQFilterList.size(); ++i) {
                    filter.and(newQFilterList.get(i));
                }
            }
        }
        return filter;
    }

    private List<QFilter> transformProperty(List<QFilter> qFilterList) {
        ArrayList newQFilterList = Lists.newArrayListWithExpectedSize((int)qFilterList.size());
        Map entryKeyMap = this.labelDataService.getEntryKeyMap();
        Map relEntityKeyMap = this.labelDataService.getRelEntityKeyMap();
        List fieldTreeNodeList = (List)this.labelDataService.getControlData().get("fieldTreeNode");
        HashMap fieldTreeNodeMap = Maps.newHashMapWithExpectedSize((int)80000);
        LabelDataService.addFieldTreeNodeMap((List)fieldTreeNodeList, (Map)fieldTreeNodeMap);
        for (QFilter qFilter : qFilterList) {
            QFilter transformQFilter = this.getTransformQFilter(qFilter, entryKeyMap, relEntityKeyMap, fieldTreeNodeMap);
            if (transformQFilter == null) continue;
            newQFilterList.add(transformQFilter);
        }
        return newQFilterList;
    }

    private QFilter getTransformQFilter(QFilter qFilter, Map<String, Set<String>> entryKeyMap, Map<String, Set<String>> relEntityKeyMap, Map<String, FieldTreeNode> fieldTreeNodeMap) {
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            this.getTransformQFilter(nest.getFilter(), entryKeyMap, relEntityKeyMap, fieldTreeNodeMap);
        }
        String property = qFilter.getProperty();
        Set<String> entryFieldKeySet = entryKeyMap.get(property);
        Set<String> relEntityKeySonSet = relEntityKeyMap.get(property);
        if (!CollectionUtils.isEmpty(entryFieldKeySet)) {
            ArrayList entryFieldQFilterList = Lists.newArrayListWithExpectedSize((int)entryFieldKeySet.size());
            for (String entryFieldKey : entryFieldKeySet) {
                FieldTreeNode fieldTreeNode;
                QFilter qFilterSon = new QFilter(entryFieldKey, qFilter.getCP(), qFilter.getValue());
                if (!this.handleQFilter(qFilterSon, (fieldTreeNode = fieldTreeNodeMap.get(entryFieldKey)).getValueType())) continue;
                entryFieldQFilterList.add(qFilterSon);
            }
            QFilter entityFieldQFilter = null;
            if (entryFieldQFilterList.size() > 0) {
                entityFieldQFilter = (QFilter)entryFieldQFilterList.get(0);
                for (int i = 1; i < entryFieldQFilterList.size(); ++i) {
                    entityFieldQFilter.or((QFilter)entryFieldQFilterList.get(i));
                }
            }
            qFilter = entityFieldQFilter;
        } else if (!CollectionUtils.isEmpty(relEntityKeySonSet)) {
            ArrayList relEntityFieldQFilterList = Lists.newArrayListWithExpectedSize((int)relEntityKeySonSet.size());
            for (String relEntityKeySon : relEntityKeySonSet) {
                FieldTreeNode fieldTreeNode;
                QFilter qFilterSon = new QFilter(relEntityKeySon, qFilter.getCP(), qFilter.getValue());
                if (!this.handleQFilter(qFilterSon, (fieldTreeNode = fieldTreeNodeMap.get(relEntityKeySon)).getValueType())) continue;
                relEntityFieldQFilterList.add(qFilterSon);
            }
            QFilter relEntityFieldQFilter = null;
            if (relEntityFieldQFilterList.size() > 0) {
                relEntityFieldQFilter = (QFilter)relEntityFieldQFilterList.get(0);
                for (int i = 1; i < relEntityFieldQFilterList.size(); ++i) {
                    relEntityFieldQFilter.or((QFilter)relEntityFieldQFilterList.get(i));
                }
            }
            qFilter = relEntityFieldQFilter;
        } else {
            String fieldKey = property.replace("_dm6h7z_", ".");
            qFilter.setProperty(fieldKey);
            FieldTreeNode fieldTreeNode = fieldTreeNodeMap.get(fieldKey);
            if (!this.handleQFilter(qFilter, fieldTreeNode.getValueType())) {
                qFilter = null;
            }
        }
        return qFilter;
    }

    private boolean handleQFilter(QFilter qFilter, String valueType) {
        if (DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(valueType) || DataTypeEnum.INTEGER.getDataTypeKey().equals(valueType) || DataTypeEnum.LONG.getDataTypeKey().equals(valueType)) {
            return this.handleNum(qFilter);
        }
        if (DataTypeEnum.DATETIME.getDataTypeKey().equals(valueType)) {
            this.handleTime(qFilter);
            return this.parseDate(qFilter);
        }
        return true;
    }

    private boolean handleNum(QFilter qFilter) {
        String cp;
        switch (cp = qFilter.getCP().toLowerCase(Locale.ROOT)) {
            case "like": {
                qFilter.__setCP("=");
                String replace = qFilter.getValue().toString().replace("%", "");
                if (replace.matches("[0-9]+")) {
                    qFilter.__setValue((Object)Long.parseLong(replace));
                    break;
                }
                return false;
            }
            case "not like": {
                qFilter.__setCP("!=");
                String replace = qFilter.getValue().toString().replace("%", "");
                if (replace.matches("[0-9]+")) {
                    qFilter.__setValue((Object)Long.parseLong(replace));
                    break;
                }
                return false;
            }
            case "is not null": {
                qFilter.clearNests();
                break;
            }
            case "is null": {
                break;
            }
            default: {
                String replace = qFilter.getValue().toString();
                if (replace.matches("[0-9]+")) {
                    qFilter.__setValue((Object)Long.parseLong(replace));
                    break;
                }
                if (QEmptyValue.value.equals(qFilter.getValue())) break;
                return false;
            }
        }
        return true;
    }

    private void handleTime(QFilter qFilter) {
        String cp;
        switch (cp = qFilter.getCP().toLowerCase(Locale.ROOT)) {
            case "like": {
                qFilter.__setCP("=");
                String replace = qFilter.getValue().toString().replace("%", "");
                qFilter.__setValue((Object)replace);
                break;
            }
            case "not like": {
                qFilter.__setCP("!=");
                String replace = qFilter.getValue().toString().replace("%", "");
                qFilter.__setValue((Object)replace);
                break;
            }
            case "is not null": {
                qFilter.clearNests();
                break;
            }
        }
    }

    private boolean parseDate(QFilter qFilter) {
        String cp;
        switch (cp = qFilter.getCP().toLowerCase(Locale.ROOT)) {
            case "=": 
            case "!=": {
                try {
                    Date date = HRDateTimeUtils.parseDate((String)qFilter.getValue().toString());
                    qFilter.__setValue((Object)date);
                    break;
                }
                catch (ParseException e) {
                    LOGGER.info("LabelDataEntryGrid_parseDate:{}", qFilter.getValue());
                    return false;
                }
            }
        }
        return true;
    }
}

