/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelDataService;
import kd.hr.hrcs.bussiness.util.GenFieldUtil;
import kd.hr.hrcs.common.constants.label.LabelConstants;
import kd.hr.hrcs.common.constants.label.LblStrategyConstants;
import kd.hr.hrcs.formplugin.web.label.LabelDataEntryGrid;

public class LabelDataListPlugin
extends AbstractFormPlugin
implements LblStrategyConstants,
LabelConstants {
    private static final Log LOGGER = LogFactory.getLog(LabelDataListPlugin.class);
    private static final String ACT_ID = "addData";

    public void createNewData(BizDataEventArgs e) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        EntryAp entryAp = this.generateEntryAp(showParameter);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        items.add(entryAp.createControl());
        HashMap mapHead = Maps.newHashMapWithExpectedSize((int)2);
        mapHead.put("id", "advconchildpanelap");
        mapHead.put("items", items);
        e.getItems().add(mapHead);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        GenFieldUtil.onGetControl((OnGetControlArgs)e, (IFormView)this.getView());
        if ("entryentity".equalsIgnoreCase(e.getKey())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            EntryAp entryAp = this.generateEntryAp(formShowParameter);
            EntryGrid entryGrid = (EntryGrid)entryAp.buildRuntimeControl();
            for (Control item : entryGrid.getItems()) {
                item.setView(this.getView());
            }
            LabelDataEntryGrid labelDataEntryGrid = this.newEntryGrid(entryGrid);
            String dataStr = this.getPageCache().get("labelData");
            if (!HRStringUtils.isEmpty((String)dataStr)) {
                List data = (List)SerializationUtils.fromJsonString((String)dataStr, List.class);
                labelDataEntryGrid.setData(data);
            }
            e.setControl((Control)labelDataEntryGrid);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LabelDataListPlugin", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        EntryAp entryAp = this.generateEntryAp(formShowParameter);
        Container container = (Container)this.getView().getControl("advconchildpanelap");
        LabelDataEntryGrid labelDataEntryGrid = this.newEntryGrid((EntryGrid)entryAp.buildRuntimeControl());
        this.fillEntryData(labelDataEntryGrid);
        container.getItems().add(labelDataEntryGrid);
        this.getView().createControlIndex(container.getItems());
        Boolean isLock = (Boolean)formShowParameter.getCustomParam("isLock");
        if (Boolean.TRUE.equals(isLock)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconbaritemap", "advconbaritemap1"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("deleteentry".equals(formOperate.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u6253\u6807\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"LabelDataListPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{selectRows.length}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deleteentry"));
            args.setCancel(true);
        } else if ("adddata".equals(formOperate.getOperateKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrcs_labeladddata");
            showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            String dataStr = this.getPageCache().get("labelData");
            if (!HRStringUtils.isEmpty((String)dataStr)) {
                List data = (List)SerializationUtils.fromJsonString((String)dataStr, List.class);
                HashSet idList = Sets.newHashSetWithExpectedSize((int)data.size());
                for (Map dataMap : data) {
                    idList.add(dataMap.get("id"));
                }
                showParameter.setCustomParam("id", (Object)(idList.isEmpty() ? null : SerializationUtils.toJsonString((Object)idList)));
            }
            showParameter.setCustomParam("labelobject", this.getView().getFormShowParameter().getCustomParam("labelobject"));
            showParameter.setCustomParam("labelObjFilter", this.getView().getFormShowParameter().getCustomParam("labelObjFilter"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACT_ID));
            this.getView().showForm(showParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("deleteentry".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            LabelDataEntryGrid entryGrid = (LabelDataEntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            HashSet deleteIdList = Sets.newHashSetWithExpectedSize((int)entryEntity.size());
            for (int selectRow : selectRows) {
                deleteIdList.add(((DynamicObject)entryEntity.get(selectRow)).get("id"));
            }
            List<Map<String, Object>> data = entryGrid.getData();
            data.removeIf(dataMap -> deleteIdList.contains(dataMap.get("id")));
            this.getPageCache().put("labelData", SerializationUtils.toJsonString(data));
            this.getModel().deleteEntryRows("entryentity", selectRows);
            entryGrid.entryGridBindPageData();
            String lang = RequestContext.get().getLang().name();
            String lblValue = (String)this.getView().getFormShowParameter().getCustomParam("labelValue");
            String tabPageKey = (String)this.getView().getFormShowParameter().getCustomParam("tabPageKey");
            this.updateTabPageName(lang, lblValue, tabPageKey, data.size());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (ACT_ID.equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            long lblObjId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("labelobject"));
            LabelDataService labelDataService = new LabelDataService(lblObjId, true);
            List idStrList = (List)SerializationUtils.fromJsonString((String)((String)closedCallBackEvent.getReturnData()), List.class);
            List idList = idStrList.stream().map(Long::parseLong).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", idList);
            String lblObjFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("labelObjFilter");
            if (!HRStringUtils.isEmpty((String)lblObjFilterStr)) {
                qFilter.and(QFilter.fromSerializedString((String)lblObjFilterStr));
            }
            List entryDataList = labelDataService.getEntryDataList(qFilter);
            String currUserId = RequestContext.get().getCurrUserId() + "";
            for (Map dataMap : entryDataList) {
                dataMap.put("labelperson", currUserId);
            }
            LabelDataEntryGrid entryGrid = (LabelDataEntryGrid)this.getControl("entryentity");
            if (entryGrid.getData() != null) {
                entryDataList.addAll(entryGrid.getData());
            }
            entryGrid.setData(entryDataList);
            this.getPageCache().put("labelData", SerializationUtils.toJsonString((Object)entryDataList));
            this.getView().updateView("entryentity");
            String lang = RequestContext.get().getLang().name();
            String lblValue = (String)this.getView().getFormShowParameter().getCustomParam("labelValue");
            String tabPageKey = (String)this.getView().getFormShowParameter().getCustomParam("tabPageKey");
            this.updateTabPageName(lang, lblValue, tabPageKey, entryDataList.size());
        }
    }

    private EntryAp generateEntryAp(FormShowParameter formShowParameter) {
        String fieldPropMapStr = (String)formShowParameter.getCustomParam("fieldPropType");
        Map fieldKeyPropMap = (Map)SerializationUtils.fromJsonString((String)fieldPropMapStr, Map.class);
        LabelDataService service = new LabelDataService();
        return service.generateEntryAp(fieldKeyPropMap);
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        LabelDataService service = new LabelDataService();
        EntryProp entryProp = service.registerDynamicProps(this.getView().getFormShowParameter());
        newMainType.addProperty((DynamicProperty)entryProp);
    }

    private LabelDataEntryGrid newEntryGrid(EntryGrid oldEntryGrid) {
        LabelDataEntryGrid newEntryGrid = new LabelDataEntryGrid();
        newEntryGrid.getItems().addAll(oldEntryGrid.getItems());
        newEntryGrid.setKey(oldEntryGrid.getKey());
        newEntryGrid.setEntryKey(oldEntryGrid.getEntryKey());
        newEntryGrid.setModel(oldEntryGrid.getModel());
        newEntryGrid.setView(this.getView());
        newEntryGrid.setSplitPage(true);
        newEntryGrid.setPageRow(20);
        return newEntryGrid;
    }

    private void fillEntryData(LabelDataEntryGrid newEntryGrid) {
        IFormView view = this.getView();
        String labelDataStr = (String)view.getFormShowParameter().getCustomParam("labelData");
        this.getPageCache().put("labelData", labelDataStr);
        if (!HRStringUtils.isEmpty((String)labelDataStr)) {
            List entryDataList = (List)SerializationUtils.fromJsonString((String)labelDataStr, List.class);
            newEntryGrid.setData(entryDataList);
        }
    }

    private void updateTabPageName(String lang, String labelVal, String tabPageKey, int count) {
        HashMap map1 = Maps.newHashMapWithExpectedSize((int)2);
        map1.put(lang, labelVal + "(" + count + ")");
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("text", map1);
        this.getView().getParentView().updateControlMetadata(tabPageKey, (Map)map);
        this.getView().sendFormAction(this.getView().getParentView());
    }
}

