/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.formplugin.web.label.info.LabelDimensionInfo;
import kd.hr.hrcs.formplugin.web.label.info.LabelEntityInfo;

public class LabelDimTreeListPlugin
extends AbstractTreeListPlugin {
    private static final String ENTITY_NUMBER = "hrcs_labelobject";
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_labelobject");
    private static final DynamicObjectType dt = EntityMetadataCache.getDataEntityType((String)"hrcs_labelobject");
    private static final String RULE_LABEL = "rule";
    private static final String MANUAL_LABEL = "manual";

    private List<LabelEntityInfo> getLabelEntityInfo() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("labelentityinfos");
        List labelEntityInfos = SerializationUtils.fromJsonStringToList((String)str, LabelEntityInfo.class);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        for (LabelEntityInfo labelEntityInfo : labelEntityInfos) {
            labelEntityInfo.getDimensions().removeIf(info -> {
                try {
                    String classPath = info.getControlProp();
                    Class<?> aClass = Class.forName(classPath);
                    Object obj = aClass.newInstance();
                    if (RULE_LABEL.equals(type)) {
                        return !(obj instanceof BasedataProp) && !(obj instanceof DateTimeProp) && !(obj instanceof ComboProp) && !(obj instanceof BooleanProp);
                    }
                    if (MANUAL_LABEL.equals(type)) {
                        return !(obj instanceof BasedataProp) && !(obj instanceof DateTimeProp) && !(obj instanceof ComboProp) && !(obj instanceof BooleanProp) && !(obj instanceof TextProp) && !(obj instanceof DecimalProp) && !(obj instanceof LongProp);
                    }
                }
                catch (Exception e) {
                    return true;
                }
                return false;
            });
        }
        return labelEntityInfos;
    }

    public void initializeTree(EventObject e) {
        List<LabelEntityInfo> labelEntityInfos = this.getLabelEntityInfo();
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"TreeNode_0", (String)"bos-entity-metadata", (Object[])new Object[0]));
        for (int i = 0; i < labelEntityInfos.size(); ++i) {
            TreeNode treeNode = new TreeNode("", labelEntityInfos.get(i).getEntityName(), labelEntityInfos.get(i).getEntityName());
            treeNode.setCheckable(i == 0);
            root.addChild(treeNode);
        }
        root.setIsOpened(true);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        if (CollectionUtils.isEmpty((Collection)root.getChildren())) {
            this.getPageCache().put("focusNodeId", root.getId());
        } else {
            TreeNode curNode = (TreeNode)root.getChildren().get(0);
            this.getPageCache().put("focusNodeId", curNode.getId());
        }
        this.getAllData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeView view = (TreeView)this.getControl("treeview");
        view.setRootVisible(false);
        TreeNode root = this.getTreeModel().getRoot();
        view.expand(root.getId());
        if (!CollectionUtils.isEmpty((Collection)root.getChildren()) && "root".equals(this.getTreeModel().getCurrentNodeId())) {
            view.focusNode((TreeNode)root.getChildren().get(0));
        }
    }

    private List<DynamicObject> getAllData() {
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>(10);
        List<LabelEntityInfo> labelEntityInfos = this.getLabelEntityInfo();
        for (LabelEntityInfo labelEntityInfo : labelEntityInfos) {
            rowList.addAll(this.getAllField(labelEntityInfo.getDimensions()));
        }
        return rowList;
    }

    private List<DynamicObject> getAllField(String entityName) {
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>(10);
        List<LabelEntityInfo> labelEntityInfos = this.getLabelEntityInfo();
        for (LabelEntityInfo labelEntityInfo : labelEntityInfos) {
            if (!entityName.equals(labelEntityInfo.getEntityName())) continue;
            return this.getAllField(labelEntityInfo.getDimensions());
        }
        return rowList;
    }

    private List<DynamicObject> getAllField(List<LabelDimensionInfo> dimensions) {
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>(10);
        for (LabelDimensionInfo labelDimensionInfo : dimensions) {
            rowList.add(this.labelDimensionInfo2Dy(labelDimensionInfo));
        }
        return rowList;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        this.getPageCache().put("focusNodeId", e.getNodeId().toString());
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        AbstractGrid.GridState entryState = proxy.getEntryState("billlistap");
        entryState.setCurrentPageIndex(Integer.valueOf(0));
    }

    private DynamicObject labelDimensionInfo2Dy(LabelDimensionInfo labelDimensionInfo) {
        DynamicObject dy = helper.generateEmptyDynamicObject();
        dy.set("id", (Object)labelDimensionInfo.getId());
        dy.set("number", (Object)labelDimensionInfo.getNumber());
        dy.set("name", (Object)labelDimensionInfo.getName());
        dy.set("type", (Object)labelDimensionInfo.getEntityName());
        return dy;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final String entityName = (String)this.getTreeModel().getCurrentNodeId();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                List rowList = limit == 100000 || "root".equals(entityName) ? LabelDimTreeListPlugin.this.getAllData() : LabelDimTreeListPlugin.this.getAllField(entityName);
                rowList = LabelDimTreeListPlugin.this.handlerFilter(rowList, this);
                List temp = rowList.subList(start, Math.min(rowList.size(), start + limit));
                DynamicObjectCollection collection = new DynamicObjectCollection(dt, null);
                collection.addAll(temp);
                QueryResult queryResult = this.getQueryResult();
                queryResult.setDataCount(rowList.size());
                queryResult.setBillDataCount(collection.size());
                queryResult.setCollection(collection);
                return collection;
            }
        });
    }

    private List<DynamicObject> handlerFilter(List<DynamicObject> temp, ListDataProvider provider) {
        List<String> filterValues = this.getSearchValues(provider.getQFilters());
        if (!CollectionUtils.isEmpty(filterValues)) {
            temp = temp.stream().filter(dy -> {
                boolean flag = true;
                for (String filterValue : filterValues) {
                    flag = flag && (dy.getString("name").contains(filterValue) || dy.getString("number").contains(filterValue));
                }
                return flag;
            }).collect(Collectors.toList());
        }
        this.handlerIdFilter(temp, provider.getQFilters());
        return temp;
    }

    private List<String> getSearchValues(List<QFilter> qFilters) {
        ArrayList<String> filterValues = new ArrayList<String>(10);
        if (CollectionUtils.isEmpty(qFilters)) {
            return filterValues;
        }
        for (QFilter qFilter : qFilters) {
            if (!"ftlike".equals(qFilter.getCP())) continue;
            String value = (String)qFilter.getValue();
            value = value.substring(value.indexOf("#") + 1);
            filterValues.add(value);
        }
        return filterValues;
    }

    private void handlerIdFilter(List<DynamicObject> temp, List<QFilter> qFilters) {
        if (CollectionUtils.isEmpty(qFilters)) {
            return;
        }
        for (QFilter qFilter : qFilters) {
            Object[] values;
            ArrayList idValues;
            if ("id".equals(qFilter.getProperty()) && "in".equalsIgnoreCase(qFilter.getCP())) {
                idValues = new ArrayList(10);
                values = (Object[])qFilter.getValue();
                idValues.addAll(Arrays.stream(values).map(value -> (Long)value).collect(Collectors.toList()));
                if (!CollectionUtils.isEmpty(idValues)) {
                    temp = temp.stream().filter(dy -> idValues.contains(dy.getLong("id"))).collect(Collectors.toList());
                }
            }
            if (!"id".equals(qFilter.getProperty()) || !"not in".equalsIgnoreCase(qFilter.getCP())) continue;
            idValues = new ArrayList(10);
            if (qFilter.getValue() instanceof List) {
                idValues.addAll((List)qFilter.getValue());
                if (CollectionUtils.isEmpty(idValues)) continue;
                temp.removeIf(dy -> idValues.contains(dy.getLong("id")));
                continue;
            }
            values = (Object[])qFilter.getValue();
            idValues.addAll(Arrays.stream(values).map(value -> (Long)value).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty(idValues)) continue;
            temp.removeIf(dy -> idValues.contains(dy.getLong("id")));
        }
    }
}

