/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.excel.LabelImportService;
import kd.hr.hrcs.common.constants.label.LblStrategyConstants;
import kd.hr.hrcs.common.utils.ImportFileUtil;
import kd.hr.hrcs.formplugin.web.label.LabelImportPlugin;

public class LabelImportStartPlugin
extends AbstractFormPlugin
implements UploadListener,
ProgresssListener,
LblStrategyConstants {
    private static final Log LOGGER = LogFactory.getLog(LabelImportStartPlugin.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String FILE_SERVER_URL = "serverUrl";
    private static final String CHECK_TEMPLATE_CALLBACK = "checkTemplate_callBack";
    private static final String CURRENT_STATUS = "currentStatus";
    private static final String INIT = "init";
    private static final String UPLOAD = "upload";
    private static final String VALIDATE = "validate";
    private static final String VALIDATE_FAILED = "validateFailed";
    private static final String INSTORE = "instore";
    private static final String FINISHED = "finished";
    private static final String TERMINATOR = "terminator";
    private static final String NO_FAIL_BILL = "noFailBill";
    private static final String NO_SUCCESS_BILL = "noSuccessBill";
    private static final String NO_SUCCESS_AND_FAIL_BILL = "noSuccessAndFailBill";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"LabelImportThreadPool", (int)6);
    private LabelImportService importService = new LabelImportService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btndowntpl", "lblviewhis", "btnstart", "btnstop", "btndownerror", "btndownall", "btnreupload", "lblfilename1", "lblfilename2", "lblfilename3", "lblfilename4", "lblfilename5", "lblfilename6", "lblfilename7"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("fileupload");
        attachmentPanel.addUploadListener((UploadListener)this);
        Button btnreupload = (Button)this.getView().getControl("btnreupload");
        btnreupload.addUploadListener((UploadListener)this);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.statusControlDisplay(INIT);
    }

    public void onProgress(ProgressEvent evt) {
        try {
            this.dealOnProgress(evt);
            if (evt.getProgress() == 0) {
                evt.setProgress(1);
            }
        }
        catch (Throwable e) {
            LOGGER.error("dealOnProgress_exception.", e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fdb\u5ea6\u5c55\u793a\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRPermImportStartPlugin_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String localPath = "";
            String filename = "";
            String filesize = "";
            try {
                if (urls[0] instanceof Map) {
                    Map map = (Map)urls[0];
                    String url = (String)map.get("url");
                    localPath = ImportFileUtil.downloadTempFile((String)url);
                    filename = (String)map.get("name");
                    filesize = String.valueOf(map.get("size"));
                } else {
                    this.statusControlDisplay(INIT);
                    String url = String.valueOf(urls[0]);
                    if (url.lastIndexOf("/") != -1) {
                        filename = url.substring(url.lastIndexOf("/") + 1);
                    }
                    localPath = ImportFileUtil.downloadFile((String)url);
                    FileService service = FileServiceFactory.getAttachmentFileService();
                    service.delete(url);
                    File file = new File(localPath);
                    filesize = String.valueOf(file.length());
                }
            }
            catch (IOException ioException) {
                LOGGER.error((Throwable)ioException);
                this.getView().showErrorNotification(ioException.getMessage());
                return;
            }
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)filename);
            model.setValue("filesize", (Object)filesize);
            model.setValue("filelocalpath", (Object)localPath);
            this.displayFilename(filename);
            try {
                if (!this.checkTemplate(localPath)) {
                    this.statusControlDisplay(INIT);
                    return;
                }
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
                this.deleteLocalFile();
                this.statusControlDisplay(INIT);
                return;
            }
            try {
                Map result = ImportFileUtil.uploadFile((String)filename, (String)localPath);
                model.setValue(FILE_SERVER_URL, result.get(FILE_SERVER_URL));
                model.setValue("fileuploadid", result.get("uploadId"));
                model.setValue("clientUrl", result.get("clientUrl"));
            }
            catch (Throwable e) {
                LOGGER.error("", e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            finally {
                this.deleteLocalFile();
            }
            this.statusControlDisplay(UPLOAD);
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnreupload": {
                this.reUpload();
                break;
            }
            case "btnstart": {
                FormShowParameter parentP = this.getView().getFormShowParameter();
                String formId = (String)parentP.getCustomParam("formId");
                boolean checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)parentP.getAppId(), (String)formId, (String)"4730fc9f000003ae");
                if (!checkPermission) {
                    this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c\u5bfc\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (String)parentP.getCustomParam("ListName")));
                    return;
                }
                String path = (String)this.getModel().getValue(FILE_SERVER_URL);
                if (HRStringUtils.isEmpty((String)path)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"HRPermImportStartPlugin_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date startTime = new Date();
                this.getModel().setValue("starttime", (Object)startTime.getTime());
                this.startImportTask();
                this.statusControlDisplay(INSTORE);
                ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
                bar.setPercent(0);
                bar.start();
                Label lblprogress = (Label)this.getControl("lblprogress");
                lblprogress.setText("");
                break;
            }
            case "btnstop": {
                this.getPageCache().put(CURRENT_STATUS, TERMINATOR);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u5df2\u7ec8\u6b62\u3002", (String)"HRPermImportStartPlugin_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "lblfilename1": 
            case "lblfilename2": 
            case "lblfilename3": 
            case "lblfilename4": 
            case "lblfilename5": 
            case "lblfilename6": 
            case "lblfilename7": {
                this.getView().download((String)this.getModel().getValue("clientUrl"));
                break;
            }
            case "btndownall": {
                this.downErrorFile("btndownall");
                break;
            }
            case "btndownerror": {
                this.downErrorFile("btndownerror");
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        if (this.getView().getParentView() != null) {
            this.getView().getParentView().getPageCache().put("success", this.getPageCache().get("success"));
            this.getView().returnDataToParent((Object)this.getPageCache().get("importFinish"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getCallBackId().equalsIgnoreCase(CHECK_TEMPLATE_CALLBACK)) {
            this.removeAttachmentPanel(this.getView());
        }
    }

    private void removeAttachmentPanel(IFormView view) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("fileupload");
        List attachmentData = attachmentPanel.getAttachmentData();
        if (CollectionUtils.isNotEmpty((Collection)attachmentData)) {
            attachmentPanel.remove((Map)attachmentData.get(0));
        }
    }

    private void statusControlDisplay(String type) {
        LOGGER.info("statusControlDisplay=" + type);
        switch (type) {
            case "init": {
                Label lblprogress = (Label)this.getControl("lblprogress");
                lblprogress.setText("1%");
                Label lblinstorevalue = (Label)this.getControl("lblinstorevalue");
                lblinstorevalue.setText("");
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefleupload", "lblremainingtip", "lblremainingtip1", "flexmini", "flexmini2", "flexmini3", "flexmini4", "flefail1", "flefail2", "flefailed", "flefail3", "flesuccess1", "flesuccess2", "flesuccess3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flestate", "fleremaintime", "lblinstorevalue", "fleremaintime1"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"radserial", "radconcurrent"});
                this.getModel().setValue(FILE_SERVER_URL, (Object)"");
                this.removeAttachmentPanel(this.getView());
                this.getPageCache().put(CURRENT_STATUS, INIT);
                break;
            }
            case "upload": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinishedupload", "btnreupload", "btnstart"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "fleselectmodel", "flevalidata", "flevalidata2", "fleinstore", "flestop", "flefinished", "btnupstep", "btnstop", "btndownerror", "btndownall", "flevalidatefail"});
                this.getPageCache().put(CURRENT_STATUS, UPLOAD);
                break;
            }
            case "instore": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "fleinstore", "btnstop", "lblinstorevalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata", "flevalidata2", "flestop", "flefinished", "btnupstep", "btnstart", "flevalidatefail", "btndownerror", "btndownall", "btnreupload"});
                this.getPageCache().put(CURRENT_STATUS, INSTORE);
                break;
            }
            case "finished": {
                this.stopProcesser(INSTORE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinished", "btnreupload", "flefinished2"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata", "flevalidata2", "flestop", "fleinstore", "btnupstep", "btnstart", "flevalidatefail", "btnstop", "flefailed"});
                this.getPageCache().put(CURRENT_STATUS, FINISHED);
                break;
            }
            case "terminator": {
                this.stopProcesser(VALIDATE);
                this.stopProcesser(INSTORE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flestop", "btnreupload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata", "flevalidata2", "flefinished", "fleinstore", "btnupstep", "btnstart", "flevalidatefail", "btnstop", "btndownerror", "btndownall"});
                this.getPageCache().put(CURRENT_STATUS, TERMINATOR);
                break;
            }
            case "validateFailed": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btndownerror", "btndownall"});
                break;
            }
            case "noSuccessBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefail1", "flefail2", "flefailed"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flesuccess1", "flesuccess2", "btndownall", "flefinished2"});
                break;
            }
            case "noFailBill": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btndownerror", "btndownall"});
                break;
            }
            case "noSuccessAndFailBill": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefail1", "flefail2", "flesuccess1", "flesuccess2"});
                break;
            }
            case "validateNoSuccessBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefail3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flesuccess3", "btndownall"});
                break;
            }
            case "hasTimeRemaining": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fleremaintime"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lblremainingtip"});
                break;
            }
        }
    }

    private String getEntityNumber() {
        String formId = this.getPageCache().get("formId");
        if (HRStringUtils.isNotEmpty((String)formId)) {
            formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        }
        return formId;
    }

    private boolean checkTemplate(String localPath) throws Exception {
        try {
            return this.importService.checkTemplate(localPath);
        }
        catch (KDBizException kdBizException) {
            this.getView().showTipNotification(kdBizException.getMessage());
            return false;
        }
    }

    private void startImportTask() {
        FormShowParameter params = this.getView().getFormShowParameter();
        String appId = (String)params.getCustomParam("ServiceAppId");
        String checkRightAppId = (String)params.getCustomParam("CheckRightAppId");
        String billFormId = (String)params.getCustomParam("BillFormId");
        String url = (String)this.getView().getModel().getValue(FILE_SERVER_URL);
        String opSaveKey = (String)params.getCustomParam("OpSave");
        String labelData = (String)params.getCustomParam("labelData");
        Object logId = ImportLogHelper.create((String)ImportDataTask.getCacheKey((String)"labelImport", (String)this.getView().getPageId()), (String)"labelImport");
        try {
            LabelImportPlugin importPlugin = (LabelImportPlugin)((Object)Class.forName("kd.hr.hrcs.formplugin.web.label.LabelImportPlugin").newInstance());
            ImportContext ctx = new ImportContext(this.getView(), logId, appId, checkRightAppId, "labelImport", billFormId, opSaveKey, url).addOption("customParams", this.getView().getFormShowParameter().getCustomParam("customParams"));
            ctx.setFromTask(Boolean.valueOf(false));
            importPlugin.setContext(RequestContext.get(), ctx, Arrays.asList("resolveExcel", "importData"));
            importPlugin.setView(this.getView());
            importPlugin.setLblObjId(Long.parseLong((String)params.getCustomParam("labelobject")));
            importPlugin.setLblId(Long.parseLong((String)params.getCustomParam("label")));
            importPlugin.setLabelData((Map)SerializationUtils.fromJsonString((String)labelData, Map.class));
            threadPool.submit((Callable)((Object)importPlugin));
            threadPool.submit((Callable)((Object)importPlugin));
        }
        catch (ClassNotFoundException | KDBizException exp) {
            LOGGER.error("LabelImportStartPlugin======================startImportTask==KDBizException", exp);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"HRPermImportStartPlugin_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        catch (IllegalAccessException exception) {
            LOGGER.error("LabelImportStartPlugin======================afterCreateNewData==IllegalAccessException", (Throwable)exception);
        }
        catch (InstantiationException exception) {
            LOGGER.error("LabelImportStartPlugin======================afterCreateNewData==InstantiationException", (Throwable)exception);
        }
    }

    private void downErrorFile(String type) {
        if (type.equals("btndownerror")) {
            String errorClientUrl = (String)this.getModel().getValue("errorclienturl");
            this.addDownLoadLog();
            this.getView().download(errorClientUrl);
        } else if (type.equals("btndownall")) {
            String allErrorUrl = (String)this.getModel().getValue("allerrorurl");
            this.addDownLoadLog();
            this.getView().download(allErrorUrl);
        }
    }

    private void addDownLoadLog() {
        String opName = ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6", (String)"HRPermImportStartPlugin_19", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String opDesc = ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6_%s", (String)"HRPermImportStartPlugin_20", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{this.getPageCache().get("impfileName")});
        ImportOperationLog.getInstance().createAppLog(this.getView().getParentView().getEntityId(), opName, opDesc);
    }

    private void displayResultData(Map<String, Object> result) {
        Label lblespensem2 = (Label)this.getControl("lblespensem2");
        Label lblespenses2 = (Label)this.getControl("lblespenses2");
        String userEndTime = (String)result.get("userEndTime");
        if (HRStringUtils.isNotEmpty((String)userEndTime)) {
            Date endTime = new Date(Long.parseLong(userEndTime));
            Long starttime = (Long)this.getModel().getValue("starttime");
            long expense = endTime.getTime() - starttime;
            if (expense > 0L) {
                String minite = String.valueOf((expense /= 1000L) / 60L);
                String second = String.valueOf(expense % 60L);
                lblespensem2.setText(minite);
                lblespenses2.setText(second);
            }
            int successCount = (Integer)result.get("succeed");
            int totalBillCount = (Integer)result.get("total");
            int failedCount = (Integer)result.get("failed");
            Label lblsuccesscount2 = (Label)this.getControl("lblsuccesscount2");
            Label lblfailcount2 = (Label)this.getControl("lblfailcount2");
            Label lbtotalcount2 = (Label)this.getControl("lbtotalcount2");
            lblsuccesscount2.setText(successCount + "");
            lblfailcount2.setText(String.valueOf(failedCount));
            lbtotalcount2.setText(totalBillCount + "");
            this.statusControlDisplay(FINISHED);
        }
        if (((Boolean)result.getOrDefault("sysTerminator", false)).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff0c\u5df2\u4e2d\u6b62\u751f\u6210\u7ed3\u679c\u62a5\u544a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    private void displayFilename(String filename) {
        Label lblfilename1 = (Label)this.getControl("lblfilename1");
        Label lblfilename3 = (Label)this.getControl("lblfilename3");
        Label lblfilename5 = (Label)this.getControl("lblfilename5");
        lblfilename1.setText(filename);
        lblfilename3.setText(filename);
        lblfilename5.setText(filename);
    }

    private void dealOnProgress(ProgressEvent evt) {
        String cachedLogStr = this.getPageCache().get("Cached_Import_Logger");
        String status = this.getPageCache().get(CURRENT_STATUS);
        JSONObject info = JSON.parseObject((String)cachedLogStr);
        String sysError = null;
        if (info != null) {
            sysError = info.getString("sysError");
        }
        if (HRStringUtils.isNotEmpty(sysError) && HRStringUtils.equals((String)sysError, (String)"1")) {
            evt.setProgress(100);
            Label lblprogress = (Label)this.getControl("lblprogress");
            lblprogress.setText("100%");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540e\u53f0\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRPermImportStartPlugin_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (HRStringUtils.isNotEmpty((String)status) && HRStringUtils.equals((String)status, (String)TERMINATOR)) {
            this.statusControlDisplay(TERMINATOR);
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
            bar.stop();
            return;
        }
        LOGGER.info("Cached_Import_Logger:{}", (Object)cachedLogStr);
        if (info != null) {
            boolean complete = false;
            Object cml = info.get((Object)"complete");
            if (Objects.nonNull(cml)) {
                complete = info.getBoolean("complete");
            }
            if (complete) {
                evt.setProgress(99);
            }
            String errFileUrl = info.getString("errFileUrl");
            String allErrFileUrl = info.getString("allErrFileUrl");
            if (HRStringUtils.isNotEmpty((String)errFileUrl)) {
                this.getModel().setValue("errorclienturl", (Object)errFileUrl);
                this.getModel().setValue("allerrorurl", (Object)allErrFileUrl);
                this.statusControlDisplay(VALIDATE_FAILED);
            } else {
                this.statusControlDisplay(NO_FAIL_BILL);
            }
            int importProgress = info.getIntValue("progress");
            if (importProgress >= 100) {
                importProgress = 99;
                this.getPageCache().remove("Cached_Import_Logger");
                this.removeAttachmentPanel(this.getView());
                this.handleBeforeEnd(info);
                this.displayResultData((Map<String, Object>)info);
            }
            evt.setProgress(importProgress);
            Label lblprogress = (Label)this.getControl("lblprogress");
            lblprogress.setText(importProgress + "%");
        }
    }

    private void handleBeforeEnd(JSONObject info) {
        this.getPageCache().put("importFinish", info.getString("importFinish"));
    }

    protected void hideDownLoadBtn() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btndownall", "btndownerror", "btnreupload", "flexpanelap147"});
        HashMap<String, LocaleString> action = new HashMap<String, LocaleString>();
        action.put("h", new LocaleString("270px"));
        this.getView().updateControlMetadata("flefinished", action);
        this.getView().updateView("flefinished");
    }

    private void stopProcesser(String type) {
        LOGGER.info("stopProcesser_type=" + type);
        if (INSTORE.equals(type)) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
            bar.stop();
        }
    }

    private void deleteLocalFile() {
        try {
            ImportFileUtil.deleteLocalTempFile((String)((String)this.getModel().getValue("filelocalpath")));
        }
        catch (FileSystemException e) {
            LOGGER.info("file can't delete.");
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
    }

    private void reUpload() {
        AttachmentPanel attachmentPanel1 = (AttachmentPanel)this.getView().getControl("fileupload");
        List attachmentDataList = attachmentPanel1.getAttachmentData();
        if (CollectionUtils.isNotEmpty((Collection)attachmentDataList)) {
            for (Map map : attachmentDataList) {
                attachmentPanel1.remove(map);
            }
        }
        IDataModel model = this.getModel();
        model.setValue("filename", (Object)"");
        model.setValue("filesize", (Object)0);
        model.setValue("filelocalpath", (Object)"");
        model.setValue(FILE_SERVER_URL, (Object)"");
        model.setValue("fileuploadid", (Object)"");
        model.setValue("clientUrl", (Object)"");
        this.statusControlDisplay(INIT);
    }
}

