/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.bussiness.util.GenFieldUtil;
import kd.hr.hrcs.common.constants.label.LabelConstants;

public class LabelStrategyFilterPlugin
extends AbstractFormPlugin
implements LabelConstants {
    private static final Log LOGGER = LogFactory.getLog(LabelStrategyFilterPlugin.class);
    private final LabelService labelService = new LabelService();
    private static final String KEY_FILTER_FLEX = "filterFlexKey";
    private static final String KEY_VALUE_FILTER = "filterValueMap";
    private static final String KEY_BASE_ENTITY_FILTER = "filterBaseEntityMap";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        List<FlexPanelAp> headApList = this.generateFilterFlex(showParameter);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)headApList.size());
        headApList.forEach(ha -> items.add(ha.createControl()));
        HashMap mapHead = Maps.newHashMapWithExpectedSize((int)2);
        mapHead.put("id", "flexpanelap");
        mapHead.put("items", items);
        e.getItems().add(mapHead);
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List<FlexPanelAp> flexPanelApList = this.generateFilterFlex(formShowParameter);
        Container myFldPanel = (Container)this.getView().getControl("flexpanelap");
        flexPanelApList.forEach(fpa -> myFldPanel.getItems().add(fpa.buildRuntimeControl()));
        this.getView().createControlIndex(myFldPanel.getItems());
        String filterValueMapStr = (String)formShowParameter.getCustomParam(KEY_VALUE_FILTER);
        Map filterValueMap = (Map)SerializationUtils.fromJsonString((String)filterValueMapStr, Map.class);
        HashSet noFilterKeySet = Sets.newHashSetWithExpectedSize((int)filterValueMap.size());
        for (Map.Entry entry : filterValueMap.entrySet()) {
            Object value = entry.getValue() instanceof List ? ((List)entry.getValue()).toArray() : entry.getValue();
            this.getModel().setValue((String)entry.getKey(), value);
            if (!((String)entry.getKey()).contains("hasfilter") || !((Boolean)value).booleanValue()) continue;
            noFilterKeySet.add(entry.getKey());
        }
        if (!noFilterKeySet.isEmpty()) {
            String customParam = (String)formShowParameter.getCustomParam("filterPropMap");
            Map filterPropMap = (Map)SerializationUtils.fromJsonString((String)customParam, Map.class);
            for (Map.Entry entry : filterPropMap.entrySet()) {
                String noFilterKey = null;
                for (String propKey : (List)entry.getValue()) {
                    if (!noFilterKeySet.contains(propKey)) continue;
                    noFilterKey = propKey;
                    break;
                }
                if (noFilterKey == null) continue;
                ((List)entry.getValue()).remove(noFilterKey);
                for (String propKey : (List)entry.getValue()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{propKey});
                }
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        GenFieldUtil.onGetControl((OnGetControlArgs)e, (IFormView)this.getView());
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LabelStrategyFilterPlugin", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (name.contains("hasfilter")) {
            boolean newValue = (Boolean)changeData.getNewValue();
            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("filterPropMap");
            Map filterPropMap = (Map)SerializationUtils.fromJsonString((String)customParam, Map.class);
            for (Map.Entry entry : filterPropMap.entrySet()) {
                if (!((List)entry.getValue()).contains(name)) continue;
                ((List)entry.getValue()).remove(name);
                if (newValue) {
                    for (String propKey : (List)entry.getValue()) {
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{propKey});
                        if (propKey.contains("daterangefield")) {
                            this.getModel().setValue(propKey + "startdate", null);
                            this.getModel().setValue(propKey + "enddate", null);
                            this.getView().updateView(propKey);
                            continue;
                        }
                        this.getModel().setValue(propKey, null);
                    }
                } else {
                    for (String propKey : (List)entry.getValue()) {
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{propKey});
                    }
                }
                break;
            }
        }
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String filterPropMapStr = (String)formShowParameter.getCustomParam("filterPropMap");
        String filterBaseEntityMapStr = (String)formShowParameter.getCustomParam(KEY_BASE_ENTITY_FILTER);
        Map filterPropMap = (Map)SerializationUtils.fromJsonString((String)filterPropMapStr, Map.class);
        Map filterBaseEntityMap = (Map)SerializationUtils.fromJsonString((String)filterBaseEntityMapStr, Map.class);
        for (Map.Entry entry : filterPropMap.entrySet()) {
            for (String key : (List)entry.getValue()) {
                List fieldPropertyList = GenFieldUtil.getFieldPropertyList((String)key, (String)key, (Map)filterBaseEntityMap, (boolean)true);
                for (DynamicProperty property : fieldPropertyList) {
                    newMainType.addProperty(property);
                }
            }
        }
    }

    private List<FlexPanelAp> generateFilterFlex(FormShowParameter showParameter) {
        Map customParams = showParameter.getCustomParams();
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)((String)customParams.get("filterMap")), Map.class);
        LinkedHashMap valueMap = Maps.newLinkedHashMapWithExpectedSize((int)filterMap.size());
        LinkedHashMap baseEntityMap = Maps.newLinkedHashMapWithExpectedSize((int)filterMap.size());
        ArrayList flexPanelApList = Lists.newArrayListWithExpectedSize((int)filterMap.size());
        LinkedHashMap fieldKeyPropMap = Maps.newLinkedHashMapWithExpectedSize((int)filterMap.size());
        int i = 0;
        for (Map.Entry entry : filterMap.entrySet()) {
            String fieldKey = (String)entry.getKey();
            DynamicProperty property = GenFieldUtil.getBindEntityProperty((String)fieldKey);
            HashSet propSet = Sets.newHashSetWithExpectedSize((int)2);
            Map value = (Map)entry.getValue();
            FlexPanelAp flexPanelAp = this.getFlexPanelAp(property, (String)value.get("name"), baseEntityMap, propSet, i);
            fieldKeyPropMap.put(fieldKey, propSet);
            flexPanelApList.add(flexPanelAp);
            Map<String, Object> resultMap = this.getValue(value, property, i);
            valueMap.putAll(resultMap);
            ++i;
        }
        customParams.put(KEY_VALUE_FILTER, SerializationUtils.toJsonString((Object)valueMap));
        customParams.put(KEY_BASE_ENTITY_FILTER, SerializationUtils.toJsonString((Object)baseEntityMap));
        customParams.put("filterPropMap", SerializationUtils.toJsonString((Object)fieldKeyPropMap));
        return flexPanelApList;
    }

    private FlexPanelAp getFlexPanelAp(DynamicProperty property, String disPlayName, Map<String, String> baseEntityMap, Set<String> propSet, int index) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("labelap" + index);
        labelAp.setName(new LocaleString(disPlayName));
        labelAp.setFontSize(14);
        LabelAp labelAp2 = new LabelAp();
        labelAp2.setKey("labelap" + index + 1);
        labelAp2.setName(new LocaleString("*"));
        labelAp2.setFontSize(14);
        labelAp2.setForeColor("#fb2323");
        FlexPanelAp flexPanelApLabel = new FlexPanelAp();
        flexPanelApLabel.setKey("labelflexap" + index);
        flexPanelApLabel.setJustifyContent("flex-end");
        flexPanelApLabel.setHeight(new LocaleString("16px"));
        flexPanelApLabel.setWidth(new LocaleString("160px"));
        flexPanelApLabel.setWrap(false);
        flexPanelApLabel.setOverflow("visible");
        flexPanelApLabel.getItems().add(labelAp);
        flexPanelApLabel.getItems().add(labelAp2);
        String allId = "hasfilter" + index;
        CheckBoxField field = new CheckBoxField();
        field.setKey(allId);
        field.setId(allId);
        field.setName(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LabelStrategyPlugin_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])));
        field.setShowStyle(2);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(allId);
        fieldAp.setKey(allId);
        fieldAp.setName(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"LabelStrategyPlugin_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])));
        fieldAp.setField((Field)field);
        fieldAp.setFireUpdEvt(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("12px");
        margin.setRight("12px");
        style.setMargin(margin);
        fieldAp.setStyle(style);
        fieldAp.setWidth(new LocaleString("80px"));
        fieldAp.setFontSize(14);
        propSet.add(allId);
        FlexPanelAp flexPanelApHasFilter = new FlexPanelAp();
        flexPanelApHasFilter.setKey("flex" + allId);
        flexPanelApHasFilter.getItems().add(fieldAp);
        FieldAp fieldAp2 = GenFieldUtil.getFieldAp((DynamicProperty)property, baseEntityMap, (int)index);
        Style style2 = new Style();
        Padding padding = new Padding();
        padding.setTop("14px");
        style2.setPadding(padding);
        Margin margin2 = new Margin();
        margin2.setBottom("8px");
        style2.setMargin(margin2);
        fieldAp2.setStyle(style2);
        fieldAp2.setFieldStyle(2);
        fieldAp2.setWidth(new LocaleString("460px"));
        propSet.add(fieldAp2.getKey());
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(KEY_FILTER_FLEX + index + index);
        flexPanelAp.setHeight(new LocaleString("46px"));
        flexPanelAp.setOverflow("hidden");
        flexPanelAp.getItems().add(fieldAp2);
        FlexPanelAp flexPanelApTop = new FlexPanelAp();
        flexPanelApTop.setKey(KEY_FILTER_FLEX + index);
        flexPanelApTop.setAlignItems("center");
        flexPanelApTop.setOverflow("visible");
        flexPanelApTop.getItems().add(flexPanelApLabel);
        flexPanelApTop.getItems().add(flexPanelApHasFilter);
        flexPanelApTop.getItems().add(fieldAp2);
        return flexPanelApTop;
    }

    private Map<String, Object> getValue(Map<String, Object> value, DynamicProperty property, int index) {
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)2);
        if (value != null && value.containsKey("hasfilter")) {
            boolean hasFilter = (Boolean)value.get("hasfilter");
            String valueStr = (String)value.get("value");
            if (hasFilter) {
                valueMap.put("hasfilter" + index, true);
            } else if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
                String entityNum;
                if (property instanceof BasedataProp) {
                    BasedataProp basedataProp = (BasedataProp)property;
                    entityNum = basedataProp.getBaseEntityId();
                } else {
                    MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                    entityNum = mulBasedataProp.getBaseEntityId();
                }
                String[] ids = valueStr.split(",");
                List idList = this.labelService.getBaseDataIds(ids, entityNum);
                valueMap.put("basedatafield" + index, idList.toArray());
            } else if (property instanceof ComboProp || property instanceof BooleanProp) {
                valueMap.put("mulcombofield" + index, valueStr);
            } else if (property instanceof DateTimeProp) {
                String[] dates = valueStr.split(",");
                try {
                    valueMap.put("daterangefield" + index + "startdate", HRDateTimeUtils.parseDate((String)dates[0]));
                    valueMap.put("daterangefield" + index + "enddate", HRDateTimeUtils.parseDate((String)dates[1]));
                }
                catch (ParseException parseException) {
                    LOGGER.error("LabelStrategyPlugin_parseException:{}", (Object)parseException.getMessage());
                }
            }
        }
        return valueMap;
    }
}

