/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.label.LblHelperConstants;
import kd.hr.hrcs.common.constants.label.LabelConstants;

@ExcludeFromJacocoGeneratedReport
public class LabelValueF7TreeListPlugin
extends AbstractTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(LabelValueF7TreeListPlugin.class);
    private static final String F7_TYPE_SEARCH = "search";
    private static final String F7_TYPE_ADD = "add";

    public void initialize() {
        super.initialize();
        if (F7_TYPE_ADD.equals(this.getF7Type())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"containdisabled"});
        } else if (F7_TYPE_SEARCH.equals(this.getF7Type())) {
            BillList billList = (BillList)this.getControl("billlistap");
            List columns = billList.getShowListColumns();
            for (IListColumn column : columns) {
                if (!"enable".equals(column.getListFieldKey())) continue;
                column.setVisible(63);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String changeKey = args.getProperty().getName();
        if ("containdisabled".equals(changeKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    private String getF7Type() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        return F7_TYPE_ADD.equals(type) ? F7_TYPE_ADD : F7_TYPE_SEARCH;
    }

    private Long getLabelSceneId() {
        Object cusSceneId = this.getView().getFormShowParameter().getCustomParam("sceneId");
        if (cusSceneId instanceof Long) {
            return (Long)cusSceneId;
        }
        if (cusSceneId instanceof String) {
            String str = (String)cusSceneId;
            if (HRStringUtils.isEmpty((String)str)) {
                return null;
            }
            return Long.parseLong(str);
        }
        return null;
    }

    private Long getLabelObjectId() {
        Object labelObjectId = this.getView().getFormShowParameter().getCustomParam("labelObjectId");
        if (labelObjectId instanceof Long) {
            return (Long)labelObjectId;
        }
        if (labelObjectId instanceof String) {
            String str = (String)labelObjectId;
            if (HRStringUtils.isEmpty((String)str)) {
                return null;
            }
            return Long.parseLong(str);
        }
        return null;
    }

    private List<Long> getLabelObjectIds() {
        Object labelObjectIds = this.getView().getFormShowParameter().getCustomParam("labelObjectIds");
        if (labelObjectIds instanceof String) {
            String str = (String)labelObjectIds;
            if (HRStringUtils.isEmpty((String)str)) {
                return null;
            }
            String[] ids = str.split(",");
            ArrayList<Long> labelObjectIdList = new ArrayList<Long>(10);
            for (String id : ids) {
                if (HRStringUtils.isEmpty((String)id)) continue;
                try {
                    labelObjectIdList.add(Long.parseLong(id));
                }
                catch (Exception exp) {
                    LOGGER.error("custom params labelObjectIds error! : {}", labelObjectIds);
                    LOGGER.error((Throwable)exp);
                }
            }
            return labelObjectIdList;
        }
        return null;
    }

    private List<Long> getLabelIds() {
        Object labelIds = this.getView().getFormShowParameter().getCustomParam("labelIds");
        if (labelIds instanceof String) {
            String str = (String)labelIds;
            if (HRStringUtils.isEmpty((String)str)) {
                return null;
            }
            String[] ids = str.split(",");
            ArrayList<Long> labelIdList = new ArrayList<Long>(10);
            for (String id : ids) {
                if (HRStringUtils.isEmpty((String)id)) continue;
                try {
                    labelIdList.add(Long.parseLong(id));
                }
                catch (Exception exp) {
                    LOGGER.error("custom params labelIds error! : {}", labelIds);
                    LOGGER.error((Throwable)exp);
                }
            }
            return labelIdList;
        }
        return null;
    }

    private String getLabelSceneNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("sceneNumber");
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
    }

    private List<Long> getLabelIdList() {
        List<Long> pLabelObjectIds;
        Long labelObjectId;
        List<Long> labelIdList = new ArrayList<Long>(10);
        Long labelSceneId = this.getLabelSceneId();
        String labelSceneNumber = this.getLabelSceneNumber();
        if (labelSceneId != null && labelSceneId != 0L || HRStringUtils.isNotEmpty((String)labelSceneNumber)) {
            labelIdList.addAll(this.getLabelIdsByScene(labelSceneId, labelSceneNumber));
        }
        if (F7_TYPE_ADD.equals(this.getF7Type()) && labelIdList.size() == 0) {
            return labelIdList;
        }
        List<Long> pLabelIds = this.getLabelIds();
        if (pLabelIds != null && pLabelIds.size() > 0) {
            labelIdList.addAll(pLabelIds);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("type", "=", (Object)"10"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        if (labelIdList.size() > 0) {
            filterList.add(new QFilter("id", "in", labelIdList));
        }
        if ((labelObjectId = this.getLabelObjectId()) != null && labelObjectId != 0L) {
            filterList.add(new QFilter("entryentityrange.labelobject.id", "=", (Object)labelObjectId));
        }
        if ((pLabelObjectIds = this.getLabelObjectIds()) != null && pLabelObjectIds.size() > 0) {
            filterList.add(new QFilter("entryentityrange.labelobject.id", "in", pLabelObjectIds));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_label");
        DynamicObject[] labels = serviceHelper.query("id,name,number", filterList.toArray(new QFilter[0]));
        labelIdList = Arrays.stream(labels).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        return labelIdList;
    }

    private List<Long> getLabelIdsByScene(Long labelSceneId, String labelSceneNumber) {
        ArrayList<Long> labelIds = new ArrayList<Long>(10);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_labelscene");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (labelSceneId != null) {
            filterList.add(new QFilter("id", "=", (Object)labelSceneId));
        } else if (HRStringUtils.isNotEmpty((String)labelSceneNumber)) {
            filterList.add(new QFilter("number", "=", (Object)labelSceneNumber));
        } else {
            filterList.add(new QFilter("id", "=", (Object)-1L));
        }
        DynamicObject scene = serviceHelper.loadDynamicObject(filterList.toArray(new QFilter[0]));
        HashMap labelSortNumber = new HashMap(16);
        if (scene != null && scene.get("entryentity") != null) {
            scene.getDynamicObjectCollection("entryentity").forEach(item -> {
                if (item != null && item.get("label") != null && "10".equals(item.getDynamicObject("label").get("type")) && (F7_TYPE_ADD.equals(this.getF7Type()) && item.getBoolean("bizlabel") || F7_TYPE_SEARCH.equals(this.getF7Type()))) {
                    labelIds.add(item.getDynamicObject("label").getLong("id"));
                    labelSortNumber.put(String.valueOf(item.getDynamicObject("label").getLong("id")), item.getString("bizindex"));
                }
            });
        }
        this.getPageCache().put(labelSortNumber);
        return labelIds;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                super.listRowClick(evt);
                ListSelectedRowCollection selectRows = evt.getListSelectedRowCollection();
                if (selectRows != null) {
                    DynamicObject[] labelValueDyns = LblHelperConstants.labelValueServiceHelper.query("id,value", new QFilter[]{new QFilter("id", "in", (Object)selectRows.getPrimaryKeyValues())});
                    HashMap<String, String> labelValueMap = new HashMap<String, String>(16);
                    if (labelValueDyns != null && labelValueDyns.length > 0) {
                        for (DynamicObject labelValueDyn : labelValueDyns) {
                            labelValueMap.put(String.valueOf(labelValueDyn.get("id")), labelValueDyn.getString("value"));
                        }
                    }
                    selectRows.forEach(item -> {
                        if (labelValueMap.containsKey(String.valueOf(item.getPrimaryKeyValue()))) {
                            item.setName((String)labelValueMap.get(String.valueOf(item.getPrimaryKeyValue())));
                        }
                    });
                    ListSelectedRow selectedRow = evt.getCurrentListSelectedRow();
                    if (selectedRow != null && selectedRow.getPrimaryKeyValue() != null && labelValueMap.containsKey(String.valueOf(selectedRow.getPrimaryKeyValue()))) {
                        selectedRow.setName((String)labelValueMap.get(String.valueOf(selectedRow.getPrimaryKeyValue())));
                    }
                }
            }
        });
    }

    public void initializeTree(EventObject e) {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("labelentityinfos");
        DynamicObject rootLabelGroup = LblHelperConstants.labelGroupServiceHelper.queryOne("id,name,number", new QFilter("id", "=", (Object)LabelConstants.VAL_PUBLIC_LABEL_GROUP_ID));
        TreeNode root = new TreeNode("", String.valueOf(LabelConstants.VAL_PUBLIC_LABEL_GROUP_ID), rootLabelGroup.getString("name"));
        root.setIsOpened(true);
        List<Long> labelIds = this.getLabelIdList();
        if (labelIds != null && labelIds.size() > 0) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            filterList.add(new QFilter("type", "=", (Object)"10"));
            if (F7_TYPE_ADD.equals(this.getF7Type())) {
                filterList.add(new QFilter("enable", "=", (Object)"1"));
            }
            filterList.add(new QFilter("id", "in", labelIds));
            DynamicObject[] labelDyns = LblHelperConstants.labelServiceHelper.query("id,group,group.id,group.longnumber", filterList.toArray(new QFilter[0]));
            if (labelDyns != null && labelDyns.length > 0) {
                HashSet<String> groupNumberSet = new HashSet<String>(16);
                groupNumberSet.add(rootLabelGroup.getString("number"));
                for (DynamicObject labelDyn : labelDyns) {
                    String longnumber;
                    if (labelDyn.getDynamicObject("group") == null || !HRStringUtils.isNotEmpty((String)(longnumber = labelDyn.getDynamicObject("group").getString("longnumber")))) continue;
                    String[] numbers = longnumber.split("\\.");
                    groupNumberSet.addAll(Arrays.stream(numbers).collect(Collectors.toSet()));
                }
                this.getTreeModel().getTreeFilter().add(new QFilter("number", "in", groupNumberSet));
            } else {
                this.getTreeModel().getTreeFilter().add(new QFilter("id", "=", (Object)0L));
            }
        } else {
            this.getTreeModel().getTreeFilter().add(new QFilter("id", "=", (Object)0L));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardview"});
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("id", "in", this.getLabelIdList()));
        e.getQFilters().add(new QFilter("status", "=", (Object)"C"));
        if (F7_TYPE_ADD.equals(this.getF7Type())) {
            e.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
            e.setOrderBy("createtime desc");
        } else if (F7_TYPE_SEARCH.equals(this.getF7Type())) {
            e.getQFilters().add(new QFilter("type", "=", (Object)"10"));
            if (this.getModel().getValue("containdisabled") instanceof Boolean && !((Boolean)this.getModel().getValue("containdisabled")).booleanValue()) {
                e.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
            }
            e.setOrderBy("group.index,index,number,entryentitylabelvalue.labelvalue  asc");
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final Map labelSortNumber = this.getPageCache().getAll();
        final String openType = this.getF7Type();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection originalDataCol = super.getData(start, limit);
                if (originalDataCol != null && originalDataCol.size() > 0) {
                    if (LabelValueF7TreeListPlugin.F7_TYPE_ADD.equals(openType)) {
                        originalDataCol.sort((Comparator)new Comparator<DynamicObject>(){

                            @Override
                            public int compare(DynamicObject o1, DynamicObject o2) {
                                String o1SortNumber = (String)labelSortNumber.get(String.valueOf(o1.getLong("id")));
                                String o2SortNumber = (String)labelSortNumber.get(String.valueOf(o2.getLong("id")));
                                if (!HRStringUtils.isEmpty((String)o1SortNumber) && !"0".equals(o1SortNumber) || !HRStringUtils.isEmpty((String)o2SortNumber) && !"0".equals(o2SortNumber)) {
                                    if (HRStringUtils.isEmpty((String)o1SortNumber) || "0".equals(o1SortNumber)) {
                                        return -1;
                                    }
                                    if (HRStringUtils.isEmpty((String)o2SortNumber) || "0".equals(o2SortNumber)) {
                                        return 1;
                                    }
                                    if (o1SortNumber.compareTo(o2SortNumber) != 0) {
                                        return o1SortNumber.compareTo(o2SortNumber);
                                    }
                                }
                                if (o1.getString("number").compareTo(o2.getString("number")) != 0) {
                                    return o1.getString("number").compareTo(o2.getString("number"));
                                }
                                if (o1.containsProperty("entryentitylabelvalue.labelvalue")) {
                                    return o1.getString("entryentitylabelvalue.labelvalue").compareTo(o2.getString("entryentitylabelvalue.labelvalue"));
                                }
                                return 0;
                            }
                        });
                    }
                    for (DynamicObject labelDyn : originalDataCol) {
                        if (labelDyn == null || !labelDyn.containsProperty("entryentitylabelvalue.id")) continue;
                        labelDyn.set("id", labelDyn.get("entryentitylabelvalue.id"));
                    }
                }
                return originalDataCol;
            }
        });
    }
}

