/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.hr.hbp.business.service.function.FunctionSubPageService;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelServiceHelper;
import kd.hr.hrcs.common.constants.label.LabelValueRuleConstants;

public class LabelValueRuleConfPlugin
extends HRBaseDataCommonEdit
implements LabelValueRuleConstants {
    private static final Log LOGGER = LogFactory.getLog(LabelValueRuleConfPlugin.class);
    private static final LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
    private static final String TAB_AP = "tabap";
    FunctionSubPageService functionSubPageService = new FunctionSubPageService();

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long labelId = (Long)formShowParameter.getCustomParam("label");
        List labelObjectList = (List)SerializationUtils.deSerializeFromBase64((String)((String)formShowParameter.getCustomParam("labelobject")));
        Long lblValueId = (Long)formShowParameter.getCustomParam("labelvalue");
        if (labelObjectList.size() == 0) {
            return;
        }
        this.getPageCache().put("label", labelId == null ? null : labelId.toString());
        this.getPageCache().put("expression", (String)formShowParameter.getCustomParam("expression"));
        this.getPageCache().put("index", (String)formShowParameter.getCustomParam("index"));
        this.getPageCache().put("labelobject", (String)formShowParameter.getCustomParam("labelobject"));
        this.getPageCache().put("labelvalue", lblValueId == null ? null : lblValueId.toString());
        this.createDynamic(labelObjectList);
        this.showForms(labelObjectList, lblValueId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate op;
        String operateKey;
        if (evt.getSource() instanceof AbstractOperate && "saverule".equals(operateKey = (op = (AbstractOperate)evt.getSource()).getOperateKey())) {
            List labelObjectList = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("labelobject"));
            StringBuilder errMsg = new StringBuilder();
            HashMap data = Maps.newHashMapWithExpectedSize((int)16);
            HashMap exprMap = Maps.newHashMapWithExpectedSize((int)labelObjectList.size());
            String sceneJson = this.getPageCache().get("scene");
            Map sceneMap = null;
            if (!HRStringUtils.isEmpty((String)sceneJson)) {
                sceneMap = (Map)SerializationUtils.fromJsonString((String)sceneJson, Map.class);
            }
            for (DynamicObject labelObject : labelObjectList) {
                long lblObjId = labelObject.getLong("id");
                Map<String, Object> resultMap = this.parseFunctionExpr(lblObjId, errMsg);
                if (resultMap == null) continue;
                exprMap.put(lblObjId + "", resultMap);
                String expr = (String)resultMap.get("expr");
                IFormView valueRuleView = this.getValueRuleView(lblObjId);
                Long sceneId = sceneMap == null ? Long.valueOf(0L) : (Long)sceneMap.get(lblObjId + "");
                Map<String, String> paramNameAndTypeMap = this.getParamNameAndTypeMap(lblObjId, sceneId);
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)paramNameAndTypeMap.size());
                paramNameAndTypeMap.forEach((key, value) -> paramMap.put(key, this.getDefaultValue((String)value)));
                this.functionSubPageService.preExecuteExpr(expr, (Map)paramMap, errMsg, valueRuleView.getPageCache().get("functionExecuteServiceClassName"));
            }
            if (errMsg.length() != 0) {
                this.getView().showTipNotification(errMsg.toString());
                evt.setCancel(true);
                return;
            }
            data.put("expr", exprMap);
            data.put("index", this.getPageCache().get("index"));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)data));
            this.getView().close();
        }
    }

    private void createDynamic(List<DynamicObject> labelObjectList) {
        Tab tab = (Tab)this.getView().getControl(TAB_AP);
        ArrayList<Map> items = new ArrayList<Map>(10);
        for (DynamicObject labelObject : labelObjectList) {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(labelObject.getString("id"));
            String labelObjectName = labelObject.getString("name");
            tabPageAp.setName(new LocaleString(labelObjectName));
            Map tabPageMap = tabPageAp.createControl();
            tabPageMap.put(labelObjectName, tabPageAp);
            items.add(tabPageMap);
        }
        tab.addControls(items);
        this.getPageCache().put("lastTab", labelObjectList.get(0).getString("id"));
    }

    private void showForms(List<DynamicObject> labelObjectList, Long lblValueId) {
        List lblObjIdList = labelObjectList.stream().map(lblObj -> lblObj.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> lblVRGroup = null;
        if (lblValueId != null) {
            DynamicObject[] lblVRs = labelServiceHelper.listVRByLabelValueIdAndObjectIdList(lblValueId, lblObjIdList);
            lblVRGroup = Arrays.stream(lblVRs).collect(Collectors.toMap(lblVR -> lblVR.getLong("labelobject.id"), lblVR -> lblVR));
        }
        String exprCacheMapJson = this.getPageCache().get("expression");
        Map exprCacheMap = null;
        if (!HRStringUtils.isEmpty((String)exprCacheMapJson)) {
            exprCacheMap = (Map)SerializationUtils.fromJsonString((String)exprCacheMapJson, Map.class);
        }
        String labelIdStr = this.getPageCache().get("label");
        Map<Long, Long> sceneMap = null;
        if (!HRStringUtils.isEmpty((String)labelIdStr)) {
            LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
            DynamicObject[] labelObjectRelCollection = labelServiceHelper.getLabelObjectRelCollection(Long.parseLong(labelIdStr));
            sceneMap = Arrays.stream(labelObjectRelCollection).collect(Collectors.toMap(lblRel -> lblRel.getLong("labelobject.id"), lblRel -> lblRel.getLong("brmscene.id")));
            this.getPageCache().put("scene", SerializationUtils.toJsonString(sceneMap));
        }
        HashMap valueRulePageMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Long lblObjId : lblObjIdList) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("hrcs_labelvaluerule");
            showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(lblObjId.toString());
            showParameter.setCustomParam("labelobject", (Object)lblObjId);
            showParameter.setCustomParam("scene", sceneMap == null ? null : sceneMap.get(lblObjId));
            showParameter.setCustomParam("expression", exprCacheMap == null ? null : exprCacheMap.get(lblObjId.toString()));
            if (lblVRGroup != null && lblVRGroup.get(lblObjId) != null) {
                showParameter.setPkId((Object)lblVRGroup.get(lblObjId).getLong("id"));
            }
            this.getView().showForm((FormShowParameter)showParameter);
            valueRulePageMap.put(lblObjId.toString(), showParameter.getPageId());
        }
        this.getPageCache().put("valueRuleId", SerializationUtils.toJsonString((Object)valueRulePageMap));
    }

    private Map<String, Object> parseFunctionExpr(Long lblObjId, StringBuilder errMsg) {
        IFormView functionView = this.getFuncView(lblObjId);
        String expr = (String)functionView.getModel().getValue("displayfunctiontext");
        if (HRStringUtils.isEmpty((String)expr)) {
            errMsg.append(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LabelValueRuleConfPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return null;
        }
        Map resultMap = this.functionSubPageService.parseFunctionExpr(errMsg, expr, functionView.getPageCache().get("fields"));
        if (resultMap == null || errMsg.length() != 0) {
            return null;
        }
        expr = expr.replaceAll("\\[", "").replaceAll("]", "");
        resultMap.put("displayfunctiontext", expr);
        return resultMap;
    }

    private IFormView getFuncView(Long lblObjId) {
        IFormView valueRuleView = this.getValueRuleView(lblObjId);
        String funcViewPageId = valueRuleView.getPageCache().get("functionViewPageId");
        return valueRuleView.getView(funcViewPageId);
    }

    private IFormView getValueRuleView(Long lblObjId) {
        String valueRulePageIdJson = this.getPageCache().get("valueRuleId");
        Map valueRulePageIdMap = (Map)SerializationUtils.fromJsonString((String)valueRulePageIdJson, Map.class);
        return this.getView().getView((String)valueRulePageIdMap.get(lblObjId.toString()));
    }

    private Map<String, String> getParamNameAndTypeMap(Long objectId, Long sceneId) {
        List fieldList = LabelServiceHelper.getFieldList((Long)objectId, (Long)sceneId);
        HashMap fieldTypeMap = Maps.newHashMapWithExpectedSize((int)fieldList.size());
        for (Map field : fieldList) {
            fieldTypeMap.put((String)field.get("fieldNumber"), (String)field.get("valueType"));
        }
        return fieldTypeMap;
    }

    private Object getDefaultValue(String type) {
        Object result = null;
        switch (DataTypeEnum.of((String)type)) {
            case INTEGER: 
            case BIGDECIMAL: {
                result = 1;
                break;
            }
            case DATETIME: {
                result = "NOW()";
                break;
            }
            case STRING: {
                result = "\"testString\"";
                break;
            }
            case BOOLEAN: {
                result = Boolean.TRUE;
                break;
            }
            case LONG: {
                result = 0L;
                break;
            }
        }
        return result;
    }
}

